﻿# -*- encoding: utf-8 -*-
=begin
= 被ダメージセリフ設定（エネミー用）

:dead_word ... 通常戦闘不能用セリフ
:orgasm_word ... 快楽戦闘不能用セリフ
:predation_word ... 捕食戦闘不能用セリフ
:incontinence_word ... 失禁用セリフ
:premortal_graphic ... 戦闘不能前グラフィック

==更新履歴
Date     Version Author Comment

=end

#==============================================================================
# ■ NWConst::Enemy
#==============================================================================
module NWConst::Enemy
  # 通常戦闘不能用セリフ
  DOWN_WORDS = {
    1 => { # スライム娘 / Slime Girl
      :dead_word => ["\\n<Slime Girl>Unyuuu...", "slime_fc1", 2],
      :orgasm_word => ["\\n<Slime Girl>Funyaaa...", "slime_fc1", 2],
      :predation_word => ["\\n<Slime Girl>No... Don't eat me... Hyaaa!", "slime_fc1", 2],
      :incontinence_word => ["\\n<Slime Girl>I'm leaking... Fuaaa...", "slime_fc1", 2],
      :premortal_graphic => "50_slime_st03",
    },
    2 => { # バニースライム娘 / Bunny Slime
      :dead_word => ["\\n<Bunny Slime>Kyuu...", "bunnyslime_fc1", 3],
      :orgasm_word => ["\\n<Bunny Slime>I'm coooming... Unyuu...", "bunnyslime_fc1", 2],
      :predation_word => ["\\n<Bunny Slime>I'm not tasty... I'm just a normal slime, after all... Hyaa!", "bunnyslime_fc1", 3],
      :incontinence_word => ["\\n<Bunny Slime>It leaked... Unyaaa...", "bunnyslime_fc1", 2],
      :premortal_graphic => "50_bunnyslime_st03",
    },
    3 => { # バニースライム娘 / Bunny Slime
      :dead_word => ["\\n<Bunny Slime>Kyuu...", "bunnyslime_fc1", 3],
      :orgasm_word => ["\\n<Bunny Slime>I'm coooming... Unyuu...", "bunnyslime_fc1", 2],
      :predation_word => ["\\n<Bunny Slime>I'm not tasty... I'm just a normal Slime, after all... Hyaa!", "bunnyslime_fc1", 3],
      :incontinence_word => ["\\n<Bunny Slime>It leaked... Unyaaa...", "bunnyslime_fc1", 2],
      :premortal_graphic => "50_bunnyslime_st03",
    },
    4 => { # ナメクジ娘 / Slug Girl
      :dead_word => ["\\n<Slug Girl>My stickiness... wasn't enough...", "name_fc1", 1],
      :orgasm_word => ["\\n<Slug Girl>Ahh... I came...", "name_fc1", 1],
      :predation_word => ["\\n<Slug Girl>Stop, don't eat me... Noooo!", "name_fc1", 1],
      :incontinence_word => ["\\n<Slug Girl>Ahh... I peed... Ahhh...", "name_fc1", 1],
      :premortal_graphic => "50_name_st11",
    },
    5 => { # インプ / Imp
      :dead_word => ["\\n<Imp>I can't do it anymore...", "inp_fc1", 2],
      :orgasm_word => ["\\n<Imp>I came... Haaauuu...", "inp_fc1", 3],
      :predation_word => ["\\n<Imp>D-don't eat me... Okay...? Hyaaaaan!", "inp_fc1", 2],
      :incontinence_word => ["\\n<Imp>I'm going to pee... Fueee...", "inp_fc1", 3],
      :premortal_graphic => "50_inp_st03",
    },
    6 => { # マンドラゴラ娘 / Mandragora
      :dead_word => ["\\n<Mandragora>I can't take any more...", "mdg_fc1", 2],
      :orgasm_word => ["\\n<Mandragora>Ah, I'm coming...", "mdg_fc1", 2],
      :predation_word => ["\\n<Mandragora>If you have to eat me, please just eat the leaves on my head... Noooo!", "mdg_fc1", 2],
      :incontinence_word => ["\\n<Mandragora>T-to think I'd pee... Ah...", "mdg_fc1", 2],
      :premortal_graphic => "50_mdg_st03",
    },
    7 => { # 犬娘 / Dog Girl
      :dead_word => ["\\n<Dog Girl>Kyun...", "dog_fc1", 4],
      :orgasm_word => ["\\n<Dog Girl>W-woof...", "dog_fc1", 4],
      :predation_word => ["\\n<Dog Girl>D-don't eat me... Kyah!", "dog_fc1", 4],
      :incontinence_word => ["\\n<Dog Girl>I'm not peeing, I'm leaving my mark... *Whine*", "dog_fc1", 4],
      :premortal_graphic => "50_dog_st05",
    },
    8 => { # ミミズ娘 / Earthworm Girl
      :dead_word => ["\\n<Earthworm Girl>The worm returns to the soil...", "mimizu_fc1", 2],
      :orgasm_word => ["\\n<Earthworm Girl>I came... Even though I'm a worm...", "mimizu_fc1", 2],
      :predation_word => ["\\n<Earthworm Girl>You're going to eat something as strange as a worm!? Kyaaa!", "mimizu_fc1", 2],
      :incontinence_word => ["\\n<Earthworm Girl>To think a worm could leak... Don't look...", "mimizu_fc1", 2],
      :premortal_graphic => "50_mimizu_st03",
    },
    9 => { # ゴブリン娘 / Goblin Girl
      :dead_word => ["\\n<Goblin Girl>Just let me rest a moment...", "gob_fc1", 3],
      :orgasm_word => ["\\n<Goblin Girl>No... I shouldn't...!", "gob_fc1", 3],
      :predation_word => ["\\n<Goblin Girl>Y-you're going to eat me!? Noooo!", "gob_fc1", 3],
      :incontinence_word => ["\\n<Goblin Girl>I peed... This is so embarrassing...", "gob_fc1", 3],
      :premortal_graphic => "80_gob_st04",
    },
    10 => { # プチラミア / Tiny Lamia
      :dead_word => ["\\n<Tiny Lamia>It can't be... Kya...", "pramia_fc1", 2],
      :orgasm_word => ["\\n<Tiny Lamia>It feels so... Fuaaa...", "pramia_fc1", 2],
      :predation_word => ["\\n<Tiny Lamia>I'm not tasty, you know! Hey, didn't you hear me? Kyaa!", "pramia_fc1", 2],
      :incontinence_word => ["\\n<Tiny Lamia>It... It's coming out... Auu...", "pramia_fc1", 2],
      :premortal_graphic => "80_pramia_st03",
    },
    11 => { # ヴァンパイアガール / Vampire Girl
      :dead_word => ["\\n<Vampire Girl>I see a world of darkness closing in...", "vgirl_fc1", 2],
      :orgasm_word => ["\\n<Vampire Girl>No, I'm coming... Hyaaann...", "vgirl_fc1", 2],
      :predation_word => ["\\n<Vampire Girl>D-don't eat me... Stop! Hyaaaa!", "vgirl_fc1", 2],
      :incontinence_word => ["\\n<Vampire Girl>It's still coming out...", "vgirl_fc1", 2],
      :premortal_graphic => "80_vgirl_st03",
    },
    12 => { # ドラゴンパピー / Dragon Pup
      :dead_word => ["\\n<Dragon Pup>Raawr...", "dragonp_fc1", 2],
      :orgasm_word => ["\\n<Dragon Pup>What is this...? My body... Haauuu!", "dragonp_fc1", 2],
      :predation_word => ["\\n<Dragon Pup>D-don't eat me! I'll bite the inside of your stomach! Hyaaa!", "dragonp_fc1", 2],
      :incontinence_word => ["\\n<Dragon Pup>My panties are all wet...", "dragonp_fc1", 2],
      :premortal_graphic => "80_dragonp_st03",
    },
    13 => { # ネズミ娘 / Rat Girl
      :dead_word => ["\\n<Rat Girl>I can't take it anymore...", "nezumi_fc1", 2],
      :orgasm_word => ["\\n<Rat Girl>I... I'm coming!", "nezumi_fc1", 2],
      :predation_word => ["\\n<Rat Girl>D-don't eat me... Noooo!", "nezumi_fc1", 2],
      :incontinence_word => ["\\n<Rat Girl>I had an accident... Don't watch... Fuuaa...", "nezumi_fc1", 2],
      :premortal_graphic => "50_nezumi_st03",
    },
    14 => { # 狼娘
      :dead_word => ["\\n<Wolf Girl>Rawr... My ancestors are calling to me...", "okami_fc1", 2],
      :orgasm_word => ["\\n<Wolf Girl>Rawr... My head is all white and fuzzy...", "okami_fc1", 2],
      :predation_word => ["\\n<Wolf Girl>You... You can't really eat me... Nooooo!", "okami_fc1", 2],
      :incontinence_word => ["\\n<Wolf Girl>I peed in a place like this...", "okami_fc1", 2],
      :premortal_graphic => "50_okami_st03",
    },
    15 => { # フェニックス娘 / Phoenix Girl
      :dead_word => ["\\n<Phoenix Girl>They got me!", "phoenix_fc1", 2],
      :orgasm_word => ["\\n<Phoenix Girl>This is the first time... Hyaauu...", "phoenix_fc1", 5],
      :predation_word => ["\\n<Phoenix Girl>If you eat a phoenix, you'll burn yourself! Hyaaa!", "phoenix_fc1", 2],
      :incontinence_word => ["\\n<Phoenix Girl>I outgrew peeing myself... But I'm still doing it...", "phoenix_fc1", 5],
      :premortal_graphic => "80_phoenix_st03",
    },
    16 => { # ヒル娘 / Leech Girl
      :dead_word => ["\\n<Leech Girl>N-no...", "hiru_fc1", 2],
      :orgasm_word => ["\\n<Leech Girl>How could I come...", "hiru_fc1", 2],
      :predation_word => ["\\n<Leech Girl>You're going to eat me...? A-ahhh!", "hiru_fc1", 2],
      :incontinence_word => ["\\n<Leech Girl>My body is letting it go... Ah...", "hiru_fc1", 2],
      :premortal_graphic => "50_hiru_st03",
    },
    17 => { # ウサギ娘 / Rabbit Girl
      :dead_word => ["\\n<Rabbit Girl>Guh... I can't feel my body...", "usagi_fc1", 2],
      :orgasm_word => ["\\n<Rabbit Girl>I'm coming in front of everyone...", "usagi_fc1", 2],
      :predation_word => ["\\n<Rabbit Girl>D-don't eat me... Miss, I'll do anything... Kyaaa!", "usagi_fc1", 2],
      :incontinence_word => ["\\n<Rabbit Girl>I-I'm peeing... I'm so embarrassed...", "usagi_fc1", 2],
      :premortal_graphic => "50_usagi_st03",
    },
    18 => { # 羊娘 / Sheep Girl
      :dead_word => ["\\n<Sheep Girl>Past the river... I see the old lady shepherd calling me...", "hituzi_fc1", 3],
      :orgasm_word => ["\\n<Sheep Girl>Don't make a drunk girl coooome...", "hituzi_fc1", 3],
      :predation_word => ["\\n<Sheep Girl>If you eat me, it'll be bad for your liver...", "hituzi_fc1", 3],
      :incontinence_word => ["\\n<Sheep Girl>It's leaking... It's because I'm drunk, right...?", "hituzi_fc1", 3],
      :premortal_graphic => "50_hituzi_st04",
    },
    19 => { # シュリー / Sully
      :dead_word => ["\\n<Sully>I can't move anymore...", "syuree_fc1", 2],
      :orgasm_word => ["\\n<Sully>What the... It feels so good...", "syuree_fc1", 3],
      :predation_word => ["\\n<Sully>Am I tasty? Please let me know...", "syuree_fc1", 1],
      :incontinence_word => ["\\n<Sully>I'm peeing... *Whine*", "syuree_fc1", 3],
      :premortal_graphic => "50_syuree_st03",
    },
    20 => { # ジェイド / Jaide
      :dead_word => ["\\n<Jaide>Breakdown. Shutting off...", "jeid_fc1", 2],
      :orgasm_word => ["\\n<Jaide>Pleasure meter is at maximum...", "jeid_fc1", 3],
      :predation_word => ["\\n<Jaide>Danger is at max... Predator...", "jeid_fc1", 2],
      :incontinence_word => ["\\n<Jaide>Oil is discharging... No. This is not oil...", "jeid_fc1", 3],
      :premortal_graphic => "50_jeid_st03",
    },
    21 => { # シェスタ / Shesta
      :dead_word => ["\\n<Shesta>Ahh, Goddess...", "syesta_fc1", 2],
      :orgasm_word => ["\\n<Shesta>It feels so good, I'm coming...", "syesta_fc1", 2],
      :predation_word => ["\\n<Shesta>Am I edible...?", "syesta_fc1", 2],
      :incontinence_word => ["\\n<Shesta>Am I leaking...?", "syesta_fc1", 2],
      :premortal_graphic => "50_syesta_st03",
    },
    22 => { # ？？？ / Nuruko
      :dead_word => ["\\n<？？？>Kyu...", "nuruko_fc1", 2],
      :orgasm_word => ["\\n<？？？>Kyuuuuuu...", "nuruko_fc1", 2],
      :predation_word => ["\\n<？？？>...Kyu!", "nuruko_fc1", 2],
      :incontinence_word => ["\\n<？？？>Kyukyuuu...", "nuruko_fc1", 2],
      :premortal_graphic => "80_nuruko_st03",
    },
    23 => { # オーク娘 / Orc Girl
      :dead_word => ["\\n<Orc Girl>Bubuuu...", "orc_fc1", 2],
      :orgasm_word => ["\\n<Orc Girl>But I'm an orc... An orc...", "orc_fc1", 2],
      :predation_word => ["\\n<Orc Girl>Buhi! I'm not tasty! I may look tasty, but I'm not!", "orc_fc1", 2],
      :incontinence_word => ["\\n<Orc Girl>Buhi... I'm an orc... This is shameful...", "orc_fc1", 2],
      :premortal_graphic => "50_orc_st03",
    },
    24 => { # ミツバチ娘 / Bee Girl
      :dead_word => ["\\n<Bee Girl>I need a honey break...", "mitubati_fc1", 2],
      :orgasm_word => ["\\n<Bee Girl>To be forced to come like this...", "mitubati_fc1", 2],
      :predation_word => ["\\n<Bee Girl>Do you think I taste sweet? You might be right... But please don't!", "mitubati_fc1", 2],
      :incontinence_word => ["\\n<Bee Girl>Ahh, I'm leaking...", "mitubati_fc1", 2],
      :premortal_graphic => "50_mitubati_st03",
    },
    25 => { # スズメ娘 / Sparrow Girl
      :dead_word => ["\\n<Sparrow Girl>I'm still so weak...", "suzume_fc1", 3],
      :orgasm_word => ["\\n<Sparrow Girl>Oh no, I'm coming...", "suzume_fc1", 3],
      :predation_word => ["\\n<Sparrow Girl>Are you really going to eat me...?", "suzume_fc1", 3],
      :incontinence_word => ["\\n<Sparrow Girl>This is so embarrassing...", "suzume_fc1", 3],
      :premortal_graphic => "50_suzume_st04",
    },
    26 => { # ハーピー / Harpy
      :dead_word => ["\\n<Harpy>I couldn't do it...", "hapy_a_fc1", 2],
      :orgasm_word => ["\\n<Harpy>I'm coming... It feels so good...", "hapy_a_fc1", 2],
      :predation_word => ["\\n<Harpy>D-don't eat me... Ahhhh!", "hapy_a_fc1", 2],
      :incontinence_word => ["\\n<Harpy>Oh no, I'm peeing...", "hapy_a_fc1", 2],
      :premortal_graphic => "80_hapy_a_st03",
    },
    27 => { # ハーピーツインズ / Harpy Sisters
      :dead_word => ["\\n<Harpy Sisters>Sister, I can't take it anymore...", "hapy_bc_fc1", 2],
      :orgasm_word => ["\\n<Harpy Sisters>Big sis, I'm coming...", "hapy_bc_fc1", 2],
      :predation_word => ["\\n<Harpy Sisters>Don't eat me...", "hapy_bc_fc1", 2],
      :incontinence_word => ["\\n<Harpy Sisters>No... I don't want to pee in front of my little sister...", "hapy_bc_fc1", 2],
      :premortal_graphic => "80_hapy_bc_st03",
    },
    28 => { # クィーンハーピー / Queen Harpy
      :dead_word => ["\\n<Queen Harpy>Guh, brought to this point...", "queenhapy_fc1", 3],
      :orgasm_word => ["\\n<Queen Harpy>Guh... Such humiliation for a queen...", "queenhapy_fc1", 3],
      :predation_word => ["\\n<Queen Harpy>Are you going to eat me...? It can't be... Ahhh!", "queenhapy_fc1", 3],
      :incontinence_word => ["\\n<Queen Harpy>To be seen like this... A lifetime of shame...", "queenhapy_fc1", 3],
      :premortal_graphic => "80_queenhapy_st04",
    },
    29 => { # ハイスラッグ娘 / High Slug
      :dead_word => ["\\n<High Slug>H-how vexing... How could I...", "highslag_fc1", 2],
      :orgasm_word => ["\\n<High Slug>For someone such as I to have been made to come... How vexing...!", "highslag_fc1", 2],
      :predation_word => ["\\n<High Slug>T-to think I'd be eaten!", "highslag_fc1", 2],
      :incontinence_word => ["\\n<High Slug>F-for me to leak in front of others...", "highslag_fc1", 2],
      :premortal_graphic => "50_highslag_st03",
    },
    30 => { # ナメクジシスター / Slug Nun
      :dead_word => ["\\n<Slug Nun>Oh Goddess, allow me to rest...", "name_s_fc1", 2],
      :orgasm_word => ["\\n<Slug Nun>Ahh, such a pleasant feeling... Ahhh...!", "name_s_fc1", 2],
      :predation_word => ["\\n<Slug Nun>Oh Goddess, help me... A-ahhh!", "name_s_fc1", 2],
      :incontinence_word => ["\\n<Slug Nun>Ah, such humiliation... Ahhh...", "name_s_fc1", 2],
      :premortal_graphic => "50_name_s_st03",
    },
    31 => { # スラグスターズ / Sluggy Stars
      :dead_word => ["\\n<Sluggy Stars>To think we couldn't do it...", "name2_fc2", 3],
      :orgasm_word => ["\\n<Sluggy Stars>To make all of us come...", "name2_fc2", 3],
      :predation_word => ["\\n<Sluggy Stars>D-don't eat me... Ahhh!", "name2_fc2", 3],
      :incontinence_word => ["\\n<Sluggy Stars>Ah, I'm leaking...", "name2_fc2", 3],
      :premortal_graphic => "80_name2_st03",
    },
    32 => { # ジャックオーランタン / Jack O Lantern
      :dead_word => ["\\n<Jack O Lantern>Smashed pumpkin...", "jack_fc1", 2],
      :orgasm_word => ["\\n<Jack O Lantern>You're... a strange one...", "jack_fc1", 2],
      :predation_word => ["\\n<Jack O Lantern>I just taste like a normal pumpkin...", "jack_fc1", 2],
      :incontinence_word => ["\\n<Jack O Lantern>I'm peeing...", "jack_fc1", 2],
      :premortal_graphic => "50_jack_st03",
    },
    33 => { # ローパー娘 / Roper Girl
      :dead_word => ["\\n<Roper Girl>I'm hungry...", "ropa_fc1", 2],
      :orgasm_word => ["\\n<Roper Girl>How could that... make me come...", "ropa_fc1", 2],
      :predation_word => ["\\n<Roper Girl>I'm going to be eaten...?", "ropa_fc1", 2],
      :incontinence_word => ["\\n<Roper Girl>Peeing... Don't look...", "ropa_fc1", 2],
      :premortal_graphic => "50_ropa_st03",
    },
    34 => { # メーダ娘 / Meda
      :dead_word => ["\\n<Meda>*Falls over*", "meda_fc1", 0],
      :orgasm_word => ["\\n<Meda>*Shivers*", "meda_fc1", 0],
      :predation_word => ["\\n<Meda>*Struggles*", "meda_fc1", 0],
      :incontinence_word => ["\\n<Meda>*Trembles*", "meda_fc1", 0],
      :premortal_graphic => "50_meda_st01",
    },
    35 => { # キャンドル娘 / Candle Girl
      :dead_word => ["\\n<Candle Girl>The flame is fading...", "candle_fc1", 2],
      :orgasm_word => ["\\n<Candle Girl>In my final moments, I can feel such pleasure...", "candle_fc1", 2],
      :predation_word => ["\\n<Candle Girl>My final moments as another creature's sustenance...", "candle_fc1", 2],
      :incontinence_word => ["\\n<Candle Girl>No... The wax is leaking...", "candle_fc1", 2],
      :premortal_graphic => "50_candle_st03",
    },
    36 => { # イーター / Eater
      :dead_word => ["\\n<Eater>I want to eat... Want to eat...", "eater_fc1", 2],
      :orgasm_word => ["\\n<Eater>Body... is strange...", "eater_fc1", 1],
      :predation_word => ["\\n<Eater>I don't want to be eaten... I want to eat...", "eater_fc1", 4],
      :incontinence_word => ["\\n<Eater>Leaking...", "eater_fc1", 1],
      :premortal_graphic => "50_eater_st03",
    },
    37 => { # ライオット / Riot
      :dead_word => ["\\n<Riot>Guh, no more...", "liot_fc1", 2],
      :orgasm_word => ["\\n<Riot>N-nooo... It's too much...", "liot_fc1", 3],
      :predation_word => ["\\n<Riot>Am I going to be preyed on here...?", "liot_fc1", 2],
      :incontinence_word => ["\\n<Riot>How could I... Such a shameful thing...", "liot_fc1", 3],
      :premortal_graphic => "50_liot_st03",
    },
    38 => { # ルクスル / Luxuru
      :dead_word => ["\\n<Luxuru>Battle continuation impossible... Body ceases to move...", "luksl_fc1", 2],
      :orgasm_word => ["\\n<Luxuru>Ahaha, I'm the one coming...?!", "luksl_fc1", 1],
      :predation_word => ["\\n<Luxuru>I'm heavy in the stomach! You won't enjoy this!", "luksl_fc1", 2],
      :incontinence_word => ["\\n<Luxuru>Ahaha, I'm leaking!", "luksl_fc1", 1],
      :premortal_graphic => "50_luksl_st03",
    },
    39 => { # ダークエルフ / Dark Elf Fencer
      :dead_word => ["\\n<Dark Elf Fencer>Kuh... To think I'd lose...", "delh_a_fc1", 2],
      :orgasm_word => ["\\n<Dark Elf Fencer>N-noooo... I'm cominggg!", "delh_a_fc1", 2],
      :predation_word => ["\\n<Dark Elf Fencer>D-don't eat me... Stop... Ahhh!", "delh_a_fc1", 2],
      :incontinence_word => ["\\n<Dark Elf Fencer>No, I'm peeing... Stop, don't look at me...", "delh_a_fc1", 2],
      :premortal_graphic => "50_delh_a_st03",
    },
    40 => { # ダークエルフ / Dark Elf Mage
      :dead_word => ["\\n<Dark Elf Mage>I can't do any more than this...", "delh_b_fc1", 2],
      :orgasm_word => ["\\n<Dark Elf Mage>How could one such as me have come...", "delh_b_fc1", 2],
      :predation_word => ["\\n<Dark Elf Mage>How could you eat one such as me...", "delh_b_fc1", 2],
      :incontinence_word => ["\\n<Dark Elf Mage>Ah, such humiliation...", "delh_b_fc1", 2],
      :premortal_graphic => "50_delh_b_st03",
    },
    41 => { # フェアリー / Fairy
      :dead_word => ["\\n<Fairy>Uwaaaa...", "fairy_fc1", 2],
      :orgasm_word => ["\\n<Fairy>I'm coooming...", "fairy_fc1", 2],
      :predation_word => ["\\n<Fairy>Nooo... Don't eat me...", "fairy_fc1", 2],
      :incontinence_word => ["\\n<Fairy>I'm going to pee...", "fairy_fc1", 2],
      :premortal_graphic => "50_fairy_st03",
    },
    42 => { # ミニカニ娘 / Mini Crab Girl
      :dead_word => ["\\n<Mini Crab Girl>Uwaan!", "minikani_fc1", 2],
      :orgasm_word => ["\\n<Mini Crab Girl>I'm coming, stop waaatching!", "minikani_fc1", 2],
      :predation_word => ["\\n<Mini Crab Girl>Waan, don't eat meeee!", "minikani_fc1", 2],
      :incontinence_word => ["\\n<Mini Crab Girl>Don't watch me peeeee!", "minikani_fc1", 2],
      :premortal_graphic => "50_minikani_st03",
    },
    43 => { # ナマズ娘 / Catfish Girl
      :dead_word => ["\\n<Catfish Girl>Curse you, bullying an elder...", "namazu_fc1", 2],
      :orgasm_word => ["\\n<Catfish Girl>Making an old girl like me... Haau...", "namazu_fc1", 2],
      :predation_word => ["\\n<Catfish Girl>Oi, my flesh isn't tasty! Hyaaa!", "namazu_fc1", 2],
      :incontinence_word => ["\\n<Catfish Girl>I must be losing it in my old age...", "namazu_fc1", 2],
      :premortal_graphic => "50_namazu_st03",
    },
    44 => { # ラフレシア娘 / Rafflesia Girl
      :dead_word => ["\\n<Rafflesia Girl>How could... I...", "rahure_fc1", 2],
      :orgasm_word => ["\\n<Rafflesia Girl>Ahh, feels good...", "rahure_fc1", 2],
      :predation_word => ["\\n<Rafflesia Girl>Even if you eat me, I'm mostly petals... A-ah!", "rahure_fc1", 2],
      :incontinence_word => ["\\n<Rafflesia Girl>I'm leaking... I'm sure it smells awful to you...", "rahure_fc1", 2],
      :premortal_graphic => "50_rahure_st03",
    },
    45 => { # セントール / Centaur
      :dead_word => ["\\n<Centaur>Is just running useless after all...?", "cent2_fc1", 2],
      :orgasm_word => ["\\n<Centaur>Ahh, I'm coming in front of everyone...", "cent2_fc1", 2],
      :predation_word => ["\\n<Centaur>Please don't eat me... Kyaaa!", "cent2_fc1", 2],
      :incontinence_word => ["\\n<Centaur>Ahh, I'm peeing in front of everyone...", "cent2_fc1", 2],
      :premortal_graphic => "50_cent2_st03",
    },
    46 => { # 銀狐二尾 / Two-Tailed Silver Kitsune
      :dead_word => ["\\n<Two-Tailed Silver Kitsune>Hyaaaa!", "youko_fc1", 2],
      :orgasm_word => ["\\n<Two-Tailed Silver Kitsune>Hyaaa, that feels so good...", "youko_fc1", 2],
      :predation_word => ["\\n<Two-Tailed Silver Kitsune>Don't eat me, I'll give you fried tofu instead... Hyaaa!", "youko_fc1", 2],
      :incontinence_word => ["\\n<Two-Tailed Silver Kitsune>I'm going to pee... *Whine*", "youko_fc1", 2],
      :premortal_graphic => "50_youko_st03",
    },
    47 => { # かむろ二尾 / Two-Tailed Geisha
      :dead_word => ["\\n<Two-Tailed Geisha>No more... I must take a short break...", "kamuro_fc1", 2],
      :orgasm_word => ["\\n<Two-Tailed Geisha>N-not this... Haauu...", "kamuro_fc1", 2],
      :predation_word => ["\\n<Two-Tailed Geisha>D-don't eat me... No... Ahhh...", "kamuro_fc1", 2],
      :incontinence_word => ["\\n<Two-Tailed Geisha>I'm sorry, I'm peeing... Haau... So... rry...", "kamuro_fc1", 2],
      :premortal_graphic => "50_kamuro_st03",
    },
    48 => { # クモ娘 / Spider Girl
      :dead_word => ["\\n<Spider Girl>No, I've been beaten!", "kumo_fc1", 2],
      :orgasm_word => ["\\n<Spider Girl>To come like this... Humiliation...!", "kumo_fc1", 2],
      :predation_word => ["\\n<Spider Girl>Eating me? It can't be, how could someone like me...?", "kumo_fc1", 2],
      :incontinence_word => ["\\n<Spider Girl>P-peeing... Hauu...", "kumo_fc1", 2],
      :premortal_graphic => "80_kumo_st03",
    },
    49 => { # ミミック娘 / Mimic
      :dead_word => ["\\n<Mimic>H-horrible!", "mimic_fc1", 1],
      :orgasm_word => ["\\n<Mimic>D-don't...", "mimic_fc1", 1],
      :predation_word => ["\\n<Mimic>D-don't eat me! Please, I'll do anything so... Kyaa!", "mimic_fc1", 1],
      :incontinence_word => ["\\n<Mimic>L-leaking... It's in my box, so it's okay...", "mimic_fc1", 1],
      :premortal_graphic => "80_mimic_st03",
    },
    50 => { # 七尾 / Nanabi
      :dead_word => ["\\n<Nanabi>Gah, I made a blunder...", "nanabi_fc1", 3],
      :orgasm_word => ["\\n<Nanabi>Such humiliation...", "nanabi_fc1", 3],
      :predation_word => ["\\n<Nanabi>For one such as I to fall prey to others...", "nanabi_fc1", 3],
      :incontinence_word => ["\\n<Nanabi>H-how could I pee... P-please don't look...", "nanabi_fc1", 3],
      :premortal_graphic => "80_nanabi_st04",
    },
    51 => { # モリガン / Morrigan
      :dead_word => ["\\n<Morrigan>Hmm, well look at you go!", "morrigan_fc1", 2],
      :orgasm_word => ["\\n<Morrigan>How could I... Nnnnn...!", "morrigan_fc1", 2],
      :predation_word => ["\\n<Morrigan>To think you'd eat me... Unbelievable... Nooooo!", "morrigan_fc1", 2],
      :incontinence_word => ["\\n<Morrigan>How could I pee...! I'll never forgive you...!", "morrigan_fc1", 2],
      :premortal_graphic => "80_morrigan_st03b",
    },
    52 => { # ナマコ娘 / Sea Cucumber Girl
      :dead_word => ["\\n<Sea Cucumber Girl>No, how could this...", "namako_fc1", 2],
      :orgasm_word => ["\\n<Sea Cucumber Girl>It feels so good, but I'm so embarrassed...", "namako_fc1", 2],
      :predation_word => ["\\n<Sea Cucumber Girl>You shouldn't be eating strange things... Kyaaa!", "namako_fc1", 2],
      :incontinence_word => ["\\n<Sea Cucumber Girl>I'm leaking... Ah...", "namako_fc1", 2],
      :premortal_graphic => "50_namako_st03",
    },
    53 => { # 貝娘 / Shellfish Girl
      :dead_word => ["\\n<Shellfish Girl>Ahh, such violence...", "kai_fc1", 2],
      :orgasm_word => ["\\n<Shellfish Girl>Someone other than my darling making me come...", "kai_fc1", 2],
      :predation_word => ["\\n<Shellfish Girl>I beg you, don't eat me... Ahhh!", "kai_fc1", 2],
      :incontinence_word => ["\\n<Shellfish Girl>Don't look at me, darling...", "kai_fc1", 2],
      :premortal_graphic => "50_kai_st03",
    },
    54 => { # カニ娘 / Crab Girl
      :dead_word => ["\\n<Crab Girl>Not this...", "kani_fc1", 2],
      :orgasm_word => ["\\n<Crab Girl>I could get addicted to this...", "kani_fc1", 2],
      :predation_word => ["\\n<Crab Girl>D-don't eat me... No... Ahhh!", "kani_fc1", 2],
      :incontinence_word => ["\\n<Crab Girl>P-peeing in public... Nooo...", "kani_fc1", 2],
      :premortal_graphic => "50_kani_st03",
    },
    55 => { # スライムベス娘 / Slime Bess
      :dead_word => ["\\n<Slime Bess>Why are you treating me like this...", "slimelord_fc1", 2],
      :orgasm_word => ["\\n<Slime Bess>Purupuru... I'm coming...", "slimelord_fc1", 2],
      :predation_word => ["\\n<Slime Bess>Don't eat me, please don't eat me...", "slimelord_fc1", 2],
      :incontinence_word => ["\\n<Slime Bess>Peeing, I'm peeing...", "slimelord_fc1", 2],
      :premortal_graphic => "50_slimelord_st03",
    },
    56 => { # スイカ娘 / Watermelon Girl
      :dead_word => ["\\n<Watermelon Girl>My watermelon broke...", "suika_fc1", 2],
      :orgasm_word => ["\\n<Watermelon Girl>So frustrating...", "suika_fc1", 2],
      :predation_word => ["\\n<Watermelon Girl>If you have to eat something, just eat the watermelon! Not my whole... Aahhh!", "suika_fc1", 2],
      :incontinence_word => ["\\n<Watermelon Girl>I can't hold it in... Don't look...", "suika_fc1", 2],
      :premortal_graphic => "50_suika_st03",
    },
    57 => { # ウツボカズラ娘 / Pitcher Plant Girl
      :dead_word => ["\\n<Pitcher Plant Girl>You got me...", "utubo_fc1", 2],
      :orgasm_word => ["\\n<Pitcher Plant Girl>This feels way too good...", "utubo_fc1", 2],
      :predation_word => ["\\n<Pitcher Plant Girl>How could I be the one eaten instead... At least make it feel good for me...", "utubo_fc1", 2],
      :incontinence_word => ["\\n<Pitcher Plant Girl>I can't hold it in... My digestive juices are leaking...", "utubo_fc1", 2],
      :premortal_graphic => "50_utubo_st03",
    },
    58 => { # ラミア / Lamia
      :dead_word => ["\\n<Lamia>No... How could I...", "lamia_fc1", 2],
      :orgasm_word => ["\\n<Lamia>How could one such as I have come...", "lamia_fc1", 2],
      :predation_word => ["\\n<Lamia>Y-you're going to eat me...? You can't be... Ahhh!", "lamia_fc1", 2],
      :incontinence_word => ["\\n<Lamia>No, it's leaking... Ahhh...", "lamia_fc1", 2],
      :premortal_graphic => "80_lamia_st03",
    },
    59 => { # ワカメ娘 / Seaweed Girl
      :dead_word => ["\\n<Seaweed Girl>*Swaying* *Collapses*", "wakame_fc1", 2],
      :orgasm_word => ["\\n<Seaweed Girl>Nnnn... *Swaying*", "wakame_fc1", 2],
      :predation_word => ["\\n<Seaweed Girl>I'm not tasty... I lied... I probably am tasty...", "wakame_fc1", 2],
      :incontinence_word => ["\\n<Seaweed Girl>*Swaying* I'm peeing...", "wakame_fc1", 2],
      :premortal_graphic => "50_wakame_st03",
    },
    60 => { # クラゲ娘 / Jellyfish Girl
      :dead_word => ["\\n<Jellyfish Girl>No more...", "kurage_fc1", 0],
      :orgasm_word => ["\\n<Jellyfish Girl>So good...", "kurage_fc1", 0],
      :predation_word => ["\\n<Jellyfish Girl>Don't eat me...", "kurage_fc1", 0],
      :incontinence_word => ["\\n<Jellyfish Girl>Peeing...", "kurage_fc1", 0],
      :premortal_graphic => "50_kurage_st01",
    },
    61 => { # イソギンチャク娘 / Sea Anemone Girl
      :dead_word => ["\\n<Sea Anemone Girl>Kyaaa!", "iso_fc1", 2],
      :orgasm_word => ["\\n<Sea Anemone Girl>To think that would make me come...!", "iso_fc1", 2],
      :predation_word => ["\\n<Sea Anemone Girl>Don't think you can eat me so easily... Don't! Ahh!", "iso_fc1", 2],
      :incontinence_word => ["\\n<Sea Anemone Girl>Guh, I can't hold it in... No... Ah...", "iso_fc1", 2],
      :premortal_graphic => "80_iso_st03",
    },
    62 => { # アンコウ娘 / Anglerfish Girl
      :dead_word => ["\\n<Anglerfish Girl>......", "ankou_fc1", 0],
      :orgasm_word => ["\\n<Anglerfish Girl>......", "ankou_fc1", 0],
      :predation_word => ["\\n<Anglerfish Girl>......", "ankou_fc1", 0],
      :incontinence_word => ["\\n<Anglerfish Girl>......", "ankou_fc1", 0],
      :premortal_graphic => "50_ankou_st01",
    },
    63 => { # メイア / Meia
      :dead_word => ["\\n<Meia>Ahh, how could this...", "meia_fc1", 3],
      :orgasm_word => ["\\n<Meia>It feels so good... But miserable at the same time...", "meia_fc1", 3],
      :predation_word => ["\\n<Meia>D-don't eat me... Kyaaaa!", "meia_fc1", 3],
      :incontinence_word => ["\\n<Meia>P-peeing in public like this... This is too embarrassing...", "meia_fc1", 3],
      :premortal_graphic => "80_meia_st04",
    },
    64 => { # 17ページ / Page 17
      :dead_word => ["\\n<Page 17>I can't move my body...", "page17_fc1", 0],
      :orgasm_word => ["\\n<Page 17>This feeling... Nnnn...", "page17_fc1", 0],
      :predation_word => ["\\n<Page 17>Don't eat me...", "page17_fc1", 0],
      :incontinence_word => ["\\n<Page 17>To think I'd pee...", "page17_fc1", 0],
      :premortal_graphic => "50_page17_st01",
    },
    65 => { # 257ページ / Page 257
      :dead_word => ["\\n<Page 257>Let me just take a short rest...", "page257_fc1", 2],
      :orgasm_word => ["\\n<Page 257>Ahh, this pleasant feeling... I can't take it anymore...", "page257_fc1", 2],
      :predation_word => ["\\n<Page 257>D-don't eat me... D-don't... No... Ah!", "page257_fc1", 2],
      :incontinence_word => ["\\n<Page 257>This is too shameful... Please... Don't look...", "page257_fc1", 2],
      :premortal_graphic => "50_page257_st03",
    },
    66 => { # 65537ページ / Page 65537
      :dead_word => ["\\n<Page 65537>How could I face such humiliation...", "page65537_fc1", 2],
      :orgasm_word => ["\\n<Page 65537>To think this body... would react to pleasure...", "page65537_fc1", 2],
      :predation_word => ["\\n<Page 65537>You would eat me!? I-I'll remember this... Kyaa!", "page65537_fc1", 2],
      :incontinence_word => ["\\n<Page 65537>D-don't look! Such humiliation...", "page65537_fc1", 2],
      :premortal_graphic => "80_page65537_st13",
    },
    67 => { # シスターラミア / Lamia Nun
      :dead_word => ["\\n<Sister Lamia>Ahh, not this... Forgive me...", "sisterlamia_fc1", 2],
      :orgasm_word => ["\\n<Sister Lamia>Oh Goddess, such pleasure... Ah...!", "sisterlamia_fc1", 2],
      :predation_word => ["\\n<Sister Lamia>For me to become the sustenance of others... Kyaaa!", "sisterlamia_fc1", 2],
      :incontinence_word => ["\\n<Sister Lamia>Ahh, such a shameful act... Oh Goddess, please forgive me...", "sisterlamia_fc1", 2],
      :premortal_graphic => "50_sisterlamia_st03",
    },
    68 => { # シスターサキュバス
      :dead_word => ["\\n<Succubus Nun>Ah, how could this...", "sisccubus_fc1", 2],
      :orgasm_word => ["\\n<Succubus Nun>My body is rejoicing... Forgive me for this sinful act...", "sisccubus_fc1", 2],
      :predation_word => ["\\n<Succubus Nun>Please stop this... Ahhh!", "sisccubus_fc1", 2],
      :incontinence_word => ["\\n<Succubus Nun>Ahh... I'll be seen doing this...", "sisccubus_fc1", 2],
      :premortal_graphic => "50_sisccubus_st03",
    },
    69 => { # アリクイ娘 / Anteater Girl
      :dead_word => ["\\n<Anteater Girl>I can't fight anymore... *Falls over*", "arikui_fc1", 2],
      :orgasm_word => ["\\n<Anteater Girl>No, it's too much... Ahh!", "arikui_fc1", 2],
      :predation_word => ["\\n<Anteater Girl>D-don't eat me! Noooo!", "arikui_fc1", 2],
      :incontinence_word => ["\\n<Anteater Girl>Heeey... Don't look at me... Nooooo...", "arikui_fc1", 2],
      :premortal_graphic => "50_arikui_st03",
    },
    70 => { # グリズリー娘 / Grizzly Bear Girl
      :dead_word => ["\\n<Grizzly Bear Girl>Rawr... I can't fight anymore...", "grizzly_fc1", 2],
      :orgasm_word => ["\\n<Grizzly Bear Girl>Hauu... This is the first time I've felt like this...", "grizzly_fc1", 2],
      :predation_word => ["\\n<Grizzly Bear Girl>You can't eat me!", "grizzly_fc1", 2],
      :incontinence_word => ["\\n<Grizzly Bear Girl>It's embarrassing... Please don't look...", "grizzly_fc1", 2],
      :premortal_graphic => "50_grizzly_st03",
    },
    71 => { # Experiment XX-7
      :dead_word => ["\\n<Experiment XX-7>My body... won't move...", "XX-7_fc1", 0],
      :orgasm_word => ["\\n<Experiment XX-7>For me... to be made to feel this...", "XX-7_fc1", 0],
      :predation_word => ["\\n<Experiment XX-7>For me... to be eaten...", "XX-7_fc1", 0],
      :incontinence_word => ["\\n<Experiment XX-7>I... am leaking...", "XX-7_fc1", 0],
      :premortal_graphic => "50_XX-7_st01",
    },
    72 => { # リトルバグ / Little Bug
      :dead_word => ["\\n<Little Bug>I'm done for...", "littlebug_fc1", 2],
      :orgasm_word => ["\\n<Little Bug>This feels good...", "littlebug_fc1", 3],
      :predation_word => ["\\n<Little Bug>You're going to eat me!? No, don't-!", "littlebug_fc1", 2],
      :incontinence_word => ["\\n<Little Bug>How could I pee... Hafuu...", "littlebug_fc1", 3],
      :premortal_graphic => "50_littlebug_st03",
    },
    73 => { # キャンサーロイド / Canceroid
      :dead_word => ["\\n<Canceroid>Kuh, I can't move my body...", "kaniloid_fc1", 2],
      :orgasm_word => ["\\n<Canceroid>This amazing feeling... Ah...", "kaniloid_fc1", 2],
      :predation_word => ["\\n<Canceroid>Don't eat me... You can't... Ahhh!", "kaniloid_fc1", 2],
      :incontinence_word => ["\\n<Canceroid>My bodily fluids... are leaking...", "kaniloid_fc1", 2],
      :premortal_graphic => "80_kaniloid_st03",
    },
    74 => { # ブリュンヒルデ / Brynhildr
      :dead_word => ["\\n<Brynhildr>My body... won't move...", "brunhild_fc1", 2],
      :orgasm_word => ["\\n<Brynhildr>Nooo... My body feels so strange...!", "brunhild_fc1", 4],
      :predation_word => ["\\n<Brynhildr>You're... going to eat me? No, I don't want this...", "brunhild_fc1", 2],
      :incontinence_word => ["\\n<Brynhildr>Something is leaking... It's strange... But it feels good...", "brunhild_fc1", 4],
      :premortal_graphic => "80_brunhild_st23",
    },
    75 => { # ゴースト / Ghost Girl
      :dead_word => ["\\n<Ghost Girl>Am I going to die again...?", "ghost_fc1", 0],
      :orgasm_word => ["\\n<Ghost Girl>It feels good... But, I can't...", "ghost_fc1", 0],
      :predation_word => ["\\n<Ghost Girl>Eating... a ghost...?", "ghost_fc1", 0],
      :incontinence_word => ["\\n<Ghost Girl>Even though I'm a ghost... I'm peeing...", "ghost_fc1", 0],
      :premortal_graphic => "50_ghost_st01",
    },
    76 => { # 呪いの人形娘 / Cursed Doll
      :dead_word => ["\\n<Cursed Doll>I want to play... More...", "doll_fc1", 2],
      :orgasm_word => ["\\n<Cursed Doll>Strange feeling... My body feels weird...", "doll_fc1", 2],
      :predation_word => ["\\n<Cursed Doll>Don't eat me... No...", "doll_fc1", 2],
      :incontinence_word => ["\\n<Cursed Doll>I'm peeing... I'm sorry...", "doll_fc1", 2],
      :premortal_graphic => "50_doll_st03",
    },
    77 => { # ゾンビ剣士 / Zombie Swordsman
      :dead_word => ["\\n<Zombie Swordsman>Uuu... Aaa...", "zonbe_fc2", 0],
      :orgasm_word => ["\\n<Zombie Swordsman>Haa... Uuu...", "zonbe_fc2", 0],
      :predation_word => ["\\n<Zombie Swordsman>Ah... Ah...", "zonbe_fc2", 0],
      :incontinence_word => ["\\n<Zombie Swordsman>Uooo... Ah...", "zonbe_fc2", 0],
      :premortal_graphic => "50_zonbe_st11",
    },
    78 => { # ゾンビ娘 / Zombie Girl
      :dead_word => ["\\n<Zombie Girl>Oooo...", "zonbe_fc3", 0],
      :orgasm_word => ["\\n<Zombie Girl>Ah...", "zonbe_fc3", 0],
      :predation_word => ["\\n<Zombie Girl>Uooo... Ah...", "zonbe_fc3", 0],
      :incontinence_word => ["\\n<Zombie Girl>Auu... Oo...", "zonbe_fc3", 0],
      :premortal_graphic => "50_zonbe_st21",
    },
    79 => { # ゾンビ娘 / Zombie Girl
      :dead_word => ["\\n<Zombie Girl>Oooo...", "zonbe_fc3", 1],
      :orgasm_word => ["\\n<Zombie Girl>Ah...", "zonbe_fc3", 1],
      :predation_word => ["\\n<Zombie Girl>Uooo... Ah...", "zonbe_fc3", 1],
      :incontinence_word => ["\\n<Zombie Girl>Auu... Oo...", "zonbe_fc3", 1],
      :premortal_graphic => "50_zonbe_st31",
    },
    80 => { # ゾンビ娘 / Zombie Girl
      :dead_word => ["\\n<Zombie Girl>Auu... Ah...", "zonbe_fc3", 2],
      :orgasm_word => ["\\n<Zombie Girl>Uooo... Ah...", "zonbe_fc3", 2],
      :predation_word => ["\\n<Zombie Girl>Ooo... Ah...", "zonbe_fc3", 2],
      :incontinence_word => ["\\n<Zombie Girl>Ah... Uooo...", "zonbe_fc3", 2],
      :premortal_graphic => "50_zonbe_st41",
    },
    81 => { # ゾンビ娘 / Zombie Girl
      :dead_word => ["\\n<Zombie Girl>Ah... aa...", "zonbe_fc1", 0],
      :orgasm_word => ["\\n<Zombie Girl>Uoo... Ah...", "zonbe_fc1", 0],
      :predation_word => ["\\n<Zombie Girl>Haa... Aah...", "zonbe_fc1", 0],
      :incontinence_word => ["\\n<Zombie Girl>Ah... Uuu...", "zonbe_fc1", 0],
      :premortal_graphic => "50_zonbe_st01",
    },
    82 => { # フレデリカ / Frederica
      :dead_word => ["\\n<Frederica>My body... won't move...", "frederika_fc1", 2],
      :orgasm_word => ["\\n<Frederica>This feeling... My body feels strange...", "frederika_fc1", 1],
      :predation_word => ["\\n<Frederica>You're going to... eat me...", "frederika_fc1", 2],
      :incontinence_word => ["\\n<Frederica>I'm peeing...", "frederika_fc1", 1],
      :premortal_graphic => "80_frederika_st13",
    },
    83 => { # クロム / Chrome
      :dead_word => ["\\n<Chrome>No more...", "chrom_fc1", 6],
      :orgasm_word => ["\\n<Chrome>N-noooo... I'm coming... Haaauuu...", "chrom_fc1", 5],
      :predation_word => ["\\n<Chrome>D-don't eat me... Hyaaa!", "chrom_fc1", 6],
      :incontinence_word => ["\\n<Chrome>I-I'm peeing... Embarrassing... Ah...", "chrom_fc1", 6],
      :premortal_graphic => "80_chrom_st34",
    },
    84 => { # エルフ / Elf
      :dead_word => ["\\n<Elf>I can't fight anymore...", "elf_fc1", 2],
      :orgasm_word => ["\\n<Elf>Ahh, coming... I'm coming... And everyone can see...", "elf_fc1", 2],
      :predation_word => ["\\n<Elf>Hey, don't eat me... You can rape me, just don't eat me... Ahh!", "elf_fc1", 2],
      :incontinence_word => ["\\n<Elf>Oh no, I'm peeing... Don't look... Ahhh...", "elf_fc1", 2],
      :premortal_graphic => "50_elf_st03",
    },
    85 => { # ブラウニーズ / Brownies
      :dead_word => ["\\n<Brownies>Goodnight...", "braunys_fc2", 0],
      :orgasm_word => ["\\n<Brownies>I came...", "braunys_fc2", 0],
      :predation_word => ["\\n<Brownies>No! Don't eat me!", "braunys_fc2", 0],
      :incontinence_word => ["\\n<Brownies>Peeing...", "braunys_fc2", 0],
      :premortal_graphic => "50_braunys_st03",
    },
    86 => { # ツインズフェアリー / Twin Fairies
      :dead_word => ["\\n<Twin Fairies>Uwaaa...", "tfairy_fc1", 2],
      :orgasm_word => ["\\n<Twin Fairies>No, I came...", "tfairy_fc1", 2],
      :predation_word => ["\\n<Twin Fairies>Don't eat meee!", "tfairy_fc1", 2],
      :incontinence_word => ["\\n<Twin Fairies>I'm peeing...", "tfairy_fc1", 2],
      :premortal_graphic => "50_tfairy_st03",
    },
    87 => { # フェアリーズ / Fairies
      :dead_word => ["\\n<Fairies>Uwaaa...", "fairys_fc1", 2],
      :orgasm_word => ["\\n<Fairies>Waaaaan, that feels gooood...", "fairys_fc1", 2],
      :predation_word => ["\\n<Fairies>I'm being eeeateeen...", "fairys_fc1", 2],
      :incontinence_word => ["\\n<Fairies>I'm peeeeing...", "fairys_fc1", 2],
      :premortal_graphic => "50_fairys_st03",
    },
    88 => { # フェアリーズ / Fairies
      :dead_word => ["\\n<Fairies>No...", "fairys_fc2", 2],
      :orgasm_word => ["\\n<Fairies>Oh no...", "fairys_fc2", 2],
      :predation_word => ["\\n<Fairies>I don't want to be eaten...", "fairys_fc2", 2],
      :incontinence_word => ["\\n<Fairies>Peeing...", "fairys_fc2", 2],
      :premortal_graphic => "50_fairys_st13",
    },
    89 => { # フェアリーズ / Fairies
      :dead_word => ["\\n<Fairies>Noooo...", "fairys_fc3", 2],
      :orgasm_word => ["\\n<Fairies>I don't want thiiis!", "fairys_fc3", 2],
      :predation_word => ["\\n<Fairies>Don't eat meee!", "fairys_fc3", 2],
      :incontinence_word => ["\\n<Fairies>I'm peeeeing!", "fairys_fc3", 2],
      :premortal_graphic => "50_fairys_st23",
    },
    90 => { # フェアリーズ / Fairies
      :dead_word => ["\\n<Fairies>Not this...", "fairys_fc4", 0],
      :orgasm_word => ["\\n<Fairies>Not this...", "fairys_fc4", 0],
      :predation_word => ["\\n<Fairies>Don't eat me...", "fairys_fc4", 0],
      :incontinence_word => ["\\n<Fairies>This is too shameful...", "fairys_fc4", 0],
      :premortal_graphic => "50_fairys_st31",
    },
    91 => { # フェアリーズ / Fairies
      :dead_word => ["\\n<Fairies>Noooo...", "fairys_fc4", 1],
      :orgasm_word => ["\\n<Fairies>What is this...", "fairys_fc4", 1],
      :predation_word => ["\\n<Fairies>Nononoooo...", "fairys_fc4", 1],
      :incontinence_word => ["\\n<Fairies>Oh no, I'm peeeeing...", "fairys_fc4", 1],
      :premortal_graphic => "50_fairys_st41",
    },
    92 => { # フェアリーズ / Fairies
      :dead_word => ["\\n<Fairies>Noooo...", "fairys_fc4", 2],
      :orgasm_word => ["\\n<Fairies>Noooo...", "fairys_fc4", 2],
      :predation_word => ["\\n<Fairies>Noooo...", "fairys_fc4", 2],
      :incontinence_word => ["\\n<Fairies>Peeing...", "fairys_fc4", 2],
      :premortal_graphic => "50_fairys_st51",
    },
    93 => { # シルフ / Sylph
      :dead_word => ["\\n<Sylph>Looks like I got the crap beaten out of me.\nThank you so much.", "sylph_fc1", 1],
      :orgasm_word => ["\\n<Sylph>Looks like I got the crap beaten out of me.\nThank you so much.", "sylph_fc1", 1],
      :predation_word => ["\\n<Sylph>D-don't eat me... Hyaaan!", "sylph_fc1", 4],
      :incontinence_word => ["\\n<Sylph>I'm gonna pee... Noooo...", "sylph_fc1", 4],
      :premortal_graphic => "50_sylph_st04",
    },
    94 => { # 鎧の狂戦士 / Armored Berserker
      :dead_word => ["\\n<Armored Berserker>AN... GE... L...!", "heinrich_fc2", 0],
      :dead_word => ["\\n<Armored Berserker>AN... GE... L...!", "heinrich_fc2", 0],
      :dead_word => ["\\n<Armored Berserker>AN... GE... L...!", "heinrich_fc2", 0],
      :dead_word => ["\\n<Armored Berserker>AN... GE... L...!", "heinrich_fc2", 0],
      :premortal_graphic => "80_heinrich_st11",
    },
    95 => { # タランチュラ娘 / Tarantula Girl
      :dead_word => ["\\n<Tarantula Girl>Not in a place like this!", "taran_fc1", 2],
      :orgasm_word => ["\\n<Tarantula Girl>I-I'm coming...?", "taran_fc1", 2],
      :predation_word => ["\\n<Tarantula Girl>No, don't eat me...", "taran_fc1", 2],
      :incontinence_word => ["\\n<Tarantula Girl>Ah, I'm leaking...", "taran_fc1", 2],
      :premortal_graphic => "50_taran_st03",
    },
    96 => { # ミノタウロス娘 / Minotauros
      :dead_word => ["\\n<Minotauros>Kah, you got me!", "mino_fc1", 2],
      :orgasm_word => ["\\n<Minotauros>Stop... Don't watch me come...", "mino_fc1", 2],
      :predation_word => ["\\n<Minotauros>E-eating me... Damn you! Nooo... Ahh!", "mino_fc1", 2],
      :incontinence_word => ["\\n<Minotauros>Stop... Don't watch me pee...", "mino_fc1", 2],
      :premortal_graphic => "80_mino_st03",
    },
    97 => { # バンダースナッチ娘 / Bandersnatch Girl
      :dead_word => ["\\n<Bandersnatch Girl>Kah, too bad...", "bander_fc1", 2],
      :orgasm_word => ["\\n<Bandersnatch Girl>How could I... Ah...", "bander_fc1", 2],
      :predation_word => ["\\n<Bandersnatch Girl>Stop... Guh! Ah...", "bander_fc1", 2],
      :incontinence_word => ["\\n<Bandersnatch Girl>I'm leaking? No way... Guu...", "bander_fc1", 2],
      :premortal_graphic => "80_bander_st03",
    },
    98 => { # エヴァ / Eva
      :dead_word => ["\\n<Eva>Why me...?!\nWhy is this always happening to me...?!", "eva_fc1", 2],
      :orgasm_word => ["\\n<Eva>I can't believe I'm being forced to come...\nI'm a succubus, damn it...", "eva_fc1", 2],
      :predation_word => ["\\n<Eva>Stop! If you're going to eat someone, eat someone else... Nooooo!", "eva_fc1", 2],
      :incontinence_word => ["\\n<Eva>Don't look! Don't look...\nUrhg...", "eva_fc1", 2],
      :premortal_graphic => "80_eva_st03",
    },
    99 => { # サボレス / Sables
      :dead_word => ["\\n<Sables>Hey, that's awful of you...", "saboresu_fc1", 2],
      :orgasm_word => ["\\n<Sables>This is too much to take...", "saboresu_fc1", 2],
      :predation_word => ["\\n<Sables>D-don't eat me... Kyaaa!", "saboresu_fc1", 2],
      :incontinence_word => ["\\n<Sables>I'm sorry, I'm peeing...", "saboresu_fc1", 2],
      :premortal_graphic => "50_saboresu_st03",
    },
    100 => { # ムカデ娘 / Centipede Girl
      :dead_word => ["\\n<Centipede Girl>It looks like my shell was useless...", "mukade_fc1", 2],
      :orgasm_word => ["\\n<Centipede Girl>Even if my shell is hard, it can't stop pleasure...", "mukade_fc1", 2],
      :predation_word => ["\\n<Centipede Girl>You better stop... My taste is infamous... Aaah!", "mukade_fc1", 2],
      :incontinence_word => ["\\n<Centipede Girl>Ah, I'm leaking...", "mukade_fc1", 2],
      :premortal_graphic => "50_mukade_st03",
    },
    101 => { # サソリ娘 / Scorpion Girl
      :dead_word => ["\\n<Scorpion Girl>How could I-!", "sasori_fc1", 2],
      :orgasm_word => ["\\n<Scorpion Girl>I've never felt this good before in the desert...", "sasori_fc1", 2],
      :predation_word => ["\\n<Scorpion Girl>I don't have much meat, so... Kyaaa!", "sasori_fc1", 2],
      :incontinence_word => ["\\n<Scorpion Girl>Kuh, such humiliation...", "sasori_fc1", 2],
      :premortal_graphic => "50_sasori_st03",
    },
    102 => { # サボテン娘 / Cactus Girl
      :dead_word => ["\\n<Cactus Girl>Ahh, I need a little rest...", "saboten_fc1", 2],
      :orgasm_word => ["\\n<Cactus Girl>I've never felt so good before... A-ah...", "saboten_fc1", 2],
      :predation_word => ["\\n<Cactus Girl>It'll hurt if you eat me... So... Kyaa!", "saboten_fc1", 2],
      :incontinence_word => ["\\n<Cactus Girl>Stop, don't look at me... Ahhh...", "saboten_fc1", 2],
      :premortal_graphic => "50_saboten_st03",
    },
    103 => { # ダチョウ娘 / Ostrich Girl
      :dead_word => ["\\n<Ostrich Girl>I can't run anymore...", "datyou_fc1", 2],
      :orgasm_word => ["\\n<Ostrich Girl>It feels too good... No more...", "datyou_fc1", 2],
      :predation_word => ["\\n<Ostrich Girl>Please don't eat me... Ah, yaaa!", "datyou_fc1", 2],
      :incontinence_word => ["\\n<Ostrich Girl>Don't watch me pee...", "datyou_fc1", 2],
      :premortal_graphic => "50_datyou_st03",
    },
    104 => { # ランプの魔女 / Lamp Genie
      :dead_word => ["\\n<Lamp Genie>I need to go back in my lamp for a while...", "lamp_fc1", 2],
      :orgasm_word => ["\\n<Lamp Genie>To make me come like this...", "lamp_fc1", 2],
      :predation_word => ["\\n<Lamp Genie>You think you can eat me...? No... Kyaaa!", "lamp_fc1", 2],
      :incontinence_word => ["\\n<Lamp Genie>To think I'd pee... Don't look... Haauu...", "lamp_fc1", 2],
      :premortal_graphic => "50_lamp_st23",
    },
    105 => { # ミイラ娘 / Mummy Girl
      :dead_word => ["\\n<Mummy Girl>I need... a short rest...", "mummy_fc1", 2],
      :orgasm_word => ["\\n<Mummy Girl>This... is my female instinct...", "mummy_fc1", 2],
      :predation_word => ["\\n<Mummy Girl>Eating me...? I'll taste awful, you know...", "mummy_fc1", 2],
      :incontinence_word => ["\\n<Mummy Girl>Was there even moisture left in me...?", "mummy_fc1", 2],
      :premortal_graphic => "50_mummy_st03",
    },
    106 => { # コブラ娘 / Cobra Girl
      :dead_word => ["\\n<Cobra Girl>Such a blunder!", "kobura_fc1", 2],
      :orgasm_word => ["\\n<Cobra Girl>For me to come... Hauu...", "kobura_fc1", 2],
      :predation_word => ["\\n<Cobra Girl>I'll never forgive you for eating me... Kyaaa!", "kobura_fc1", 2],
      :incontinence_word => ["\\n<Cobra Girl>Making me pee in such a place...", "kobura_fc1", 2],
      :premortal_graphic => "50_kobura_st03",
    },
    107 => { # ネフェルラミアス / Nefertiti Lamias
      :dead_word => ["\\n<Nefertiti Lamias>Kyaaa!", "lamias_fc2", 4],
      :orgasm_word => ["\\n<Nefertiti Lamias>Oh no, I'm coming...!", "lamias_fc2", 4],
      :predation_word => ["\\n<Nefertiti Lamias>Don't eat us... Or at least just eat me and leave my sisters alone...", "lamias_fc2", 4],
      :incontinence_word => ["\\n<Nefertiti Lamias>No, I'm peeing...", "lamias_fc2", 4],
      :premortal_graphic => "80_lamias_st02",
    },
    108 => { # スフィンクス娘 / Sphinx
      :dead_word => ["\\n<Sphinx>For me to have... What humiliation...", "sphinx_fc1", 2],
      :orgasm_word => ["\\n<Sphinx>It has been hundreds of years since such pleasure...", "sphinx_fc1", 2],
      :predation_word => ["\\n<Sphinx>For me to have ended up being eaten...", "sphinx_fc1", 2],
      :incontinence_word => ["\\n<Sphinx>For me to expose such a miserable visage...", "sphinx_fc1", 2],
      :premortal_graphic => "80_sphinx_st03",
    },
    109 => { # サラ / Sara
      :dead_word => ["\\n<Sara>Ahh... I don't have any more strength...", "sara_fc4", 2],
      :orgasm_word => ["\\n<Sara>It feels good... But it's humiliating...", "sara_fc4", 2],
      :predation_word => ["\\n<Sara>I'm going to be eaten...?", "sara_fc4", 2],
      :incontinence_word => ["\\n<Sara>Ah, I'm leaking... So much pee...", "sara_fc4", 2],
      :premortal_graphic => "80_saraevil_st03",
    },
    110 => { # アスタロト / Astaroth
      :dead_word => ["\\n<Astaroth>It seems I've been careless...", "astaroth_fc1", 2],
      :orgasm_word => ["\\n<Astaroth>I cannot accept such humiliation... I'm a great succubus, this is...!", "astaroth_fc1", 2],
      :predation_word => ["\\n<Astaroth>To eat me... You'll regret this!", "astaroth_fc1", 2],
      :incontinence_word => ["\\n<Astaroth>Kuh, such humiliation... P-prepare yourself!", "astaroth_fc1", 2],
      :premortal_graphic => "80_astaroth_st03b",
    },
    111 => { # ワニ娘 / Alligator Girl
      :dead_word => ["\\n<Alligator Girl>I... No more...", "wani_fc1", 2],
      :orgasm_word => ["\\n<Alligator Girl>I'm coming...", "wani_fc1", 2],
      :predation_word => ["\\n<Alligator Girl>I'm going to be eaten...?", "wani_fc1", 2],
      :incontinence_word => ["\\n<Alligator Girl>I'm peeing...", "wani_fc1", 2],
      :premortal_graphic => "50_wani_st03",
    },
    112 => { # サキ / Saki
      :dead_word => ["\\n<Saki>I'm sorry, fans... I'll be going to the next world first...", "saki_fc1", 2],
      :orgasm_word => ["\\n<Saki>I can't show this to my fans...", "saki_fc1", 2],
      :predation_word => ["\\n<Saki>You're going to eat me? No, noooo...", "saki_fc1", 2],
      :incontinence_word => ["\\n<Saki>No, I'm peeing... Are my fans happy? Or disillusioned...?", "saki_fc1", 2],
      :premortal_graphic => "80_saki_st03",
    },
    113 => { # デビルファイター / Devil Fighter
      :dead_word => ["\\n<Devil Fighter>This is also part of being a warrior...", "d_fighter_fc1", 0],
      :orgasm_word => ["\\n<Devil Fighter>Coming... This is so embarrassing...", "d_fighter_fc1", 2],
      :predation_word => ["\\n<Devil Fighter>Don't eat me... Nooo... Kyaaaa!", "d_fighter_fc1", 0],
      :incontinence_word => ["\\n<Devil Fighter>Peeing... Don't look...", "d_fighter_fc1", 2],
      :premortal_graphic => "50_d_fighter_st03",
    },
    114 => { # 大蜘蛛 / Oogumo
      :dead_word => ["\\n<Oogumo>Urhg... I can't move my body any longer...", "oogumo_fc1", 2],
      :orgasm_word => ["\\n<Oogumo>To think I'd be forced to come...", "oogumo_fc1", 2],
      :predation_word => ["\\n<Oogumo>D-don't eat me... Kyaaa!", "oogumo_fc1", 2],
      :incontinence_word => ["\\n<Oogumo>I'm peeing... Haau...", "oogumo_fc1", 2],
      :premortal_graphic => "50_oogumo_st03",
    },
    115 => { # サックボア / Suck Vore
      :dead_word => ["\\n<Suck Vore>......", "suckvore_fc1", 2],
      :orgasm_word => ["\\n<Suck Vore>......", "suckvore_fc1", 2],
      :predation_word => ["\\n<Suck Vore>......", "suckvore_fc1", 2],
      :incontinence_word => ["\\n<Suck Vore>......", "suckvore_fc1", 2],
      :premortal_graphic => "50_suckvore_st01",
    },
    116 => { # アイアンメイデン / Iron Maiden
      :dead_word => ["\\n<Iron Maiden>......", "ironmaiden_fc1", 0],
      :orgasm_word => ["\\n<Iron Maiden>......", "ironmaiden_fc1", 0],
      :predation_word => ["\\n<Iron Maiden>......", "ironmaiden_fc1", 0],
      :incontinence_word => ["\\n<Iron Maiden>......", "ironmaiden_fc1", 0],
      :premortal_graphic => "50_ironmaiden_st01",
    },
    117 => { # ワームビレッジャ / Worm Villager
      :dead_word => ["\\n<Worm Villager>No more... More power...", "wormv_fc1", 2],
      :orgasm_word => ["\\n<Worm Villager>So good... More...", "wormv_fc1", 2],
      :predation_word => ["\\n<Worm Villager>Eaten... I don't want this... Ah...", "wormv_fc1", 2],
      :incontinence_word => ["\\n<Worm Villager>Peeing... Feels so good...", "wormv_fc1", 2],
      :premortal_graphic => "80_wormv_st03",
    },
    118 => { # ウーストレル / Ustrel
      :dead_word => ["\\n<Ustrel>I'm taking a short break... Whew...", "ustrel_fc1", 2],
      :orgasm_word => ["\\n<Ustrel>Am I going to come...? No, not... Auuu...", "ustrel_fc1", 2],
      :predation_word => ["\\n<Ustrel>D-do anything but eat me... Kyaaaa!", "ustrel_fc1", 2],
      :incontinence_word => ["\\n<Ustrel>I'm peeing in a place like this...", "ustrel_fc1", 2],
      :premortal_graphic => "50_ustrel_st03",
    },
    119 => { # 蜜壺 / Honey Pot
      :dead_word => ["\\n<Honey Pot>I never should have left my pot...", "mitutubo_fc1", 2],
      :orgasm_word => ["\\n<Honey Pot>Ahh... It's already so wet in my pot...", "mitutubo_fc1", 2],
      :predation_word => ["\\n<Honey Pot>Hey, don't eat my pot!", "mitutubo_fc1", 2],
      :incontinence_word => ["\\n<Honey Pot>It's okay to pee in my pot, right...?", "mitutubo_fc1", 2],
      :premortal_graphic => "80_mitutubo_st03",
    },
    120 => { # リリィ / Lily
      :dead_word => ["\\n<Lily>Am I back to crawling on the ground...?", "lily_fc1", 6],
      :orgasm_word => ["\\n<Lily>For me to be humiliated such...! Ahhh...!", "lily_fc1", 6],
      :predation_word => ["\\n<Lily>Hmph. Do whatever you want...", "lily_fc1", 5],
      :incontinence_word => ["\\n<Lily>I'll never forgive you for this humiliation... Never... Never!", "lily_fc1", 6],
      :premortal_graphic => "80_lily_st04",
    },
    121 => { # 小鬼 / Oni
      :dead_word => ["\\n<Oni>I can't do any more... Gotta rest...", "kooni_fc1", 2],
      :orgasm_word => ["\\n<Oni>That feeling is... Auuhnnn...", "kooni_fc1", 2],
      :predation_word => ["\\n<Oni>Hey, this is a joke, right...? Don't eat meeee!", "kooni_fc1", 2],
      :incontinence_word => ["\\n<Oni>This is... embarrassing...", "kooni_fc1", 2],
      :premortal_graphic => "50_kooni_st03",
    },
    122 => { # オナホ娘 / Onahole Girl
      :dead_word => ["\\n<Onahole Girl>I can't fight any longer...", "onaho_fc1", 2],
      :orgasm_word => ["\\n<Onahole Girl>It's weird for me to be the one to come...", "onaho_fc1", 2],
      :predation_word => ["\\n<Onahole Girl>I might be soft, but I'm not tasty...", "onaho_fc1", 2],
      :incontinence_word => ["\\n<Onahole Girl>Ahh, I'm leaking...", "onaho_fc1", 2],
      :premortal_graphic => "50_onaho_st03",
    },
    123 => { # ナーキュバス / Naccubus
      :dead_word => ["\\n<Naccubus>I still have work to do...", "narcubus_fc1", 2],
      :orgasm_word => ["\\n<Naccubus>Haauu... I'm coming...", "narcubus_fc1", 2],
      :predation_word => ["\\n<Naccubus>I don't want to be eaten...", "narcubus_fc1", 2],
      :incontinence_word => ["\\n<Naccubus>I'm a naughty nurse... I'm even peeing...", "narcubus_fc1", 2],
      :premortal_graphic => "50_narcubus_st13",
    },
    124 => { # ルシア / Lucia
      :dead_word => ["\\n<Lucia>My power wasn't enough...", "lusia_fc1", 2],
      :orgasm_word => ["\\n<Lucia>Such humiliation...! I'll remember this...!", "lusia_fc1", 2],
      :predation_word => ["\\n<Lucia>You can't seriously... want to eat me...?", "lusia_fc1", 2],
      :incontinence_word => ["\\n<Lucia>Making me do something like this...", "lusia_fc1", 2],
      :premortal_graphic => "80_lusia_st03",
    },
    125 => { # 百々目鬼 / Dodomeki
      :dead_word => ["\\n<Dodomeki>I need to rest for a bit...", "dodome_fc1", 2],
      :orgasm_word => ["\\n<Dodomeki>How could I come... A-ah...!", "dodome_fc1", 2],
      :predation_word => ["\\n<Dodomeki>Don't eat me, don't eat me please...", "dodome_fc1", 2],
      :incontinence_word => ["\\n<Dodomeki>I'm peeing... Nooo...", "dodome_fc1", 2],
      :premortal_graphic => "50_dodome_st03",
    },
    126 => { # リザードシーフ / Lizard Thief
      :dead_word => ["\\n<Lizard Thief>How could I lose!?", "lizardthief_fc1", 2],
      :orgasm_word => ["\\n<Lizard Thief>Shit, how could someone like you make me come... Haaauuu...", "lizardthief_fc1", 2],
      :predation_word => ["\\n<Lizard Thief>Stop, don't eat me... Gyaaa!", "lizardthief_fc1", 2],
      :incontinence_word => ["\\n<Lizard Thief>Shit, I'm peeing...", "lizardthief_fc1", 2],
      :premortal_graphic => "50_lizardthief_st03",
    },
    127 => { # リザードシーフ / Lizard Thief
      :dead_word => ["\\n<Lizard Thief>It seems I was weaker...", "lizardthief_fc2", 2],
      :orgasm_word => ["\\n<Lizard Thief>Such humiliation... Ahhh...", "lizardthief_fc2", 2],
      :predation_word => ["\\n<Lizard Thief>Please, don't eat me... Kyaaaa!", "lizardthief_fc2", 2],
      :incontinence_word => ["\\n<Lizard Thief>How could I pee in a place like this...", "lizardthief_fc2", 2],
      :premortal_graphic => "50_lizardthief_st13",
    },
    128 => { # リザードボス / Lizard Boss
      :dead_word => ["\\n<Lizard Boss>Shit, I screwed up!", "lizardboss_fc1", 2],
      :orgasm_word => ["\\n<Lizard Boss>Shit, how could you... Ahhhh...!", "lizardboss_fc1", 5],
      :predation_word => ["\\n<Lizard Boss>Me, being eaten? How could this... Ahhh!", "lizardboss_fc1", 2],
      :incontinence_word => ["\\n<Lizard Boss>Shit, quit watching me... Ah, no... Leaking...", "lizardboss_fc1", 5],
      :premortal_graphic => "80_lizardboss_st03",
    },
    129 => { # 蜃気楼娘 / Mirage Girl
      :dead_word => ["\\n<Mirage Girl>*Plop*", "sinkiro_fc1", 3],
      :orgasm_word => ["\\n<Mirage Girl>Even though I'm just a mirage, I came...", "sinkiro_fc1", 2],
      :predation_word => ["\\n<Mirage Girl>A mirage isn't tasty... Hyaaa!", "sinkiro_fc1", 3],
      :incontinence_word => ["\\n<Mirage Girl>P-peeing... No, not this...", "sinkiro_fc1", 2],
      :premortal_graphic => "50_sinkiro_st04",
    },
    130 => { # アリジゴク娘 / Antlion Girl
      :dead_word => ["\\n<Antlion Girl>Damn... You should have been prey!", "arizigoku_fc1", 2],
      :orgasm_word => ["\\n<Antlion Girl>No, how could I come...", "arizigoku_fc1", 2],
      :predation_word => ["\\n<Antlion Girl>Eating me instead? You got guts!", "arizigoku_fc1", 2],
      :incontinence_word => ["\\n<Antlion Girl>How could I pee...", "arizigoku_fc1", 2],
      :premortal_graphic => "80_arizigoku_st03",
    },
    131 => { # サンドワーム娘 / Sandworm
      :dead_word => ["\\n<Sandworm>Ow...", "sandw_fc1", 2],
      :orgasm_word => ["\\n<Sandworm>So good...", "sandw_fc1", 2],
      :predation_word => ["\\n<Sandworm>How could I be eaten...", "sandw_fc1", 2],
      :incontinence_word => ["\\n<Sandworm>Peeing... Don't drown...", "sandw_fc1", 2],
      :premortal_graphic => "80_sandw_st03",
    },
    132 => { # デザートスキュラ / Desert Scylla
      :dead_word => ["\\n<Desert Scylla>I hate this!", "d_scylla_fc1", 2],
      :orgasm_word => ["\\n<Desert Scylla>Nooo, I came...!", "d_scylla_fc1", 2],
      :predation_word => ["\\n<Desert Scylla>I don't want to be eaten!", "d_scylla_fc1", 2],
      :incontinence_word => ["\\n<Desert Scylla>I'm peeing... Nooo...", "d_scylla_fc1", 2],
      :premortal_graphic => "50_d_scylla_st03",
    },
    133 => { # ノーム / Gnome
      :dead_word => ["\\n<Gnome>......", "gnome_fc1", 1],
      :orgasm_word => ["\\n<Gnome>......~~!", "gnome_fc1", 1],
      :predation_word => ["\\n<Gnome>...!!", "gnome_fc1", 1],
      :incontinence_word => ["\\n<Gnome>......", "gnome_fc1", 1],
      :premortal_graphic => "80_gnome_st02",
    },
    134 => { # ヴィタエ / Vitae
      :dead_word => ["\\n<Vitae>Ending here... Regrettable...", "vitae_fc1", 2],
      :orgasm_word => ["\\n<Vitae>To think I'd be forced to come...", "vitae_fc1", 2],
      :predation_word => ["\\n<Vitae>To think I'd be preyed on...", "vitae_fc1", 2],
      :incontinence_word => ["\\n<Vitae>Ahh, my body fluids are leaking...", "vitae_fc1", 2],
      :premortal_graphic => "50_vitae_st03",
    },
    135 => { # ヴェータラ / Vetala
      :dead_word => ["\\n<Vetala>This is making me angry...", "vetala_fc1", 2],
      :orgasm_word => ["\\n<Vetala>Ahh, I'm feeling it...", "vetala_fc1", 2],
      :predation_word => ["\\n<Vetala>How could I be preyed on...", "vetala_fc1", 2],
      :incontinence_word => ["\\n<Vetala>Disgraceful... Miserable...", "vetala_fc1", 2],
      :premortal_graphic => "50_vetala_st03",
    },
    136 => { # ヴァルト / Valto
      :dead_word => ["\\n<Valto>All parts, ceasing function...", "valt_fc1", 2],
      :orgasm_word => ["\\n<Valto>Pleasure endurance exceeded...", "valt_fc1", 2],
      :predation_word => ["\\n<Valto>Becoming prey...", "valt_fc1", 2],
      :incontinence_word => ["\\n<Valto>Urine liquids discharging...", "valt_fc1", 2],
      :premortal_graphic => "50_valt_st03",
    },
    137 => { # シニファ / Shinifa
      :dead_word => ["\\n<Shinifa>Ahahaha...", "sinifa_fc1", 2],
      :orgasm_word => ["\\n<Shinifa>Fufu... Hahaha!", "sinifa_fc1", 3],
      :predation_word => ["\\n<Shinifa>Hah, hahahahaha...!", "sinifa_fc1", 2],
      :incontinence_word => ["\\n<Shinifa>Hnnff... Hahahahaaa...", "sinifa_fc1", 3],
      :premortal_graphic => "50_sinifa_st03",
    },
    138 => { # シャドー娘 / Shadow Girl
      :dead_word => ["\\n<Shadow Girl>Return to the shadow world...", "shadow_fc1", 0],
      :orgasm_word => ["\\n<Shadow Girl>Climax... reached...", "shadow_fc1", 0],
      :predation_word => ["\\n<Shadow Girl>A shadow... being preyed on...", "shadow_fc1", 0],
      :incontinence_word => ["\\n<Shadow Girl>Urine... leaking...", "shadow_fc1", 0],
      :premortal_graphic => "50_shadow_st01",
    },
    139 => { # ガイストビーネ / Paintgeist
      :dead_word => ["\\n<Paintgeist>My strength... is fading...", "gaistvine_fc1", 1],
      :orgasm_word => ["\\n<Paintgeist>Ahh, feels good...", "gaistvine_fc1", 1],
      :predation_word => ["\\n<Paintgeist>I don't want to be eaten...", "gaistvine_fc1", 1],
      :incontinence_word => ["\\n<Paintgeist>I don't want to pee...", "gaistvine_fc1", 1],
      :premortal_graphic => "50_gaistvine_st02",
    },
    140 => { # キメラホムンクルス / Chimera Homunculus
      :dead_word => ["\\n<Chimera Homunculus>My... power...", "c_homunculus_fc1", 2],
      :orgasm_word => ["\\n<Chimera Homunculus>This pleasure... I can't take it...", "c_homunculus_fc1", 2],
      :predation_word => ["\\n<Chimera Homunculus>I... am being preyed on...", "c_homunculus_fc1", 2],
      :incontinence_word => ["\\n<Chimera Homunculus>I'm... discharging urine...", "c_homunculus_fc1", 2],
      :premortal_graphic => "50_c_homunculus_st03",
    },
    141 => { # アイアンメイデン改 / Neo Iron Maiden
      :dead_word => ["\\n<Neo Iron Maiden>Dispose... the sinners...", "ironmaiden_k_fc1", 2],
      :orgasm_word => ["\\n<Neo Iron Maiden>This pleasure... I'm a sinner...", "ironmaiden_k_fc1", 2],
      :predation_word => ["\\n<Neo Iron Maiden>I... am being preyed on...", "ironmaiden_k_fc1", 2],
      :incontinence_word => ["\\n<Neo Iron Maiden>I'm... incontinent...", "ironmaiden_k_fc1", 2],
      :premortal_graphic => "50_ironmaiden_k_st03",
    },
    142 => { # ジャンクドール娘 / Junk Doll Girl
      :dead_word => ["\\n<Junk Doll Girl>No... I'm junk...", "junkdoll_fc2", 1],
      :orgasm_word => ["\\n<Junk Doll Girl>Ah... I'm feeling it...", "junkdoll_fc2", 1],
      :predation_word => ["\\n<Junk Doll Girl>You're eating a doll...? W-weirdo!", "junkdoll_fc2", 1],
      :incontinence_word => ["\\n<Junk Doll Girl>How is this even possible...", "junkdoll_fc2", 1],
      :premortal_graphic => "80_junkdoll_st01",
    },
    143 => { # アドラメレク / Adramelech
      :dead_word => ["\\n<Adramelech>C... Class... Two... C... ont...", "adramelek_fc1", 6],
      :orgasm_word => ["\\n<Adramelech>C... Class... Two... C... ont...", "adramelek_fc1", 6],
      :predation_word => ["\\n<Adramelech>C... Class... Two... C... ont...", "adramelek_fc1", 6],
      :incontinence_word => ["\\n<Adramelech>......", "adramelek_fc1", 5],
      :premortal_graphic => "80_adramelek_st14",
    },
    144 => { # アリスフィーズ16世 / Alipheese the 16th
      :dead_word => ["\\n<Alipheese the 16th>Guh... I'm pushed to here...", "alice_fc2", 1],
      :orgasm_word => ["\\n<Alipheese the 16th>I'm being forced to come...", "alice_fc2", 1],
      :predation_word => ["\\n<Alipheese the 16th>D-don't eat me! Uwaaa!!", "alice_fc2", 1],
      :incontinence_word => ["\\n<Alipheese the 16th>I'm peeing... Ahhh...", "alice_fc2", 1],
      :premortal_graphic => "80_alice_st10",
    },
    145 => { # 死神 / Reaper
      :dead_word => ["\\n<Reaper>So I'm forced to my knees, eh...", "sinigami_fc1", 2],
      :orgasm_word => ["\\n<Reaper>I'm forced to do this...", "sinigami_fc1", 2],
      :predation_word => ["\\n<Reaper>I'm being preyed on...?", "sinigami_fc1", 2],
      :incontinence_word => ["\\n<Reaper>I'm peeing...", "sinigami_fc1", 2],
      :premortal_graphic => "80_sinigami_st03",
    },
    146 => { # ラナエル / Archangel Ranael
      :dead_word => ["\\n<Archangel Ranael>How could I lose...!", "ranael_fc1", 2],
      :orgasm_word => ["\\n<Archangel Ranael>How could I succumb to pleasure...!", "ranael_fc1", 2],
      :predation_word => ["\\n<Archangel Ranael>Eating me! I'll never forgive this!", "ranael_fc1", 2],
      :incontinence_word => ["\\n<Archangel Ranael>Such humiliation! I'll never forgive this!", "ranael_fc1", 2],
      :premortal_graphic => "80_ranael_st33",
    },
    147 => { # ナガエル / Principality Nagael
      :dead_word => ["\\n<Principality Nagael>I must not be defeated...", "nagael_fc1", 2],
      :orgasm_word => ["\\n<Principality Nagael>Defeated by pleasure...\nGoddess Ilias, forgive me...", "nagael_fc1", 2],
      :predation_word => ["\\n<Principality Nagael>E-eating me...?!\nYou can't be... Ahhh!", "nagael_fc1", 2],
      :incontinence_word => ["\\n<Principality Nagael>How could I...\nAhh, snakes, don't lick it... Nooo...", "nagael_fc1", 2],
      :premortal_graphic => "80_nagael_st03",
    },
    148 => { # インプ
      :dead_word => ["\\n<Imp>Bleh...", "inp_fc3", 2],
      :orgasm_word => ["\\n<Imp>Noooo...", "inp_fc3", 2],
      :predation_word => ["\\n<Imp>No...", "inp_fc3", 2],
      :incontinence_word => ["\\n<Imp>Leaking...", "inp_fc3", 2],
      :premortal_graphic => "50_inp_st23",
    },
    149 => { # インプ / Imp
      :dead_word => ["\\n<Imp>Bleh...", "inp_fc2", 2],
      :orgasm_word => ["\\n<Imp>Nng... Nnnggg!", "inp_fc2", 2],
      :predation_word => ["\\n<Imp>Nnnngg!", "inp_fc2", 2],
      :incontinence_word => ["\\n<Imp>Noooo... Don't...", "inp_fc2", 2],
      :premortal_graphic => "50_inp_st13",
    },
    151 => { # きのこ娘
      :dead_word => ["\\n<Mushroom Girl>Ahh, such regret...", "kinoko_fc1", 2],
      :orgasm_word => ["\\n<Mushroom Girl>This... Ahhh...", "kinoko_fc1", 2],
      :predation_word => ["\\n<Mushroom Girl>Mushrooms are nutritious... Ahh...", "kinoko_fc1", 2],
      :incontinence_word => ["\\n<Mushroom Girl>Ahh, so embarrassing...\nDon't look, don't look...", "kinoko_fc1", 2],
      :premortal_graphic => "80_kinoko_st03",
    },
    152 => { # ノビスタドール娘
      :dead_word => ["\\n<Novistador Girl>Hya!?", "nobisutam_fc1", 2],
      :orgasm_word => ["\\n<Novistador Girl>Coming...", "nobisutam_fc1", 2],
      :predation_word => ["\\n<Novistador Girl>I'm not tasty...", "nobisutam_fc1", 2],
      :incontinence_word => ["\\n<Novistador Girl>It's leaking...", "nobisutam_fc1", 2],
      :premortal_graphic => "50_nobisutam_st03",
    },
    153 => { # ウルスキュラ
      :dead_word => ["\\n<Urscylla>Why are you treating me like this...", "u_scylla_fc1", 2],
      :orgasm_word => ["\\n<Urscylla>In front of everyone... Ahh...", "u_scylla_fc1", 2],
      :predation_word => ["\\n<Urscylla>D-don't eat me... Nooo!!", "u_scylla_fc1", 2],
      :incontinence_word => ["\\n<Urscylla>The worst... Don't look...", "u_scylla_fc1", 2],
      :premortal_graphic => "50_u_scylla_st03",
    },
    154 => { # 襖
      :dead_word => ["\\n<Fusuma>*Swaying slowly*", "husuma_fc1", 2],
      :orgasm_word => ["\\n<Fusuma>Coming...", "husuma_fc1", 2],
      :predation_word => ["\\n<Fusuma>I'm light, I won't taste good...", "husuma_fc1", 2],
      :incontinence_word => ["\\n<Fusuma>I'll get wet and stained...", "husuma_fc1", 2],
      :premortal_graphic => "80_husuma_st03",
    },
    155 => { # マーメイド
      :dead_word => ["\\n<Mermaid>I need a short rest...", "mermaid_fc1", 2],
      :orgasm_word => ["\\n<Mermaid>Ahh, that feels good...", "mermaid_fc1", 2],
      :predation_word => ["\\n<Mermaid>How could you eat a mermaid... Ahh...", "mermaid_fc1", 2],
      :incontinence_word => ["\\n<Mermaid>I shouldn't... Ahh, how embarrassing...", "mermaid_fc1", 2],
      :premortal_graphic => "50_mermaid_st03",
    },
    156 => { # 商人マーメイド
      :dead_word => ["\\n<Mermaid Merchant>This is my limit...", "s_mermaid_fc1", 2],
      :orgasm_word => ["\\n<Mermaid Merchant>Not this... Nnnnn!", "s_mermaid_fc1", 2],
      :predation_word => ["\\n<Mermaid Merchant>I don't taste good...", "s_mermaid_fc1", 2],
      :incontinence_word => ["\\n<Mermaid Merchant>This shame play...", "s_mermaid_fc1", 2],
      :premortal_graphic => "50_s_mermaid_st03",
    },
    157 => { # 海賊マーメイド
      :dead_word => ["\\n<Mermaid Pirate>No more...", "k_mermaid_fc1", 2],
      :orgasm_word => ["\\n<Mermaid Pirate>Coming...", "k_mermaid_fc1", 2],
      :predation_word => ["\\n<Mermaid Pirate>D-don't eat meeee! Hyaa!", "k_mermaid_fc1", 2],
      :incontinence_word => ["\\n<Mermaid Pirate>Stop watching me pee...", "k_mermaid_fc1", 2],
      :premortal_graphic => "50_k_mermaid_st03",
    },
    158 => { # 一反木綿娘
      :dead_word => ["\\n<Ittan-Momen>I'm gonna dieee!", "ittanmomen_fc1", 2],
      :orgasm_word => ["\\n<Ittan-Momen>I'm cominggg!", "ittanmomen_fc1", 2],
      :predation_word => ["\\n<Ittan-Momen>Paper doesn't taste good, you know...", "ittanmomen_fc1", 2],
      :incontinence_word => ["\\n<Ittan-Momen>I don't want to peeee!", "ittanmomen_fc1", 2],
      :premortal_graphic => "80_ittanmomen_st03",
    },
    159 => { # 一反木綿娘
      :dead_word => ["\\n<Ittan-Momen>I'm so tired...", "ittanmomen_fc2", 2],
      :orgasm_word => ["\\n<Ittan-Momen>That feels good...", "ittanmomen_fc2", 2],
      :predation_word => ["\\n<Ittan-Momen>Nooo, don't eat me!", "ittanmomen_fc2", 2],
      :incontinence_word => ["\\n<Ittan-Momen>I'm leaking...", "ittanmomen_fc2", 2],
      :premortal_graphic => "80_ittanmomen_st13",
    },
    160 => { # 一反木綿娘
      :dead_word => ["\\n<Ittan-Momen>Don't bully me...", "ittanmomen_fc3", 2],
      :orgasm_word => ["\\n<Ittan-Momen>This feeling... For the first time...", "ittanmomen_fc3", 2],
      :predation_word => ["\\n<Ittan-Momen>My body is toxic, so... Kyaaa!", "ittanmomen_fc3", 2],
      :incontinence_word => ["\\n<Ittan-Momen>This is so embarrassing...", "ittanmomen_fc3", 2],
      :premortal_graphic => "80_ittanmomen_st23",
    },
    161 => { # ダゴン娘
      :dead_word => ["\\n<Dagon Girl>No mooore!", "dagon_fc1", 2],
      :orgasm_word => ["\\n<Dagon Girl>I'm coming...", "dagon_fc1", 2],
      :predation_word => ["\\n<Dagon Girl>S-stop this... Hyaa!", "dagon_fc1", 2],
      :incontinence_word => ["\\n<Dagon Girl>Peeing is so embarrassing...", "dagon_fc1", 2],
      :premortal_graphic => "50_dagon_st03",
    },
    162 => { # 人魂娘
      :dead_word => ["\\n<Hitodama Girl>How could I die...? I'm already a soul...", "hitodama_fc1", 2],
      :orgasm_word => ["\\n<Hitodama Girl>Ahh, that feels good...", "hitodama_fc1", 2],
      :predation_word => ["\\n<Hitodama Girl>If you eat a soul, you'll be cursed, you know...", "hitodama_fc1", 2],
      :incontinence_word => ["\\n<Hitodama Girl>Ahh... I'm leaking...", "hitodama_fc1", 2],
      :premortal_graphic => "50_hitodama_st03",
    },
    163 => { # アシェル
      :dead_word => ["\\n<Ashel>Tch. In a place like this...", "ashel_fc1", 2],
      :orgasm_word => ["\\n<Ashel>Damn, such humiliation... Nnnnn!", "ashel_fc1", 2],
      :predation_word => ["\\n<Ashel>Don't eat me, damn it...", "ashel_fc1", 2],
      :incontinence_word => ["\\n<Ashel>Don't look! Stop looking, I said!", "ashel_fc1", 2],
      :premortal_graphic => "50_ashel_st03",
    },
    164 => { # ボニー
      :dead_word => ["\\n<Bonnie>Uuu!", "bonny_fc1", 2],
      :orgasm_word => ["\\n<Bonnie>I'm cominggg! Ahhhh!", "bonny_fc1", 2],
      :predation_word => ["\\n<Bonnie>I-I don't want to be eaten!", "bonny_fc1", 2],
      :incontinence_word => ["\\n<Bonnie>*Sniffle* I peed...", "bonny_fc1", 2],
      :premortal_graphic => "50_bonny_st03",
    },
    165 => { # タツノコ海兵
      :dead_word => ["\\n<Seahorse Marine>Kyuu...", "tatunoko_k_fc1", 2],
      :orgasm_word => ["\\n<Seahorse Marine>That feels gooood!", "tatunoko_k_fc1", 2],
      :predation_word => ["\\n<Seahorse Marine>I don't want to be eaten! Hyaaaa!", "tatunoko_k_fc1", 2],
      :incontinence_word => ["\\n<Seahorse Marine>This is so embarrassing...", "tatunoko_k_fc1", 2],
      :premortal_graphic => "50_tatunoko_k_st03",
    },
    166 => { # ウミウシ海兵
      :dead_word => ["\\n<Sea Slug Marine>You got me...", "umiusi_k_fc1", 2],
      :orgasm_word => ["\\n<Sea Slug Marine>Ahh, how could I come...", "umiusi_k_fc1", 2],
      :predation_word => ["\\n<Sea Slug Marine>You're eating me...", "umiusi_k_fc1", 2],
      :incontinence_word => ["\\n<Sea Slug Marine>You're making me pee...", "umiusi_k_fc1", 2],
      :premortal_graphic => "50_umiusi_k_st03",
    },
    167 => { # リヴァイアサン娘
      :dead_word => ["\\n<Leviathan>To fall here!", "levia_fc1", 2],
      :orgasm_word => ["\\n<Leviathan>This humiliation... Forgive me...!", "levia_fc1", 2],
      :predation_word => ["\\n<Leviathan>You think to eat me... Damn you!", "levia_fc1", 2],
      :incontinence_word => ["\\n<Leviathan>D-don't look... Ahhh...", "levia_fc1", 2],
      :premortal_graphic => "80_levia_st03",
    },
    168 => { # カエル娘
      :dead_word => ["\\n<Frog Girl>Ribbit...", "kaeru_fc1", 2],
      :orgasm_word => ["\\n<Frog Girl>No, I'm coming...!", "kaeru_fc1", 2],
      :predation_word => ["\\n<Frog Girl>Frogs aren't tasty, you know... Hya!", "kaeru_fc1", 2],
      :incontinence_word => ["\\n<Frog Girl>So embarrassing...", "kaeru_fc1", 2],
      :premortal_graphic => "50_kaeru_st03",
    },
    169 => { # カエル娘
      :dead_word => ["\\n<Frog Girl>Ribbit...", "kaeru_fc2", 2],
      :orgasm_word => ["\\n<Frog Girl>This is so... embarrassing...", "kaeru_fc2", 2],
      :predation_word => ["\\n<Frog Girl>Even though I won't taste good...", "kaeru_fc2", 2],
      :incontinence_word => ["\\n<Frog Girl>Ah... Miserable...", "kaeru_fc2", 2],
      :premortal_graphic => "50_kaeru_st13",
    },
    170 => { # ケンタウロス娘
      :dead_word => ["\\n<Kentauros>Even with my speed, I couldn't avoid this...", "centa_fc1", 2],
      :orgasm_word => ["\\n<Kentauros>N-no... Ahhh...!", "centa_fc1", 2],
      :predation_word => ["\\n<Kentauros>Eating a horse... Uwaa!", "centa_fc1", 2],
      :incontinence_word => ["\\n<Kentauros>Kuh... Such humiliation...", "centa_fc1", 2],
      :premortal_graphic => "80_centa_st03",
    },
    171 => { # アルラウネ
      :dead_word => ["\\n<Alraune>Hawawawa...", "alraune_fc1", 1],
      :orgasm_word => ["\\n<Alraune>I'm coooming...", "alraune_fc1", 1],
      :predation_word => ["\\n<Alraune>These flowers are sweet and delicious...", "alraune_fc1", 1],
      :incontinence_word => ["\\n<Alraune>This is embarrassing...", "alraune_fc1", 1],
      :premortal_graphic => "80_alraune_st03",
    },
    172 => { # 御菊蟲
      :dead_word => ["\\n<Okiku-Mushi>No more...", "okikumusi_fc1", 3],
      :orgasm_word => ["\\n<Okiku-Mushi>What is this... Fuwa...", "okikumusi_fc1", 3],
      :predation_word => ["\\n<Okiku-Mushi>Don't eat meee!", "okikumusi_fc1", 3],
      :incontinence_word => ["\\n<Okiku-Mushi>I'm sorry, I peed...", "okikumusi_fc1", 3],
      :premortal_graphic => "50_okikumusi_st03",
    },
    173 => { # 幽霊娘
      :dead_word => ["\\n<Spirit Girl>Even though I'm a ghost, I'm exhausted...", "ghost2_fc1", 2],
      :orgasm_word => ["\\n<Spirit Girl>Ahh, I'm ascending...", "ghost2_fc1", 2],
      :predation_word => ["\\n<Spirit Girl>Ghosts taste like cotton candy...", "ghost2_fc1", 2],
      :incontinence_word => ["\\n<Spirit Girl>This is ectoplasm...", "ghost2_fc1", 2],
      :premortal_graphic => "50_ghost2_st03",
    },
    174 => { # ハコイリ
      :dead_word => ["\\n<Boxed Girl>I don't like this...", "hakoiri_fc1", 2],
      :orgasm_word => ["\\n<Boxed Girl>That feels good... I lost...", "hakoiri_fc1", 2],
      :predation_word => ["\\n<Boxed Girl>D-don't eat me... Ahh...", "hakoiri_fc1", 2],
      :incontinence_word => ["\\n<Boxed Girl>T-this is... embarrassing...", "hakoiri_fc1", 2],
      :premortal_graphic => "80_hakoiri_st03",
    },
    175 => { # デュラハン
      :dead_word => ["\\n<Dullahan>Such skill...", "durahan_fc1", 2],
      :orgasm_word => ["\\n<Dullahan>To give in to such humiliation...", "durahan_fc1", 2],
      :predation_word => ["\\n<Dullahan>This is also the fate of the loser...", "durahan_fc1", 2],
      :incontinence_word => ["\\n<Dullahan>Humiliation... Uuuhh...", "durahan_fc1", 2],
      :premortal_graphic => "80_durahan_st03",
    },
    176 => { # ケルベロス
      :dead_word => ["\\n<Cerberus>My defeat...", "kerberos_fc1", 2],
      :orgasm_word => ["\\n<Cerberus>How could I come... Ahhh...!", "kerberos_fc1", 2],
      :predation_word => ["\\n<Cerberus>Shit, the law of nature...", "kerberos_fc1", 2],
      :incontinence_word => ["\\n<Cerberus>D-don't look... A-ahh...", "kerberos_fc1", 2],
      :premortal_graphic => "80_kerberos_st03",
    },
    177 => { # アルマエルマ
      :dead_word => ["\\n<Alma Elma>Not bad, fufu...", "arumaeruma_fc2", 0],
      :orgasm_word => ["\\n<Alma Elma>It's humiliating, but... it feels so gooood...", "arumaeruma_fc2", 6],
      :predation_word => ["\\n<Alma Elma>Being eaten... feels good, doesn't it...", "arumaeruma_fc2", 6],
      :incontinence_word => ["\\n<Alma Elma>I can feel it... Such a disgraceful display...", "arumaeruma_fc2", 6],
      :premortal_graphic => "80_arumaeruma_st62",
    },
    178 => { # グランベリア
      :dead_word => ["\\n<Granberia>Alma Elma... Again...", "granberia_fc3", 2],
      :orgasm_word => ["\\n<Granberia>Yielding to... pleasure... A-ahh...", "granberia_fc3", 6],
      :predation_word => ["\\n<Granberia>The weak are nothing but food...", "granberia_fc3", 2],
      :incontinence_word => ["\\n<Granberia>Kuh... Don't look, don't look!", "granberia_fc3", 6],
      :premortal_graphic => "80_granberia_st63",
    },
    179 => { # 濡れ女
      :dead_word => ["\\n<Nure-Onna>I'll remember this...", "nureonnna_fc1", 2],
      :orgasm_word => ["\\n<Nure-Onna>It feels good, but it's regrettable...", "nureonnna_fc1", 2],
      :predation_word => ["\\n<Nure-Onna>My grudge will follow you, so you... Ahh...", "nureonnna_fc1", 2],
      :incontinence_word => ["\\n<Nure-Onna>Ahh... My urine is getting me wetter...", "nureonnna_fc1", 2],
      :premortal_graphic => "50_nureonnna_st03",
    },
    180 => { # ハイミノタウロス
      :dead_word => ["\\n<High Minotauros>Big sister has lost...", "h_mino_fc1", 2],
      :orgasm_word => ["\\n<High Minotauros>Big Sister is coming...", "h_mino_fc1", 2],
      :predation_word => ["\\n<High Minotauros>Even if you eat me, I won't be tasty... Ahh...", "h_mino_fc1", 2],
      :incontinence_word => ["\\n<High Minotauros>Big sister is peeing...", "h_mino_fc1", 2],
      :premortal_graphic => "50_h_mino_st03",
    },
    181 => { # ミズタウロス
      :dead_word => ["\\n<Misstauros>I just wanted to be younger...", "m_mino_fc1", 2],
      :orgasm_word => ["\\n<Misstauros>Ahh, you made me come...", "m_mino_fc1", 2],
      :predation_word => ["\\n<Misstauros>There are tastier things than me...", "m_mino_fc1", 2],
      :incontinence_word => ["\\n<Misstauros>I'm too old for this... So shameful...", "m_mino_fc1", 2],
      :premortal_graphic => "50_m_mino_st03",
    },
    182 => { # ジニタウロス
      :dead_word => ["\\n<Genitauros>It's useless... I don't understand...", "zinitauros_fc1", 2],
      :orgasm_word => ["\\n<Genitauros>I'm coming... Ahh...!", "zinitauros_fc1", 2],
      :predation_word => ["\\n<Genitauros>D-don't eat me... Ah!", "zinitauros_fc1", 2],
      :incontinence_word => ["\\n<Genitauros>Oh no... So embarrassing...", "zinitauros_fc1", 2],
      :premortal_graphic => "50_zinitauros_st03",
    },
    183 => { # 斉天大聖
      :dead_word => ["\\n<Sun Wukong>Well done...", "seitentaisei_fc1", 2],
      :orgasm_word => ["\\n<Sun Wukong>The highest of pleasures... But vexing...", "seitentaisei_fc1", 2],
      :predation_word => ["\\n<Sun Wukong>It's not the first time I've been eaten...", "seitentaisei_fc1", 2],
      :incontinence_word => ["\\n<Sun Wukong>How could I...", "seitentaisei_fc1", 2],
      :premortal_graphic => "80_seitentaisei_st03",
    },
    184 => { # 牛魔王
      :dead_word => ["\\n<Cow Demon Queen>Quite a miserable showing...", "nyumaou_fc1", 2],
      :orgasm_word => ["\\n<Cow Demon Queen>To do this in public... Nnnn!", "nyumaou_fc1", 2],
      :predation_word => ["\\n<Cow Demon Queen>Eating me... Quite the bold one...", "nyumaou_fc1", 2],
      :incontinence_word => ["\\n<Cow Demon Queen>Kuh, such humiliation!", "nyumaou_fc1", 2],
      :premortal_graphic => "80_nyumaou_st03",
    },
    185 => { # くのいちエルフ
      :dead_word => ["\\n<Kunoichi Elf>A shinobi only dies in the shadows...", "kunoitielf_fc1", 2],
      :orgasm_word => ["\\n<Kunoichi Elf>No... Even though I was trained...", "kunoitielf_fc1", 2],
      :predation_word => ["\\n<Kunoichi Elf>Eating a kunoichi...", "kunoitielf_fc1", 2],
      :incontinence_word => ["\\n<Kunoichi Elf>For a kunoichi to be incontinent... How shameful...", "kunoitielf_fc1", 2],
      :premortal_graphic => "80_kunoitielf_st03",
    },
    186 => { # サムライエルフ
      :dead_word => ["\\n<Samurai Elf>Regrettable...", "samuraielf_fc1", 2],
      :orgasm_word => ["\\n<Samurai Elf>Don't look... at my orgasming figure...", "samuraielf_fc1", 2],
      :predation_word => ["\\n<Samurai Elf>Ending as food for another... How unseemly...", "samuraielf_fc1", 2],
      :incontinence_word => ["\\n<Samurai Elf>S-such... sh-shame...", "samuraielf_fc1", 2],
      :premortal_graphic => "80_samuraielf_st03",
    },
    187 => { # 雪女
      :dead_word => ["\\n<Yuki-Onna>My cold body becomes colder...", "yukionna_fc1", 2],
      :orgasm_word => ["\\n<Yuki-Onna>My body is warm...", "yukionna_fc1", 2],
      :predation_word => ["\\n<Yuki-Onna>You'll only be eating snow, you know...", "yukionna_fc1", 2],
      :incontinence_word => ["\\n<Yuki-Onna>Ahh, my crotch is warm...", "yukionna_fc1", 2],
      :premortal_graphic => "50_yukionna_st03",
    },
    188 => { # ねこまた
      :dead_word => ["\\n<Nekomata>Unya...", "nekomata_fc1", 4],
      :orgasm_word => ["\\n<Nekomata>Funyaaa...", "nekomata_fc1", 3],
      :predation_word => ["\\n<Nekomata>Nyaa!!", "nekomata_fc1", 1],
      :incontinence_word => ["\\n<Nekomata>Unyaa...", "nekomata_fc1", 3],
      :premortal_graphic => "50_nekomata_st03",
    },
    189 => { # あかなめ
      :dead_word => ["\\n<Akaname>No more...", "akaname_fc2", 3],
      :orgasm_word => ["\\n<Akaname>I'm coming...", "akaname_fc2", 3],
      :predation_word => ["\\n<Akaname>Everyone knows akaname aren't tasty...\nHyaaaa!", "akaname_fc2", 3],
      :incontinence_word => ["\\n<Akaname>Ahh, I'm leaking...", "akaname_fc2", 3],
      :premortal_graphic => "80_akaname_st03",
    },
    190 => { # 河童
      :dead_word => ["\\n<Kappa>Let's play again...", "kappa_fc1", 2],
      :orgasm_word => ["\\n<Kappa>My body is so hot...", "kappa_fc1", 2],
      :predation_word => ["\\n<Kappa>I don't taste like cucumbers, so... Hyaa!", "kappa_fc1", 2],
      :incontinence_word => ["\\n<Kappa>No, don't look...", "kappa_fc1", 2],
      :premortal_graphic => "50_kappa_st03",
    },
    191 => { # 二口娘
      :dead_word => ["\\n<Futakuchi Girl>I'm so hungry...", "hutakuti_fc1", 7],
      :orgasm_word => ["\\n<Futakuchi Girl>Ah... Coming...", "hutakuti_fc1", 7],
      :predation_word => ["\\n<Futakuchi Girl>D-don't eat me...", "hutakuti_fc1", 7],
      :incontinence_word => ["\\n<Futakuchi Girl>Hauuu... I'm so sorry...", "hutakuti_fc1", 7],
      :premortal_graphic => "80_hutakuti_st13",
    },
    192 => { # 白蛇様
      :dead_word => ["\\n<Shirohebi>I was foolish...", "sirohebisama_fc1", 2],
      :orgasm_word => ["\\n<Shirohebi>For me to give in to pleasure... How foolish...", "sirohebisama_fc1", 2],
      :predation_word => ["\\n<Shirohebi>To be eaten... Such regret...", "sirohebisama_fc1", 2],
      :incontinence_word => ["\\n<Shirohebi>How could I leak like this... D-don't look...", "sirohebisama_fc1", 2],
      :premortal_graphic => "80_sirohebisama_st03",
    },
    193 => { # 巫女ラミア
      :dead_word => ["\\n<Miko Lamia>Ahh, so rough...", "mikolamia_fc1", 2],
      :orgasm_word => ["\\n<Miko Lamia>How could I come...", "mikolamia_fc1", 2],
      :predation_word => ["\\n<Miko Lamia>Ahh, I don't want to be eaten...", "mikolamia_fc1", 2],
      :incontinence_word => ["\\n<Miko Lamia>Don't watch me pee...", "mikolamia_fc1", 2],
      :premortal_graphic => "50_mikolamia_st03",
    },
    194 => { # 巫女アラクネ
      :dead_word => ["\\n<Miko Arachne>I can't keep going...", "mikoarachne_fc1", 2],
      :orgasm_word => ["\\n<Miko Arachne>Coming...", "mikoarachne_fc1", 3],
      :predation_word => ["\\n<Miko Arachne>D-don't eat me...", "mikoarachne_fc1", 2],
      :incontinence_word => ["\\n<Miko Arachne>This is so embarrassing...", "mikoarachne_fc1", 3],
      :premortal_graphic => "50_mikoarachne_st03",
    },
    195 => { # 毛倡妓
      :dead_word => ["\\n<Kejourou>This is quite a miserable ending...", "kezyorou_fc1", 2],
      :orgasm_word => ["\\n<Kejourou>I'm coming first...", "kezyorou_fc1", 2],
      :predation_word => ["\\n<Kejourou>Hey, stop... Ahhh!", "kezyorou_fc1", 2],
      :incontinence_word => ["\\n<Kejourou>S-such shame...", "kezyorou_fc1", 2],
      :premortal_graphic => "80_kezyorou_st03",
    },
    196 => { # ヤマタノオロチ
      :dead_word => ["\\n<Yamata no Orochi>How could I collapse...", "yamatanooroti_fc3", 3],
      :orgasm_word => ["\\n<Yamata no Orochi>Is this how I end...?", "yamatanooroti_fc3", 3],
      :predation_word => ["\\n<Yamata no Orochi>Eating me? How repulsive...", "yamatanooroti_fc3", 3],
      :incontinence_word => ["\\n<Yamata no Orochi>Kuh, avert your eyes...", "yamatanooroti_fc3", 3],
      :premortal_graphic => "80_yamatanooroti_st03",
    },
    197 => { # マジカルアゲハ
      :dead_word => ["\\n<Magical Butterfly>Stop doing these awful things...", "m_batterfly_fc1", 2],
      :orgasm_word => ["\\n<Magical Butterfly>That feels good...", "m_batterfly_fc1", 2],
      :predation_word => ["\\n<Magical Butterfly>Insects don't taste good, so... Nooo!", "m_batterfly_fc1", 2],
      :incontinence_word => ["\\n<Magical Butterfly>I thought I outgrew this...", "m_batterfly_fc1", 2],
      :premortal_graphic => "50_m_batterfly_st03",
    },
    198 => { # マジカルフライ
      :dead_word => ["\\n<Magical Dragonfly>I need a short rest...", "m_dragonfly_fc1", 1],
      :orgasm_word => ["\\n<Magical Dragonfly>I'm coming...", "m_dragonfly_fc1", 1],
      :predation_word => ["\\n<Magical Dragonfly>I don't taste good...", "m_dragonfly_fc1", 1],
      :incontinence_word => ["\\n<Magical Dragonfly>I'm peeing...", "m_dragonfly_fc1", 1],
      :premortal_graphic => "50_m_dragonfly_st03",
    },
    199 => { # マジカルテントウ
      :dead_word => ["\\n<Magical Ladybug>No more...", "m_tento_fc1", 2],
      :orgasm_word => ["\\n<Magical Ladybug>My head feels funny...", "m_tento_fc1", 2],
      :predation_word => ["\\n<Magical Ladybug>Don't eat me!", "m_tento_fc1", 2],
      :incontinence_word => ["\\n<Magical Ladybug>I leaked...", "m_tento_fc1", 2],
      :premortal_graphic => "50_m_tento_st03",
    },
    200 => { # マジカルピクシー
      :dead_word => ["\\n<Magical Pixie>You bully...", "m_fairy_fc1", 2],
      :orgasm_word => ["\\n<Magical Pixie>This is so embarrassing...", "m_fairy_fc1", 2],
      :predation_word => ["\\n<Magical Pixie>D-don't eat me... Nooo!", "m_fairy_fc1", 2],
      :incontinence_word => ["\\n<Magical Pixie>Don't look, don't looook...", "m_fairy_fc1", 2],
      :premortal_graphic => "50_m_fairy_st03",
    },
    201 => { # マジカルエルフ
      :dead_word => ["\\n<Magical Elf>I'm leaving early today...", "m_elf_fc1", 2],
      :orgasm_word => ["\\n<Magical Elf>I'm an honor student, I can't drown in pleasure...", "m_elf_fc1", 2],
      :predation_word => ["\\n<Magical Elf>Don't believe the lies... Elves aren't tasty...\nA-ahhh!", "m_elf_fc1", 2],
      :incontinence_word => ["\\n<Magical Elf>I'm an honor student... How could I...", "m_elf_fc1", 2],
      :premortal_graphic => "50_m_elf_st03",
    },
    202 => { # マジカルサキュバス
      :dead_word => ["\\n<Magical Succubus>I can't do more than this...", "m_succubus_fc1", 2],
      :orgasm_word => ["\\n<Magical Succubus>Even though I'm a succubus... How...?", "m_succubus_fc1", 2],
      :predation_word => ["\\n<Magical Succubus>Being eaten... Humiliating...", "m_succubus_fc1", 2],
      :incontinence_word => ["\\n<Magical Succubus>Even though I'm a succubus, I'm peeing...", "m_succubus_fc1", 2],
      :premortal_graphic => "50_m_succubus_st03",
    },
    203 => { # メフィスト
      :dead_word => ["\\n<Mephisto>I didn't have the strength...", "mefist_fc2", 2],
      :orgasm_word => ["\\n<Mephisto>To make me come...", "mefist_fc2", 2],
      :predation_word => ["\\n<Mephisto>To think I'd be preyed on...", "mefist_fc2", 2],
      :incontinence_word => ["\\n<Mephisto>I can't be a teacher anymore after this...", "mefist_fc2", 2],
      :premortal_graphic => "80_mefist_st13",
    },
    204 => { # カマキリ娘
      :dead_word => ["\\n<Mantis Girl>Hee... Heehee...", "kamakiri_fc1", 2],
      :orgasm_word => ["\\n<Mantis Girl>Heehee... Good...", "kamakiri_fc1", 2],
      :predation_word => ["\\n<Mantis Girl>Heehee... Don't eat...", "kamakiri_fc1", 2],
      :incontinence_word => ["\\n<Mantis Girl>Leaking... Hee, heehee...", "kamakiri_fc1", 2],
      :premortal_graphic => "50_kamakiri_st03",
    },
    205 => { # カイコ娘
      :dead_word => ["\\n<Silkworm Girl>I lost...", "kaiko_fc1", 2],
      :orgasm_word => ["\\n<Silkworm Girl>Ahh, that feels good...", "kaiko_fc1", 2],
      :predation_word => ["\\n<Silkworm Girl>I only taste like silk...", "kaiko_fc1", 2],
      :incontinence_word => ["\\n<Silkworm Girl>Ahh, I'm leaking...", "kaiko_fc1", 2],
      :premortal_graphic => "50_kaiko_st03",
    },
    206 => { # アルラ・アルム
      :dead_word => ["\\n<Alra Arum>This is it, eh...", "a_alm_fc1", 1],
      :orgasm_word => ["\\n<Alra Arum>How could I come...", "a_alm_fc1", 1],
      :predation_word => ["\\n<Alra Arum>Plants are full of nutrition...", "a_alm_fc1", 1],
      :incontinence_word => ["\\n<Alra Arum>Ahh, I'm so ashamed...", "a_alm_fc1", 1],
      :premortal_graphic => "50_a_alm_st03",
    },
    207 => { # アルラ・ルーティー
      :dead_word => ["\\n<Alra Rooty>It looks like I'm withering...", "a_looty_fc1", 2],
      :orgasm_word => ["\\n<Alra Rooty>I'm coming...", "a_looty_fc1", 2],
      :predation_word => ["\\n<Alra Rooty>I'm not an edible root...", "a_looty_fc1", 2],
      :incontinence_word => ["\\n<Alra Rooty>My sap is leaking...", "a_looty_fc1", 2],
      :premortal_graphic => "50_a_looty_st03",
    },
    208 => { # アルラ・ボア
      :dead_word => ["\\n<Alra Vore>I can't fight anymore...", "a_vore_fc1", 2],
      :orgasm_word => ["\\n<Alra Vore>Ahh, such humiliation...", "a_vore_fc1", 2],
      :predation_word => ["\\n<Alra Vore>Looks like I'm the vegetable side...", "a_vore_fc1", 2],
      :incontinence_word => ["\\n<Alra Vore>How could I pee...", "a_vore_fc1", 2],
      :premortal_graphic => "50_a_vore_st03",
    },
    209 => { # アルラ・パラソル
      :dead_word => ["\\n<Alra Parasol>My umbrella is broken...", "a_parasol_fc1", 2],
      :orgasm_word => ["\\n<Alra Parasol>Ahh, that feels good...", "a_parasol_fc1", 2],
      :predation_word => ["\\n<Alra Parasol>My umbrella tastes good, but my body doesn't... Kyaa!", "a_parasol_fc1", 2],
      :incontinence_word => ["\\n<Alra Parasol>Ahh, I'm so ashamed...", "a_parasol_fc1", 2],
      :premortal_graphic => "50_a_parasol_st03",
    },
    210 => { # アルラ・プリズン
      :dead_word => ["\\n<Alra Prison>I can't do more than this...", "a_prison_fc1", 2],
      :orgasm_word => ["\\n<Alra Prison>That doesn't feel good...", "a_prison_fc1", 2],
      :predation_word => ["\\n<Alra Prison>I'm not a vegetable, don't eat me!", "a_prison_fc1", 2],
      :incontinence_word => ["\\n<Alra Prison>How awful, I'm leaking...", "a_prison_fc1", 2],
      :premortal_graphic => "50_a_prison_st03",
    },
    211 => { # アルラ・マッシュ
      :dead_word => ["\\n<Alra Shroom>Mashed mushrooms...", "a_mash_fc1", 0],
      :orgasm_word => ["\\n<Alra Shroom>Coming...", "a_mash_fc1", 0],
      :predation_word => ["\\n<Alra Shroom>Nutritious and delicious...", "a_mash_fc1", 0],
      :incontinence_word => ["\\n<Alra Shroom>My juice is leaking...", "a_mash_fc1", 0],
      :premortal_graphic => "50_a_mash_st01",
    },
    212 => { # ドローシー
      :dead_word => ["\\n<Dorothy>This is my limit...", "dorothy_fc1", 2],
      :orgasm_word => ["\\n<Dorothy>Kuh... But it feels so good...", "dorothy_fc1", 2],
      :predation_word => ["\\n<Dorothy>Don't eat me... I won't forgive this...\nA-ahh!", "dorothy_fc1", 2],
      :incontinence_word => ["\\n<Dorothy>This humiliation... I won't forgive you...", "dorothy_fc1", 2],
      :premortal_graphic => "50_dorothy_st03",
    },
    213 => { # ラフィ
      :dead_word => ["\\n<Raffia>I need more nutrients...", "rafi_fc1", 2],
      :orgasm_word => ["\\n<Raffia>A melting pleasure...", "rafi_fc1", 2],
      :predation_word => ["\\n<Raffia>How could you eat a pitcher plant...", "rafi_fc1", 2],
      :incontinence_word => ["\\n<Raffia>Ah, my sap is leaking...", "rafi_fc1", 2],
      :premortal_graphic => "50_rafi_st03",
    },
    214 => { # ディーナ
      :dead_word => ["\\n<Deana>I need to rest...", "dina_fc1", 2],
      :orgasm_word => ["\\n<Deana>You made me feel good...", "dina_fc1", 2],
      :predation_word => ["\\n<Deana>I won't forgive you...", "dina_fc1", 2],
      :incontinence_word => ["\\n<Deana>I won't forget this humiliation...", "dina_fc1", 2],
      :premortal_graphic => "50_dina_st03",
    },
    215 => { # アルラ・プリエステス
      :dead_word => ["\\n<Alra Priestess>I must rest...", "a_emp_fc1", 2],
      :orgasm_word => ["\\n<Alra Priestess>I'm... To pleasure... Ahh...", "a_emp_fc1", 2],
      :predation_word => ["\\n<Alra Priestess>D-don't eat me... Ahh...", "a_emp_fc1", 2],
      :incontinence_word => ["\\n<Alra Priestess>I feel refreshed...", "a_emp_fc1", 1],
      :premortal_graphic => "80_a_emp_st03",
    },
    216 => { # モス娘
      :dead_word => ["\\n<Moth Girl>Life is so fragile...", "moss_fc1", 2],
      :orgasm_word => ["\\n<Moth Girl>Ahh, that feels good...", "moss_fc1", 2],
      :predation_word => ["\\n<Moth Girl>You shouldn't eat insects...", "moss_fc1", 2],
      :incontinence_word => ["\\n<Moth Girl>Ahh, what humiliation...", "moss_fc1", 2],
      :premortal_graphic => "50_moss_st03",
    },
    217 => { # モスキート娘
      :dead_word => ["\\n<Mosquito Girl>Summer's over...", "mosquito_fc1", 2],
      :orgasm_word => ["\\n<Mosquito Girl>I'm coming...", "mosquito_fc1", 2],
      :predation_word => ["\\n<Mosquito Girl>Mosquitos don't taste good, you know!", "mosquito_fc1", 2],
      :incontinence_word => ["\\n<Mosquito Girl>Don't look, it's awful...", "mosquito_fc1", 2],
      :premortal_graphic => "50_mosquito_st03",
    },
    218 => { # イモムシ娘
      :dead_word => ["\\n<Caterpillar Girl>I wanted to be a butterfly...", "imomusi_fc1", 2],
      :orgasm_word => ["\\n<Caterpillar Girl>That feels good...", "imomusi_fc1", 2],
      :predation_word => ["\\n<Caterpillar Girl>No... Nooo...", "imomusi_fc1", 2],
      :incontinence_word => ["\\n<Caterpillar Girl>I leaked...", "imomusi_fc1", 2],
      :premortal_graphic => "50_imomusi_st03",
    },
    219 => { # スズメバチ娘
      :dead_word => ["\\n<Hornet Girl>NO MORE FIGHTING...", "suzumebati_fc1", 1],
      :orgasm_word => ["\\n<Hornet Girl>FEELS GOOD...", "suzumebati_fc1", 1],
      :predation_word => ["\\n<Hornet Girl>EATEN...", "suzumebati_fc1", 1],
      :incontinence_word => ["\\n<Hornet Girl>LEAKING...", "suzumebati_fc1", 1],
      :premortal_graphic => "80_suzumebati_st03",
    },
    220 => { # クィーン・ビー
      :dead_word => ["\\n<Queen Bee>Forgive me, daughters...", "queenbee_fc1", 2],
      :orgasm_word => ["\\n<Queen Bee>Kuh, this good feeling... Hauu...", "queenbee_fc1", 2],
      :predation_word => ["\\n<Queen Bee>Will I taste sweet, like honey...?", "queenbee_fc1", 2],
      :incontinence_word => ["\\n<Queen Bee>The queen must not leak urine...", "queenbee_fc1", 2],
      :premortal_graphic => "80_queenbee_st03",
    },
    221 => { # テスカトリポカ
      :dead_word => ["\\n<Tezcatlipoca>Nyaa...?!", "tezcatlipoca_fc1", 2],
      :orgasm_word => ["\\n<Tezcatlipoca>Nyaaa...", "tezcatlipoca_fc1", 6],
      :predation_word => ["\\n<Tezcatlipoca>Don't eat me, nyaaaah!", "tezcatlipoca_fc1", 2],
      :incontinence_word => ["\\n<Tezcatlipoca>I'm just marking, nya!\nI'm not peeing, nya!", "tezcatlipoca_fc1", 2],
      :premortal_graphic => "80_tezcatlipoca_st03",
    },
    222 => { # ケツァルコァトル
      :dead_word => ["\\n<Quetzalcoatl>No... How could this-!", "coatlus_fc1", 4],
      :orgasm_word => ["\\n<Quetzalcoatl>It feels so good it's making me weak...", "coatlus_fc1", 2],
      :predation_word => ["\\n<Quetzalcoatl>How could I be the prey...", "coatlus_fc1", 4],
      :incontinence_word => ["\\n<Quetzalcoatl>T-this isn't what it seems...", "coatlus_fc1", 6],
      :premortal_graphic => "80_coatlus_st05",
    },
    223 => { # グノーシス
      :dead_word => ["\\n<Gnosis>Indeed, a power that cannot be ignored...", "gnosis_fc1", 3],
      :orgasm_word => ["\\n<Gnosis>How could I be forced to this...", "gnosis_fc1", 3],
      :predation_word => ["\\n<Gnosis>Preying on me will be punished...", "gnosis_fc1", 3],
      :incontinence_word => ["\\n<Gnosis>For a seraph like me to... Such humiliation...", "gnosis_fc1", 3],
      :premortal_graphic => "80_gnosis_st03",
    },
    224 => { # シオン
      :dead_word => ["\\n<Zion>Heh, not bad...", "shion_fc1", 4],
      :orgasm_word => ["\\n<Zion>I'm coming...", "shion_fc1", 4],
      :predation_word => ["\\n<Zion>Stop...! Don't eat me...!!", "shion_fc1", 2],
      :incontinence_word => ["\\n<Zion>Shit...! I'll kill all of you...!", "shion_fc1", 2],
      :premortal_graphic => "80_shion_st03",
    },
    225 => { # ジェリー娘
      :dead_word => ["\\n<Jelly Girl>No more...", "jelly_fc1", 2],
      :orgasm_word => ["\\n<Jelly Girl>That feels good...", "jelly_fc1", 2],
      :predation_word => ["\\n<Jelly Girl>You want to taste jelly...?", "jelly_fc1", 2],
      :incontinence_word => ["\\n<Jelly Girl>My jelly is melting...", "jelly_fc1", 2],
      :premortal_graphic => "50_jelly_st03",
    },
    226 => { # ブロブ娘
      :dead_word => ["\\n<Blob Girl>What an awful feeling...", "blob_fc1", 2],
      :orgasm_word => ["\\n<Blob Girl>I'm cominggg!", "blob_fc1", 2],
      :predation_word => ["\\n<Blob Girl>I like to be the one eating...", "blob_fc1", 2],
      :incontinence_word => ["\\n<Blob Girl>Leaking...", "blob_fc1", 2],
      :premortal_graphic => "50_blob_st03",
    },
    227 => { # グリーンスライム
      :dead_word => ["\\n<Green Slime>No more...", "slime_green_fc1", 2],
      :orgasm_word => ["\\n<Green Slime>I can feel it...", "slime_green_fc1", 2],
      :predation_word => ["\\n<Green Slime>Sweet and delicious... Not!", "slime_green_fc1", 2],
      :incontinence_word => ["\\n<Green Slime>I'm peeing all over...", "slime_green_fc1", 2],
      :premortal_graphic => "50_slime_green_st03",
    },
    228 => { # レッドスライム
      :dead_word => ["\\n<Red Slime>Impossible!", "slime_red_fc1", 2],
      :orgasm_word => ["\\n<Red Slime>Such humiliation...!", "slime_red_fc1", 2],
      :predation_word => ["\\n<Red Slime>Don't eat me, don't eat me!", "slime_red_fc1", 2],
      :incontinence_word => ["\\n<Red Slime>Nooo... So embarrassing...", "slime_red_fc1", 2],
      :premortal_graphic => "50_slime_red_st03",
    },
    229 => { # ブルースライム
      :dead_word => ["\\n<Blue Slime>I need a break...", "slime_blue_fc1", 2],
      :orgasm_word => ["\\n<Blue Slime>That feels good...", "slime_blue_fc1", 2],
      :predation_word => ["\\n<Blue Slime>But I don't taste good...", "slime_blue_fc1", 2],
      :incontinence_word => ["\\n<Blue Slime>Peeing...", "slime_blue_fc1", 2],
      :premortal_graphic => "50_slime_blue_st03",
    },
    230 => { # パープルスライム
      :dead_word => ["\\n<Purple Slime>Such disgrace...", "slime_purple_fc1", 2],
      :orgasm_word => ["\\n<Purple Slime>Ahh, how could I come...", "slime_purple_fc1", 2],
      :predation_word => ["\\n<Purple Slime>You'll remember the taste of a slime...", "slime_purple_fc1", 2],
      :incontinence_word => ["\\n<Purple Slime>Ahh... So much urine...", "slime_purple_fc1", 2],
      :premortal_graphic => "50_slime_purple_st03",
    },
    231 => { # ウンディーネ
      :dead_word => ["\\n<Undine>...You've shown me your power.", "undine_fc1", 2],
      :orgasm_word => ["\\n<Undine>How could I come...", "undine_fc1", 2],
      :predation_word => ["\\n<Undine>I may look delicious...\nbut I won't digest easy...", "undine_fc1", 2],
      :incontinence_word => ["\\n<Undine>Ahh, my water is...", "undine_fc1", 2],
      :premortal_graphic => "80_undine_st03",
    },
    232 => { # エルベティエ
      :dead_word => ["\\n<Erubetie>I lost...?", "erbetie_fc1", 0],
      :orgasm_word => ["\\n<Erubetie>How could I come...", "erbetie_fc1", 0],
      :predation_word => ["\\n<Erubetie>How could I be swallowed...", "erbetie_fc1", 0],
      :incontinence_word => ["\\n<Erubetie>My fluids are leaking...", "erbetie_fc1", 0],
      :premortal_graphic => "80_erbetie_st01",
    },
    233 => { # アリ娘
      :dead_word => ["\\n<Ant Girl>CAN'T WORK MORE...", "ant_fc1", 1],
      :orgasm_word => ["\\n<Ant Girl>FEEL GOOD...", "ant_fc1", 1],
      :predation_word => ["\\n<Ant Girl>ANTS NOT TASTY...", "ant_fc1", 1],
      :incontinence_word => ["\\n<Ant Girl>PEEING... SORRY...", "ant_fc1", 1],
      :premortal_graphic => "80_ant_st13",
    },
    234 => { # オートマータ娘
      :dead_word => ["\\n<Automata Girl>I must rest...", "artm_fc1", 1],
      :orgasm_word => ["\\n<Automata Girl>How could I come...", "artm_fc1", 1],
      :predation_word => ["\\n<Automata Girl>I apologize, but dolls are not appetizing...", "artm_fc1", 1],
      :incontinence_word => ["\\n<Automata Girl>My urine is leaking...\nForgive me... Forgive me...", "artm_fc1", 1],
      :premortal_graphic => "50_artm_st03",
    },
    235 => { # パイズリ人形
      :dead_word => ["\\n<Paizuri Doll>.........", "paizuridoll_fc1", 2],
      :orgasm_word => ["\\n<Paizuri Doll>.........", "paizuridoll_fc1", 2],
      :predation_word => ["\\n<Paizuri Doll>.........", "paizuridoll_fc1", 2],
      :incontinence_word => ["\\n<Paizuri Doll>.........", "paizuridoll_fc1", 2],
      :premortal_graphic => "50_paizuridoll_st03",
    },
    236 => { # スキュラ
      :dead_word => ["\\n<Scylla>I can't fight anymore...", "scylla_fc1", 2],
      :orgasm_word => ["\\n<Scylla>H-how could I come...", "scylla_fc1", 2],
      :predation_word => ["\\n<Scylla>Scylla aren't delicious! That's just a folktale!\nAhhhh!!", "scylla_fc1", 2],
      :incontinence_word => ["\\n<Scylla>Kuh... D-don't look!", "scylla_fc1", 2],
      :premortal_graphic => "50_scylla_st03",
    },
    237 => { # メデューサ
      :dead_word => ["\\n<Medusa>I'll remember this...", "medusa_fc1", 2],
      :orgasm_word => ["\\n<Medusa>S-such humiliation... I won't forgive this...", "medusa_fc1", 2],
      :predation_word => ["\\n<Medusa>But I don't taste good... Ahh...", "medusa_fc1", 2],
      :incontinence_word => ["\\n<Medusa>Making me leak like this... I won't forgive it...", "medusa_fc1", 2],
      :premortal_graphic => "50_medusa_st03",
    },
    238 => { # あげは娘
      :dead_word => ["\\n<Butterfly Girl>I can't fly anymore...", "ageha_fc1", 2],
      :orgasm_word => ["\\n<Butterfly Girl>Such a good feeling... Nnnn...", "ageha_fc1", 2],
      :predation_word => ["\\n<Butterfly Girl>D-don't eat me... Ahh...", "ageha_fc1", 2],
      :incontinence_word => ["\\n<Butterfly Girl>I'm sorry...\nI'm peeing, I'm sorry...", "ageha_fc1", 2],
      :premortal_graphic => "50_ageha_st03",
    },
    239 => { # ブロム娘
      :dead_word => ["\\n<Brom Girl>No more...", "blom_fc1", 2],
      :orgasm_word => ["\\n<Brom Girl>Ahh, I'm coming...", "blom_fc1", 2],
      :predation_word => ["\\n<Brom Girl>If you eat me, your stomach will burst...\nSo... A-ahhh!!", "blom_fc1", 2],
      :incontinence_word => ["\\n<Brom Girl>My poisonous pee is leaking...", "blom_fc1", 2],
      :premortal_graphic => "50_blom_st03",
    },
    240 => { # ウォーマー
      :dead_word => ["\\n<Warmer>No more...", "warmer_fc1", 2],
      :orgasm_word => ["\\n<Warmer>Coming...", "warmer_fc1", 2],
      :predation_word => ["\\n<Warmer>But I don't taste good...", "warmer_fc1", 2],
      :incontinence_word => ["\\n<Warmer>Leaking...", "warmer_fc1", 2],
      :premortal_graphic => "50_warmer_st03",
    },
    241 => { # グール
      :dead_word => ["\\n<Ghoul>Uaaa...", "gool_fc1", 0],
      :orgasm_word => ["\\n<Ghoul>Ahhh...", "gool_fc1", 0],
      :predation_word => ["\\n<Ghoul>Ooh... Aah...", "gool_fc1", 0],
      :incontinence_word => ["\\n<Ghoul>Uaa... Ahh...", "gool_fc1", 0],
      :premortal_graphic => "50_gool_st01",
    },
    242 => { # グール
      :dead_word => ["\\n<Ghoul>Uaaa...", "gool_fc1", 1],
      :orgasm_word => ["\\n<Ghoul>Ahhh...", "gool_fc1", 1],
      :predation_word => ["\\n<Ghoul>Ooh... Aah...", "gool_fc1", 1],
      :incontinence_word => ["\\n<Ghoul>Uaa... Ahh...", "gool_fc1", 1],
      :premortal_graphic => "50_gool_st11",
    },
    243 => { # グール
      :dead_word => ["\\n<Ghoul>Uaaa...", "gool_fc1", 2],
      :orgasm_word => ["\\n<Ghoul>Ahhh...", "gool_fc1", 2],
      :predation_word => ["\\n<Ghoul>Ooh... Aah...", "gool_fc1", 2],
      :incontinence_word => ["\\n<Ghoul>Uaa... Ahh...", "gool_fc1", 2],
      :premortal_graphic => "50_gool_st21",
    },
    244 => { # フェイクジェリー
      :dead_word => ["\\n<Fake Jelly>I want to rest...", "fakejelly_fc1", 2],
      :orgasm_word => ["\\n<Fake Jelly>Ahh, I'm coming...!", "fakejelly_fc1", 2],
      :predation_word => ["\\n<Fake Jelly>How could you want to eat a purupuru body...", "fakejelly_fc1", 2],
      :incontinence_word => ["\\n<Fake Jelly>I'm leaking...", "fakejelly_fc1", 2],
      :premortal_graphic => "50_fakejelly_st03",
    },
    245 => { # ウィングハーピー
      :dead_word => ["\\n<Wing Harpy>So this is it for me...", "w_hapy_fc1", 0],
      :orgasm_word => ["\\n<Wing Harpy>Ahh, that feels good...", "w_hapy_fc1", 0],
      :predation_word => ["\\n<Wing Harpy>How could you eat me...", "w_hapy_fc1", 0],
      :incontinence_word => ["\\n<Wing Harpy>Ahh, how embarrassing...", "w_hapy_fc1", 0],
      :premortal_graphic => "50_w_hapy_st01",
    },
    246 => { # ナイトハーピー
      :dead_word => ["\\n<Harpy Knight>As my wings fold, my life is forfeit...", "k_hapy_fc1", 2],
      :orgasm_word => ["\\n<Harpy Knight>N-no... A-ahhh!", "k_hapy_fc1", 2],
      :predation_word => ["\\n<Harpy Knight>I'll pierce my blade into your stomach... Ahh!", "k_hapy_fc1", 2],
      :incontinence_word => ["\\n<Harpy Knight>S-such humiliation... Avert your eyes!", "k_hapy_fc1", 2],
      :premortal_graphic => "50_k_hapy_st03",
    },
    247 => { # マッドゴーレム娘
      :dead_word => ["\\n<Mud Golem Girl>CEASING OPERATION...", "madgolem_fc1", 0],
      :orgasm_word => ["\\n<Mud Golem Girl>OVERHEATING FROM PLEASURE...", "madgolem_fc1", 0],
      :predation_word => ["\\n<Mud Golem Girl>BEING PREYED UPON...", "madgolem_fc1", 0],
      :incontinence_word => ["\\n<Mud Golem Girl>URINARY FLUID LEAKING...", "madgolem_fc1", 0],
      :premortal_graphic => "80_madgolem_st01",
    },
    248 => { # ゴーレム娘
      :dead_word => ["\\n<Golem Girl>COMBAT ABILITY DEGRADED...", "golem_fc1", 0],
      :orgasm_word => ["\\n<Golem Girl>PLEASURE CIRCUITS OVERHEATING...", "golem_fc1", 0],
      :predation_word => ["\\n<Golem Girl>PREDATION...UNAVOIDABLE...", "golem_fc1", 0],
      :incontinence_word => ["\\n<Golem Girl>INCONTINENCE...SHAME...", "golem_fc1", 0],
      :premortal_graphic => "80_golem_st01",
    },
    249 => { # ハナビラカマキリ娘
      :dead_word => ["\\n<Flower Mantis Girl>I think I'm going to faint...", "h_kamakiri_fc1", 2],
      :orgasm_word => ["\\n<Flower Mantis Girl>Ahh, I can feel it...", "h_kamakiri_fc1", 2],
      :predation_word => ["\\n<Flower Mantis Girl>Well, I am edible...", "h_kamakiri_fc1", 2],
      :incontinence_word => ["\\n<Flower Mantis Girl>I'm leaking...", "h_kamakiri_fc1", 2],
      :premortal_graphic => "50_h_kamakiri_st03",
    },
    250 => { # ブラックゴーレム
      :dead_word => ["\\n<Black Golem>No mooore!", "bgolem_fc1", 2],
      :orgasm_word => ["\\n<Black Golem>Cominggg!", "bgolem_fc1", 2],
      :predation_word => ["\\n<Black Golem>Golems aren't tasty...\nA-ahhh!!", "bgolem_fc1", 2],
      :incontinence_word => ["\\n<Black Golem>Ahhh... I'm leaking...", "bgolem_fc1", 2],
      :premortal_graphic => "50_bgolem_st03",
    },
    251 => { # 狐獣
      :dead_word => ["\\n<Feral Kitsune>I-I just need a quick break...!", "kitunezyu_fc1", 2],
      :orgasm_word => ["\\n<Feral Kitsune>It's not like...it feels good...", "kitunezyu_fc1", 2],
      :predation_word => ["\\n<Feral Kitsune>Don't come any closer...", "kitunezyu_fc1", 2],
      :incontinence_word => ["\\n<Feral Kitsune>Ahh, don't look... don't look at me...!", "kitunezyu_fc1", 2],
      :premortal_graphic => "50_kitunezyu_st03",
    },
    252 => { # くのいち三尾
      :dead_word => ["\\n<Three-Tailed Kunoichi>It's over, isn't it...?", "kunoitisanbi_fc1", 2],
      :orgasm_word => ["\\n<Three-Tailed Kunoichi>I will not yield to such pleasure... Uuu...", "kunoitisanbi_fc1", 2],
      :predation_word => ["\\n<Three-Tailed Kunoichi>Guh, how regrettable...!", "kunoitisanbi_fc1", 2],
      :incontinence_word => ["\\n<Three-Tailed Kunoichi>This is...miserable...", "kunoitisanbi_fc1", 2],
      :premortal_graphic => "50_kunoitisanbi_st03",
    },
    253 => { # もののふ四尾
      :dead_word => ["\\n<Four-Tailed Samurai>No more fighting for me...", "mononohuyonbi_fc1", 2],
      :orgasm_word => ["\\n<Four-Tailed Samurai>Coming on the battlefield...ahh...", "mononohuyonbi_fc1", 2],
      :predation_word => ["\\n<Four-Tailed Samurai>This is the fate of a loser...", "mononohuyonbi_fc1", 2],
      :incontinence_word => ["\\n<Four-Tailed Samurai>Ugh...such humiliation...", "mononohuyonbi_fc1", 2],
      :premortal_graphic => "50_mononohuyonbi_st03",
    },
    254 => { # クィーンアント
      :dead_word => ["\\n<Queen Ant>How disgraceful...", "queenant_fc1", 1],
      :orgasm_word => ["\\n<Queen Ant>The queen is finished feeling pleasant...", "queenant_fc1", 1],
      :predation_word => ["\\n<Queen Ant>This is how I meet my end, being preyed upon...", "queenant_fc1", 1],
      :incontinence_word => ["\\n<Queen Ant>Such humiliation... D-don't look...", "queenant_fc1", 1],
      :premortal_graphic => "80_queenant_st03",
    },
    255 => { # リリス
      :dead_word => ["\\n<Lilith>I see, this is the power of the hero Luka...", "lilith2_fc1", 2],
      :orgasm_word => ["\\n<Lilith>To defeat me with pleasure...", "lilith2_fc1", 2],
      :predation_word => ["\\n<Lilith>To eat me... You are truly resolute...", "lilith2_fc1", 2],
      :incontinence_word => ["\\n<Lilith>To make me incontinent... How miserable...", "lilith2_fc1", 2],
      :premortal_graphic => "80_lilith2_st03b",
    },
    256 => { # 溶岩娘
      :dead_word => ["\\n<Lava Girl>I'll just go back into the lava...", "yougan_fc1", 2],
      :orgasm_word => ["\\n<Lava Girl>Body...feeling very hot...", "yougan_fc1", 2],
      :predation_word => ["\\n<Lava Girl>Does lava taste good...?", "yougan_fc1", 2],
      :incontinence_word => ["\\n<Lava Girl>Ah, peeing in the lava...", "yougan_fc1", 2],
      :premortal_graphic => "50_yougan_st03",
    },
    257 => { # デーモンラミア
      :dead_word => ["\\n<Demon Lamia>Why, in such a way...", "lamiad_fc1", 2],
      :orgasm_word => ["\\n<Demon Lamia>How could I come... Ah, aaah...", "lamiad_fc1", 2],
      :predation_word => ["\\n<Demon Lamia>Don't eat me... Aaaah!!", "lamiad_fc1", 2],
      :incontinence_word => ["\\n<Demon Lamia>This is...so embarrassing...", "lamiad_fc1", 2],
      :premortal_graphic => "50_lamiad_st03",
    },
    258 => { # デーモンスキュラ
      :dead_word => ["\\n<Demon Scylla>I'm so tired...", "scyllad_fc1", 2],
      :orgasm_word => ["\\n<Demon Scylla>That feels good...that feels really good...", "scyllad_fc1", 2],
      :predation_word => ["\\n<Demon Scylla>D-don't eat me... Ahh...", "scyllad_fc1", 2],
      :incontinence_word => ["\\n<Demon Scylla>Don't look... Please don't look...", "scyllad_fc1", 2],
      :premortal_graphic => "50_scyllad_st03",
    },
    259 => { # セイレーン
      :dead_word => ["\\n<Siren>I can't sing anymore...", "seiren_fc1", 2],
      :orgasm_word => ["\\n<Siren>Ahh...I feel...", "seiren_fc1", 2],
      :predation_word => ["\\n<Siren>I don't want to end...like this...", "seiren_fc1", 2],
      :incontinence_word => ["\\n<Siren>Leaking...makes me feel good...", "seiren_fc1", 2],
      :premortal_graphic => "80_seiren_st03",
    }, 
    260 => { # サンゴ娘
      :dead_word => ["\\n<Coral Girl>.........", "sango_fc1", 0],
      :orgasm_word => ["\\n<Coral Girl>.........", "sango_fc1", 0],
      :predation_word => ["\\n<Coral Girl>.........", "sango_fc1", 0],
      :incontinence_word => ["\\n<Coral Girl>.........", "sango_fc1", 0],
      :premortal_graphic => "50_sango_st01",
    },
    261 => { # ヒトデ娘
      :dead_word => ["\\n<Starfish Girl>This isn't a kind world...", "hitode_fc1", 2],
      :orgasm_word => ["\\n<Starfish Girl>Ahh...it tickles...", "hitode_fc1", 2],
      :predation_word => ["\\n<Starfish Girl>You eat weird things...", "hitode_fc1", 2],
      :incontinence_word => ["\\n<Starfish Girl>How humiliating...", "hitode_fc1", 2],
      :premortal_graphic => "50_hitode_st03",
    },
    262 => { # ベルゼバブ
      :dead_word => ["\\n<Beelzebub>I won't forgive you...", "beelzebub_fc1", 2],
      :orgasm_word => ["\\n<Beelzebub>Such humiliation...", "beelzebub_fc1", 2],
      :predation_word => ["\\n<Beelzebub>Even if you eat me, the others will...", "beelzebub_fc1", 2],
      :incontinence_word => ["\\n<Beelzebub>Don't look at me...in this condition...", "beelzebub_fc1", 2],
      :premortal_graphic => "50_beelzebub_st03",
    },
    263 => { # ベルゼバブ
      :dead_word => ["\\n<Beelzebub>This is it, eh...", "beelzebub_fc2", 2],
      :orgasm_word => ["\\n<Beelzebub>Ahh, it feels so good...", "beelzebub_fc2", 2],
      :predation_word => ["\\n<Beelzebub>I will never forgive...", "beelzebub_fc2", 2],
      :incontinence_word => ["\\n<Beelzebub>Ahh...how humiliating...", "beelzebub_fc2", 2],
      :premortal_graphic => "50_beelzebub_st13",
    },
    264 => { # ベルゼバブ
      :dead_word => ["\\n<Beelzebub>It's over...", "beelzebub_fc3", 2],
      :orgasm_word => ["\\n<Beelzebub>It feels good...", "beelzebub_fc3", 2],
      :predation_word => ["\\n<Beelzebub>Don't eat me...", "beelzebub_fc3", 2],
      :incontinence_word => ["\\n<Beelzebub>Don't look...", "beelzebub_fc3", 2],
      :premortal_graphic => "50_beelzebub_st23",
    },
    265 => { # アークジェリー
      :dead_word => ["\\n<Arch Jelly>Going limp...", "arkjelly_fc1", 2],
      :orgasm_word => ["\\n<Arch Jelly>Coming...", "arkjelly_fc1", 2],
      :predation_word => ["\\n<Arch Jelly>Even though I'm mostly water and have no taste...", "arkjelly_fc1", 2],
      :incontinence_word => ["\\n<Arch Jelly>Moisture is leaking...", "arkjelly_fc1", 2],
      :premortal_graphic => "50_arkjelly_st03",
    },
    266 => { # エルダースキュラ
      :dead_word => ["\\n<Elder Scylla>Don't cut the tentacles...", "e_scylla_fc1", 2],
      :orgasm_word => ["\\n<Elder Scylla>How can I be exposed to such humiliation...", "e_scylla_fc1", 2],
      :predation_word => ["\\n<Elder Scylla>Unforgivable, I'm not delicious...", "e_scylla_fc1", 2],
      :incontinence_word => ["\\n<Elder Scylla>Ah... This is the ultimate humiliation...", "e_scylla_fc1", 2],
      :premortal_graphic => "80_e_scylla_st03",
    },
    267 => { # ポセイドネス
      :dead_word => ["\\n<Poseidoness>I surrender...", "poseidones_fc1", 2],
      :orgasm_word => ["\\n<Poseidoness>Such an...unsightly end...", "poseidones_fc1", 2],
      :predation_word => ["\\n<Poseidoness>To eat me, what boldness...", "poseidones_fc1", 2],
      :incontinence_word => ["\\n<Poseidoness>Someone like me...with everyone watching...", "poseidones_fc1", 2],
      :premortal_graphic => "80_poseidones_st03",
    },
    268 => { # サキュバス
      :dead_word => ["\\n<Succubus>I loathe this kind of violence...", "succubuses_fc2", 2],
      :orgasm_word => ["\\n<Succubus>This feels good, I love it!", "succubuses_fc2", 2],
      :predation_word => ["\\n<Succubus>Before eating me, at least let me...", "succubuses_fc2", 2],
      :incontinence_word => ["\\n<Succubus>Even though I'm a succubus...it's humiliating...", "succubuses_fc2", 2],
      :premortal_graphic => "80_succubuses_st03",
    },
    269 => { # サキュバス
      :dead_word => ["\\n<Succubus>I don't like this...", "succubuses_fc3", 2],
      :orgasm_word => ["\\n<Succubus>It feels good...", "succubuses_fc3", 2],
      :predation_word => ["\\n<Succubus>Don't... No, stop...", "succubuses_fc3", 2],
      :incontinence_word => ["\\n<Succubus>I'm peeing... Don't look...", "succubuses_fc3", 2],
      :premortal_graphic => "80_succubuses_st13",
    },
    270 => { # サキュバス
      :dead_word => ["\\n<Succubus>I need to rest...", "succubuses_fc4", 2],
      :orgasm_word => ["\\n<Succubus>It's embarrassing, but it feels good...", "succubuses_fc4", 2],
      :predation_word => ["\\n<Succubus>Ah, it feels a little comfortable...", "succubuses_fc4", 2],
      :incontinence_word => ["\\n<Succubus>This is...embarrassing...", "succubuses_fc4", 2],
      :premortal_graphic => "80_succubuses_st23",
    },
    271 => { # サキュバス
      :dead_word => ["\\n<Succubus>Bye-byeee...", "succubuses_fc5", 2],
      :orgasm_word => ["\\n<Succubus>It feels good, I like it...", "succubuses_fc5", 2],
      :predation_word => ["\\n<Succubus>Wait a minute, don't eat me...", "succubuses_fc5", 2],
      :incontinence_word => ["\\n<Succubus>This is the worst...", "succubuses_fc5", 2],
      :premortal_graphic => "80_succubuses_st33",
    },
    272 => { # メイキュバス
      :dead_word => ["\\n<Maidcubus>I shall excuse myself then...", "maycubbus_fc1", 2],
      :orgasm_word => ["\\n<Maidcubus>I should be the one serving you in the end...", "maycubbus_fc1", 2],
      :predation_word => ["\\n<Maidcubus>This kind of end is...disgusting... Aaah...", "maycubbus_fc1", 2],
      :incontinence_word => ["\\n<Maidcubus>I'm sorry, I'll clean it up later...", "maycubbus_fc1", 2],
      :premortal_graphic => "50_maycubbus_st03",
    },
    273 => { # マキュバス
      :dead_word => ["\\n<Maccubus>This is terrible...", "maccubus_fc1", 6],
      :orgasm_word => ["\\n<Maccubus>It feels humiliating...but good...", "maccubus_fc1", 6],
      :predation_word => ["\\n<Maccubus>My last moment... Ahh!", "maccubus_fc1", 6],
      :incontinence_word => ["\\n<Maccubus>Being seen...in such a state...", "maccubus_fc1", 6],
      :premortal_graphic => "50_maccubus_st31",
    },
    274 => { # ミンキュバス
      :dead_word => ["\\n<Mincubus>It hurts...", "minccubus_fc1", 3],
      :orgasm_word => ["\\n<Mincubus>Feels nice...", "minccubus_fc1", 3],
      :predation_word => ["\\n<Mincubus>No, nooooo...!!", "minccubus_fc1", 3],
      :incontinence_word => ["\\n<Mincubus>I can't pee like this...", "minccubus_fc1", 3],
      :premortal_graphic => "50_minccubus_st21",
    },
    275 => { # レンキュバス
      :dead_word => ["\\n<Lencubus>I can't do this anymore...", "renccubus_fc1", 4],
      :orgasm_word => ["\\n<Lencubus>I'm coming...", "renccubus_fc1", 4],
      :predation_word => ["\\n<Lencubus>I'm going to be eaten... Aaah...", "renccubus_fc1", 4],
      :incontinence_word => ["\\n<Lencubus>Doing this, in front of my sister...", "renccubus_fc1", 4],
      :premortal_graphic => "50_renccubus_st21",
    },
    276 => { # サキュバス
      :dead_word => ["\\n<Succubus>Everyone in the village...I'm sorry...", "succubus_fc1", 3],
      :orgasm_word => ["\\n<Succubus>This is...how I deal with pleasure...", "succubus_fc1", 3],
      :predation_word => ["\\n<Succubus>I'll remember this... Ah, aaah...!", "succubus_fc1", 3],
      :incontinence_word => ["\\n<Succubus>P-please don't look...", "succubus_fc1", 3],
      :premortal_graphic => "80_succubus_st03",
    },
    277 => { # ナターシャ
      :dead_word => ["\\n<Natasha>I'm used to this...", "d_succubus_fc1", 2],
      :orgasm_word => ["\\n<Natasha>Ahh, that feels good...", "d_succubus_fc1", 2],
      :predation_word => ["\\n<Natasha>Always someone's food...", "d_succubus_fc1", 2],
      :incontinence_word => ["\\n<Natasha>Ahh, I'm so ashamed...", "d_succubus_fc1", 2],
      :premortal_graphic => "80_d_succubus_st03",
    },
    278 => { # メイドスキュラ
      :dead_word => ["\\n<Maid Scylla>I need to rest for a while...", "maidscyulla_fc1", 3],
      :orgasm_word => ["\\n<Maid Scylla>Being forced to come against my will...", "maidscyulla_fc1", 3],
      :predation_word => ["\\n<Maid Scylla>My legs are rumored to be delicious...", "maidscyulla_fc1", 3],
      :incontinence_word => ["\\n<Maid Scylla>Ah, wetting myself like this...", "maidscyulla_fc1", 3],
      :premortal_graphic => "80_maidscyulla_st03",
    },
    279 => { # マダムインセクト
      :dead_word => ["\\n<Madame Insect>This is...regrettable...", "madaminsect_fc1", 2],
      :orgasm_word => ["\\n<Madame Insect>Such humiliation... I'll remember this...", "madaminsect_fc1", 2],
      :predation_word => ["\\n<Madame Insect>Guh, stop... Ahh...!", "madaminsect_fc1", 2],
      :incontinence_word => ["\\n<Madame Insect>Ah, this is...unbecoming of a lady...", "madaminsect_fc1", 2],
      :premortal_graphic => "50_madaminsect_st03",
    },
    280 => { # マダムアンブレラ
      :dead_word => ["\\n<Madame Umbrella>That's enough for now...", "madamumbrella_fc1", 2],
      :orgasm_word => ["\\n<Madame Umbrella>Ahh, that feels good...", "madamumbrella_fc1", 2],
      :predation_word => ["\\n<Madame Umbrella>I'll admit I look delicious, but...", "madamumbrella_fc1", 2],
      :incontinence_word => ["\\n<Madame Umbrella>Ah, this is so...embarrassing...", "madamumbrella_fc1", 2],
      :premortal_graphic => "50_madamumbrella_st03",
    },
    281 => { # アラディア
      :dead_word => ["\\n<Aradia>Let me have a little rest...", "aradia_fc1", 2],
      :orgasm_word => ["\\n<Aradia>Such sweet pleasure...", "aradia_fc1", 2],
      :predation_word => ["\\n<Aradia>How miserable, being eaten like this...", "aradia_fc1", 2],
      :incontinence_word => ["\\n<Aradia>This is embarrassing, yet pleasant...", "aradia_fc1", 2],
      :premortal_graphic => "80_aradia_st03",
    },
    282 => { # キャンディ
      :dead_word => ["\\n<Candy>I'm so hungry...", "candy_fc1", 3],
      :orgasm_word => ["\\n<Candy>This makes me warm...♪", "candy_fc1", 3],
      :predation_word => ["\\n<Candy>I'm very delicious...♪", "candy_fc1", 3],
      :incontinence_word => ["\\n<Candy>Pouring juice feels good...♪", "candy_fc1", 3],
      :premortal_graphic => "80_candy_st03",
    },
    283 => { # バジリスク娘
      :dead_word => ["\\n<Basilisk>Ugh, I yield...", "basilisk_fc1", 2],
      :orgasm_word => ["\\n<Basilisk>How could I succumb to such pleasure...ahh...", "basilisk_fc1", 2],
      :predation_word => ["\\n<Basilisk>I'll make you hard as stone inside your belly...!", "basilisk_fc1", 2],
      :incontinence_word => ["\\n<Basilisk>Guh, this is humiliating...", "basilisk_fc1", 2],
      :premortal_graphic => "80_basilisk_st03",
    },
    284 => { # ドラゴン娘
      :dead_word => ["\\n<Dragon Girl>The dragon has been defeated...", "dragon_fc1", 2],
      :orgasm_word => ["\\n<Dragon Girl>Such pleasure... Aaah...", "dragon_fc1", 2],
      :predation_word => ["\\n<Dragon Girl>To be able to eat a dragon...", "dragon_fc1", 2],
      :incontinence_word => ["\\n<Dragon Girl>A proud dragon...doing this...", "dragon_fc1", 2],
      :premortal_graphic => "80_dragon_st03",
    },
    285 => { # サラマンダー
      :dead_word => ["\\n<Salamander>Your strength is indeed magnificent...", "salamander_fc1", 2],
      :orgasm_word => ["\\n<Salamander>Doing this in public... Ahh...", "salamander_fc1", 2],
      :predation_word => ["\\n<Salamander>Guh... You'll get burned...", "salamander_fc1", 2],
      :incontinence_word => ["\\n<Salamander>How miserable... Damn you...", "salamander_fc1", 2],
      :premortal_graphic => "80_salamander_st03",
    },
    286 => { # グランベリア
      :dead_word => ["\\n<Granberia>As I thought, you won't be defeated so easily...", "granberia_fc3", 2],
      :orgasm_word => ["\\n<Granberia>Yielding to pleasure... A-aah...", "granberia_fc3", 6],
      :predation_word => ["\\n<Granberia>The weak are nothing but food...", "granberia_fc3", 2],
      :incontinence_word => ["\\n<Granberia>Guh... Don't look, don't look!", "granberia_fc3", 6],
      :premortal_graphic => "80_granberia_st63",
    },
    287 => { # ゼラチナスキューブ娘
      :dead_word => ["\\n<Gelatinous Cube Girl>Let me take a little nap...", "gelatinous_fc1", 2],
      :orgasm_word => ["\\n<Gelatinous Cube Girl>Coming... Ah, aaaaaah!", "gelatinous_fc1", 2],
      :predation_word => ["\\n<Gelatinous Cube Girl>Please don't eat me... Nooooo...", "gelatinous_fc1", 2],
      :incontinence_word => ["\\n<Gelatinous Cube Girl>Don't look, it's awful...!", "gelatinous_fc1", 2],
      :premortal_graphic => "50_gelatinous_st03",
    },
    288 => { # 妖鬼
      :dead_word => ["\\n<Youki>The oni has been exterminated...", "youki_fc1", 2],
      :orgasm_word => ["\\n<Youki>Damn it, it feels good...", "youki_fc1", 2],
      :predation_word => ["\\n<Youki>S-stop... Eating an oni is...!", "youki_fc1", 2],
      :incontinence_word => ["\\n<Youki>Ah... I feel pitiful...", "youki_fc1", 2],
      :premortal_graphic => "50_youki_st03",
    },
    289 => { # 虎娘
      :dead_word => ["\\n<Tiger Girl>Does a tiger's fangs come off when they die...?", "tora_fc1", 2],
      :orgasm_word => ["\\n<Tiger Girl>I ended up doing it in front of everyone...", "tora_fc1", 2],
      :predation_word => ["\\n<Tiger Girl>Eating a tiger... Even though it is a rare creature...", "tora_fc1", 2],
      :incontinence_word => ["\\n<Tiger Girl>This is... dishonorable...", "tora_fc1", 2],
      :premortal_graphic => "50_tora_st03",
    },
    290 => { # ヴァンパイア
      :dead_word => ["\\n<Vampire>I'll disappear into the fog...", "vampire_fc1", 2],
      :orgasm_word => ["\\n<Vampire>Ah, it's so pleasant...", "vampire_fc1", 2],
      :predation_word => ["\\n<Vampire>How could you eat a noble of the night...", "vampire_fc1", 2],
      :incontinence_word => ["\\n<Vampire>Ah, this feeling of liberation...", "vampire_fc1", 2],
      :premortal_graphic => "80_vampire_st03",
    },
    291 => { # ジェライラ
      :dead_word => ["\\n<Jellaila>Farewell...", "jeraira_fc1", 2],
      :orgasm_word => ["\\n<Jellaila>I've come...", "jeraira_fc1", 2],
      :predation_word => ["\\n<Jellaila>I'm not delicious...", "jeraira_fc1", 2],
      :incontinence_word => ["\\n<Jellaila>Ah, I mustn't leak...", "jeraira_fc1", 2],
      :premortal_graphic => "50_jeraira_st03",
    },
    292 => { # リボ・リボ
      :dead_word => ["\\n<Ribo-Ribo>Continuation of battle impossible...", "libolibo_fc1", 2],
      :orgasm_word => ["\\n<Ribo-Ribo>Pleasure tolerance exceeded...", "libolibo_fc1", 2],
      :predation_word => ["\\n<Ribo-Ribo>Predation inescapable...", "libolibo_fc1", 2],
      :incontinence_word => ["\\n<Ribo-Ribo>Incontinent emission...", "libolibo_fc1", 2],
      :premortal_graphic => "50_libolibo_st03",
    },
    293 => { # アンフィル
      :dead_word => ["\\n<Amphil>This is horrible...", "anfill_fc1", 2],
      :orgasm_word => ["\\n<Amphil>It feels good...", "anfill_fc1", 2],
      :predation_word => ["\\n<Amphil>Did I look tasty...?", "anfill_fc1", 2],
      :incontinence_word => ["\\n<Amphil>I'm leaking urine...", "anfill_fc1", 2],
      :premortal_graphic => "50_anfill_st03",
    },
    294 => { # ツィンケル
      :dead_word => ["\\n<Twinkell>Our body won't move anymore...", "twinkel_fc1", 2],
      :orgasm_word => ["\\n<Twinkell>Ah...so good...", "twinkel_fc1", 2],
      :predation_word => ["\\n<Twinkell>You came a long way to eat some strange food...", "twinkel_fc1", 2],
      :incontinence_word => ["\\n<Twinkell>Being exposed in this condition...is the worst...", "twinkel_fc1", 2],
      :premortal_graphic => "80_twinkel_st03",
    },
    295 => { # リリス＆リリム
      :dead_word => ["\\n<Lilith & Lilim>We'll take a little rest...", "lilith_fc1", 2],
      :orgasm_word => ["\\n<Lilith & Lilim>Such humiliation...but such a good feeling...", "lilith_fc1", 2],
      :predation_word => ["\\n<Lilith & Lilim>It will have a sweet taste...", "lilith_fc1", 2],
      :incontinence_word => ["\\n<Lilith & Lilim>Aaah... The queen is peeing...", "lilith_fc1", 2],
      :premortal_graphic => "80_lilith_st03",
    },
    296 => { # エミリ
      :dead_word => ["\\n<Emily>Already? No way...", "emily_fc1", 3],
      :orgasm_word => ["\\n<Emily>I'll remember this...ahh..", "emily_fc1", 3],
      :predation_word => ["\\n<Emily>Don't eat me, I'll do anything...\nEyaaah...!!", "emily_fc1", 3],
      :incontinence_word => ["\\n<Emily>You're the worst... Don't look, don't look at me...!", "emily_fc1", 3],
      :premortal_graphic => "50_emily_st03",
    },
    297 => { # カサンドラ
      :dead_word => ["\\n<Cassandra>I'll remember this...", "cassandra_fc1", 7],
      :orgasm_word => ["\\n<Cassandra>Such humiliation... Ah, ahhh...", "cassandra_fc1", 7],
      :predation_word => ["\\n<Cassandra>Eating someone like me... Absolutely unforgivable...!", "cassandra_fc1", 7],
      :incontinence_word => ["\\n<Cassandra>I've been seen by everyone in this condition...", "cassandra_fc1", 7],
      :premortal_graphic => "50_cassandra_st23",
    },
    298 => { # ウィッチ
      :dead_word => ["\\n<Succubus Witch>This is my limit...", "witchs_fc1", 3],
      :orgasm_word => ["\\n<Succubus Witch>I enjoy pleasure, but...", "witchs_fc1", 3],
      :predation_word => ["\\n<Succubus Witch>Eating me, I'm scared...", "witchs_fc1", 3],
      :incontinence_word => ["\\n<Succubus Witch>Such a figure...will soon be forgotten...", "witchs_fc1", 3],
      :premortal_graphic => "80_witchs_st03",
    },
    299 => { # シーシーアネモネ
      :dead_word => ["\\n<Sea Anemone Girl>I don't like violence...", "seaanemone_fc1", 0],
      :orgasm_word => ["\\n<Sea Anemone Girl>Ah, I'm coming...", "seaanemone_fc1", 0],
      :predation_word => ["\\n<Sea Anemone Girl>Just because I'm a sea creature doesn't mean I'm tasty...", "seaanemone_fc1", 0],
      :incontinence_word => ["\\n<Sea Anemone Girl>Ah, I'm leaking...", "seaanemone_fc1", 0],
      :premortal_graphic => "50_seaanemone_st01",
    },
    300 => { # 水龍娘
      :dead_word => ["\\n<Sea Dragon Girl>Do you not respect dragons...?", "suiryu_fc1", 2],
      :orgasm_word => ["\\n<Sea Dragon Girl>To come like this is so unsightly...", "suiryu_fc1", 2],
      :predation_word => ["\\n<Sea Dragon Girl>To be eaten is so unsightly...", "suiryu_fc1", 2],
      :incontinence_word => ["\\n<Sea Dragon Girl>To leak in public...what a blunder...", "suiryu_fc1", 2],
      :premortal_graphic => "50_suiryu_st03",
    },
    301 => { # マンタ娘
      :dead_word => ["\\n<Manta Girl>I...regret this...", "manta_fc1", 2],
      :orgasm_word => ["\\n<Manta Girl>Such a pleasant feeling...I can't bear it...", "manta_fc1", 2],
      :predation_word => ["\\n<Manta Girl>I'm quite a gourmet...", "manta_fc1", 2],
      :incontinence_word => ["\\n<Manta Girl>How am I leaking pee...", "manta_fc1", 2],
      :premortal_graphic => "80_manta_st03",
    },
    302 => { # イッカク娘
      :dead_word => ["\\n<Narwhal Girl>The lord of the seas has fallen...", "ikkaku_fc1", 2],
      :orgasm_word => ["\\n<Narwhal Girl>Defeated by coming... Hn, hnnnn...", "ikkaku_fc1", 2],
      :predation_word => ["\\n<Narwhal Girl>Don't let my horn get stuck in your stomach...", "ikkaku_fc1", 2],
      :incontinence_word => ["\\n<Narwhal Girl>My urine will become a great tide...", "ikkaku_fc1", 2],
      :premortal_graphic => "80_ikkaku_st03",
    },
    303 => { # トリックフェアリー
      :dead_word => ["\\n<Trick Fairy>I'm playing dead...", "trickfairy_fc1", 2],
      :orgasm_word => ["\\n<Trick Fairy>My head feels fluffy...♪", "trickfairy_fc1", 2],
      :predation_word => ["\\n<Trick Fairy>Nooo... Don't eat me...", "trickfairy_fc1", 2],
      :incontinence_word => ["\\n<Trick Fairy>I just tinkled...ehehe...♪", "trickfairy_fc1", 2],
      :premortal_graphic => "50_trickfairy_st03",
    },
    304 => { # アマゾネスエルフ
      :dead_word => ["\\n<Elf Amazoness>I'm sorry...my comrades...", "amazoneself_fc1", 2],
      :orgasm_word => ["\\n<Elf Amazoness>S-such...shame...!", "amazoneself_fc1", 2],
      :predation_word => ["\\n<Elf Amazoness>To fall prey...regretful...", "amazoneself_fc1", 2],
      :incontinence_word => ["\\n<Elf Amazoness>Wr-wretched...Don't look...!", "amazoneself_fc1", 2],
      :premortal_graphic => "50_amazoneself_st03",
    },
    305 => { # カーバンクル娘
      :dead_word => ["\\n<Carbuncle Girl>This is as far as I can go...", "carbuncle_fc1", 2],
      :orgasm_word => ["\\n<Carbuncle Girl>Giving in to pleasure like this...", "carbuncle_fc1", 2],
      :predation_word => ["\\n<Carbuncle Girl>Is this the law of survival of the fittest...?", "carbuncle_fc1", 2],
      :incontinence_word => ["\\n<Carbuncle Girl>Becoming incontinent like this...how miserable...", "carbuncle_fc1", 2],
      :premortal_graphic => "50_carbuncle_st03",
    },
    306 => { # ジャイガンテック娘
      :dead_word => ["\\n<Gigantic Girl>Everyone, I'm sorry...", "gigantic_fc1", 2],
      :orgasm_word => ["\\n<Gigantic Girl>I'm coming!", "gigantic_fc1", 2],
      :predation_word => ["\\n<Gigantic Girl>I never thought I could be eaten!", "gigantic_fc1", 2],
      :incontinence_word => ["\\n<Gigantic Girl>My pee will become a river...", "gigantic_fc1", 2],
      :premortal_graphic => "80_gigantic_st03",
    },
    307 => { # クィーンフェアリー
      :dead_word => ["\\n<Queen Fairy>Someone...take care of the fairies...", "queenfairy_fc1", 2],
      :orgasm_word => ["\\n<Queen Fairy>How could I come...", "queenfairy_fc1", 2],
      :predation_word => ["\\n<Queen Fairy>I'm going to meet such a horrible end...", "queenfairy_fc1", 2],
      :incontinence_word => ["\\n<Queen Fairy>I don't want to be seen by the fairies...in such a state...", "queenfairy_fc1", 2],
      :premortal_graphic => "80_queenfairy_st03",
    },
    308 => { # クィーンエルフ
      :dead_word => ["\\n<Queen Elf>I've used up all of my strength...", "queenelf_fc1", 2],
      :orgasm_word => ["\\n<Queen Elf>For the queen of the elves to climax...\nI cannot...feel this good...", "queenelf_fc1", 2],
      :predation_word => ["\\n<Queen Elf>Ah, what a cruel fate...", "queenelf_fc1", 2],
      :incontinence_word => ["\\n<Queen Elf>Ah...I am the queen...\nTo be seen by everyone, leaking urine...", "queenelf_fc1", 2],
      :premortal_graphic => "80_queenelf_st03",
    },
    309 => { # フォレストアルラウネ
      :dead_word => ["\\n<Forest Alraune>Ah, no more...", "f_alraune_fc1", 2],
      :orgasm_word => ["\\n<Forest Alraune>Ah, coming...", "f_alraune_fc1", 2],
      :predation_word => ["\\n<Forest Alraune>You shouldn't eat flowers...", "f_alraune_fc1", 2],
      :incontinence_word => ["\\n<Forest Alraune>Ah, I'm peeing...", "f_alraune_fc1", 2],
      :premortal_graphic => "50_f_alraune_st03",
    },
    310 => { # フォレストドリアード
      :dead_word => ["\\n<Forest Dryad>Ah, I'm sorry...", "f_dryad_fc1", 2],
      :orgasm_word => ["\\n<Forest Dryad>I'm feeling it...", "f_dryad_fc1", 2],
      :predation_word => ["\\n<Forest Dryad>Please don't eat me...\nAh, aaah...", "f_dryad_fc1", 2],
      :incontinence_word => ["\\n<Forest Dryad>I apologize, I have to pee...", "f_dryad_fc1", 2],
      :premortal_graphic => "50_f_dryad_st03",
    },
    311 => { # ワルラウネ
      :dead_word => ["\\n<Walraune>Jeez, this is the worst...", "walraune_fc1", 2],
      :orgasm_word => ["\\n<Walraune>I'm coming...", "walraune_fc1", 2],
      :predation_word => ["\\n<Walraune>S-stop... Kyaaah!!", "walraune_fc1", 2],
      :incontinence_word => ["\\n<Walraune>This feeling of liberation...is so good...", "walraune_fc1", 2],
      :premortal_graphic => "80_walraune_st03",
    },
    312 => { # ドリアード
      :dead_word => ["\\n<Dryad>It's hopeless...", "dryad_fc1", 2],
      :orgasm_word => ["\\n<Dryad>This feels good...", "dryad_fc1", 2],
      :predation_word => ["\\n<Dryad>I don't want to be eaten...", "dryad_fc1", 2],
      :incontinence_word => ["\\n<Dryad>Ah... I'm leaking...", "dryad_fc1", 2],
      :premortal_graphic => "50_dryad_st03",
    },
    313 => { # ドリアード
      :dead_word => ["\\n<Dark Dryad>You'll regret this...", "dryad_fc1", 6],
      :orgasm_word => ["\\n<Dark Dryad>This is humiliating...", "dryad_fc1", 6],
      :predation_word => ["\\n<Dark Dryad>I can't become food...", "dryad_fc1", 6],
      :incontinence_word => ["\\n<Dark Dryad>Don't look...it's disgusting...", "dryad_fc1", 6],
      :premortal_graphic => "50_dryad_st13",
    },
    314 => { # クィーンアルラウネ
      :dead_word => ["\\n<Queen Alraune>Am I to be finished here...?", "queenalraune_fc1", 2],
      :orgasm_word => ["\\n<Queen Alraune>The queen of alraunes, brought to a climax...", "queenalraune_fc1", 2],
      :predation_word => ["\\n<Queen Alraune>At least my toxins will... Ah, they're not enough...?", "queenalraune_fc1", 2],
      :incontinence_word => ["\\n<Queen Alraune>Such a shameful sight... Ah, you mustn't look...", "queenalraune_fc1", 2],
      :premortal_graphic => "80_queenalraune_st03",
    },
    315 => { # アジ・ダハーカ
      :dead_word => ["\\n<Aži Dahāka>How could you defeat me...", "azidahaka_fc1", 2],
      :orgasm_word => ["\\n<Aži Dahāka>Finished...by pleasure...", "azidahaka_fc1", 2],
      :predation_word => ["\\n<Aži Dahāka>I've...become prey...", "azidahaka_fc1", 2],
      :incontinence_word => ["\\n<Aži Dahāka>To be made incontinent...is humiliating...", "azidahaka_fc1", 2],
      :premortal_graphic => "80_azidahaka_st03",
    },
    316 => { # ナイトマーメイド
      :dead_word => ["\\n<Mermaid Knight>I guess this is the end...", "knight_mermaid_fc1", 2],
      :orgasm_word => ["\\n<Mermaid Knight>This pleasure...ah, it's the best...", "knight_mermaid_fc1", 2],
      :predation_word => ["\\n<Mermaid Knight>I can't be eaten... This is the worst...", "knight_mermaid_fc1", 2],
      :incontinence_word => ["\\n<Mermaid Knight>This...ah, it's embarrassing...", "knight_mermaid_fc1", 2],
      :premortal_graphic => "50_knight_mermaid_st03",
    },
    317 => { # ジェネラルマーメイド
      :dead_word => ["\\n<Mermaid General>I'm still inexperienced...", "g_marmaid_fc1", 2],
      :orgasm_word => ["\\n<Mermaid General>It's so good to fall from pleasure...", "g_marmaid_fc1", 2],
      :predation_word => ["\\n<Mermaid General>I didn't want to end up like this...", "g_marmaid_fc1", 2],
      :incontinence_word => ["\\n<Mermaid General>Ah... This is disgraceful behavior for a warrior...", "g_marmaid_fc1", 2],
      :premortal_graphic => "50_g_mermaid_st03",
    },
    318 => { # ローレライ
      :dead_word => ["\\n<Lorelei>I can't swim anymore...", "loreley_fc1", 0],
      :orgasm_word => ["\\n<Lorelei>I'm drowning in sweet pleasure...", "loreley_fc1", 0],
      :predation_word => ["\\n<Lorelei>Don't eat me... Ah, aaah...", "loreley_fc1", 0],
      :incontinence_word => ["\\n<Lorelei>Ah, the pleasure of incontinence...", "loreley_fc1", 0],
      :premortal_graphic => "80_loreley_st01",
    },
    319 => { # エル
      :dead_word => ["\\n<El>I'm sorry, mom...", "ningyohime_fc1", 7],
      :orgasm_word => ["\\n<El>This feels nice...", "ningyohime_fc1", 7],
      :predation_word => ["\\n<El>I can't get eaten, nooo...", "ningyohime_fc1", 7],
      :incontinence_word => ["\\n<El>Peeing is so embarrassing...", "ningyohime_fc1", 7],
      :premortal_graphic => "80_ningyohime_st08",
    },
    320 => { # クイーンマーメイド
      :dead_word => ["\\n<Queen Mermaid>This is a stain upon the Queen's name...", "queenmermaid_fc1", 1],
      :orgasm_word => ["\\n<Queen Mermaid>I cannot resist...this pleasure...", "queenmermaid_fc1", 1],
      :predation_word => ["\\n<Queen Mermaid>How could the queen become food...", "queenmermaid_fc1", 1],
      :incontinence_word => ["\\n<Queen Mermaid>Don't speak of this...to my daughter...", "queenmermaid_fc1", 1],
      :premortal_graphic => "80_queenmermaid_st03",
    },
    321 => { # アラクネ
      :dead_word => ["\\n<Arachne>Can I take a break now...?", "arachnes_fc2", 2],
      :orgasm_word => ["\\n<Arachne>I'm coming...", "arachnes_fc2", 2],
      :predation_word => ["\\n<Arachne>You want to eat spiders...?", "arachnes_fc2", 2],
      :incontinence_word => ["\\n<Arachne>Aaah... Don't look, it's disgusting...", "arachnes_fc2", 2],
      :premortal_graphic => "50_arachnes_st03",
    },
    322 => { # アラクネ
      :dead_word => ["\\n<Arachne>*flop*...", "arachnes_fc3", 2],
      :orgasm_word => ["\\n<Arachne>That feels good...", "arachnes_fc3", 2],
      :predation_word => ["\\n<Arachne>I hope I'm not tasty...?", "arachnes_fc3", 2],
      :incontinence_word => ["\\n<Arachne>I'm leaking...", "arachnes_fc3", 2],
      :premortal_graphic => "50_arachnes_st13",
    },
    323 => { # アラクネ
      :dead_word => ["\\n<Arachne>I can't do this anymore...", "arachnes_fc4", 2],
      :orgasm_word => ["\\n<Arachne>Coming in front of everyone is embarrassing ...", "arachnes_fc4", 2],
      :predation_word => ["\\n<Arachne>D-don't eat me...!", "arachnes_fc4", 2],
      :incontinence_word => ["\\n<Arachne>This is embarrassing...", "arachnes_fc4", 2],
      :premortal_graphic => "50_arachnes_st23",
    },
    324 => { # あやし土蜘蛛
      :dead_word => ["\\n<Tsuchigumo>I can only go this far...", "tutigumo_fc1", 2],
      :orgasm_word => ["\\n<Tsuchigumo>I'm drowning in pleasure...", "tutigumo_fc1", 2],
      :predation_word => ["\\n<Tsuchigumo>To be eaten in return...", "tutigumo_fc1", 2],
      :incontinence_word => ["\\n<Tsuchigumo>Ah... Even as my friends are watching me...", "tutigumo_fc1", 2],
      :premortal_graphic => "80_tutigumo_st13",
    },
    325 => { # アラクネロード
      :dead_word => ["\\n<Arachne Lord>Guh, no more...", "alakneload_fc1", 2],
      :orgasm_word => ["\\n<Arachne Lord>To succumb to pleasure is...miserable...", "alakneload_fc1", 2],
      :predation_word => ["\\n<Arachne Lord>I've become food for another...", "alakneload_fc1", 2],
      :incontinence_word => ["\\n<Arachne Lord>Ah, how could I pee...", "alakneload_fc1", 2],
      :premortal_graphic => "50_alakneload_st03",
    },
    326 => { # アトラク＝ナクア
      :dead_word => ["\\n<Atlach-Nacha>This is regrettable...", "atlach_fc1", 0],
      :orgasm_word => ["\\n<Atlach-Nacha>Ah...this feels good...", "atlach_fc1", 0],
      :predation_word => ["\\n<Atlach-Nacha>Have I become nourishment for another...?", "atlach_fc1", 0],
      :incontinence_word => ["\\n<Atlach-Nacha>My body fluids are leaking onto the ground...", "atlach_fc1", 0],
      :premortal_graphic => "80_atlach_st02",
    },
    327 => { # 蜘蛛之皇女
      :dead_word => ["\\n<Spider Princess>I have faltered...", "kumonomiko_fc1", 2],
      :orgasm_word => ["\\n<Spider Princess>I can't come... I'll never accept this humiliation...", "kumonomiko_fc1", 2],
      :predation_word => ["\\n<Spider Princess>What the-? you're eating me...? Aaah...", "kumonomiko_fc1", 2],
      :incontinence_word => ["\\n<Spider Princess>Doing this to me... Unforgivable, I won't forgive you...", "kumonomiko_fc1", 2],
      :premortal_graphic => "80_kumonomiko_st03",
    },
    328 => { # コンキスタ
      :dead_word => ["\\n<Conquista>It's over for today...", "conquista_fc1", 2],
      :orgasm_word => ["\\n<Conquista>This pleasure...will likely become a habit...", "conquista_fc1", 2],
      :predation_word => ["\\n<Conquista>Am I food as well...? That is regrettable...", "conquista_fc1", 2],
      :incontinence_word => ["\\n<Conquista>Stop... Don't look...", "conquista_fc1", 2],
      :premortal_graphic => "50_conquista_st03",
    },
    329 => { # ヴェンデッタ
      :dead_word => ["\\n<Vendetta>I shall return to the night...", "vendetta_fc1", 2],
      :orgasm_word => ["\\n<Vendetta>This feels so good...", "vendetta_fc1", 2],
      :predation_word => ["\\n<Vendetta>Becoming food...feels a bit pleasant...", "vendetta_fc1", 2],
      :incontinence_word => ["\\n<Vendetta>Ah... This is embarrassing...", "vendetta_fc1", 2],
      :premortal_graphic => "50_vendetta_st03",
    },
    330 => { # エルダーヴァンパイア
      :dead_word => ["\\n<Elder Vampire>My strength is exhausted...", "e_vampire_fc1", 0],
      :orgasm_word => ["\\n<Elder Vampire>I'm succumbing to pleasure...", "e_vampire_fc1", 0],
      :predation_word => ["\\n<Elder Vampire>For me to become prey...", "e_vampire_fc1", 0],
      :incontinence_word => ["\\n<Elder Vampire>This is a shameful sight for a noble of the night...", "e_vampire_fc1", 0],
      :premortal_graphic => "80_e_vampire_st01",
    },
    331 => { # カーミラ
      :dead_word => ["\\n<Carmilla>I can't do this anymore...", "carmilla_fc1", 2],
      :orgasm_word => ["\\n<Carmilla>I'm coming...", "carmilla_fc1", 2],
      :predation_word => ["\\n<Carmilla>I hate this...", "carmilla_fc1", 2],
      :incontinence_word => ["\\n<Carmilla>Peeing is so embarrassing...", "carmilla_fc1", 2],
      :premortal_graphic => "80_carmilla_st03",
    },
    332 => { # エリザベート
      :dead_word => ["\\n<Elizabeth>You'll definitely regret this...", "elisabeth_fc1", 2],
      :orgasm_word => ["\\n<Elizabeth>Ugh, this humiliation...damn you...", "elisabeth_fc1", 2],
      :predation_word => ["\\n<Elizabeth>Stop, don't eat meeee...!!", "elisabeth_fc1", 2],
      :incontinence_word => ["\\n<Elizabeth>D-don't look... Uuu *sob*...", "elisabeth_fc1", 2],
      :premortal_graphic => "80_elisabeth_st03",
    },
    333 => { # クィーンヴァンパイア
      :dead_word => ["\\n<Queen Vampire>I bend my knee to you...", "queenvampire_fc1", 2],
      :orgasm_word => ["\\n<Queen Vampire>To give in to pleasure...such a blunder...", "queenvampire_fc1", 2],
      :predation_word => ["\\n<Queen Vampire>How vulgar, I'll never forgive you... Guuuh...", "queenvampire_fc1", 2],
      :incontinence_word => ["\\n<Queen Vampire>You mustn't look... U...uuu...", "queenvampire_fc1", 2],
      :premortal_graphic => "80_queenvanpire_st13",
    },
    334 => { # マスターシャドウ
      :dead_word => ["\\n<Master Shadow>I'll curse you...", "m_shadow_fc1", 2],
      :orgasm_word => ["\\n<Master Shadow>It feels like I'm going towards heaven...", "m_shadow_fc1", 2],
      :predation_word => ["\\n<Master Shadow>How are you eating a ghost...", "m_shadow_fc1", 2],
      :incontinence_word => ["\\n<Master Shadow>Ah... I'm leaking...", "m_shadow_fc1", 2],
      :premortal_graphic => "50_m_shadow_st03",
    },
    335 => { # 煙々羅
      :dead_word => ["\\n<Enenra>My smoke is fading away...", "enenra_fc1", 2],
      :orgasm_word => ["\\n<Enenra>I...I'm coming...", "enenra_fc1", 2],
      :predation_word => ["\\n<Enenra>Smoke isn't good for you... Hyaaah...!", "enenra_fc1", 2],
      :incontinence_word => ["\\n<Enenra>This is...I-I'm not peeing...", "enenra_fc1", 2],
      :premortal_graphic => "50_enenra_st11",
    },
    336 => { # 麒麟
      :dead_word => ["\\n<Kirin>I can only go this far...", "kirin_fc1", 2],
      :orgasm_word => ["\\n<Kirin>This...feels good...", "kirin_fc1", 2],
      :predation_word => ["\\n<Kirin>If you eat me...you'll be punished...!", "kirin_fc1", 2],
      :incontinence_word => ["\\n<Kirin>No, this isn't me peeing...", "kirin_fc1", 2],
      :premortal_graphic => "80_kirin_st03",
    },
    337 => { # 蛇骨女
      :dead_word => ["\\n<Jakotsu-Onna>A snake's grudge lasts a hundred years...", "zyakotuonna_fc1", 2],
      :orgasm_word => ["\\n<Jakotsu-Onna>Uuu... How pitiful...", "zyakotuonna_fc1", 2],
      :predation_word => ["\\n<Jakotsu-Onna>You eat strange things...", "zyakotuonna_fc1", 2],
      :incontinence_word => ["\\n<Jakotsu-Onna>How humiliating... Ah, aaah...", "zyakotuonna_fc1", 2],
      :premortal_graphic => "50_zyakotuonna_st03",
    },
    338 => { # ベヒーモス娘
      :dead_word => ["\\n<Behemoth>If only I could rage more...", "behemoth_fc1", 2],
      :orgasm_word => ["\\n<Behemoth>I'm only hopeless...against pleasure...", "behemoth_fc1", 2],
      :predation_word => ["\\n<Behemoth>I should be the one eating you...", "behemoth_fc1", 2],
      :incontinence_word => ["\\n<Behemoth>This condition... Guh, don't look...", "behemoth_fc1", 2],
      :premortal_graphic => "80_behemoth_st03",
    },
    339 => { # ワイバーン
      :dead_word => ["\\n<Wyvern>The moment my wings give in...", "wyvern_fc1", 2],
      :orgasm_word => ["\\n<Wyvern>I want to savor this feeling...", "wyvern_fc1", 2],
      :predation_word => ["\\n<Wyvern>What a monster you are, eating a flying dragon...", "wyvern_fc1", 2],
      :incontinence_word => ["\\n<Wyvern>Being exposed with such disgraceful behavior... How careless of me...", "wyvern_fc1", 2],
      :premortal_graphic => "80_wyvern_st03",
    },
    340 => { # 巨竜娘
      :dead_word => ["\\n<Kyoryuu>No more...", "kyoryuu_fc1", 2],
      :orgasm_word => ["\\n<Kyoryuu>So good...", "kyoryuu_fc1", 2],
      :predation_word => ["\\n<Kyoryuu>I'll break your stomach...", "kyoryuu_fc1", 2],
      :incontinence_word => ["\\n<Kyoryuu>I made a lake...", "kyoryuu_fc1", 2],
      :premortal_graphic => "80_kyoryuu_st03",
    },
    341 => { # モンクサキュバス
      :dead_word => ["\\n<Succubus Monk>You're stronger than me...", "monk_sucubuss_fc1", 2],
      :orgasm_word => ["\\n<Succubus Monk>Fwaah...I'm coming...", "monk_sucubuss_fc1", 2],
      :predation_word => ["\\n<Succubus Monk>Don't eat me... Kyaaah..!", "monk_sucubuss_fc1", 2],
      :incontinence_word => ["\\n<Succubus Monk>Yaaa...! Don't look, don't look...", "monk_sucubuss_fc1", 2],
      :premortal_graphic => "50_monk_sucubuss_st03",
    },
    342 => { # モンクデーモン
      :dead_word => ["\\n<Demon Monk>Even after training so much...", "monk_demon_fc1", 2],
      :orgasm_word => ["\\n<Demon Monk>Guh, how could I come...!", "monk_demon_fc1", 2],
      :predation_word => ["\\n<Demon Monk>I don't want it to end like this... Ah, aaah!", "monk_demon_fc1", 2],
      :incontinence_word => ["\\n<Demon Monk>Aaah... I've been humiliated...", "monk_demon_fc1", 2],
      :premortal_graphic => "50_monk_demon_st03",
    },
    343 => { # スキュラサーバント
      :dead_word => ["\\n<Scylla Servant>I can't help you anymore...", "scylla_s_fc1", 2],
      :orgasm_word => ["\\n<Scylla Servant>This pleasant feeling, even my master would...", "scylla_s_fc1", 2],
      :predation_word => ["\\n<Scylla Servant>How could you eat me...ah...", "scylla_s_fc1", 2],
      :incontinence_word => ["\\n<Scylla Servant>Excuse me...I'll clean this myself...", "scylla_s_fc1", 2],
      :premortal_graphic => "50_scylla_s_st03",
    },
    344 => { # ヴィーヴル娘
      :dead_word => ["\\n<Vouivre Girl>I can't do this anymore, I give up...", "vouivre_fc1", 2],
      :orgasm_word => ["\\n<Vouivre Girl>I'm going to come...", "vouivre_fc1", 2],
      :predation_word => ["\\n<Vouivre Girl>Don't eat me...", "vouivre_fc1", 2],
      :incontinence_word => ["\\n<Vouivre Girl>Leaking...", "vouivre_fc1", 2],
      :premortal_graphic => "50_vouivre_st03",
    },
    345 => { # 黒華
      :dead_word => ["\\n<Black Dahlia>Guh, I can't do this...", "sanki0_fc1", 2],
      :orgasm_word => ["\\n<Black Dahlia>How could you make a succubus come... Ah, aaah...", "sanki0_fc1", 2],
      :predation_word => ["\\n<Black Dahlia>This isn't how I want to end up...!", "sanki0_fc1", 2],
      :incontinence_word => ["\\n<Black Dahlia>This is...the worst...", "sanki0_fc1", 2],
      :premortal_graphic => "80_sanki_st03",
    },
    346 => { # 黒蛇
      :dead_word => ["\\n<Black Mamba>I yield...", "sanki1_fc1", 2],
      :orgasm_word => ["\\n<Black Mamba>How could I give in to pleasure...!", "sanki1_fc1", 2],
      :predation_word => ["\\n<Black Mamba>For me to become prey...", "sanki1_fc1", 2],
      :incontinence_word => ["\\n<Black Mamba>Guh, don't look at my figure...", "sanki1_fc1", 2],
      :premortal_graphic => "80_sanki_st13",
    },
    347 => { # 黒薔薇
      :dead_word => ["\\n<Black Rose>I've been defeated...", "sanki2_fc1", 2],
      :orgasm_word => ["\\n<Black Rose>Ahh, that feels good...", "sanki2_fc1", 2],
      :predation_word => ["\\n<Black Rose>Guh, such a miserable end...", "sanki2_fc1", 2],
      :incontinence_word => ["\\n<Black Rose>It's embarrassing, but..it feels comfortable....", "sanki2_fc1", 2],
      :premortal_graphic => "80_sanki_st23",
    },
    348 => { # 黒のアリス
      :dead_word => ["\\n<Black Alice>Ara, you're impolite...", "alice8th_fc1", 2],
      :orgasm_word => ["\\n<Black Alice>This feels pleasant, ufufu...", "alice8th_fc1", 2],
      :predation_word => ["\\n<Black Alice>Is it okay to take me inside...?", "alice8th_fc1", 2],
      :incontinence_word => ["\\n<Black Alice>Oh, excuse me... This feels quite good...", "alice8th_fc1", 3],
      :premortal_graphic => "80_alice8th_st03",
    },
    349 => { # 黒のアリス
      :dead_word => ["\\n<Black Alice>Your abilities seem to be genuine...", "alice8th_fc1", 6],
      :orgasm_word => ["\\n<Black Alice>This feels pleasant, ufufu...", "alice8th_fc1", 6],
      :predation_word => ["\\n<Black Alice>Is it okay to take me inside...?", "alice8th_fc1", 6],
      :incontinence_word => ["\\n<Black Alice>Oh, excuse me... This feels quite good...", "alice8th_fc1", 5],
      :premortal_graphic => "80_alice8th2_st03",
    },
    350 => { # 黒のアリス
      :dead_word => ["\\n<Black Alice>Very impressive...!", "alice8th_fc2", 2],
      :orgasm_word => ["\\n<Black Alice>This feels pleasant, ufufu...", "alice8th_fc2", 2],
      :predation_word => ["\\n<Black Alice>Is it okay to take me inside...?", "alice8th_fc2", 2],
      :incontinence_word => ["\\n<Black Alice>Oh, excuse me... This feels quite good...", "alice8th_fc2", 1],
      :premortal_graphic => "80_alice8th3_st03",
    },
    351 => { # 氷の魔女
      :dead_word => ["\\n<Ice Witch>My magical power and life have come to an end...", "icemaze_fc1", 2],
      :orgasm_word => ["\\n<Ice Witch>My cold body is...hot...", "icemaze_fc1", 2],
      :predation_word => ["\\n<Ice Witch>Your stomach will go cold if you eat me...", "icemaze_fc1", 2],
      :incontinence_word => ["\\n<Ice Witch>My urine is leaking...", "icemaze_fc1", 2],
      :premortal_graphic => "50_icemaze_st03",
    },
    352 => { # シロクマ娘
      :dead_word => ["\\n<Polar Bear Girl>Cold...", "shirokuma_fc1", 2],
      :orgasm_word => ["\\n<Polar Bear Girl>Body, warm...", "shirokuma_fc1", 2],
      :predation_word => ["\\n<Polar Bear Girl>Is your stomach warm...?", "shirokuma_fc1", 2],
      :incontinence_word => ["\\n<Polar Bear Girl>Peeing, warm...", "shirokuma_fc1", 2],
      :premortal_graphic => "50_shirokuma_st03",
    },
    353 => { # 天使兵
      :dead_word => ["\\n<Angel Soldier>I still have a duty...", "angels_fc1", 2],
      :orgasm_word => ["\\n<Angel Soldier>This is the first time I've... Aaaah...!", "angels_fc1", 2],
      :predation_word => ["\\n<Angel Soldier>S-stop... Divine punishment will... Aaah!", "angels_fc1", 2],
      :incontinence_word => ["\\n<Angel Soldier>Such a...g-good feeling...", "angels_fc1", 2],
      :premortal_graphic => "50_angels_st03",
    },
    354 => { # 天使兵
      :dead_word => ["\\n<Angel Soldier>Guh, I won't forget this...", "angels_fc2", 2],
      :orgasm_word => ["\\n<Angel Soldier>Th-this... Hauuu...", "angels_fc2", 2],
      :predation_word => ["\\n<Angel Soldier>S-stop... I won't forgive you...\nAhhh...!", "angels_fc2", 2],
      :incontinence_word => ["\\n<Angel Soldier>Guh, this is humiliating... Don't look...", "angels_fc2", 2],
      :premortal_graphic => "50_angels_st13",
    },
    355 => { # 天使兵
      :dead_word => ["\\n<Angel Soldier>N-no more...", "angels_fc3", 2],
      :orgasm_word => ["\\n<Angel Soldier>Hyauu... That feels good...", "angels_fc3", 2],
      :predation_word => ["\\n<Angel Soldier>D-don't...I'm scared...", "angels_fc3", 2],
      :incontinence_word => ["\\n<Angel Soldier>I just peed...", "angels_fc3", 2],
      :premortal_graphic => "50_angels_st23",
    },
    356 => { # 天使兵
      :dead_word => ["\\n<Angel Soldier>I've used up all my strength here...", "angels_fc4", 2],
      :orgasm_word => ["\\n<Angel Soldier>Ah, that feels good...", "angels_fc4", 2],
      :predation_word => ["\\n<Angel Soldier>Ah, what a cruel end...", "angels_fc4", 2],
      :incontinence_word => ["\\n<Angel Soldier>Ah, how could I pee...", "angels_fc4", 2],
      :premortal_graphic => "50_angels_st33",
    },
    357 => { # 天使兵
      :dead_word => ["\\n<Angel Soldier>Ah, how miserable...", "angels_fc5", 2],
      :orgasm_word => ["\\n<Angel Soldier>How could I be coming...", "angels_fc5", 2],
      :predation_word => ["\\n<Angel Soldier>Ilias, I'm becoming food...", "angels_fc5", 2],
      :incontinence_word => ["\\n<Angel Soldier>Ah, how embarrassing...", "angels_fc5", 2],
      :premortal_graphic => "50_angels_st43",
    },
    358 => { # トリニティ
      :dead_word => ["\\n<Trinity>At last, the three of us together...", "trinity_fc1", 2],
      :orgasm_word => ["\\n<Trinity>Ah...I'm drowning in pleasure...", "trinity_fc1", 2],
      :predation_word => ["\\n<Trinity>Ah...the pleasure of being eaten...", "trinity_fc1", 2],
      :incontinence_word => ["\\n<Trinity>This is...pleasant...", "trinity_fc1", 2],
      :premortal_graphic => "50_trinity_st03",
    },
    359 => { # トリニティ
      :dead_word => ["\\n<Trinity>I'm sorry, Ilias...", "trinity_fc2", 2],
      :orgasm_word => ["\\n<Trinity>This good feeling...it's as if I'm ascending...", "trinity_fc2", 2],
      :predation_word => ["\\n<Trinity>This is my last moment...Ilias...", "trinity_fc2", 2],
      :incontinence_word => ["\\n<Trinity>Ah, how deplorable...", "trinity_fc2", 2],
      :premortal_graphic => "50_trinity_st13",
    },
    360 => { # トリニティ
      :dead_word => ["\\n<Trinity>I wanted to work more...", "trinity_fc3", 2],
      :orgasm_word => ["\\n<Trinity>I'm supposed to be the one giving pleasure...", "trinity_fc3", 2],
      :predation_word => ["\\n<Trinity>Even though I'm being eaten...it feels good...", "trinity_fc3", 2],
      :incontinence_word => ["\\n<Trinity>Please...please don't look...", "trinity_fc3", 2],
      :premortal_graphic => "50_trinity_st23",
    },
    361 => { # ウラヌス
      :dead_word => ["\\n<Uranus>The life of the Holy Beast is being severed here...", "uranus_fc1", 2],
      :orgasm_word => ["\\n<Uranus>The Holy Beast...meets her end in pleasure...", "uranus_fc1", 2],
      :predation_word => ["\\n<Uranus>I am the Holy Beast... How could you eat me...", "uranus_fc1", 2],
      :incontinence_word => ["\\n<Uranus>The Holy Beast is leaking urine... How pitiful of me...", "uranus_fc1", 2],
      :premortal_graphic => "50_uranus_st03",
    },
    362 => { # エリシエル
      :dead_word => ["\\n<Eliciel>Please bless this soul...", "erisiel_fc1", 2],
      :orgasm_word => ["\\n<Eliciel>This pleasure...ahh, it feels good...", "erisiel_fc1", 2],
      :predation_word => ["\\n<Eliciel>Eat my fruit, don't eat me whole...", "erisiel_fc1", 2],
      :incontinence_word => ["\\n<Eliciel>Ahh, how embarrassing...", "erisiel_fc1", 2],
      :premortal_graphic => "50_ediniel_st03",
    },
    363 => { # キューピッド
      :dead_word => ["\\n<Cupid>I can't do this anymooore...", "cupid_fc1", 2],
      :orgasm_word => ["\\n<Cupid>Aha... This feels so good! ♪", "cupid_fc1", 3],
      :predation_word => ["\\n<Cupid>Being eaten...it feels good...♪", "cupid_fc1", 3],
      :incontinence_word => ["\\n<Cupid>Peeing feels good...♪", "cupid_fc1", 3],
      :premortal_graphic => "50_cupid_st03",
    },
    364 => { # ヴァルキリー
      :dead_word => ["\\n<Valkyrie>Ilias...I'm sorry...", "valkyrie_fc1", 2],
      :orgasm_word => ["\\n<Valkyrie>This pleasant feeling...hauu...", "valkyrie_fc1", 1],
      :predation_word => ["\\n<Valkyrie>I have...become nourishment for evil...", "valkyrie_fc1", 2],
      :incontinence_word => ["\\n<Valkyrie>I am a war maiden... To be incontinent in public is...", "valkyrie_fc1", 1],
      :premortal_graphic => "50_valkyrie_st03",
    },
    365 => { # エデン
      :dead_word => ["\\n<Eden>So much of my power has been lost...", "eden_fc1", 2],
      :orgasm_word => ["\\n<Eden>How am I...feeling this kind of pleasure...", "eden_fc1", 2],
      :predation_word => ["\\n<Eden>There will be punishment...for such savagery...ahh...", "eden_fc1", 2],
      :incontinence_word => ["\\n<Eden>Ahh... D-don't look...\nPlease don't look...", "eden_fc1", 2],
      :premortal_graphic => "80_eden_st23",
    },
    366 => { # ヘリエル
      :dead_word => ["\\n<Heriel>My body won't move...", "heriel_fc1", 2],
      :orgasm_word => ["\\n<Heriel>Feeling good...", "heriel_fc1", 2],
      :predation_word => ["\\n<Heriel>Am I edible...?", "heriel_fc1", 2],
      :incontinence_word => ["\\n<Heriel>I'm peeing...", "heriel_fc1", 2],
      :premortal_graphic => "80_heriel_st03",
    },
    367 => { # アルシエル
      :dead_word => ["\\n<Alciel>The nightmare of this world...", "arusiel_fc1", 2],
      :orgasm_word => ["\\n<Alciel>I cannot resist...this pleasure...", "arusiel_fc1", 2],
      :predation_word => ["\\n<Alciel>I've become food... This is a nightmare...", "arusiel_fc1", 2],
      :incontinence_word => ["\\n<Alciel>Dripping urine...onto the earth...", "arusiel_fc1", 2],
      :premortal_graphic => "80_arusiel_st13",
    },
    368 => { # ソニアマズダ
      :dead_word => ["\\n<Sonya Mazda>■■ruin■■■it■■■■...", "soniamazda_fc1", 2],
      :orgasm_word => ["\\n<Sonya Mazda>■■■shame■■■■■■■■■■■■...", "soniamazda_fc1", 2],
      :incontinence_word => ["\\n<Sonya Mazda>■■■...■■■...", "soniamazda_fc1", 2],
      :premortal_graphic => "80_soniamazda_st03",
    },
    369 => { # ソニアマンユ
      :dead_word => ["\\n<Sonya Mainyu>■■is■■■■mix■■■■■■!", "soniamanyu_fc1", 3],
      :orgasm_word => ["\\n<Sonya Mainyu>■■...feel■■■■■■■■a...", "soniamanyu_fc1", 3],
      :incontinence_word => ["\\n<Sonya Mainyu>■■Leak■■■■■■,■■■■■■■■...?", "soniamanyu_fc1", 3],
      :premortal_graphic => "80_soniamanyu_st04",
    },
    370 => { # ソニアカオス
      :dead_word => ["\\n<Sonya Chaos>■■■■■■■■■■■■■■■■■■■■■■■■\n■■■■■■■■■■■■■■■■■■■■■■■■", "soniachaos_fc1", 3],
      :orgasm_word => ["\\n<Sonya Chaos>■■■■■■■■■■■■■■■■■■■■■■■■\n■■■■■■■■■■■■■■■■■■■■■■■■", "soniachaos_fc1", 3],
      :predation_word => ["\\n<Sonya Chaos>■■■■■■■■■■■■■■■■■■■■■■■■\n■■■■■■■■■■■■■■■■■■■■■■■■", "soniachaos_fc1", 3],
      :incontinence_word => ["\\n<Sonya Chaos>■■■u■■■■■■n■...", "soniachaos_fc1", 3],
      :premortal_graphic => "80_soniachaos_st04",
    },
    371 => { # ミカエラ
      :dead_word => ["\\n<Micaela>I lost...", "micaela_fc2", 0],
      :orgasm_word => ["\\n<Micaela>How could I...", "micaela_fc2", 0],
      :incontinence_word => ["\\n<Micaela>Kuh, don't look... Not this...", "micaela_fc2", 0],
      :premortal_graphic => "80_micaela_st31",
    },
    372 => { # ルシフィナ
      :dead_word => ["\\n<Lucifina>Is this the end? My death...?", "rucyfina_fc2", 0],
      :orgasm_word => ["\\n<Lucifina>Ah, I'm ascending to heaven...", "rucyfina_fc2", 0],
      :incontinence_word => ["\\n<Lucifina>It's shameful, but it feels so good...", "rucyfina_fc2", 0],
      :premortal_graphic => "80_rucyfina_st21",
    },
    373 => { # キメラビースト
      :dead_word => ["\\n<Chimera Beast>Unable to fight, ceasing functions...", "c_beast_fc1", 1],
      :orgasm_word => ["\\n<Chimera Beast>Climaxing... Ceasing functions...", "c_beast_fc1", 1],
      :predation_word => ["\\n<Chimera Beast>Being predated... Stop...", "c_beast_fc1", 1],
      :incontinence_word => ["\\n<Chimera Beast>Discharging urine...", "c_beast_fc1", 1],
      :premortal_graphic => "50_c_beast_st03",
    },
    374 => { # S-2
      :dead_word => ["\\n<Experiment S-2>Awawa, *bubble* *bubble*...", "c_s2_fc1", 2],
      :orgasm_word => ["\\n<Experiment S-2>Feels so good... *bubble* *bubble*...", "c_s2_fc1", 2],
      :predation_word => ["\\n<Experiment S-2>No, I'm being eaten... *bubble* *bubble*...", "c_s2_fc1", 2],
      :incontinence_word => ["\\n<Experiment S-2>Peeing... *bubble* *bubble*...", "c_s2_fc1", 2],
      :premortal_graphic => "50_c_s2_st03",
    },
    375 => { # A-3
      :dead_word => ["\\n<Experiment A-3>Why, with this form...", "c_a3_fc1", 0],
      :orgasm_word => ["\\n<Experiment A-3>It's disgraceful, but...it feels good...", "c_a3_fc1", 0],
      :predation_word => ["\\n<Experiment A-3>I cannot meet my end being eaten... Horrible...", "c_a3_fc1", 0],
      :incontinence_word => ["\\n<Experiment A-3>Such a figure...I won't forgive this...", "c_a3_fc1", 0],
      :premortal_graphic => "50_c_a3_st01",
    },
    376 => { # AD-5
      :dead_word => ["\\n<Experiment AD-5>It's over...", "AD-5_fc1", 0],
      :orgasm_word => ["\\n<Experiment AD-5>Climaxing...", "AD-5_fc1", 0],
      :predation_word => ["\\n<Experiment AD-5>Getting eaten...", "AD-5_fc1", 0],
      :incontinence_word => ["\\n<Experiment AD-5>Leaking...", "AD-5_fc1", 0],
      :premortal_graphic => "50_AD-5_st01",
    },
    377 => { # Q-5
      :dead_word => ["\\n<Experiment Q-5>Spin spin...*thud*", "q_5_fc1", 0],
      :orgasm_word => ["\\n<Experiment Q-5>That feels good...", "q_5_fc1", 0],
      :predation_word => ["\\n<Experiment Q-5>Don't eat me...don't eat me...", "q_5_fc1", 0],
      :incontinence_word => ["\\n<Experiment Q-5>I'm leaking out...", "q_5_fc1", 0],
      :premortal_graphic => "50_q_5_st01",
    },
    378 => { # フェルナンデス
      :dead_word => ["\\n<Fernandez>I can't move my body...", "cirqueb_fc1", 2],
      :orgasm_word => ["\\n<Fernandez>My body...feels hot...", "cirqueb_fc1", 2],
      :predation_word => ["\\n<Fernandez>Have I become prey...?", "cirqueb_fc1", 2],
      :incontinence_word => ["\\n<Fernandez>My urine...is pouring out...", "cirqueb_fc1", 2],
      :premortal_graphic => "50_cirque_st03",
    },
    379 => { # タイタニア
      :dead_word => ["\\n<Titania>No mooore!", "cirqueb_fc2", 2],
      :orgasm_word => ["\\n<Titania>Comiiing...!", "cirqueb_fc2", 2],
      :predation_word => ["\\n<Titania>I don't want to be eaten!", "cirqueb_fc2", 2],
      :incontinence_word => ["\\n<Titania>I'm going to pee...", "cirqueb_fc2", 2],
      :premortal_graphic => "50_cirque_st13",
    },
    380 => { # ロザ
      :dead_word => ["\\n<Roza>How could I lose...", "cirqueb_fc3", 2],
      :orgasm_word => ["\\n<Roza>I cannot resist this pleasure...", "cirqueb_fc3", 2],
      :predation_word => ["\\n<Roza>Surely, I must be delicious...", "cirqueb_fc3", 2],
      :incontinence_word => ["\\n<Roza>So shameful...", "cirqueb_fc3", 2],
      :premortal_graphic => "50_cirque_st23",
    },
    381 => { # アリア・ラミア
      :dead_word => ["\\n<Queen Lamia>Ah... Regrettable...", "cirqueb_fc4", 2],
      :orgasm_word => ["\\n<Queen Lamia>I cannot meet my end in pleasure...", "cirqueb_fc4", 2],
      :predation_word => ["\\n<Queen Lamia>Get a good taste...", "cirqueb_fc4", 2],
      :incontinence_word => ["\\n<Queen Lamia>Such a shameful figure...I apologize...", "cirqueb_fc4", 2],
      :premortal_graphic => "50_cirque_st33",
    },
    382 => { # リフレツィア
      :dead_word => ["\\n<Former Queen Harpy>I can't be defeated like this...", "cirqueb_fc5", 2],
      :orgasm_word => ["\\n<Former Queen Harpy>How could I come...", "cirqueb_fc5", 2],
      :predation_word => ["\\n<Former Queen Harpy>How could you eat me... You're the worst...", "cirqueb_fc5", 2],
      :incontinence_word => ["\\n<Former Queen Harpy>I won't forgive you...for this humiliation...", "cirqueb_fc5", 2],
      :premortal_graphic => "50_cirque_st43",
    },
    383 => { # ゼノビア
      :dead_word => ["\\n<Queen Scylla>I'm leaving...", "cirqueb_fc6", 2],
      :orgasm_word => ["\\n<Queen Scylla>Ah...so pleasant...", "cirqueb_fc6", 2],
      :predation_word => ["\\n<Queen Scylla>Please savor if you're going to eat me...", "cirqueb_fc6", 2],
      :incontinence_word => ["\\n<Queen Scylla>I can't be seen in this state...", "cirqueb_fc6", 2],
      :premortal_graphic => "50_cirque_st53",
    },
    384 => { # 玉藻
      :dead_word => ["\\n<Tamamo>Splendid!", "tamamo_fc3", 0],
      :orgasm_word => ["\\n<Tamamo>This is superb!", "tamamo_fc3", 0],
      :predation_word => ["\\n<Tamamo>To devour me like this...", "tamamo_fc3", 2],
      :incontinence_word => ["\\n<Tamamo>Don't look...don't look...", "tamamo_fc3", 2],
      :premortal_graphic => "80_tamamo_st61",
    },
    385 => { # アルマエルマ
      :dead_word => ["\\n<Alma Elma>You're truly impressive...", "arumaeruma_fc2", 0],
      :orgasm_word => ["\\n<Alma Elma>It's humiliating, but...it feels so gooood...", "arumaeruma_fc2", 6],
      :predation_word => ["\\n<Alma Elma>Being eaten is indecent, isn't it...", "arumaeruma_fc2", 6],
      :incontinence_word => ["\\n<Alma Elma>I can feel it... Such a miserable display...", "arumaeruma_fc2", 6],
      :premortal_graphic => "80_arumaeruma_st62",
    },
    386 => { # ルカ・ホリィ
      :dead_word => ["\\n<Luka Holly>Is this as far as I can go...?", "doppele_fc1", 0],
      :orgasm_word => ["\\n<Luka Holly>Aaah, I mustn't...", "doppele_fc1", 0],
      :predation_word => ["\\n<Luka Holly>I'm being eaten...", "doppele_fc1", 0],
      :incontinence_word => ["\\n<Luka Holly>I-I'm peeing...", "doppele_fc1", 0],
      :premortal_graphic => "50_doppele_st01",
    },
    387 => { # ルカ・リノア
      :dead_word => ["\\n<Luka Rinoa>Done in so easily...", "doppele_fc1", 4],
      :orgasm_word => ["\\n<Luka Rinoa>How could I feel like this...", "doppele_fc1", 4],
      :predation_word => ["\\n<Luka Rinoa>To become food is humiliating...", "doppele_fc1", 4],
      :incontinence_word => ["\\n<Luka Rinoa>Y-you're the worst...", "doppele_fc1", 4],
      :premortal_graphic => "50_doppele_st11",
    },
    388 => { # ルカ・ハイネ
      :dead_word => ["\\n<Luka Heine>I've looost!", "doppele_fc1", 1],
      :orgasm_word => ["\\n<Luka Heine>This feels gooood...!", "doppele_fc1", 1],
      :predation_word => ["\\n<Luka Heine>Don't eat meee!", "doppele_fc1", 1],
      :incontinence_word => ["\\n<Luka Heine>I'm peeing...", "doppele_fc1", 1],
      :premortal_graphic => "50_doppele_st21",
    },
    389 => { # ルカ・キリエ
      :dead_word => ["\\n<Luka Kyrie>Regrettable...", "doppele_fc1", 2],
      :orgasm_word => ["\\n<Luka Kyrie>Such humiliation...", "doppele_fc1", 2],
      :predation_word => ["\\n<Luka Kyrie>I wonder if I'm delicious...", "doppele_fc1", 2],
      :incontinence_word => ["\\n<Luka Kyrie>Don't look...where I'm peeing...", "doppele_fc1", 2],
      :premortal_graphic => "50_doppele_st31",
    },
    390 => { # フェルナンデス
      :dead_word => ["\\n<Fernandez>I can't move my body...", "cirquec_fc1", 2],
      :orgasm_word => ["\\n<Fernandez>My body...feels hot...", "cirquec_fc1", 2],
      :predation_word => ["\\n<Fernandez>Have I become prey...?", "cirquec_fc1", 2],
      :incontinence_word => ["\\n<Fernandez>My urine...is pouring out...", "cirquec_fc1", 2],
      :premortal_graphic => "80_cirquec_st03",
    },
    391 => { # タイタニア
      :dead_word => ["\\n<Titania>No mooore!", "cirquec_fc2", 2],
      :orgasm_word => ["\\n<Titania>Comiiing!", "cirquec_fc2", 2],
      :predation_word => ["\\n<Titania>I don't want to be eaten!", "cirquec_fc2", 2],
      :incontinence_word => ["\\n<Titania>I'm going to pee...", "cirquec_fc2", 2],
      :premortal_graphic => "80_cirquec_st13",
    },
    392 => { # ロザ
      :dead_word => ["\\n<Roza>How could I lose...", "cirquec_fc3", 2],
      :orgasm_word => ["\\n<Roza>I cannot resist this pleasure...", "cirquec_fc3", 2],
      :predation_word => ["\\n<Roza>Surely, I must be delicious...", "cirquec_fc3", 2],
      :incontinence_word => ["\\n<Roza>So shameful...", "cirquec_fc3", 2],
      :premortal_graphic => "80_cirquec_st23",
    },
    393 => { # アリア・ラミア
      :dead_word => ["\\n<Queen Lamia>Ah... Regrettable...", "cirquec_fc4", 2],
      :orgasm_word => ["\\n<Queen Lamia>I cannot meet my end in pleasure...", "cirquec_fc4", 2],
      :predation_word => ["\\n<Queen Lamia>Get a good taste...", "cirquec_fc4", 2],
      :incontinence_word => ["\\n<Queen Lamia>Such a shameful figure...I'm sorry...", "cirquec_fc4", 2],
      :premortal_graphic => "80_cirquec_st33",
    },
    394 => { # リフレツィア
      :dead_word => ["\\n<Former Queen Harpy>I can't be defeated like this...", "cirquec_fc5", 2],
      :orgasm_word => ["\\n<Former Queen Harpy>How could I come...", "cirquec_fc5", 2],
      :predation_word => ["\\n<Former Queen Harpy>How could you eat me... You're the worst...", "cirquec_fc5", 2],
      :incontinence_word => ["\\n<Former Queen Harpy>I won't forgive you...for this humiliation...", "cirquec_fc5", 2],
      :premortal_graphic => "80_cirquec_st43",
    },
    395 => { # ゼノビア
      :dead_word => ["\\n<Queen Scylla>I'm leaving...", "cirquec_fc6", 2],
      :orgasm_word => ["\\n<Queen Scylla>Ah...so pleasant...", "cirquec_fc6", 2],
      :predation_word => ["\\n<Queen Scylla>Please savor if you're going to eat me...", "cirquec_fc6", 2],
      :incontinence_word => ["\\n<Queen Scylla>I can't be seen in this state...", "cirquec_fc6", 2],
      :premortal_graphic => "80_cirquec_st53",
    },
    396 => { # ルシア
      :dead_word => ["\\n<Lucia>  My power doesn't work...", "lusia_fc2", 2],
      :orgasm_word => ["\\n<Lucia>  Such humiliation...!  Remember...!", "lusia_fc2", 2],
      :predation_word => ["\\n<Lucia>  How dare you eat me...that's it...", "lusia_fc2", 2],
      :incontinence_word => ["\\n<Lucia>  I can't believe you're exposing yourself like this...", "lusia_fc2", 2],
      :premortal_graphic => "80_lusia_st23",
    },
    397 => { # 天使殺し
      :dead_word => ["\\n<Angel Killer>With this, it finally ends...", "heinrich_fc3", 2],
      :orgasm_word => ["\\n<Angel Killer>With this, it finally ends...", "heinrich_fc3", 2],
      :predation_word => ["\\n<Angel Killer>With this, it finally ends...", "heinrich_fc3", 2],
      :premortal_graphic => "80_heinrich_st23",
    },
    398 => { # ジャッジメント
      :dead_word => ["\\n<Judgement>The time of judgment...", "judgement_fc1", 2],
      :orgasm_word => ["\\n<Judgement>The time of judgment...", "judgement_fc1", 2],
      :predation_word => ["\\n<Judgement>The time of judgment...", "judgement_fc1", 2],
      :premortal_graphic => "80_judgement_st01",
    },
    399 => { # ワールドブレイカー
      :dead_word => ["\\n<World Breaker>All of the worlds...", "worldbreaker_fc1", 2],
      :orgasm_word => ["\\n<World Breaker>All of the worlds...", "worldbreaker_fc1", 2],
      :predation_word => ["\\n<World Breaker>All of the worlds...", "worldbreaker_fc1", 2],
      :premortal_graphic => "80_worldbreaker_st03",
    },
    400 => { #サキュバス
      :dead_word => ["\\n<Demi-Nightmare>aah... I can't anymore...", "succubusj_fc1", 2],
      :orgasm_word => ["\\n<Demi-Nightmare>So good...I'm cumming...", "succubusj_fc1", 2],
      :predation_word => ["\\n<Demi-Nightmare>To think I'd get eaten...", "succubusj_fc1", 2],
      :incontinence_word => ["\\n<Demi-Nightmare>I'm leaking... ufufu...", "succubusj_fc1", 2],
      :premortal_graphic => "50_succubusj_st03",
    },
    401 => { # サキュバス
      :dead_word => ["\\n<Succubus>I loathe this kind of violence...", "succubuses_fc2", 2],
      :orgasm_word => ["\\n<Succubus>This feels good, I love it!", "succubuses_fc2", 2],
      :predation_word => ["\\n<Succubus>Before eating me, at least let me...", "succubuses_fc2", 2],
      :incontinence_word => ["\\n<Succubus>Even though I'm a succubus...it's humiliating...", "succubuses_fc2", 2],
      :premortal_graphic => "50_succubuses_st03",
    },
    402 => { # サキュバス
      :dead_word => ["\\n<Succubus>I don't like this...", "succubuses_fc3", 2],
      :orgasm_word => ["\\n<Succubus>It feels good...", "succubuses_fc3", 2],
      :predation_word => ["\\n<Succubus>Don't... No, stop...", "succubuses_fc3", 2],
      :incontinence_word => ["\\n<Succubus>I'm peeing... Don't look...", "succubuses_fc3", 2],
      :premortal_graphic => "50_succubuses_st13",
    },
    403 => { # サキュバス
      :dead_word => ["\\n<Succubus>I need to rest...", "succubuses_fc4", 2],
      :orgasm_word => ["\\n<Succubus>It's embarrassing, but it feels good...", "succubuses_fc4", 2],
      :predation_word => ["\\n<Succubus>Ah, it feels a little comfortable...", "succubuses_fc4", 2],
      :incontinence_word => ["\\n<Succubus>This is...embarrassing...", "succubuses_fc4", 2],
      :premortal_graphic => "50_succubuses_st23",
    },
    404 => { # サキュバス
      :dead_word => ["\\n<Succubus>Bye-byeee...", "succubuses_fc5", 2],
      :orgasm_word => ["\\n<Succubus>It feels good, I like it...", "succubuses_fc5", 2],
      :predation_word => ["\\n<Succubus>Wait a minute, don't eat me...", "succubuses_fc5", 2],
      :incontinence_word => ["\\n<Succubus>This is the worst...", "succubuses_fc5", 2],
      :premortal_graphic => "50_succubuses_st33",
    },
    405 => { # マダムインセクト
      :dead_word => ["\\n<Madame Insect>This is...regrettable...", "madaminsect_fc1", 2],
      :orgasm_word => ["\\n<Madame Insect>Such humiliation... I'll remember this...", "madaminsect_fc1", 2],
      :predation_word => ["\\n<Madame Insect>Guh, stop... Ahh...!", "madaminsect_fc1", 2],
      :incontinence_word => ["\\n<Madame Insect>Ah, this is...unbecoming of a lady...", "madaminsect_fc1", 2],
      :premortal_graphic => "50_madaminsect_st03",
    },
    406 => { # マダムアンブレラ
      :dead_word => ["\\n<Madame Umbrella>That's enough for now...", "madamumbrella_fc1", 2],
      :orgasm_word => ["\\n<Madame Umbrella>Ahh, that feels good...", "madamumbrella_fc1", 2],
      :predation_word => ["\\n<Madame Umbrella>I'll admit I look delicious, but...", "madamumbrella_fc1", 2],
      :incontinence_word => ["\\n<Madame Umbrella>Ah, this is so...embarrassing...", "madamumbrella_fc1", 2],
      :premortal_graphic => "50_madamumbrella_st03",
    },
    407 => { #エクスキューショナー
      :dead_word => ["\\n<Executioner>Yaaan~ It's my loss~", "executioner_fc1", 2],
      :orgasm_word => ["\\n<Executioner>C-c-cooming!!!", "executioner_fc1", 2],
      :predation_word => ["\\n<Executioner>W...what's this?! It doesn't feel goo-", "executioner_fc1", 2],
      :incontinence_word => ["\\n<Executioner>Pyaaaa! I wet myself!", "executioner_fc1", 2],
      :premortal_graphic => "80_executioner_st03",
    },
    408 => { #ランパス
      :dead_word => ["\\n<Lampas>For me to be done in like this...", "lanpass_fc2", 2],
      :orgasm_word => ["\\n<Lampas>Aaaa...?", "lanpass_fc2", 2],
      :predation_word => ["\\n<Lampas>H-Hang on! What are you?!?!", "lanpass_fc2", 2],
      :incontinence_word => ["\\n<Lampas>Haaa... crap, I can't hold it back...", "lanpass_fc2", 2],
      :premortal_graphic => "50_lanpass_st01",
    },
    409 => { #Spirit Fox
      :dead_word => ["\\n<Spirit Fox>Uaaaah... Really not feeling it today...", "youkosan_fc1", 2],
      :orgasm_word => ["\\n<Spirit Fox>Th-this rut... isn't stoooopping...♪", "youkosan_fc1", 6],
      :predation_word => ["\\n<Spirit Fox>Stoop! Don't eat me - If you do, you'll be sick, okay?! Nooo!!", "youkosan_fc1", 3],
      :incontinence_word => ["\\n<Spirit Fox>Aheee♪ I'm turning back into a wild beast...", "youkosan_fc1", 6],
      :premortal_graphic => "50_youkosan_st01",
    },
    410 => { #ミュスカ
      :dead_word => ["\\n<Myusca>Eh...? Hang on, time out...", "myuska_fc1", 7],
      :orgasm_word => ["\\n<Myusca>Ah, ah...♪ I... came...?", "myuska_fc1", 5],
      :predation_word => ["\\n<Myusca>H-hey... I'm not some snack you can just...", "myuska_fc1", 7],
      :incontinence_word => ["\\n<Myusca>N...Aaaa...?\nHey, it's your fault if I get addicted, kay?", "myuska_fc1", 5],
      :premortal_graphic => "80_myuska_st13",
    },
    411 => { # マーメイド
      :dead_word => ["\\n<Mermaid>I need a short rest...", "mermaid_fc1", 2],
      :orgasm_word => ["\\n<Mermaid>Ahh, that feels good...", "mermaid_fc1", 2],
      :predation_word => ["\\n<Mermaid>How could you eat a mermaid... Ahh...", "mermaid_fc1", 2],
      :incontinence_word => ["\\n<Mermaid>I shouldn't... Ahh, how embarrassing...", "mermaid_fc1", 2],
      :premortal_graphic => "50_mermaid_st03",
    },
    412 => { # ヒトデ娘
      :dead_word => ["\\n<Starfish Girl>This isn't a kind world...", "hitode_fc1", 2],
      :orgasm_word => ["\\n<Starfish Girl>Ahh...it tickles...", "hitode_fc1", 2],
      :predation_word => ["\\n<Starfish Girl>You eat weird things...", "hitode_fc1", 2],
      :incontinence_word => ["\\n<Starfish Girl>How humiliating...", "hitode_fc1", 2],
      :premortal_graphic => "50_hitode_st03",
    },
    413 => { # セイレーン
      :dead_word => ["\\n<Siren>I can't sing anymore...", "seiren_fc1", 2],
      :orgasm_word => ["\\n<Siren>Ahh...I feel...", "seiren_fc1", 2],
      :predation_word => ["\\n<Siren>I don't want to end...like this...", "seiren_fc1", 2],
      :incontinence_word => ["\\n<Siren>Leaking...makes me feel good...", "seiren_fc1", 2],
      :premortal_graphic => "80_seiren_st03",
    }, 
    414 => { # ミノタウロス娘
	  :dead_word => ["\\n<Minotauros>Kah, you got me!", "mino_fc1", 2],
      :orgasm_word => ["\\n<Minotauros>Stop... Don't watch me come...", "mino_fc1", 2],
      :predation_word => ["\\n<Minotauros>E-eating me... Damn you! Nooo... Ahh!", "mino_fc1", 2],
      :incontinence_word => ["\\n<Minotauros>Stop... Don't watch me pee...", "mino_fc1", 2],
      :premortal_graphic => "80_mino_st03",
    },
    415 => { # ハイミノタウロス
      :dead_word => ["\\n<High Minotauros>Big sister has lost...", "h_mino_fc1", 2],
      :orgasm_word => ["\\n<High Minotauros>Big Sister is coming...", "h_mino_fc1", 2],
      :predation_word => ["\\n<High Minotauros>Even if you eat me, I won't be tasty... Ahh...", "h_mino_fc1", 2],
      :incontinence_word => ["\\n<High Minotauros>Big sister is peeing...", "h_mino_fc1", 2],
      :premortal_graphic => "50_h_mino_st03",
    },
    416 => { # ミズタウロス
      :dead_word => ["\\n<Misstauros>I just wanted to be younger...", "m_mino_fc1", 2],
      :orgasm_word => ["\\n<Misstauros>Ahh, you made me come...", "m_mino_fc1", 2],
      :predation_word => ["\\n<Misstauros>There are tastier things than me...", "m_mino_fc1", 2],
      :incontinence_word => ["\\n<Misstauros>I'm too old for this... So shameful...", "m_mino_fc1", 2],
      :premortal_graphic => "50_m_mino_st03",
    },
    417 => { # ジニタウロス
      :dead_word => ["\\n<Genitauros>It's useless... I don't understand...", "zinitauros_fc1", 2],
      :orgasm_word => ["\\n<Genitauros>I'm coming... Ahh...!", "zinitauros_fc1", 2],
      :predation_word => ["\\n<Genitauros>D-don't eat me... Ah!", "zinitauros_fc1", 2],
      :incontinence_word => ["\\n<Genitauros>Oh no... So embarrassing...", "zinitauros_fc1", 2],
      :premortal_graphic => "50_zinitauros_st03",
    },
    418 => { # デビルファイター
      :dead_word => ["\\n<Devil Fighter>This is also part of being a warrior...", "d_fighter_fc1", 0],
      :orgasm_word => ["\\n<Devil Fighter>Coming... This is so embarrassing...", "d_fighter_fc1", 2],
      :predation_word => ["\\n<Devil Fighter>Don't eat me... Nooo... Kyaaaa!", "d_fighter_fc1", 0],
      :incontinence_word => ["\\n<Devil Fighter>Peeing... Don't look...", "d_fighter_fc1", 2],
      :premortal_graphic => "50_d_fighter_st03",
    },
    419 => { # アルラウネ
      :dead_word => ["\\n<Alraune>Hawawawa...", "alraune_fc1", 1],
      :orgasm_word => ["\\n<Alraune>I'm coooming...", "alraune_fc1", 1],
      :predation_word => ["\\n<Alraune>These flowers are sweet and delicious...", "alraune_fc1", 1],
      :incontinence_word => ["\\n<Alraune>This is embarrassing...", "alraune_fc1", 1],
      :premortal_graphic => "80_alraune_st03",
    },
    420 => { #ベル
      :dead_word => ["\\n<Bell>L...lyla...", "bell_fc1", 0],
      :orgasm_word => ["\\n<Bell>No, any more and... I'll...", "bell_fc1", 0],
      :predation_word => ["\\n<Bell>W, what are you doing to me?!?!", "bell_fc1", 0],
      :incontinence_word => ["\\n<Bell>S...stop... don't look....", "bell_fc1", 0],
      :premortal_graphic => "80_bell_st01",
    },
    421 => { #リラ
      :dead_word => ["\\n<Lyla>All the strength... is leaving my body...", "lira_fc1", 0],
      :orgasm_word => ["\\n<Lyla>T,this... this kind oooff thiiiing....", "lira_fc1", 0],
      :predation_word => ["\\n<Lyla>Hii!? Wh-what are you doing!?!?", "lira_fc1", 0],
      :incontinence_word => ["\\n<Lyla>Hafu...uuu...", "lira_fc1", 0],
      :premortal_graphic => "80_lira_st01",
    },
    422 => { # 雪女
      :dead_word => ["\\n<Yuki-Onna>My cold body becomes colder...", "yukionna_fc1", 2],
      :orgasm_word => ["\\n<Yuki-Onna>My body is warm...", "yukionna_fc1", 2],
      :predation_word => ["\\n<Yuki-Onna>You'll only be eating snow, you know...", "yukionna_fc1", 2],
      :incontinence_word => ["\\n<Yuki-Onna>Ahh, my crotch is warm...", "yukionna_fc1", 2],
      :premortal_graphic => "50_yukionna_st03",
    },
    423 => { # ねこまた
      :dead_word => ["\\n<Nekomata>Unya...", "nekomata_fc1", 4],
      :orgasm_word => ["\\n<Nekomata>Funyaaa...", "nekomata_fc1", 3],
      :predation_word => ["\\n<Nekomata>Nyaa!!", "nekomata_fc1", 1],
      :incontinence_word => ["\\n<Nekomata>Unyaa...", "nekomata_fc1", 3],
      :premortal_graphic => "50_nekomata_st03",
    },
    424 => { # あかなめ
      :dead_word => ["\\n<Akaname>No more...", "akaname_fc2", 3],
      :orgasm_word => ["\\n<Akaname>I'm coming...", "akaname_fc2", 3],
      :predation_word => ["\\n<Akaname>Everyone knows akaname aren't tasty...\nHyaaaa!", "akaname_fc2", 3],
      :incontinence_word => ["\\n<Akaname>Ahh, I'm leaking...", "akaname_fc2", 3],
      :premortal_graphic => "80_akaname_st03",
    },
    425 => { #オーガトゥース
      :dead_word => ["\\n<Ogretooth>Damn you, I won't forget what you did here!", "ogretooth_fc1", 5],
      :orgasm_word => ["\\n<Ogretooth>Guuuu!", "ogretooth_fc1", 5],
      :predation_word => ["\\n<Ogretooth>Kuh! I can't move!", "ogretooth_fc1", 5],
      :incontinence_word => ["\\n<Ogretooth>Aaaa! D-don't look!", "ogretooth_fc1", 5],
      :premortal_graphic => "80_ogretooth_st03",
    },
    426 => { # くのいちエルフ
      :dead_word => ["\\n<Kunoichi Elf>A shinobi only dies in the shadows...", "kunoitielf_fc1", 2],
      :orgasm_word => ["\\n<Kunoichi Elf>No... Even though I was trained...", "kunoitielf_fc1", 2],
      :predation_word => ["\\n<Kunoichi Elf>Eating a kunoichi...", "kunoitielf_fc1", 2],
      :incontinence_word => ["\\n<Kunoichi Elf>For a kunoichi to be incontinent... How shameful...", "kunoitielf_fc1", 2],
      :premortal_graphic => "80_kunoitielf_st03",
    },
    427 => { # サムライエルフ
      :dead_word => ["\\n<Samurai Elf>Regrettable...", "samuraielf_fc1", 2],
      :orgasm_word => ["\\n<Samurai Elf>Don't look... at my orgasming figure...", "samuraielf_fc1", 2],
      :predation_word => ["\\n<Samurai Elf>Ending as food for another... How unseemly...", "samuraielf_fc1", 2],
      :incontinence_word => ["\\n<Samurai Elf>S-such... sh-shame...", "samuraielf_fc1", 2],
      :premortal_graphic => "80_samuraielf_st03",
    },
    428 => { # 妖鬼
      :dead_word => ["\\n<Youki>The oni has been exterminated...", "youki_fc1", 2],
      :orgasm_word => ["\\n<Youki>Damn it, it feels good...", "youki_fc1", 2],
      :predation_word => ["\\n<Youki>S-stop... Eating an oni is...!", "youki_fc1", 2],
      :incontinence_word => ["\\n<Youki>Ah... I feel pitiful...", "youki_fc1", 2],
      :premortal_graphic => "50_youki_st03",
    },
    429 => { # 虎娘
      :dead_word => ["\\n<Tiger Girl>Does a tiger's fangs come off when they die...?", "tora_fc1", 2],
      :orgasm_word => ["\\n<Tiger Girl>I ended up doing it in front of everyone...", "tora_fc1", 2],
      :predation_word => ["\\n<Tiger Girl>Eating a tiger... Even though it is a rare creature...", "tora_fc1", 2],
      :incontinence_word => ["\\n<Tiger Girl>This is ...dishonorable...", "tora_fc1", 2],
      :premortal_graphic => "50_tora_st03",
    },
    430 => { # ヴァンパイア
      :dead_word => ["\\n<Vampire>I'll disappear into the fog...", "vampire_fc1", 2],
      :orgasm_word => ["\\n<Vampire>Ah, it's so pleasant...", "vampire_fc1", 2],
      :predation_word => ["\\n<Vampire>How could you eat a noble of the night...", "vampire_fc1", 2],
      :incontinence_word => ["\\n<Vampire>Ah, this feeling of liberation...", "vampire_fc1", 2],
      :premortal_graphic => "80_vampire_st03",
    },
    431 => { # デーモンラミア
      :dead_word => ["\\n<Demon Lamia>Why, in such a way...", "lamiad_fc1", 2],
      :orgasm_word => ["\\n<Demon Lamia>How could I come... Ah, aaah...", "lamiad_fc1", 2],
      :predation_word => ["\\n<Demon Lamia>Don't eat me... Aaaah!!", "lamiad_fc1", 2],
      :incontinence_word => ["\\n<Demon Lamia>This is...so embarrassing...", "lamiad_fc1", 2],
      :premortal_graphic => "50_lamiad_st03",
    },
    432 => { # デーモンスキュラ
      :dead_word => ["\\n<Demon Scylla>I'm so tired...", "scyllad_fc1", 2],
      :orgasm_word => ["\\n<Demon Scylla>That feels good...that feels really good...", "scyllad_fc1", 2],
      :predation_word => ["\\n<Demon Scylla>D-don't eat me... Ahh...", "scyllad_fc1", 2],
      :incontinence_word => ["\\n<Demon Scylla>Don't look... Please don't look...", "scyllad_fc1", 2],
      :premortal_graphic => "50_scyllad_st03",
    },
    433 => { # ドラゴン娘
      :dead_word => ["\\n<Dragon Girl>The dragon has been defeated...", "dragon_fc1", 2],
      :orgasm_word => ["\\n<Dragon Girl>Such pleasure... Aaah...", "dragon_fc1", 2],
      :predation_word => ["\\n<Dragon Girl>To be able to eat a dragon...", "dragon_fc1", 2],
      :incontinence_word => ["\\n<Dragon Girl>A proud dragon...doing this...", "dragon_fc1", 2],
      :premortal_graphic => "80_dragon_st03",
    },
    434 => { # サラマンダー
      :dead_word => ["\\n<Salamander>Your strength is indeed magnificent...", "salamander_fc1", 2],
      :orgasm_word => ["\\n<Salamander>Doing this in public... Ahh...", "salamander_fc1", 2],
      :predation_word => ["\\n<Salamander>Guh... You'll get burned...", "salamander_fc1", 2],
      :incontinence_word => ["\\n<Salamander>How miserable... Damn you...", "salamander_fc1", 2],
      :premortal_graphic => "80_salamander_st03",
    },
    435 => { #躯
      :dead_word => ["\\n<Mukuro>............", "mukuro_fc1", 2],
      :orgasm_word => ["\\n<Mukuro>......!!", "mukuro_fc1", 2],
      :predation_word => ["\\n<Mukuro>......!!", "mukuro_fc1", 2],
      :incontinence_word => ["\\n<Mukuro>............", "mukuro_fc1", 2],
      :premortal_graphic => "50_mukuro_st01",
    },
    436 => { #躯
      :dead_word => ["\\n<Mukuro>............", "mukuro_fc1", 2],
      :orgasm_word => ["\\n<Mukuro>......!!", "mukuro_fc1", 2],
      :predation_word => ["\\n<Mukuro>......!!", "mukuro_fc1", 2],
      :incontinence_word => ["\\n<Mukuro>............", "mukuro_fc1", 2],
      :premortal_graphic => "80_mukuro_st01",
    },
    437 => { #ネメア
      :dead_word => ["\\n<Nemea>Haa... you're so intense... won't you let me rest a little?", "nemea_fc1", 2],
      :orgasm_word => ["\\n<Nemea>A...Haaan!\nYou've truly managed to satisfy me~♡", "nemea_fc1", 5],
      :predation_word => ["\\n<Nemea>Arara... you want to gobble me all up, don't you?", "nemea_fc1", 2],
      :incontinence_word => ["\\n<Nemea>Aaaahnn? My, my...?\nYou're looking at something naughty, haven't you♪", "nemea_fc1", 5],
      :premortal_graphic => "80_nemea_st03",
    },
    438 => { # オートマータ娘
      :dead_word => ["\\n<Automata Girl>I must rest...", "artm_fc1", 1],
      :orgasm_word => ["\\n<Automata Girl>How could I come...", "artm_fc1", 1],
      :predation_word => ["\\n<Automata Girl>I apologize, but dolls are not appetizing...", "artm_fc1", 1],
      :incontinence_word => ["\\n<Automata Girl>My urine is leaking...\nForgive me... Forgive me...", "artm_fc1", 1],
      :premortal_graphic => "50_artm_st03",
    },
    439 => { # パイズリ人形
      :dead_word => ["\\n<Paizuri Doll>............", "paizuridoll_fc1", 2],
      :orgasm_word => ["\\n<Paizuri Doll>............", "paizuridoll_fc1", 2],
      :predation_word => ["\\n<Paizuri Doll>............", "paizuridoll_fc1", 2],
      :incontinence_word => ["\\n<Paizuri Doll>............", "paizuridoll_fc1", 2],
      :premortal_graphic => "50_paizuridoll_st03",
    },
    440 => { # くのいち三尾
      :dead_word => ["\\n<Three-Tailed Kunoichi>It's over, isn't it...?", "kunoitisanbi_fc1", 2],
      :orgasm_word => ["\\n<Three-Tailed Kunoichi>I will not yield to such pleasure... Uuu...", "kunoitisanbi_fc1", 2],
      :predation_word => ["\\n<Three-Tailed Kunoichi>Guh, how regrettable...!", "kunoitisanbi_fc1", 2],
      :incontinence_word => ["\\n<Three-Tailed Kunoichi>This is...miserable...", "kunoitisanbi_fc1", 2],
      :premortal_graphic => "50_kunoitisanbi_st03",
    },
    441 => { # もののふ四尾
      :dead_word => ["\\n<Four-Tailed Samurai>No more fighting for me...", "mononohuyonbi_fc1", 2],
      :orgasm_word => ["\\n<Four-Tailed Samurai>Coming on the battlefield...ahh...", "mononohuyonbi_fc1", 2],
      :predation_word => ["\\n<Four-Tailed Samurai>This is the fate of a loser...", "mononohuyonbi_fc1", 2],
      :incontinence_word => ["\\n<Four-Tailed Samurai>Ugh...such humiliation...", "mononohuyonbi_fc1", 2],
      :premortal_graphic => "50_mononohuyonbi_st03",
    },
    442 => { #ターサ
      :dead_word => ["\\n<Tarsa>S...sorry...", "tarsa_fc1", 2],
      :orgasm_word => ["\\n<Tarsa>A-aah...Noooooo!!!", "tarsa_fc1", 2],
      :predation_word => ["\\n<Tarsa>No... Help me!!!", "tarsa_fc1", 2],
      :incontinence_word => ["\\n<Tarsa>Stop! Don't look!", "tarsa_fc1", 2],
      :premortal_graphic => "80_tarsa_st13",
    },
    443 => { #ミュゼット
      :dead_word => ["\\n<Musette>I-impossible... I lost...?!", "muzet_fc1", 0],
      :orgasm_word => ["\\n<Musette>I-Is... this as far as I go...?!", "muzet_fc1", 0],
      :predation_word => ["\\n<Musette>S,s...stop...", "muzet_fc1", 0],
      :incontinence_word => ["\\n<Musette>To s,succumb to this kind of humiliation...", "muzet_fc1", 0],
      :premortal_graphic => "80_muzet_st01",
    },
    444 => { #サキュバスSR
      :dead_word => ["\\n<Nightmare>I lost... to pure violence...", "succubusm_fc1", 2],
      :orgasm_word => ["\\n<Nightmare>This pleasure is... hellish...♡", "succubusm_fc1", 1],
      :predation_word => ["\\n<Nightmare>To be eaten... feels rather nice, actually...♡", "succubusm_fc1", 1],
      :incontinence_word => ["\\n<Nightmare>A-ahh, I'm seen... it feels so good...", "succubusm_fc1", 1],
      :premortal_graphic => "50_succubusm_st03",
    },
    445 => { # モンクサキュバス
      :dead_word => ["\\n<Succubus Monk>You're stronger than me...", "monk_sucubuss_fc1", 2],
      :orgasm_word => ["\\n<Succubus Monk>Fwaah...I'm coming...", "monk_sucubuss_fc1", 2],
      :predation_word => ["\\n<Succubus Monk>Don't eat me... Kyaaah..!", "monk_sucubuss_fc1", 2],
      :incontinence_word => ["\\n<Succubus Monk>Yaaa...! Don't look, don't look...", "monk_sucubuss_fc1", 2],
      :premortal_graphic => "50_monk_sucubuss_st03",
    },
    446 => { # モンクデーモン
      :dead_word => ["\\n<Demon Monk>Even after training so much...", "monk_demon_fc1", 2],
      :orgasm_word => ["\\n<Demon Monk>Guh, how could I come...!", "monk_demon_fc1", 2],
      :predation_word => ["\\n<Demon Monk>I don't want it to end like this... Ah, aaah!", "monk_demon_fc1", 2],
      :incontinence_word => ["\\n<Demon Monk>Aaah... I've been humiliated...", "monk_demon_fc1", 2],
      :premortal_graphic => "50_monk_demon_st03",
    },
    447 => { # スキュラサーバント
      :dead_word => ["\\n<Scylla Servant>I can't help you anymore...", "scylla_s_fc1", 2],
      :orgasm_word => ["\\n<Scylla Servant>This pleasant feeling, even my master would...", "scylla_s_fc1", 2],
      :predation_word => ["\\n<Scylla Servant>How could you eat me...ah...", "scylla_s_fc1", 2],
      :incontinence_word => ["\\n<Scylla Servant>Excuse me...I'll clean this myself...", "scylla_s_fc1", 2],
      :premortal_graphic => "50_scylla_s_st03",
    },
    448 => { #フルビュア
      :dead_word => ["\\n<Fulbeua>D...don't make such a big deal out of beating me...", "fulbeua_fc1", 1],
      :orgasm_word => ["\\n<Fulbeua>Ahn♡... Haa... Darling♡, I'm...\nC-coming...♡", "fulbeua_fc1", 1],
      :predation_word => ["\\n<Fulbeua>You spoiled child...\nHogging me all for yourself?♡", "fulbeua_fc1", 1],
      :incontinence_word => ["\\n<Fulbeua>B...be honored... to have the privilege of staring at my soiled self...♡", "fulbeua_fc1", 1],
      :premortal_graphic => "80_fulbeua_st02",
    },
    449 => { #ヴィヌム
      :dead_word => ["\\n<Vinum>To think that I would be brought down to my knees... Interesting!", "vinum_fc1", 4],
      :orgasm_word => ["\\n<Vinum>Kuh... this pleasure... is... irresistible...?", "vinum_fc1", 4],
      :predation_word => ["\\n<Vinum>Hooh... so you desire to devour me, hmm?", "vinum_fc1", 2],
      :incontinence_word => ["\\n<Vinum>N... kufufu?\nI've gotten sloppy haven't I...?", "vinum_fc1", 4],
      :premortal_graphic => "80_vinum_st03",
    },
    450 => { # コンキスタ
      :dead_word => ["\\n<Conquista>It's over for today...", "conquista_fc1", 2],
      :orgasm_word => ["\\n<Conquista>This pleasure...will likely become a habit...", "conquista_fc1", 2],
      :predation_word => ["\\n<Conquista>Am I food as well...? That is regrettable...", "conquista_fc1", 2],
      :incontinence_word => ["\\n<Conquista>Stop... Don't look...", "conquista_fc1", 2],
      :premortal_graphic => "50_conquista_st03",
    },
    451 => { # ヴェンデッタ
      :dead_word => ["\\n<Vendetta>I shall return to the night...", "vendetta_fc1", 2],
      :orgasm_word => ["\\n<Vendetta>This feels so good...", "vendetta_fc1", 2],
      :predation_word => ["\\n<Vendetta>Becoming food...feels a bit pleasant...", "vendetta_fc1", 2],
      :incontinence_word => ["\\n<Vendetta>Ah... This is embarrassing...", "vendetta_fc1", 2],
      :premortal_graphic => "50_vendetta_st03",
    },
    452 => { # アラクネロード
      :dead_word => ["\\n<Arachne Lord>Guh, no more...", "alakneload_fc1", 2],
      :orgasm_word => ["\\n<Arachne Lord>To succumb to pleasure is...miserable...", "alakneload_fc1", 2],
      :predation_word => ["\\n<Arachne Lord>I've become food for another...", "alakneload_fc1", 2],
      :incontinence_word => ["\\n<Arachne Lord>Ah, how could I pee...", "alakneload_fc1", 2],
      :premortal_graphic => "50_alakneload_st03",
    },
    453 => { # ローレライ
      :dead_word => ["\\n<Lorelei>I can't swim anymore...", "loreley_fc1", 0],
      :orgasm_word => ["\\n<Lorelei>I'm drowning in sweet pleasure...", "loreley_fc1", 0],
      :predation_word => ["\\n<Lorelei>Don't eat me... Ah, aaah...", "loreley_fc1", 0],
      :incontinence_word => ["\\n<Lorelei>Ah, the pleasure of incontinence...", "loreley_fc1", 0],
      :premortal_graphic => "80_loreley_st01",
    },
    454 => { #ミステルテイン
      :dead_word => ["\\n<Mysteltainn>I've made a grave mistake...", "mistilteinn_fc1", 2],
      :orgasm_word => ["\\n<Mysteltainn>Fuaaaaaaan!", "mistilteinn_fc1", 2],
      :predation_word => ["\\n<Mysteltainn>You're kidding meeeeee!!", "mistilteinn_fc1", 2],
      :incontinence_word => ["\\n<Mysteltainn>Haa...haa...uu...", "mistilteinn_fc1", 2],
      :premortal_graphic => "80_mistilteinn_st33",
    },
    455 => { #ランパス
      :dead_word => ["\\n<Lampas>For me to be done in like this...", "lanpass_fc2", 2],
      :orgasm_word => ["\\n<Lampas>Aaaa...?", "lanpass_fc2", 2],
      :predation_word => ["\\n<Lampas>H-Hang on! What are you?!?!", "lanpass_fc2", 2],
      :incontinence_word => ["\\n<Lampas>Haaa... crap, I can't hold it back...", "lanpass_fc2", 2],
      :premortal_graphic => "50_lanpass_st01",
    },
    456 => { #Spirit Fox
      :dead_word => ["\\n<Spirit Fox>Uaaaah... Really not feeling it today...", "youkosan_fc1", 2],
      :orgasm_word => ["\\n<Spirit Fox>Th-this rut... isn't stoooopping...♪", "youkosan_fc1", 6],
      :predation_word => ["\\n<Spirit Fox>Stoop! Don't eat me - If you do, you'll be sick, okay?! Nooo!!", "youkosan_fc1", 3],
      :incontinence_word => ["\\n<Spirit Fox>Aheee♪ I'm turning back into a wild beast...", "youkosan_fc1", 6],
      :premortal_graphic => "50_youkosan_st01",
    },
    457 => { #躯
      :dead_word => ["\\n<Mukuro>............", "mukuro_fc1", 2],
      :orgasm_word => ["\\n<Mukuro>......!!", "mukuro_fc1", 2],
      :predation_word => ["\\n<Mukuro>......!!", "mukuro_fc1", 2],
      :incontinence_word => ["\\n<Mukuro>............", "mukuro_fc1", 2],
      :premortal_graphic => "50_mukuro_st01",
    },
    458 => { # キューピッド
      :dead_word => ["\\n<Cupid>I can't do this anymooore...", "cupid_fc1", 2],
      :orgasm_word => ["\\n<Cupid>Aha... This feels so good! ♪", "cupid_fc1", 3],
      :predation_word => ["\\n<Cupid>Being eaten...it feels good...♪", "cupid_fc1", 3],
      :incontinence_word => ["\\n<Cupid>Peeing feels good...♪", "cupid_fc1", 3],
      :premortal_graphic => "50_cupid_st03",
    },
    459 => { # ヴァルキリー
      :dead_word => ["\\n<Valkyrie>Ilias...I'm sorry...", "valkyrie_fc1", 2],
      :orgasm_word => ["\\n<Valkyrie>This pleasant feeling...hauu...", "valkyrie_fc1", 1],
      :predation_word => ["\\n<Valkyrie>I have...become nourishment for evil...", "valkyrie_fc1", 2],
      :incontinence_word => ["\\n<Valkyrie>I am a war maiden... To be incontinent in public is...", "valkyrie_fc1", 1],
      :premortal_graphic => "50_valkyrie_st03",
    },
    460 => { #ギルゴーン
      :dead_word => ["\\n<Gilgorn>H... how could I...!!", "gilgoon_fc1", 1],
      :orgasm_word => ["\\n<Gilgorn>S-stop, I beg you gh! E-enough...ugh, any more and I'll... ha...nh...♡", "gilgoon_fc1", 1],
      :predation_word => ["\\n<Gilgorn>H-how dare you!! Spit me out now!!", "gilgoon_fc1", 1],
      :incontinence_word => ["\\n<Gilgorn>Ha-aahh...♡\nS-such humiliation...", "gilgoon_fc1", 1],
      :premortal_graphic => "80_gilgoon_st02",
    },
    461 => { # インプ
      :dead_word => ["\\n<Imp>I can't do it anymore...", "inp_fc1", 2],
      :orgasm_word => ["\\n<Imp>I came... Haaauuu...", "inp_fc1", 3],
      :predation_word => ["\\n<Imp>D-don't eat me... Okay...? Hyaaaaan!", "inp_fc1", 2],
      :incontinence_word => ["\\n<Imp>I'm going to pee... Fueee...", "inp_fc1", 3],
      :premortal_graphic => "50_inp_st03",
    },
    462 => { # サキュバスSQ
      :dead_word => ["\\n<Nightmare>Heey, haven't you hurt me enough...?", "succubusq_fc1", 2],
      :orgasm_word => ["\\n<Nightmare>Ahn...♡ How wonderful...", "succubusq_fc1", 2],
      :predation_word => ["\\n<Nightmare>Ufufufu... You think I'm tasty, don't you...♡", "succubusq_fc1", 2],
      :incontinence_word => ["\\n<Nightmare>This... no, don't look...♡", "succubusq_fc1", 2],
      :premortal_graphic => "50_succubusq_st03",
    },
    463 => { # シェスタ
      :dead_word => ["\\n<Shesta>Ahh, Goddess...", "syesta_fc1", 2],
      :orgasm_word => ["\\n<Shesta>It feels so good, I'm coming...", "syesta_fc1", 2],
      :predation_word => ["\\n<Shesta>Am I edible...?", "syesta_fc1", 2],
      :incontinence_word => ["\\n<Shesta>Am I leaking...?", "syesta_fc1", 2],
      :premortal_graphic => "50_syesta_st03",
    },
    464 => { # ライオット
      :dead_word => ["\\n<Riot>Guh, no more...", "liot_fc1", 2],
      :orgasm_word => ["\\n<Riot>N-nooo... It's too much...", "liot_fc1", 3],
      :predation_word => ["\\n<Riot>Am I going to be preyed on here...?", "liot_fc1", 2],
      :incontinence_word => ["\\n<Riot>How could I... Such a shameful thing...", "liot_fc1", 3],
      :premortal_graphic => "50_liot_st03",
    },
    465 => { # ルクスル
      :dead_word => ["\\n<Luxuru>Battle continuation impossible... Body ceases to move...", "luksl_fc1", 2],
      :orgasm_word => ["\\n<Luxuru>Ahaha, I'm the one coming...?!", "luksl_fc1", 1],
      :predation_word => ["\\n<Luxuru>I'm heavy in the stomach! You won't enjoy this!", "luksl_fc1", 2],
      :incontinence_word => ["\\n<Luxuru>Ahaha, I'm leaking!", "luksl_fc1", 1],
      :premortal_graphic => "50_luksl_st03",
    },
    466 => { # ヴァルト
      :dead_word => ["\\n<Valto>All parts, ceasing function...", "valt_fc1", 2],
      :orgasm_word => ["\\n<Valto>Pleasure endurance exceeded...", "valt_fc1", 2],
      :predation_word => ["\\n<Valto>Becoming prey...", "valt_fc1", 2],
      :incontinence_word => ["\\n<Valto>Urine liquids discharging...", "valt_fc1", 2],
      :premortal_graphic => "50_valt_st03",
    },
    467 => { # シニファ
      :dead_word => ["\\n<Shinifa>Ahahaha...", "sinifa_fc1", 2],
      :orgasm_word => ["\\n<Shinifa>Fufu... Hahaha!", "sinifa_fc1", 3],
      :predation_word => ["\\n<Shinifa>Hah, hahahahaha...!", "sinifa_fc1", 2],
      :incontinence_word => ["\\n<Shinifa>Hnnff... Hahahahaaa...", "sinifa_fc1", 3],
      :premortal_graphic => "50_sinifa_st03",
    },
    468 => { # ジェライラ
      :dead_word => ["\\n<Jellaila>Farewell...", "jeraira_fc1", 2],
      :orgasm_word => ["\\n<Jellaila>I've come...", "jeraira_fc1", 2],
      :predation_word => ["\\n<Jellaila>I'm not delicious...", "jeraira_fc1", 2],
      :incontinence_word => ["\\n<Jellaila>Ah, I mustn't leak...", "jeraira_fc1", 2],
      :premortal_graphic => "50_jeraira_st03",
    },
    469 => { # ツィンケル
      :dead_word => ["\\n<Twinkell>Our body won't move anymore...", "twinkel_fc1", 2],
      :orgasm_word => ["\\n<Twinkell>Ah...so good...", "twinkel_fc1", 2],
      :predation_word => ["\\n<Twinkell>You came a long way to eat some strange food...", "twinkel_fc1", 2],
      :incontinence_word => ["\\n<Twinkell>Being exposed in this condition...is the worst...", "twinkel_fc1", 2],
      :premortal_graphic => "80_twinkel_st03",
    },
    470 => { #ベル
      :dead_word => ["\\n<Bell>L-Lyla...", "bell_fc1", 0],
      :orgasm_word => ["\\n<Bell>No, any more and... I'm!!!!!", "bell_fc1", 0],
      :predation_word => ["\\n<Bell>W-what are you doooing?!?!?", "bell_fc1", 0],
      :incontinence_word => ["\\n<Bell>S...stop, don't look...", "bell_fc1", 0],
      :premortal_graphic => "80_bell_st11",
    },
    471 => { #リラ
      :dead_word => ["\\n<Lyla>I... I can't move...", "lira_fc1", 0],
      :orgasm_word => ["\\n<Lyla>T...this.. kind of thiiing... aaah...", "lira_fc1", 0],
      :predation_word => ["\\n<Lyla>HiiiII! W-What is this?!?!", "lira_fc1", 0],
      :incontinence_word => ["\\n<Lyla>Hafuu...uuu...", "lira_fc1", 0],
      :premortal_graphic => "80_lira_st11",
    },
    472 => { #ミュゼット
      :dead_word => ["\\n<Musette>It can't be... for this kind of thing to...", "muzet_fc1", 0],
      :orgasm_word => ["\\n<Musette>F...for me...to have this happen here...", "muzet_fc1", 0],
      :predation_word => ["\\n<Musette>S-st-stop...", "muzet_fc1", 0],
      :incontinence_word => ["\\n<Musette>T...this kind of humiliation...", "muzet_fc1", 0],
      :premortal_graphic => "80_muzet_st01",
    },
    473 => { #フルビュア
      :dead_word => ["\\n<Fulbeua>D...don't make such a big deal out of beating me...", "fulbeua_fc1", 1],
      :orgasm_word => ["\\n<Fulbeua>Ahn♡... Haa... Darling♡, I'm...\nC-coming...♡", "fulbeua_fc1", 1],
      :predation_word => ["\\n<Fulbeua>You spoiled brat...\nHogging me all for yourself?", "fulbeua_fc1", 1],
      :incontinence_word => ["\\n<Fulbeua>B-be honored... to have the privilege of gazing upon my soiled self... Fufu...", "fulbeua_fc1", 1],
      :premortal_graphic => "80_fulbeua_st02",
    },
    474 => { #妲己
      :dead_word => ["\\n<Daji>Ghh...! I was being careless...!", "dakki_fc2", 4],
      :orgasm_word => ["\\n<Daji>.....hhnnn!", "dakki_fc2", 4],
      :predation_word => ["\\n<Daji>Foool! W-what are you doooing?!", "dakki_fc2", 4],
      :incontinence_word => ["\\n<Daji>To subject a woman to this kind of humiliation...\nAah, what have you done!?", "dakki_fc2", 4],
      :premortal_graphic => "80_dakki_st01",
    },
    475 => { #エスト
      :dead_word => ["\\n<Est>Let us meet once more, in a dream...?", "est_fc1", 1],
      :orgasm_word => ["\\n<Est>Aaaahhnnnn!", "est_fc1", 1],
      :predation_word => ["\\n<Est>Ah, you've brought me a rare pleasure... Let me indulge...", "est_fc1", 1],
      :incontinence_word => ["\\n<Est>A-aah... would you like... a sip...?", "est_fc1", 1],
      :premortal_graphic => "80_est_st01",
    },
    476 => { #エスト
      :dead_word => ["\\n<Est>Let us meet once more, in a dream...?", "est_fc1", 1],
      :orgasm_word => ["\\n<Est>Aaaahhnnnn!", "est_fc1", 1],
      :predation_word => ["\\n<Est>Ah, you've brought me a rare pleasure... Let me indulge...", "est_fc1", 1],
      :incontinence_word => ["\\n<Est>A-aah... would you like... a sip...?", "est_fc1", 1],
      :premortal_graphic => "80_est_st11",
    },
    477 => { #エクスキューショナー
      :dead_word => ["\\n<Executioner>Yaaan~ It's my loss~", "executioner_fc1", 2],
      :orgasm_word => ["\\n<Executioner>C-c-cooming!!!", "executioner_fc1", 2],
      :predation_word => ["\\n<Executioner>W...what's this?! It doesn't feel goo-", "executioner_fc1", 2],
      :incontinence_word => ["\\n<Executioner>Pyaaaa! I wet myself!", "executioner_fc1", 2],
      :premortal_graphic => "80_executioner_st23",
    },
    478 => { #オーガトゥース
      :dead_word => ["\\n<Ogretooth>Damn you... I won't forget this!", "ogretooth_fc1", 5],
      :orgasm_word => ["\\n<Ogretooth>Kuuuuuu!!", "ogretooth_fc1", 5],
      :predation_word => ["\\n<Ogretooth>Kun! H-help me...", "ogretooth_fc1", 5],
      :incontinence_word => ["\\n<Ogretooth>Aaaa! D-don't look!", "ogretooth_fc1", 5],
      :premortal_graphic => "80_ogretooth_st23",
    },
    479 => { #ミステルテイン
      :dead_word => ["\\n<Mysteltainn>I've made a grave mistake...", "mistilteinn_fc1", 2],
      :orgasm_word => ["\\n<Mysteltainn>Fuaaaaaaan!", "mistilteinn_fc1", 2],
      :predation_word => ["\\n<Mysteltainn>You're kidding meeeeee!!", "mistilteinn_fc1", 2],
      :incontinence_word => ["\\n<Mysteltainn>Haa...haa...uu...", "mistilteinn_fc1", 2],
      :premortal_graphic => "80_mistilteinn_st23",
    },
    480 => { #ミュスカ
      :dead_word => ["\\n<Myusca>Eh...? Hang on, time out...", "myuska_fc1", 7],
      :orgasm_word => ["\\n<Myusca>Ah, ah...♪ I... came...?", "myuska_fc1", 5],
      :predation_word => ["\\n<Myusca>H-hey... I'm not some snack you can just...", "myuska_fc1", 7],
      :incontinence_word => ["\\n<Myusca>N...Aaaa...?\nHey, it's your fault if I get addicted, kay?", "myuska_fc1", 5],
      :premortal_graphic => "80_myuska_st23",
    },
    481 => { #ネメア
      :dead_word => ["\\n<Nemea>Haaahn! So intense... I shall rest for a spell...", "nemea_fc1", 2],
      :orgasm_word => ["\\n<Nemea>A...Hnngh!\nYou're reaaallly good...", "nemea_fc1", 5],
      :predation_word => ["\\n<Nemea>Ararara~! You want to gobble onee-san all up?", "nemea_fc1", 2],
      :incontinence_word => ["\\n<Nemea>Aaaahnn? My, my...?\nYou've seen something dirty, haven't you♪", "nemea_fc1", 5],
      :premortal_graphic => "80_nemea_st13",
    },
    482 => { #ヴィヌム
      :dead_word => ["\\n<Vinum>To think that I would be brought down to my knees... how interesting...", "vinum_fc1", 4],
      :orgasm_word => ["\\n<Vinum>Kuh... this pleasure... is... irresistible...?", "vinum_fc1", 4],
      :predation_word => ["\\n<Vinum>Hooh... so, you wish to devour me whole, hmm?", "vinum_fc1", 2],
      :incontinence_word => ["\\n<Vinum>N... kufufu?\nI've gotten sloppy haven't I...?", "vinum_fc1", 4],
      :premortal_graphic => "80_vinum_st13",
    },
    483 => { #ベル
      :dead_word => ["\\n<Bell>L...lyla...", "bell_fc1", 0],
      :orgasm_word => ["\\n<Bell>No, any more and... I'm!!!!!", "bell_fc1", 0],
      :predation_word => ["\\n<Bell>W-what are you doooing?!?!?", "bell_fc1", 0],
      :incontinence_word => ["\\n<Bell>S...stop, don't look...", "bell_fc1", 0],
      :premortal_graphic => "80_bell_st11",
    },
    484 => { #リラ
      :dead_word => ["\\n<Lyla>I... I can't move...", "lira_fc1", 0],
      :orgasm_word => ["\\n<Lyla>T...this.. kind of thiiing... aaah...", "lira_fc1", 0],
      :predation_word => ["\\n<Lyla>HiiiII! W-What is this?!?!", "lira_fc1", 0],
      :incontinence_word => ["\\n<Lyla>Hafuu...uuu...", "lira_fc1", 0],
      :premortal_graphic => "80_lira_st11",
    },
    485 => { #ミュゼット
      :dead_word => ["\\n<Musette>It can't be... for this kind of thing to...", "muzet_fc1", 0],
      :orgasm_word => ["\\n<Musette>F...for me...to have this happen here...", "muzet_fc1", 0],
      :predation_word => ["\\n<Musette>S-st-stop...", "muzet_fc1", 0],
      :incontinence_word => ["\\n<Musette>T...this kind of humiliation...", "muzet_fc1", 0],
      :premortal_graphic => "80_muzet_st01",
    },
    486 => { #フルビュア
      :dead_word => ["\\n<Fulbeua>D...don't make such a big deal out of beating me...", "fulbeua_fc1", 1],
      :orgasm_word => ["\\n<Fulbeua>Ahn♡... Haa... Darling♡, I'm...\nC-coming...♡", "fulbeua_fc1", 1],
      :predation_word => ["\\n<Fulbeua>You spoiled brat...\nHogging me all for yourself?", "fulbeua_fc1", 1],
      :incontinence_word => ["\\n<Fulbeua>B-be honored... to have the privilege of gazing upon my soiled self... Fufu...", "fulbeua_fc1", 1],
      :premortal_graphic => "80_fulbeua_st02",
    },
    487 => { #ギルゴーン
      :dead_word => ["\\n<Gilgorn>...To think that I, of all people...!", "gilgoon_fc1", 1],
      :orgasm_word => ["\\n<Gilgorn>N...No! No more!\n...Any more... I'll!?", "gilgoon_fc1", 1],
      :predation_word => ["\\n<Gilgorn>How daaare you! L-let me goo!!", "gilgoon_fc1", 1],
      :incontinence_word => ["\\n<Gilgorn>Haa...Ha....?\nTh-this humiliation...", "gilgoon_fc1", 1],
      :premortal_graphic => "80_gilgoon_st02",
    },
    488 => { #大明海
      :dead_word => ["\\n<Daimyokai>H-how vexing... I'll just pleasure myself to forget this...", "daimeikai_fc1", 1],
      :orgasm_word => ["\\n<Daimyokai>H...Hooo~♪ My loins are on fire~♪", "daimeikai_fc1", 3],
      :predation_word => ["\\n<Daimyokai>Ugh! I don't have this kind of fetish!", "daimeikai_fc1", 1],
      :incontinence_word => ["\\n<Daimyokai>Hoo! Hooo...♪", "daimeikai_fc1", 7],
      :premortal_graphic => "80_daimeikai_st01",
    },
    489 => { #ターサ
      :dead_word => ["\\n<Tarsa>W...what am I doing?", "tarsa_fc2", 2],
      :orgasm_word => ["\\n<Tarsa>My genitals... it's so hot...", "tarsa_fc2", 2],
      :predation_word => ["\\n<Tarsa>Eeh? What are you planning to do with m-", "tarsa_fc2", 2],
      :incontinence_word => ["\\n<Tarsa>Kyaaan!", "tarsa_fc2", 2],
      :premortal_graphic => "80_tarsa_st13",
    },
    490 => { #妲己
     :dead_word => ["\\n<Daji>Ghh..! I was being careless...!", "dakki_fc2", 4],
      :orgasm_word => ["\\n<Daji>.....hhnnn!", "dakki_fc2", 4],
      :predation_word => ["\\n<Daji>Foool! W-what are you doooing!?", "dakki_fc2", 4],
      :incontinence_word => ["\\n<Daji>To subject a woman to this kind of humiliation...\nAah, what have you done!?", "dakki_fc2", 4],
      :premortal_graphic => "80_dakki_st01",
    },
    491 => { #エスト
      :dead_word => ["\\n<Est>Let us meet once more, in a dream...?", "est_fc1", 1],
      :orgasm_word => ["\\n<Est>Aaaahhnnnn!", "est_fc1", 1],
      :predation_word => ["\\n<Est>Ah, you've brought me a rare pleasure... Let me indulge...", "est_fc1", 1],
      :incontinence_word => ["\\n<Est>A-aah... would you like... a sip...?", "est_fc1", 1],
      :premortal_graphic => "80_est_st01",
    },
    492 => { #サキュバス
      :dead_word => ["\\n<Demi-Nightmare>Aah... No more...", "succubusj_fc1", 2],
      :orgasm_word => ["\\n<Demi-Nightmare>S...so good... I'm coming...", "succubusj_fc1", 1],
      :predation_word => ["\\n<Demi-Nightmare>T-to think that I would be eaten to death...", "succubusj_fc1", 2],
      :incontinence_word => ["\\n<Demi-Nightmare>Ufufu... Watch me soil myself...", "succubusj_fc1", 1],
      :premortal_graphic => "50_succubusj_st03",
    },
    493 => { # ミミック娘
      :dead_word => ["\\n<Mimic>H-horrible!", "mimic_fc1", 1],
      :orgasm_word => ["\\n<Mimic>D-don't...", "mimic_fc1", 1],
      :predation_word => ["\\n<Mimic>D-don't eat me! Please, I'll do anything so... Kyaa!", "mimic_fc1", 1],
      :incontinence_word => ["\\n<Mimic>L-leaking... It's in my box, so it's okay...", "mimic_fc1", 1],
      :premortal_graphic => "80_mimic_st03",
    },
    494 => { #サキュバスSR
      :dead_word => ["\\n<Nightmare>To lose... to such violence...", "succubusm_fc1", 2],
      :orgasm_word => ["\\n<Nightmare>Aah... this pleasure is... intoxicating ♡", "succubusm_fc1", 1],
      :predation_word => ["\\n<Nightmare>This... feels rather nice, actually♡", "succubusm_fc1", 1],
      :incontinence_word => ["\\n<Nightmare>Aaah, to be seen doing this... it's delectable♡", "succubusm_fc1", 1],
      :premortal_graphic => "50_succubusm_st03",
    },
    495 => { #エクスキューショナー
      :dead_word => ["\\n<Executioner>Yaaan~ It's my loss~", "executioner_fc1", 2],
      :orgasm_word => ["\\n<Executioner>C-c-cooming!!!", "executioner_fc1", 2],
      :predation_word => ["\\n<Executioner>W...what's this?! It doesn't feel goo-", "executioner_fc1", 2],
      :incontinence_word => ["\\n<Executioner>Pyaaaa! I wet myself!", "executioner_fc1", 2],
      :premortal_graphic => "80_executioner_st03",
    },
    496 => { #オーガトゥース
      :dead_word => ["\\n<Ogretooth>Damn you... I won't forget this!", "ogretooth_fc1", 5],
      :orgasm_word => ["\\n<Ogretooth>Kuuuuuu!!", "ogretooth_fc1", 5],
      :predation_word => ["\\n<Ogretooth>Kun! H-help me...", "ogretooth_fc1", 5],
      :incontinence_word => ["\\n<Ogretooth>Aaaa! D-don't look!", "ogretooth_fc1", 5],
      :premortal_graphic => "80_ogretooth_st03",
    },
    497 => { # イデア・ルカス
      :dead_word => ["\\n<Idea Luka>Even if it ends here...I'll try as many times as it takes...", "idea_rukas_fc1", 0],
      :orgasm_word => ["\\n<Idea Luka>Even if it ends here...I'll try as many times as it takes...", "idea_rukas_fc1", 0],
      :predation_word => ["\\n<Idea Luka>Even if it ends here...I'll try as many times as it takes...", "idea_rukas_fc1", 0],
      :premortal_graphic => "80_idea_rukas_st01",
    },
    498 => { # カサンドラ
      :dead_word => ["\\n<Cassandra>I'll remember this...", "cassandra_fc1", 2],
      :orgasm_word => ["\\n<Cassandra>Such humiliation... Ah, ahhh...", "cassandra_fc1", 2],
      :predation_word => ["\\n<Cassandra>Eating someone like me... Absolutely unforgivable...!", "cassandra_fc1", 2],
      :incontinence_word => ["\\n<Cassandra>I've been seen by everyone in this condition...", "cassandra_fc1", 2],
      :premortal_graphic => "80_cassandra_st03",
    },
    500 => { # 魔王カサンドラ
      :dead_word => ["\\n<Monster Lord Cassandra>Even with so much power, I still cannot win...", "cassandra_fc3", 2],
      :orgasm_word => ["\\n<Monster Lord Cassandra>This is humiliating for a Monster Lord such as I...", "cassandra_fc3", 2],
      :predation_word => ["\\n<Monster Lord Cassandra>The weak are destined to be food...", "cassandra_fc3", 2],
      :incontinence_word => ["\\n<Monster Lord Cassandra>Even as a Monster Lord, I still face such humiliation...", "cassandra_fc3", 2],
      :premortal_graphic => "80_cassandra_st53",
    },
    501 => { # ガルダ
      :dead_word => ["\\n<Garuda>Kweeeh...", "galda_fc1", 0],
      :orgasm_word => ["\\n<Garuda>K...kweeeh...", "galda_fc1", 0],
      :predation_word => ["\\n<Garuda>Kweeehhh!!", "galda_fc1", 0],
      :incontinence_word => ["\\n<Garuda>Kweeeeh...", "galda_fc1", 0],
      :premortal_graphic => "80_galda_st03",
    },
    502 => { # コックローチ娘
      :dead_word => ["\\n<Cockroach Girl>This already sucks...", "cockroacha_fc1", 2],
      :orgasm_word => ["\\n<Cockroach Girl>It's frustrating, but this feels so good...", "cockroacha_fc1", 2],
      :predation_word => ["\\n<Cockroach Girl>You're really nuts enough to eat a cockraoch?", "cockroacha_fc1", 2],
      :incontinence_word => ["\\n<Cockroach Girl>Aaaaah, I'm peeing...", "cockroacha_fc1", 2],
      :premortal_graphic => "50_cockroacha_st03",
    },
    503 => { # スピードローチ
      :dead_word => ["\\n<Speed Roach>Sorry...", "cockroachb_fc1", 2],
      :orgasm_word => ["\\n<Speed Roach>Coming...", "cockroachb_fc1", 2],
      :predation_word => ["\\n<Speed Roach>Even though I'm not tasty...", "cockroachb_fc1", 2],
      :incontinence_word => ["\\n<Speed Roach>So dirty...", "cockroachb_fc1", 2],
      :premortal_graphic => "50_cockroachb_st03",
    },
    504 => { # クィーンローチ
      :dead_word => ["\\n<Queen Roach>Ghh, how disgraceful of me...", "queenroach_fc1", 2],
      :orgasm_word => ["\\n<Queen Roach>What am I feeling...", "queenroach_fc1", 2],
      :predation_word => ["\\n<Queen Roach>This...will destroy your stomach...", "queenroach_fc1", 2],
      :incontinence_word => ["\\n<Queen Roach>Aah, I'm leaking so much...", "queenroach_fc1", 2],
      :premortal_graphic => "80_queenroach_st03",
    },
    505 => { # エルベティエ分裂体
      :dead_word => ["\\n<Erubetie>I was just a clone anyways...", "erbetie_fc1", 0],
      :orgasm_word => ["\\n<Erubetie>I was just a clone anyways...", "erbetie_fc1", 0],
      :predation_word => ["\\n<Erubetie>I was just a clone anyways...", "erbetie_fc1", 0],
      :incontinence_word => ["\\n<Erubetie>My fluids are leaking...", "erbetie_fc1", 0],
      :premortal_graphic => "80_erbetie_st01",
    },
    506 => { # エルベティエ
      :dead_word => ["\\n<Erubetie>I lost...?", "erbetie_fc1", 0],
      :orgasm_word => ["\\n<Erubetie>How could I come...", "erbetie_fc1", 0],
      :predation_word => ["\\n<Erubetie>How could I be swallowed...", "erbetie_fc1", 0],
      :incontinence_word => ["\\n<Erubetie>My fluids are leaking...", "erbetie_fc1", 0],
      :premortal_graphic => "80_erbetie_st01",
    },
    507 => { # マジックポット
      :dead_word => ["\\n<Magic Pot>Bye-bye...", "magicpot_fc1", 2],
      :orgasm_word => ["\\n<Magic Pot>I'm coming...", "magicpot_fc1", 2],
      :predation_word => ["\\n<Magic Pot>I taste like elixirs, right...?", "magicpot_fc1", 2],
      :incontinence_word => ["\\n<Magic Pot>I leaked...", "magicpot_fc1", 2],
      :premortal_graphic => "80_magicpot_st03",
    },
    508 => { # 豆狸
      :dead_word => ["\\n<Junior Tanuki>I lost...", "mametanuki_fc1", 2],
      :orgasm_word => ["\\n<Junior Tanuki>It feels good...", "mametanuki_fc1", 2],
      :predation_word => ["\\n<Junior Tanuki>Do I really look so tasty...?", "mametanuki_fc1", 2],
      :incontinence_word => ["\\n<Junior Tanuki>Aaahh, this is embarrassing...", "mametanuki_fc1", 2],
      :premortal_graphic => "50_mametanuki_st03",
    },
    509 => { # 上狸
      :dead_word => ["\\n<High Tanuki>I've been beaten!", "zyoutanuki_fc1", 2],
      :orgasm_word => ["\\n<High Tanuki>I came...", "zyoutanuki_fc1", 2],
      :predation_word => ["\\n<High Tanuki>Please don't eat meeee!", "zyoutanuki_fc1", 2],
      :incontinence_word => ["\\n<High Tanuki>Don't look! Please don't look...", "zyoutanuki_fc1", 2],
      :premortal_graphic => "50_zyoutanuki_st03",
    },
    510 => { # 忍狸
      :dead_word => ["\\n<Shinobitanuki>You'll regret this!", "shinobitanuki_fc1", 2],
      :orgasm_word => ["\\n<Shinobitanuki>Hauu, it feels so good...", "shinobitanuki_fc1", 2],
      :predation_word => ["\\n<Shinobitanuki>I won't taste good...", "shinobitanuki_fc1", 2],
      :incontinence_word => ["\\n<Shinobitanuki>I peed myself...\nI'm sorry...", "shinobitanuki_fc1", 2],
      :premortal_graphic => "50_shinobitanuki_st03",
    },
    511 => { # 化け狸
      :dead_word => ["\\n<Bakedanuki>I need to go rest...", "baketanuki_fc1", 2],
      :orgasm_word => ["\\n<Bakedanuki>Ahh, this feels good...", "baketanuki_fc1", 2],
      :predation_word => ["\\n<Bakedanuki>Don't eat me... Aaah...", "baketanuki_fc1", 2],
      :incontinence_word => ["\\n<Bakedanuki>Aah, please don't look...", "baketanuki_fc1", 2],
      :premortal_graphic => "50_baketanuki_st03",
    },
    512 => { # 隠神刑部狸
      :dead_word => ["\\n<Inugami Gyobu-danuki>Harahoreeee... *thud*", "inugami_fc1", 2],
      :orgasm_word => ["\\n<Inugami Gyobu-danuki>Ahaa, that felt great...", "inugami_fc1", 1],
      :predation_word => ["\\n<Inugami Gyobu-danuki>Even though my flesh will taste just like sake...", "inugami_fc1", 2],
      :incontinence_word => ["\\n<Inugami Gyobu-danuki>Ahaa... I've gotten piss-drunk...", "inugami_fc1", 1],
      :premortal_graphic => "80_inugami_st03",
    },
    513 => { # 黒狸
      :dead_word => ["\\n<Black Tanuki>Why can't I win...?!", "kurodanuki_fc1", 2],
      :orgasm_word => ["\\n<Black Tanuki>It feels so good...I'm coming.", "kurodanuki_fc1", 2],
      :predation_word => ["\\n<Black Tanuki>I'll make your stomach hurt...", "kurodanuki_fc1", 2],
      :incontinence_word => ["\\n<Black Tanuki>Don't look...don't look at me like this...!", "kurodanuki_fc1", 2],
      :premortal_graphic => "80_kurodanuki_st03",
    },
    514 => { # ヒミコ
      :dead_word => ["\\n<Himiko>Such humiliation... I won't forget it!", "tukumokomati_fc1", 2],
      :orgasm_word => ["\\n<Himiko>I have been defeated with pleasure...?", "tukumokomati_fc1", 2],
      :predation_word => ["\\n<Himiko>Get a good taste of this quality meat...", "tukumokomati_fc1", 2],
      :incontinence_word => ["\\n<Himiko>C-curse you... I won't forgive this...", "tukumokomati_fc1", 2],
      :premortal_graphic => "80_tukumokomati_st03",
    },
    515 => { # くのいちエルフ
      :dead_word => ["\\n<Kunoichi Elf>I guess I needed more training...", "kunoitielf2_fc1", 2],
      :orgasm_word => ["\\n<Kunoichi Elf>My training was inadequate if I'm coming like this...", "kunoitielf2_fc1", 2],
      :predation_word => ["\\n<Kunoichi Elf>S-stop... Aaah!", "kunoitielf2_fc1", 2],
      :incontinence_word => ["\\n<Kunoichi Elf>I'm a kunoichi, and yet I was forced to leak...", "kunoitielf2_fc1", 2],
      :premortal_graphic => "80_kunoitielf2_st03",
    },
    516 => { # くのいちエルフ
      :dead_word => ["\\n<Kunoichi Elf>I-I'll remember this...", "kunoitielf2_fc2", 2],
      :orgasm_word => ["\\n<Kunoichi Elf>This is so disgraceful...", "kunoitielf2_fc2", 2],
      :predation_word => ["\\n<Kunoichi Elf>I didn't train myself just to become food...", "kunoitielf2_fc2", 2],
      :incontinence_word => ["\\n<Kunoichi Elf>This would disqualify me from being a kunoichi...", "kunoitielf2_fc2", 2],
      :premortal_graphic => "80_kunoitielf2_st13",
    },
    517 => { # くのいちエルフ
      :dead_word => ["\\n<Kunoichi Elf>I can't fight this one anymore...", "kunoitielf2_fc3", 2],
      :orgasm_word => ["\\n<Kunoichi Elf>I can't believe you've made a kunoichi come instead...", "kunoitielf2_fc3", 2],
      :predation_word => ["\\n<Kunoichi Elf>Wait a minute, I don't even taste good...!", "kunoitielf2_fc3", 2],
      :incontinence_word => ["\\n<Kunoichi Elf>K-keep this a secret...from everyone.", "kunoitielf2_fc3", 2],
      :premortal_graphic => "80_kunoitielf2_st23",
    },
    518 => { # くのいちサキュバス
      :dead_word => ["\\n<Kunoichi Succubus>I was caught off-guard...", "kuno_succubus_fc1", 2],
      :orgasm_word => ["\\n<Kunoichi Succubus>I can't believe you're making me come...", "kuno_succubus_fc1", 2],
      :predation_word => ["\\n<Kunoichi Succubus>I do look pretty tasty, don't I...?", "kuno_succubus_fc1", 2],
      :incontinence_word => ["\\n<Kunoichi Succubus>This is so embarrassing...", "kuno_succubus_fc1", 2],
      :premortal_graphic => "50_kuno_succubus_st03",
    },
    519 => { # くのいちハーピー
      :dead_word => ["\\n<Kunoichi Harpy>I couldn't avoid this...", "kuno_hapy_fc1", 2],
      :orgasm_word => ["\\n<Kunoichi Harpy>I'm a kunoichi, and yet I've been humiliated...", "kuno_hapy_fc1", 2],
      :predation_word => ["\\n<Kunoichi Harpy>I don't taste weird...do I?", "kuno_hapy_fc1", 2],
      :incontinence_word => ["\\n<Kunoichi Harpy>Ugh... Don't look at me...", "kuno_hapy_fc1", 2],
      :premortal_graphic => "50_kuno_hapy_st03",
    },
    520 => { # くのいちスキュラ
      :dead_word => ["\\n<Kunoichi Scylla>My abilities weren't enough...", "kuno_scylla_fc1", 2],
      :orgasm_word => ["\\n<Kunoichi Scylla>Th-that feels good...", "kuno_scylla_fc1", 2],
      :predation_word => ["\\n<Kunoichi Scylla>At least just eat the tentacles... Aaah!", "kuno_scylla_fc1", 2],
      :incontinence_word => ["\\n<Kunoichi Scylla>Ahh... I've wet myself...", "kuno_scylla_fc1", 2],
      :premortal_graphic => "50_kuno_scylla_st03",
    },
    521 => { # くのいちアラクネ
      :dead_word => ["\\n<Kunoichi Arachne>Kh, what a strong opponent...", "kuno_arachne_fc1", 2],
      :orgasm_word => ["\\n<Kunoichi Arachne>Such pleasure... Ahh...", "kuno_arachne_fc1", 2],
      :predation_word => ["\\n<Kunoichi Arachne>N-no... Don't eat me...", "kuno_arachne_fc1", 2],
      :incontinence_word => ["\\n<Kunoichi Arachne>This is...humiliating...", "kuno_arachne_fc1", 2],
      :premortal_graphic => "50_kuno_arachne_st03",
    },
    522 => { # エルフ姫
      :dead_word => ["\\n<Elf Princess>I-it hurts...", "elfhime_fc1", 2],
      :orgasm_word => ["\\n<Elf Princess>This feels so good... Ahhh...", "elfhime_fc1", 2],
      :predation_word => ["\\n<Elf Princess>N-no... Help me...", "elfhime_fc1", 2],
      :incontinence_word => ["\\n<Elf Princess>D-don't look...you mustn't...", "elfhime_fc1", 2],
      :premortal_graphic => "80_elfhime_st03",
    },
    523 => { # イザナミ
      :dead_word => ["\\n<Izanami>To think your skills have come this far along...", "izanami_fc1", 2],
      :orgasm_word => ["\\n<Izanami>Pleasure is also sweet...", "izanami_fc1", 2],
      :predation_word => ["\\n<Izanami>You would even eat death...?", "izanami_fc1", 2],
      :incontinence_word => ["\\n<Izanami>The river of death flows here...", "izanami_fc1", 2],
      :premortal_graphic => "80_izanami_st03",
    },
    524 => { # 鎧の狂戦士
      :dead_word => ["\\n<Armored Berserker>AN... GE... L...!", "heinrich_fc2", 0],
      :orgasm_word => ["\\n<Armored Berserker>AN... GE... L...!", "heinrich_fc2", 0],
      :predation_word => ["\\n<Armored Berserker>AN... GE... L...!", "heinrich_fc2", 0],
      :incontinence_word => ["\\n<Armored Berserker>AN... GE... L...!", "heinrich_fc2", 0],
      :premortal_graphic => "50_heinrich_st51",
    },
    525 => { # 八尾
      :dead_word => ["\\n<Yao>Curses, how could I...", "hatibi_fc1", 3],
      :orgasm_word => ["\\n<Yao>Kh, to make me feel this...", "hatibi_fc1", 3],
      :predation_word => ["\\n<Yao>You must be quite the gourmand to be eating me...", "hatibi_fc1", 3],
      :incontinence_word => ["\\n<Yao>D-don't look! Don't look at me!", "hatibi_fc1", 3],
      :premortal_graphic => "80_hatibi_st03",
    },
    526 => { # エルダーサキュバス
      :dead_word => ["\\n<Elder Succubus>I can't do this anymore...", "esuccubus_fc1", 2],
      :orgasm_word => ["\\n<Elder Succubus>This is disgraceful for a succubus...", "esuccubus_fc1", 2],
      :predation_word => ["\\n<Elder Succubus>Ahh, even though I don't taste very good...", "esuccubus_fc1", 2],
      :incontinence_word => ["\\n<Elder Succubus>Ufufu... This unpleasant feeling of release...", "esuccubus_fc1", 1],
      :premortal_graphic => "80_esuccubus_st03",
    },
    527 => { # グランセントール
      :dead_word => ["\\n<Grand Centaur>U-urgh... This is disgraceful...", "gran_centa_fc1", 2],
      :orgasm_word => ["\\n<Grand Centaur>I-I'm coming...", "gran_centa_fc1", 2],
      :predation_word => ["\\n<Grand Centaur>Am I to be horse sashimi?!", "gran_centa_fc1", 2],
      :incontinence_word => ["\\n<Grand Centaur>Oh no... ew........", "gran_centa_fc1", 2],
      :premortal_graphic => "50_gran_centa_st03",
    },
    528 => { # エイビス娘
      :dead_word => ["\\n<Aevis Girl>Gh, I'll remember this...!", "abis_fc1", 2],
      :orgasm_word => ["\\n<Aevis Girl>This kind of humiliation is unbearable...!", "abis_fc1", 2],
      :predation_word => ["\\n<Aevis Girl>Get a good taste of me, I'm delicious!", "abis_fc1", 2],
      :incontinence_word => ["\\n<Aevis Girl>Ahh, have I just leaked...?", "abis_fc1", 2],
      :premortal_graphic => "50_abis_st03",
    },
    529 => { # 陰陽五尾
      :dead_word => ["\\n<Five-Tailed Taoist>I can only go this far, how regrettable...", "onmyougobi_fc1", 2],
      :orgasm_word => ["\\n<Five-Tailed Taoist>For me to climax is... Hauu...", "onmyougobi_fc1", 2],
      :predation_word => ["\\n<Five-Tailed Taoist>Even if you eat me, you won't gain any power...", "onmyougobi_fc1", 2],
      :incontinence_word => ["\\n<Five-Tailed Taoist>Ahh, my hakama is soiled...", "onmyougobi_fc1", 2],
      :premortal_graphic => "50_onmyougobi_st03",
    },
    530 => { # 花魁六尾
      :dead_word => ["\\n<Six-Tailed Courtesan>I'll take a little break...", "oiranrokubi_fc1", 2],
      :orgasm_word => ["\\n<Six-Tailed Courtesan>This is humiliating for one such as I...", "oiranrokubi_fc1", 2],
      :predation_word => ["\\n<Six-Tailed Courtesan>You are quite the gourmand...", "oiranrokubi_fc1", 2],
      :incontinence_word => ["\\n<Six-Tailed Courtesan>I can't stand wetting myself like this...", "oiranrokubi_fc1", 2],
      :premortal_graphic => "50_oiranrokubi_st03",
    },
    531 => { # 黒華
      :dead_word => ["\\n<Black Dahlia>Guh, I can't do this...", "sanki0_fc1", 2],
      :orgasm_word => ["\\n<Black Dahlia>How could you make a succubus come... Ah, aaah...", "sanki0_fc1", 2],
      :predation_word => ["\\n<Black Dahlia>This isn't how I want to end up...!", "sanki0_fc1", 2],
      :incontinence_word => ["\\n<Black Dahlia>This is...the worst...", "sanki0_fc1", 2],
      :premortal_graphic => "80_sanki_st03",
    },
    532 => { # 黒蛇
      :dead_word => ["\\n<Black Mamba>I yield...", "sanki1_fc1", 2],
      :orgasm_word => ["\\n<Black Mamba>How could I give in to pleasure...!", "sanki1_fc1", 2],
      :predation_word => ["\\n<Black Mamba>For me to become prey...", "sanki1_fc1", 2],
      :incontinence_word => ["\\n<Black Mamba>Guh, don't look at my figure...", "sanki1_fc1", 2],
      :premortal_graphic => "80_sanki_st13",
    },
    533 => { # 黒薔薇
      :dead_word => ["\\n<Black Rose>I've been defeated...", "sanki2_fc1", 2],
      :orgasm_word => ["\\n<Black Rose>Ahh, that feels good...", "sanki2_fc1", 2],
      :predation_word => ["\\n<Black Rose>Guh, such a miserable end...", "sanki2_fc1", 2],
      :incontinence_word => ["\\n<Black Rose>It's embarrassing, but..it feels comfortable....", "sanki2_fc1", 2],
      :premortal_graphic => "80_sanki_st23",
    },
    534 => { # たまも
      :dead_word => ["\\n<Tamamo>Hrmm, I got careless...", "tamamo_fc1", 3],
      :orgasm_word => ["\\n<Tamamo>This isn't so bad...", "tamamo_fc1", 2],
      :predation_word => ["\\n<Tamamo>Savor me well...", "tamamo_fc1", 3],
      :incontinence_word => ["\\n<Tamamo>I've just wet myself...", "tamamo_fc1", 3],
      :premortal_graphic => "80_tamamo_st03",
    },
    535 => { # エルベティエ
      :dead_word => ["\\n<Erubetie>I lost...?", "erbetie_fc1", 0],
      :orgasm_word => ["\\n<Erubetie>How could I come...", "erbetie_fc1", 0],
      :predation_word => ["\\n<Erubetie>How could I be swallowed...", "erbetie_fc1", 0],
      :incontinence_word => ["\\n<Erubetie>My fluids are leaking...", "erbetie_fc1", 0],
      :premortal_graphic => "80_erbetie_st01",
    },
    536 => { # グランベリア
      :dead_word => ["\\n<Granberia>I've lost again...", "granberia_fc3", 2],
      :orgasm_word => ["\\n<Granberia>Yielding to... pleasure... A-ahh...", "granberia_fc3", 6],
      :predation_word => ["\\n<Granberia>The weak are nothing but food...", "granberia_fc3", 2],
      :incontinence_word => ["\\n<Granberia>Kuh... Don't look, don't look!", "granberia_fc3", 6],
      :premortal_graphic => "80_granberia_st63",
    },
    537 => { # ラファエラ
      :dead_word => ["\\n<Raphaela>As I expected from the Child of Judgement...", "rafaera_fc1", 2],
      :orgasm_word => ["\\n<Raphaela>As I expected from the Child of Judgement...", "rafaera_fc1", 2],
      :predation_word => ["\\n<Raphaela>As I expected from the Child of Judgement...", "rafaera_fc1", 2],
      :incontinence_word => ["\\n<Raphaela>Aah, I am peeing so much...", "rafaera_fc1", 4],
      :premortal_graphic => "80_rafaera_st13",
    },
    538 => { # シオン
      :dead_word => ["\\n<Zion>Heh, not bad...", "shion_fc1", 4],
      :orgasm_word => ["\\n<Zion>I'm coming...", "shion_fc1", 4],
      :predation_word => ["\\n<Zion>Stop...! Don't eat me...!!", "shion_fc1", 2],
      :incontinence_word => ["\\n<Zion>Shit...! I'll kill all of you...!", "shion_fc1", 2],
      :premortal_graphic => "80_shion_st03",
    },
    539 => { # グノーシス
      :dead_word => ["\\n<Gnosis>Indeed, a power that cannot be ignored...", "gnosis_fc1", 3],
      :orgasm_word => ["\\n<Gnosis>How could I be forced to this...", "gnosis_fc1", 3],
      :predation_word => ["\\n<Gnosis>Preying on me will be punished...", "gnosis_fc1", 3],
      :incontinence_word => ["\\n<Gnosis>For a seraph like me to... Such humiliation...", "gnosis_fc1", 3],
      :premortal_graphic => "80_gnosis_st03",
    },
    540 => { # エデン
      :dead_word => ["\\n<Eden>Forgive me, Ilias...", "eden_fc2", 5],
      :orgasm_word => ["\\n<Eden>How am I...feeling this kind of pleasure...", "eden_fc2", 5],
      :predation_word => ["\\n<Eden>There will be punishment...for such savagery...ahh...", "eden_fc2", 5],
      :incontinence_word => ["\\n<Eden>Ahh... D-don't look...\nPlease don't look...", "eden_fc2", 5],
      :premortal_graphic => "80_eden_st36",
    },
    541 => { # アリスフィーズ15世
      :dead_word => ["\\n<Alipheese the 15th>As I expected from the Destroyer of Worlds...", "alice15th_fc3", 1],
      :orgasm_word => ["\\n<Alipheese the 15th>Kh, to think this is how I meet my end...", "alice15th_fc3", 1],
      :predation_word => ["\\n<Alipheese the 15th>For me to become food...", "alice15th_fc3", 1],
      :incontinence_word => ["\\n<Alipheese the 15th>I don't want my daughter to see me like this...", "alice15th_fc3", 1],
      :premortal_graphic => "80_alice15th_st53",
    },
    542 => { # モリガン
      :dead_word => ["\\n<Morrigan>Damn it, this is it...", "morrigan_fc1", 2],
      :orgasm_word => ["\\n<Morrigan>How could I come...!\nArgh, Ahhh...", "morrigan_fc1", 2],
      :predation_word => ["\\n<Morrigan>Stop! Argh, I won't forget this...!", "morrigan_fc1", 2],
      :incontinence_word => ["\\n<Morrigan>Dammit, don't look at me...!\nDon't look, don't look...!", "morrigan_fc1", 2],
      :premortal_graphic => "80_morrigan_st03b",
    },
    543 => { # アスタロト
      :dead_word => ["\\n<Astaroth>It seems I've been careless...", "astaroth_fc1", 2],
      :orgasm_word => ["\\n<Astaroth>I cannot accept such humiliation... I'm a great succubus, this is...!", "astaroth_fc1", 2],
      :predation_word => ["\\n<Astaroth>To eat me... You'll regret this!", "astaroth_fc1", 2],
      :incontinence_word => ["\\n<Astaroth>Kuh, such humiliation... P-prepare yourself!", "astaroth_fc1", 2],
      :premortal_graphic => "80_astaroth_st03b",
    },
    544 => { # サバサソウル
      :dead_word => ["\\n<Sabasa's Soul>............", "sabasa_fc2", 0],
      :orgasm_word => ["\\n<Sabasa's Soul>............", "sabasa_fc2", 0],
      :predation_word => ["\\n<Sabasa's Soul>............", "sabasa_fc2", 0],
      :incontinence_word => ["\\n<Sabasa's Soul>............", "sabasa_fc2", 0],
      :premortal_graphic => "80_sabasa_st11",
    },
    545 => { # アモルドール
      :dead_word => ["\\n<Amor Doll>Don't break the dolls...", "amoldoll_fc1", 2],
      :orgasm_word => ["\\n<Amor Doll>This is quite embarrassing...", "amoldoll_fc1", 2],
      :predation_word => ["\\n<Amor Doll>Don't eat the dolls...", "amoldoll_fc1", 2],
      :incontinence_word => ["\\n<Amor Doll>I need to make sure not to stain the dolls...", "amoldoll_fc1", 2],
      :premortal_graphic => "50_amoldoll_st03",
    },
    546 => { # アモルラーム
      :dead_word => ["\\n<Amor Rahm>............", "amoldoll_fc2", 2],
      :orgasm_word => ["\\n<Amor Rahm>............", "amoldoll_fc2", 2],
      :predation_word => ["\\n<Amor Rahm>............", "amoldoll_fc2", 2],
      :incontinence_word => ["\\n<Amor Rahm>............", "amoldoll_fc2", 2],
      :premortal_graphic => "50_amoldoll_st13",
    },
    547 => { # アモルリーム
      :dead_word => ["\\n<Amor Rihm>............", "amoldoll_fc2", 5],
      :orgasm_word => ["\\n<Amor Rihm>............", "amoldoll_fc2", 5],
      :predation_word => ["\\n<Amor Rihm>............", "amoldoll_fc2", 5],
      :incontinence_word => ["\\n<Amor Rihm>............", "amoldoll_fc2", 5],
      :premortal_graphic => "50_amoldoll_st23",
    },
    548 => { # ペルセポネー
      :dead_word => ["\\n<Persephone>Death for me...", "persephone_fc1", 2],
      :orgasm_word => ["\\n<Persephone>Sweet pleasure...", "persephone_fc1", 2],
      :predation_word => ["\\n<Persephone>Will I return to the cycle of reincarnation...?", "persephone_fc1", 2],
      :incontinence_word => ["\\n<Persephone>Ahh... My digestive juices are leaking...", "persephone_fc1", 2],
      :premortal_graphic => "50_persephone_st03",
    },
    549 => { # トリロバイト
      :dead_word => ["\\n<Trilobite>We can be revived as many times as we want...", "trilobite_fc1", 2],
      :orgasm_word => ["\\n<Trilobite>It feels so good... Ahh, so refreshing...", "trilobite_fc1", 2],
      :predation_word => ["\\n<Trilobite>We're the ones being consumed...?", "trilobite_fc1", 2],
      :incontinence_word => ["\\n<Trilobite>Our fluids are leaking out...", "trilobite_fc1", 2],
      :premortal_graphic => "80_trilobite_st13",
    },
    550 => { # ヘブンズゲート
      :dead_word => ["\\n<Heaven's Gate>To think this gate can be broken...", "heavensgate_fc1", 2],
      :orgasm_word => ["\\n<Heaven's Gate>I'm drowning in pleasure...", "heavensgate_fc1", 2],
      :predation_word => ["\\n<Heaven's Gate>How bold of you to eat the entire gate...", "heavensgate_fc1", 2],
      :incontinence_word => ["\\n<Heaven's Gate>Drops of heaven are coming out of this gate...", "heavensgate_fc1", 2],
      :premortal_graphic => "80_heavensgate_st03",
    },
    551 => { # ネフィリムウェポン
      :dead_word => ["\\n<Nephilim Weapon>Is this the moment of my destruction...?", "nephilim_fc1", 2],
      :orgasm_word => ["\\n<Nephilim Weapon>Is this the moment of my end...?", "nephilim_fc1", 2],
      :predation_word => ["\\n<Nephilim Weapon>What will you accomplish by devouring me...?", "nephilim_fc1", 2],
      :incontinence_word => ["\\n<Nephilim Weapon>I'm leaking urine...", "nephilim_fc1", 2],
      :premortal_graphic => "80_nephilim_st03",
    },
    552 => { # ギガントウェポン
      :dead_word => ["\\n<Giganto Weapon>Ceasing function...", "gigantweapon_fc1", 1],
      :orgasm_word => ["\\n<Giganto Weapon>Pleasure overload...", "gigantweapon_fc1", 1],
      :predation_word => ["\\n<Giganto Weapon>Being eaten... Going into sleep mode...", "gigantweapon_fc1", 1],
      :incontinence_word => ["\\n<Giganto Weapon>Leaking urine...", "gigantweapon_fc1", 1],
      :premortal_graphic => "80_gigantweapon_st02",
    },
    554 => { # マリエル
      :dead_word => ["\\n<Mariel>It hurts... I can't fight any more...", "mariel_fc1", 2],
      :orgasm_word => ["\\n<Mariel>I-it feels good... More...", "mariel_fc1", 2],
      :predation_word => ["\\n<Mariel>Do I taste like sugar...?", "mariel_fc1", 2],
      :incontinence_word => ["\\n<Mariel>I, I peed myself...\nI'm sorry, I'm sorry...", "mariel_fc1", 2],
      :premortal_graphic => "50_mariel_st03",
    },
    555 => { # 淫乳天女
      :dead_word => ["\\n<Busty Tennyo>I'm down already...", "tennyo_fc1", 2],
      :orgasm_word => ["\\n<Busty Tennyo>It feels so nice...", "tennyo_fc1", 2],
      :predation_word => ["\\n<Busty Tennyo>I'm not tasty...", "tennyo_fc1", 2],
      :incontinence_word => ["\\n<Busty Tennyo>I'm peeing so much...", "tennyo_fc1", 2],
      :premortal_graphic => "50_tennyo_st03",
    },
    556 => { # キメラテンタクル
      :dead_word => ["\\n<Chimera Tentacle>Don't tear off my tentacles...", "c_tentacle_fc1", 2],
      :orgasm_word => ["\\n<Chimera Tentacle>That felt really good...", "c_tentacle_fc1", 2],
      :predation_word => ["\\n<Chimera Tentacle>Just be satisfied with my tentacles...", "c_tentacle_fc1", 2],
      :incontinence_word => ["\\n<Chimera Tentacle>To think I would pee in front of everyone...", "c_tentacle_fc1", 2],
      :premortal_graphic => "50_c_tentacle_st03",
    },
    557 => { # グランディーネ
      :dead_word => ["\\n<Grandine>This is it for me...", "grandine_fc1", 2],
      :orgasm_word => ["\\n<Grandine>I'm melting away...", "grandine_fc1", 2],
      :predation_word => ["\\n<Grandine>You'll be melted from the inside...", "grandine_fc1", 2],
      :incontinence_word => ["\\n<Grandine>My conents are leaking out...", "grandine_fc1", 2],
      :premortal_graphic => "80_grandine_st03",
    },
    558 => { # アリエル
      :dead_word => ["\\n<Ariel>How regrettable... Forgive me for this...", "ariel_fc1", 3],
      :orgasm_word => ["\\n<Ariel>Ahh, this is the first time I've felt such pleasure...", "ariel_fc1", 3],
      :predation_word => ["\\n<Ariel>You shall be damned for eating an angel...", "ariel_fc1", 3],
      :incontinence_word => ["\\n<Ariel>I-I'm leaking...\nHow shameful of me...", "ariel_fc1", 3],
      :premortal_graphic => "80_ariel_st03",
    },
    559 => { # ラナエル
      :dead_word => ["\\n<Ranael>How could I lose...!", "ranael_fc1", 2],
      :orgasm_word => ["\\n<Ranael>How could I succumb to pleasure...!", "ranael_fc1", 2],
      :predation_word => ["\\n<Ranael>How dare you eat me...!\nYou won't be forgiven...!", "ranael_fc1", 2],
      :incontinence_word => ["\\n<Ranael>Such humiliation...!\nI'll never forgive this...!", "ranael_fc1", 2],
      :premortal_graphic => "80_ranael_st33",
    },
    560 => { # リファイール
      :dead_word => ["\\n<Leafael>I shall rest for a bit...", "rifaiel_fc1", 2],
      :orgasm_word => ["\\n<Leafael>I'm being led towards ultimate bliss...", "rifaiel_fc1", 2],
      :predation_word => ["\\n<Leafael>Lotus flowers are delicious...", "rifaiel_fc1", 2],
      :incontinence_word => ["\\n<Leafael>Aah, my holy drops are spilling out...", "rifaiel_fc1", 2],
      :premortal_graphic => "80_rifaiel_st13",
    },
    561 => { # ラプンツェル
      :dead_word => ["\\n<Rapunzel>This isn't fun any more...", "rapun_fc1", 2],
      :orgasm_word => ["\\n<Rapunzel>I'm enjoying this a lot...", "rapun_fc1", 1],
      :predation_word => ["\\n<Rapunzel>Am I delicious...? I'm delicious aren't I...?", "rapun_fc1", 1],
      :incontinence_word => ["\\n<Rapunzel>This feeling of liberation... it's irresistable...", "rapun_fc1", 1],
      :premortal_graphic => "80_rapun_st03",
    },
    562 => { # ナガエル
      :dead_word => ["\\n<Nagael>I must not be defeated...", "nagael_fc1", 2],
      :orgasm_word => ["\\n<Nagael>Defeated by pleasure...\nGoddess Ilias, forgive me...", "nagael_fc1", 2],
      :predation_word => ["\\n<Nagael>E-eating me...?!\nYou can't be... Ahhh!", "nagael_fc1", 2],
      :incontinence_word => ["\\n<Nagael>How could I...\nAhh, snakes, don't lick it... Nooo...", "nagael_fc1", 2],
      :premortal_graphic => "80_nagael_st03",
    },
    563 => { # キメラメデュラハン
      :dead_word => ["\\n<Chimera Medullahan>It hurts... I can't do this any more...", "c_medulahan_fc1", 2],
      :orgasm_word => ["\\n<Chimera Medullahan>I can't stand this kind of pleasure...", "c_medulahan_fc1", 2],
      :predation_word => ["\\n<Chimera Medullahan>For you to be eating me... Do you enjoy snakes?", "c_medulahan_fc1", 2],
      :incontinence_word => ["\\n<Chimera Medullahan>Such humiliation... Ah, it's leaking...", "c_medulahan_fc1", 2],
      :premortal_graphic => "50_c_medulahan_st03",
    },
    564 => { # ノーマレン
      :dead_word => ["\\n<Gnomaren>............", "gnomaren_fc1", 3],
      :orgasm_word => ["\\n<Gnomaren>............", "gnomaren_fc1", 2],
      :predation_word => ["\\n<Gnomaren>............", "gnomaren_fc1", 3],
      :incontinence_word => ["\\n<Gnomaren>............", "gnomaren_fc1", 2],
      :premortal_graphic => "80_gnomaren_st03",
    },
    565 => { # ラタエル
      :dead_word => ["\\n<Latael>To think I've been defeated...", "ratael_fc1", 2],
      :orgasm_word => ["\\n<Latael>I can't believe I'm being forced to come...", "ratael_fc1", 2],
      :predation_word => ["\\n<Latael>I'm highly nutritious...", "ratael_fc1", 2],
      :incontinence_word => ["\\n<Latael>My sap is leaking...", "ratael_fc1", 2],
      :premortal_graphic => "50_ratael_st03",
    },
    566 => { # リファイール
      :dead_word => ["\\n<Leafael>I shall rest for a bit...", "rifaiel_fc1", 2],
      :orgasm_word => ["\\n<Leafael>I'm being led towards ultimate bliss...", "rifaiel_fc1", 2],
      :predation_word => ["\\n<Leafael>Lotus flowers are delicious...", "rifaiel_fc1", 2],
      :incontinence_word => ["\\n<Leafael>Aah, my holy drops are spilling out...", "rifaiel_fc1", 2],
      :premortal_graphic => "50_rifaiel_st13",
    },
    567 => { # ガブリエラ
      :dead_word => ["\\n<Gabriela>Fufu, you're trying so hard...", "gaburiera_fc1", 0],
      :orgasm_word => ["\\n<Gabriela>Fufu, you're trying so hard...", "gaburiera_fc1", 0],
      :predation_word => ["\\n<Gabriela>Fufu, you're trying so hard...", "gaburiera_fc1", 0],
      :incontinence_word => ["\\n<Gabriela>This is...urgh...such...", "gaburiera_fc1", 2],
      :premortal_graphic => "80_gaburiera_st13",
    },
    568 => { # ギリエル
      :dead_word => ["\\n<Giriel>Gh, damn you...!", "giriel_fc1", 2],
      :orgasm_word => ["\\n<Giriel>I've been forced to come...", "giriel_fc1", 2],
      :predation_word => ["\\n<Giriel>Don't eat me, damnit...", "giriel_fc1", 2],
      :incontinence_word => ["\\n<Giriel>I peed myself... Don't look at me...", "giriel_fc1", 2],
      :premortal_graphic => "50_giriel_st03",
    },
    569 => { # トルーパーロイド
      :dead_word => ["\\n<Trooperoid>It hurts, I can't take any more of this!", "trooperloid_fc1", 4],
      :orgasm_word => ["\\n<Trooperoid>This feels kinda good...", "trooperloid_fc1", 3],
      :predation_word => ["\\n<Trooperoid>Don't eat me!", "trooperloid_fc1", 4],
      :incontinence_word => ["\\n<Trooperoid>It's not what you think! It's just an oil leak!", "trooperloid_fc1", 4],
      :premortal_graphic => "50_trooperloid_st05",
    },
    570 => { # サビリエル
      :dead_word => ["\\n<Sabiriel>Incredible...!", "sabiriel_fc1", 7],
      :orgasm_word => ["\\n<Sabiriel>Such humiliation...!", "sabiriel_fc1", 7],
      :predation_word => ["\\n<Sabiriel>D-don't eat me--", "sabiriel_fc1", 7],
      :incontinence_word => ["\\n<Sabiriel>Aaah... Don't look at me...", "sabiriel_fc1", 7],
      :premortal_graphic => "80_sabiriel_st11",
    },
    571 => { # サビリエル
      :dead_word => ["\\n<Sabiriel>Incredible...!", "sabiriel_fc1", 2],
      :orgasm_word => ["\\n<Sabiriel>Such humiliation...!", "sabiriel_fc1", 2],
      :predation_word => ["\\n<Sabiriel>D-don't eat me--", "sabiriel_fc1", 2],
      :incontinence_word => ["\\n<Sabiriel>Aaah... Don't look at me...", "sabiriel_fc1", 2],
      :premortal_graphic => "50_sabiriel_st03",
    },
    572 => { # フェルナンデス
      :dead_word => ["\\n<Fernandez>My body won't move...", "cirquec_fc1", 2],
      :orgasm_word => ["\\n<Fernandez>My body... feels hot...", "cirquec_fc1", 2],
      :predation_word => ["\\n<Fernandez>Am I becoming prey...?", "cirquec_fc1", 2],
      :incontinence_word => ["\\n<Fernandez>My urine... is flowing out...", "cirquec_fc1", 2],
      :premortal_graphic => "80_cirquec_st03",
    },
    573 => { # ウリエラ
      :dead_word => ["\\n<Uriela>Haha, you're pretty good!!", "uriera_fc1", 1],
      :orgasm_word => ["\\n<Uriela>Haha, you're pretty good!!", "uriera_fc1", 1],
      :predation_word => ["\\n<Uriela>Haha, you're pretty good!!", "uriera_fc1", 1],
      :incontinence_word => ["\\n<Uriela>Don't look, don't look...!", "uriera_fc1", 4],
      :premortal_graphic => "80_uriera_st13",
    },
    574 => { # ムズキエル
      :dead_word => ["\\n<Muzukiel>Let me rest for a bit...", "muzukiel_fc1", 2],
      :orgasm_word => ["\\n<Muzukiel>What a humiliation this is...", "muzukiel_fc1", 2],
      :predation_word => ["\\n<Muzukiel> Let me introduce you to more delicious insects...  Because... ahhh!", "muzukiel_fc1", 2],
      :incontinence_word => ["\\n<Muzukiel> is embarrassing...please don't look at it...", "muzukiel_fc1", 2],
      :premortal_graphic => "50_muzukiel_st03",
    },
    575 => { # シルキエル
      :dead_word => ["\\n<Silkiel> I hate violence...", "silkiel_fc1", 2],
      :orgasm_word => ["\\n<Silkiel> I'm going to cum...haaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "silkiel_fc1", 2],
      :predation_word => ["\\n<Silkiel> Stop it...nooooo! !", "silkiel_fc1", 2],
      :incontinence_word => ["\\n<Silkiel> sticky thread leaks...", "silkiel_fc1", 2],
      :premortal_graphic => "50_silkiel_st03",
    },
    576 => { # サリエラ
      :dead_word => ["\\n<Sariela> This is just a wasted effort...", "sariera_fc1", 2],
      :orgasm_word => ["\\n<Sariela> This is just a wasted effort...", "sariera_fc1", 2],
      :predation_word => ["\\n<Sariela> This is just a wasted effort...", "sariera_fc1", 2],
      :incontinence_word => ["\\n<Sariela> This humiliation... I can't stand it...", "sariera_fc1", 2],
      :premortal_graphic => "80_sariera_st13",
    },
    577 => { # ベリエル
      :dead_word => ["\\n<Berryelle> I'm tired of it...", "berryel_fc1", 2],
      :orgasm_word => ["\\n<Berryelle> It feels good...", "berryel_fc1", 2],
      :predation_word => ["\\n<Berryelle> Not just the fruit, but me as a whole...", "berryel_fc1", 2],
      :incontinence_word => ["\\n<Berryelle> The sap is spilling...", "berryel_fc1", 2],
      :premortal_graphic => "50_berryel_st03",
    },
    578 => { # キメラプラント
      :dead_word => ["\\n<Chimera Plant> I can't move...", "evilprant_fc1", 0],
      :orgasm_word => ["\\n<Chimera Plant> This is a pleasure...", "evilprant_fc1", 0],
      :predation_word => ["\\n<Chimera Plant> It's full of nutrients...", "evilprant_fc1", 0],
      :incontinence_word => ["\\n<Chimera Plant> solution is leaking...", "evilprant_fc1", 0],
      :premortal_graphic => "50_evilprant_st01",
    },
    579 => { # リヴァエル
      :dead_word => ["\\n<Revel> Let's go back to reincarnation too...", "revel_fc1", 0],
      :orgasm_word => ["\\n<Revel> Let's ascend to heaven...", "revel_fc1", 0],
      :predation_word => ["\\n<Revel> This is also a chain...", "revel_fc1", 0],
      :incontinence_word => ["\\n<Revel> leaks...drops of heaven...", "revel_fc1", 0],
      :premortal_graphic => "80_revel_st01",
    },
    580 => { # ギガマンドラ
      :dead_word => ["\\n<Gigamander> Ridiculous, to think it would go this far...", "gigamander_fc1", 2],
      :orgasm_word => ["\\n<Gigamander> The flames of pleasure are smoldering...", "gigamander_fc1", 2],
      :predation_word => ["\\n<Gigamander> Damn, it burns...!", "gigamander_fc1", 2],
      :incontinence_word => ["\\n<Gigamander> Ah, how humiliating...", "gigamander_fc1", 2],
      :premortal_graphic => "80_gigamander_st03",
    },
    581 => { # ハイヌウェレ
      :dead_word => ["\\n<Hainuwele> I can't take it anymore, I'm stopping...", "hainu_fc1", 2],
      :orgasm_word => ["\\n<Hainuwele> This... I shouldn't be feeling this...", "hainu_fc1", 2],
      :predation_word => ["\\n<Hainuwele> Don't eat me...! You're the worst...!", "hainu_fc1", 2],
      :incontinence_word => ["\\n<Hainuwele> This... such a miserable feeling...", "hainu_fc1", 2],
      :premortal_graphic => "80_hainu_st03",
    },
    582 => { # ドッペル
      :dead_word => ["\\n<Doppel> Is this... the end...?", "doppele_fc2", 0],
      :orgasm_word => ["\\n<Doppel> Ah, no, I can't...", "doppele_fc2", 0],
      :predation_word => ["\\n<Doppel>I'm going to be eaten...", "doppele_fc2", 0],
      :incontinence_word => ["\\n<Doppel>I'm also leaking...", "doppele_fc2", 0],
      :premortal_graphic => "50_doppeleb_st03",
    },
    583 => { # ルカ・リノア
      :dead_word => ["\\n<Luka Rinoa>You're quite skilled...", "doppele_fc1", 4],
      :orgasm_word => ["\\n<Luka Rinoa>To think I'd feel this...", "doppele_fc1", 4],
      :predation_word => ["\\n<Luka Rinoa>To become food, such humiliation...", "doppele_fc1", 4],
      :incontinence_word => ["\\n<Luka Rinoa>You're the worst...", "doppele_fc1", 4],
      :premortal_graphic => "50_doppele_st11",
    },
    584 => { # キメラタン
      :dead_word => ["\\n<Chimera Tongue>My tongue is tingling...", "c_tangh_fc1", 2],
      :orgasm_word => ["\\n<Chimera Tongue>Ah, it feels good...", "c_tangh_fc1", 2],
      :predation_word => ["\\n<Chimera Tongue>Tongue salt...", "c_tangh_fc1", 2],
      :incontinence_word => ["\\n<Chimera Tongue>This is drool...", "c_tangh_fc1", 2],
      :premortal_graphic => "50_c_tangh_st03",
    },
    585 => { # キメラバグ
      :dead_word => ["\\n<Chimera Bug>Ouch, it hurts...", "c_bug_fc1", 2],
      :orgasm_word => ["\\n<Chimera Bug>It's embarrassing, but a little happy...", "c_bug_fc1", 1],
      :predation_word => ["\\n<Chimera Bug>There's no way it's delicious...", "c_bug_fc1", 2],
      :incontinence_word => ["\\n<Chimera Bug>Stop! Don't look...!", "c_bug_fc1", 2],
      :premortal_graphic => "50_c_bug_st03",
    },
    586 => { # キメラスラッグ
      :dead_word => ["\\n<Chimera Slug>You're doing something terrible...", "c_slag_fc1", 0],
      :orgasm_word => ["\\n<Chimera Slug>I'm melting...", "c_slag_fc1", 0],
      :predation_word => ["\\n<Chimera Slug>You have a peculiar taste...", "c_slag_fc1", 0],
      :incontinence_word => ["\\n<Chimera Slug>I let it out...", "c_slag_fc1", 0],
      :premortal_graphic => "50_c_slag_st01",
    },
    587 => { # キメラドリアード
      :dead_word => ["\\n<Chimera Dryad>Ah... ugh...", "c_dryad_fc1", 0],
      :orgasm_word => ["\\n<Chimera Dryad>Ha... ugh...", "c_dryad_fc1", 0],
      :predation_word => ["\\n<Chimera Dryad>Eat... me...", "c_dryad_fc1", 0],
      :incontinence_word => ["\\n<Chimera Dryad>Ha... auu...", "c_dryad_fc1", 0],
      :premortal_graphic => "50_c_dryad_st01",
    },
    588 => { # 鎧の狂戦士
      :dead_word => ["\\n<Armored Berserker>An... ge... l...!", "heinrich_fc2", 0],
      :orgasm_word => ["\\n<Armored Berserker>An... ge... l...!", "heinrich_fc2", 0],
      :predation_word => ["\\n<Armored Berserker>An... ge... l...!", "heinrich_fc2", 0],
      :incontinence_word => ["\\n<Armored Berserker>An... ge... l...!", "heinrich_fc2", 0],
      :premortal_graphic => "50_heinrich_st51",
    },
    589 => { # カトブレパス
      :dead_word => ["\\n<Catoblepas>For me to fall...", "catoblepas_fc1", 0],
      :orgasm_word => ["\\n<Catoblepas>I'll indulge in pleasure...", "catoblepas_fc1", 0],
      :predation_word => ["\\n<Catoblepas>Even if I turn to stone, I don't care...", "catoblepas_fc1", 0],
      :incontinence_word => ["\\n<Catoblepas>For me to wet myself...", "catoblepas_fc1", 0],
      :premortal_graphic => "50_catoblepas_st01",
    },
    590 => { # テュポーン
      :dead_word => ["\\n<Typhon>Why am I suffering like this...", "typhon_fc1", 0],
      :orgasm_word => ["\\n<Typhon>It feels good, doesn't it...", "typhon_fc1", 0],
      :predation_word => ["\\n<Typhon>Stop... Kyaaa!", "typhon_fc1", 0],
      :incontinence_word => ["\\n<Typhon>  It's leaking... It's leaking...", "typhon_fc1", 0],
      :premortal_graphic => "50_typhon_st01",
    },
    591 => { # アンフィスバエナ
      :dead_word => ["\\n<Amphisbaena>  I can't move my body anymore...", "amphis_fc1", 2],
      :orgasm_word => ["\\n<Amphisbaena>  I can't resist this pleasure...", "amphis_fc1", 2],
      :predation_word => ["\\n<Amphisbaena> , stop it... ah!", "amphis_fc1", 2],
      :incontinence_word => ["\\n<Amphisbaena> , it's humiliating...", "amphis_fc1", 2],
      :premortal_graphic => "80_amphis_st03",
    },
    592 => { # ラプラス
      :dead_word => ["\\n<Laplace>  Battle, pause...", "laplace_fc1", 3],
      :orgasm_word => ["\\n<Laplace>  The pleasure exceeded the allowable amount...", "laplace_fc1", 3],
      :predation_word => ["\\n<Laplace>  I'll give you this emergency ration...ahh.", "laplace_fc1", 3],
      :incontinence_word => ["\\n<Laplace>  Urinary function malfunctions...ahh.", "laplace_fc1", 3],
      :premortal_graphic => "80_laplace_st03",
    },
    593 => { # トラップテミス
      :dead_word => ["\\n<Themis Trap>................", "traptemis_fc1", 0],
      :orgasm_word => ["\\n<Themis Trap>................", "traptemis_fc1", 0],
      :predation_word => ["\\n<Themis Trap>................", "traptemis_fc1", 0],
      :incontinence_word => ["\\n<Themis Trap>................", "traptemis_fc1", 0],
      :premortal_graphic => "50_traptemis_st01",
    },
    594 => { # ツクヨミ
      :dead_word => ["\\n<Tsukuyomi> I can't go any further...", "tukuyomi_fc1", 2],
      :orgasm_word => ["\\n<Tsukuyomi> To succumb to pleasure... isn't so bad...", "tukuyomi_fc1", 2],
      :predation_word => ["\\n<Tsukuyomi> To have this body devoured...", "tukuyomi_fc1", 2],
      :incontinence_word => ["\\n<Tsukuyomi> S-so embarrassing... like this...", "tukuyomi_fc1", 2],
      :premortal_graphic => "80_tukuyomi_st03",
    },
    595 => { # フーリエル
      :dead_word => ["\\n<Furiel> For me... this is regrettable...", "furiel_fc1", 2],
      :orgasm_word => ["\\n<Furiel> For me... to reach my end...", "furiel_fc1", 2],
      :predation_word => ["\\n<Furiel> Even if you eat me, you won't gain any knowledge...", "furiel_fc1", 2],
      :incontinence_word => ["\\n<Furiel> It's been hundreds of years since I last leaked...", "furiel_fc1", 2],
      :premortal_graphic => "50_furiel_st03",
    },
    596 => { # ドレインプラント
      :dead_word => ["\\n<Drain Plant> Violence is not good...", "drainplant_fc1", 2],
      :orgasm_word => ["\\n<Drain Plant> Ah, I'm feeling it...", "drainplant_fc1", 2],
      :predation_word => ["\\n<Drain Plant> To think you would even consume the stored energy...", "drainplant_fc1", 2],
      :incontinence_word => ["\\n<Drain Plant> The energy is leaking out...", "drainplant_fc1", 2],
      :premortal_graphic => "50_drainplant_st03",
    },
    597 => { # ドレインロイド
      :dead_word => ["\\n<Drainroid> Shutting down...", "drainloid_fc1", 2],
      :orgasm_word => ["\\n<Drainroid> Shutting down due to climax...", "drainloid_fc1", 2],
      :predation_word => ["\\n<Drainroid> I am not meant for consumption...", "drainloid_fc1", 2],
      :incontinence_word => ["\\n<Drainroid> Fluid is leaking out... I feel embarrassed...", "drainloid_fc1", 2],
      :premortal_graphic => "80_drainloid_st03",
    },
    598 => { # ハンディロイド
      :dead_word => ["\\n<Handyroid>Please do not break me...", "handyloid_fc1", 3],
      :orgasm_word => ["\\n<Handyroid>To think I would succumb to pleasure...", "handyloid_fc1", 2],
      :predation_word => ["\\n<Handyroid>I am not food...", "handyloid_fc1", 3],
      :incontinence_word => ["\\n<Handyroid>Is the leaking fluid milk...", "handyloid_fc1", 2],
      :premortal_graphic => "50_handyloid_st03",
    },
    599 => { # メタトローネ
      :dead_word => ["\\n<Metatronne>It's such a hassle...", "metatorone_fc1", 4],
      :orgasm_word => ["\\n<Metatronne>It's such a hassle...", "metatorone_fc1", 4],
      :predation_word => ["\\n<Metatronne>It's such a hassle...", "metatorone_fc1", 4],
      :incontinence_word => ["\\n<Metatronne>It's such a hassle...", "metatorone_fc1", 4],
      :premortal_graphic => "80_metatorone_st13",
    },
    600 => { # サンダルフォーネ
      :dead_word => ["\\n<Sandalphone>You're persistent... Surprisingly...", "sandalforne_fc1", 0],
      :orgasm_word => ["\\n<Sandalphone>You're persistent... Surprisingly...", "sandalforne_fc1", 0],
      :predation_word => ["\\n<Sandalphone>You're persistent... Surprisingly...", "sandalforne_fc1", 0],
      :incontinence_word => ["\\n<Sandalphone>I... peed myself...", "sandalforne_fc1", 1],
      :premortal_graphic => "80_sandalforne_st13",
    },
    601 => { # メイドエンジェル
      :dead_word => ["\\n<Angel Maid>Excuse me, I'm sorry...", "maid_angel_fc1", 2],
      :orgasm_word => ["\\n<Angel Maid>To lose myself to pleasure...", "maid_angel_fc1", 2],
      :predation_word => ["\\n<Angel Maid>This is not right, a maid is not food...", "maid_angel_fc1", 2],
      :incontinence_word => ["\\n<Angel Maid>For someone like me to act so childish...", "maid_angel_fc1", 2],
      :premortal_graphic => "50_maid_angel_st03",
    },
    602 => { # コックエンジェル
      :dead_word => ["\\n<Angel Cook>Kyu...", "cooc_angel_fc1", 2],
      :orgasm_word => ["\\n<Angel Cook>I'm coming...", "cooc_angel_fc1", 2],
      :predation_word => ["\\n<Angel Cook>I'll cook for you— Gyuum.", "cooc_angel_fc1", 2],
      :incontinence_word => ["\\n<Angel Cook>If this gets found out, I won't be able to stay in the kitchen...", "cooc_angel_fc1", 2],
      :premortal_graphic => "50_cooc_angel_st03",
    },
    603 => { # ワイティエル
      :dead_word => ["\\n<Whiteyel>It's sad to lose...", "whiteyel_fc1", 2],
      :orgasm_word => ["\\n<Whiteyel>It's humiliating to climax...", "whiteyel_fc1", 2],
      :predation_word => ["\\n<Whiteyel>Please don't use your teeth...", "whiteyel_fc1", 2],
      :incontinence_word => ["\\n<Whiteyel>Ah, it's embarrassing...", "whiteyel_fc1", 2],
      :premortal_graphic => "50_whiteyel_st03",
    },
    604 => { # ラミアンロイド
      :dead_word => ["\\n<Lamiaroid>That hurts...", "lamianloid_fc1", 2],
      :orgasm_word => ["\\n<Lamiaroid>It feels good...", "lamianloid_fc1", 2],
      :predation_word => ["\\n<Lamiaroid>Don't eat me~!", "lamianloid_fc1", 2],
      :incontinence_word => ["\\n<Lamiaroid>Ah, I'm going to leak...", "lamianloid_fc1", 2],
      :premortal_graphic => "50_lamianloid_st03",
    },
    605 => { # シオン
      :dead_word => ["\\n<Zion>Gah, am I going to lose...!", "shion_fc3", 2],
      :orgasm_word => ["\\n<Zion>Am I really going to be made to come...", "shion_fc3", 2],
      :predation_word => ["\\n<Zion>Stop it...! Don't eat me...!!", "shion_fc3", 2],
      :incontinence_word => ["\\n<Zion>Damn it...! I'll kill everyone...!", "shion_fc3", 2],
      :premortal_graphic => "80_shion_st33",
    },
    606 => { # シオン
      :dead_word => ["\\n<Zion>Ugh, any more than this...", "shion_fc5", 2],
      :orgasm_word => ["\\n<Zion>Am I really going to be made to come...", "shion_fc5", 2],
      :predation_word => ["\\n<Zion>Stop it...! Don't eat me...!!", "shion_fc5", 2],
      :incontinence_word => ["\\n<Zion>Damn it...! I'll kill everyone...!", "shion_fc5", 2],
      :premortal_graphic => "80_shion_st53",
    },
    607 => { # シオン
      :dead_word => ["\\n<Zion>Function... cease...", "shion_fc7", 0],
      :orgasm_word => ["\\n<Zion>Function... cease...", "shion_fc7", 0],
      :predation_word => ["\\n<Zion>Function... cease...", "shion_fc7", 0],
      :incontinence_word => ["\\n<Zion>Fuel, leaking...", "shion_fc7", 0],
      :premortal_graphic => "80_shion_st73",
    },
    608 => { # イリアス
      :dead_word => ["\\n<Ilias>That power, truly a threat...", "iriasu_fc4", 4],
      :orgasm_word => ["\\n<Ilias>For even me to come... no... ah, ahhh...", "iriasu_fc4", 6],
      :predation_word => ["\\n<Ilias>N-no... don't eat me... hyahhh...!", "iriasu_fc4", 6],
      :incontinence_word => ["\\n<Ilias>No, please don't look... hauuu...", "iriasu_fc4", 6],
      :premortal_graphic => "50_iriasu_st38",
    },
    609 => { # プルエル
      :dead_word => ["\\n<Puruel>Lady Ilias...", "slime_fc1", 2],
      :orgasm_word => ["\\n<Puruel>Funyaaaa...", "slime_fc1", 2],
      :predation_word => ["\\n<Puruel>I don't want to be eaten... Hyaaaa!", "slime_fc1", 2],
      :incontinence_word => ["\\n<Puruel>I'm leaking... Fuaaa...", "slime_fc1", 2],
      :premortal_graphic => "50_slime_st03",
    },
    610 => { # イヌエル
      :dead_word => ["\\n<Inuel>Kyaun... I'm sorry...", "dog_fc1", 4],
      :orgasm_word => ["\\n<Inuel>Howawan...", "dog_fc1", 4],
      :predation_word => ["\\n<Inuel>Kuuun, don't eat me... Kyankyan!", "dog_fc1", 4],
      :incontinence_word => ["\\n<Inuel>It's not peeing, it's marking... Jororororo...", "dog_fc1", 4],
      :premortal_graphic => "50_dog_st05",
    },
    611 => { # エンディエル
      :dead_word => ["\\n<Endiel>Let me rest in the veil...", "endiel_fc1", 2],
      :orgasm_word => ["\\n<Endiel>To think that I would be the first to fall...", "endiel_fc1", 2],
      :predation_word => ["\\n<Endiel> Ah, satisfying even the pleasure of food...", "endiel_fc1", 2],
      :incontinence_word => ["\\n<Endiel> Getting the book wet...oh, it's embarrassing...", "endiel_fc1", 2],
      :premortal_graphic => "50_endiel_st13",
    },
    612 => { # ホルミエル
      :dead_word => ["\\n<Holmiel> To think that I would be defeated...", "holmiel_fc1", 2],
      :orgasm_word => ["\\n<Holmiel> I never thought I would climax...", "holmiel_fc1", 2],
      :predation_word => ["\\n<Holmiel> Eating an angel is a punishment...", "holmiel_fc1", 2],
      :incontinence_word => ["\\n<Holmiel> Ah, urine... it's embarrassing...", "holmiel_fc1", 2],
      :premortal_graphic => "80_holmiel_st03",
    },
    613 => { # レプリカント
      :dead_word => ["\\n<Replicant> It ends here...", "replicant_fc1", 1],
      :orgasm_word => ["\\n<Replicant> I never thought I would end up feeling pleasure...", "replicant_fc1", 1],
      :predation_word => ["\\n<Replicant> I am also excellent as food...", "replicant_fc1", 1],
      :incontinence_word => ["\\n<Replicant> This is incontinence...hah...", "replicant_fc1", 1],
      :premortal_graphic => "50_replicant_st02",
    },
    614 => { # ドッペル
      :dead_word => ["\\n<Doppel> Is this... the end...?", "doppele_fc2", 0],
      :orgasm_word => ["\\n<Doppel> Ah, no, I can't...", "doppele_fc2", 0],
      :predation_word => ["\\n<Doppel>I'm going to be eaten...", "doppele_fc2", 0],
      :incontinence_word => ["\\n<Doppel>I'm also leaking...", "doppele_fc2", 0],
      :premortal_graphic => "50_doppeleb_st03",
    },
    615 => { # ルカ・キリエ
      :dead_word => ["\\n<Luka Kyrie>  I regret it...", "doppele_fc1", 2],
      :orgasm_word => ["\\n<Luka Kyrie>  Such humiliation...", "doppele_fc1", 2],
      :predation_word => ["\\n<Luka Kyrie>  I wonder if it's delicious...", "doppele_fc1", 2],
      :incontinence_word => ["\\n<Luka Kyrie>  I'm going to leak it...don't look...", "doppele_fc1", 2],
      :premortal_graphic => "50_doppele_st31",
    },
    616 => { # キメラプリズン
      :dead_word => ["\\n<Chimera Prison>  Don't break it...", "c_prison_fc1", 0],
      :orgasm_word => ["\\n<Chimera Prison>  I went...", "c_prison_fc1", 0],
      :predation_word => ["\\n<Chimera Prison>  Eating a cage doesn't taste good...", "c_prison_fc1", 0],
      :incontinence_word => ["\\n<Chimera Prison>  Urine is leaking...", "c_prison_fc1", 0],
      :premortal_graphic => "50_c_prison_st01",
    },
    617 => { # ジルフィ
      :dead_word => ["\\n<Zylphe>  Bye bye...", "zylphe_fc1", 2],
      :orgasm_word => ["\\n<Zylphe>  Feels good...", "zylphe_fc1", 1],
      :predation_word => ["\\n<Zylphe>No……", "zylphe_fc1", 2],
      :incontinence_word => ["\\n<Zylphe>I wet myself……", "zylphe_fc1", 1],
      :premortal_graphic => "80_zylphe_st03",
    },
    618 => { # タイタニア
      :dead_word => ["\\n<Titania>I can't take it anymore~!", "cirquec_fc2", 2],
      :orgasm_word => ["\\n<Titania>I'm going to come~!", "cirquec_fc2", 2],
      :predation_word => ["\\n<Titania>Don't eat me~!", "cirquec_fc2", 2],
      :incontinence_word => ["\\n<Titania>I'm going to wet myself……", "cirquec_fc2", 2],
      :premortal_graphic => "80_cirquec_st13",
    },
    619 => { # マイコニド
      :dead_word => ["\\n<Myconid>Ufufufu……", "maikonido_fc1", 0],
      :orgasm_word => ["\\n<Myconid>Ahh……", "maikonido_fc1", 0],
      :predation_word => ["\\n<Myconid>Ahaha, hahahaha……", "maikonido_fc1", 0],
      :incontinence_word => ["\\n<Myconid>Ufu…… fufufu……", "maikonido_fc1", 0],
      :premortal_graphic => "50_maikonido_st01",
    },
    620 => { # マタンゴ
      :dead_word => ["\\n<Matango>Is this mushroom bullying...", "matango_fc1", 6],
      :orgasm_word => ["\\n<Matango>Twitch... twitch...", "matango_fc1", 2],
      :predation_word => ["\\n<Matango>Delicious and full of nutrients... No wonder I'm being eaten.", "matango_fc1", 4],
      :incontinence_word => ["\\n<Matango>I wet myself... I wet myself...", "matango_fc1", 2],
      :premortal_graphic => "80_matango_st01",
    },
    621 => { # メルティモス
      :dead_word => ["\\n<Melty Moth>No... stop...", "meltymoss_fc1", 0],
      :orgasm_word => ["\\n<Melty Moth>Shivering...", "meltymoss_fc1", 0],
      :predation_word => ["\\n<Melty Moth>Don't eat me... No...", "meltymoss_fc1", 0],
      :incontinence_word => ["\\n<Melty Moth>I wet myself... I'm sorry...", "meltymoss_fc1", 0],
      :premortal_graphic => "50_meltymoss_st01",
    },
    622 => { # メルティローズ
      :dead_word => ["\\n<Melty Rose>Help me...", "meltyrose_fc1", 0],
      :orgasm_word => ["\\n<Melty Rose>Feels good...", "meltyrose_fc1", 0],
      :predation_word => ["\\n<Melty Rose>Don't eat me……", "meltyrose_fc1", 0],
      :incontinence_word => ["\\n<Melty Rose>Melting……", "meltyrose_fc1", 0],
      :premortal_graphic => "50_meltyrose_st01",
    },
    623 => { # キメラドリアード・ボア
      :dead_word => ["\\n<Chimera Dryad Vore>My strength……", "c_dryad_vore_fc1", 0],
      :orgasm_word => ["\\n<Chimera Dryad Vore>Melting……", "c_dryad_vore_fc1", 0],
      :predation_word => ["\\n<Chimera Dryad Vore>Not a vegetable……", "c_dryad_vore_fc1", 0],
      :incontinence_word => ["\\n<Chimera Dryad Vore>Sap is……", "c_dryad_vore_fc1", 0],
      :premortal_graphic => "50_c_dryad_vore_st01",
    },
    624 => { # コスモス
      :dead_word => ["\\n<Cosmos>Curse you, how careless of me……", "queenmoss_fc1", 4],
      :orgasm_word => ["\\n<Cosmos>Damn, can't resist the pleasure……", "queenmoss_fc1", 4],
      :predation_word => ["\\n<Cosmos>To make me your prey……ugh.", "queenmoss_fc1", 4],
      :incontinence_word => ["\\n<Cosmos>This is amniotic fluid……not urine……", "queenmoss_fc1", 4],
      :premortal_graphic => "80_queenmoss_st01",
    },
    625 => { # コスモス
      :dead_word => ["\\n<Cosmos> The concubine who is the spirit of the stars is like this...", "queenmoss_fc1", 2],
      :orgasm_word => ["\\n<Cosmos>Damn, can't resist the pleasure……", "queenmoss_fc1", 2],
      :predation_word => ["\\n<Cosmos>To make me your prey……ugh.", "queenmoss_fc1", 2],
      :incontinence_word => ["\\n<Cosmos>This is amniotic fluid……not urine……", "queenmoss_fc1", 2],
      :premortal_graphic => "80_queenmoss_st13",
    },
    626 => { # 帽子のアリス
      :dead_word => ["\\n<Hat Alice> Please excuse me for this...", "alice8thx_fc1", 0],
      :orgasm_word => ["\\n<Hat Alice> I enjoyed it...", "alice8thx_fc1", 0],
      :predation_word => ["\\n<Hat Alice> It must be delicious, hehe...", "alice8thx_fc1", 0],
      :incontinence_word => ["\\n<Hat Alice> This is embarrassing, hehe...", "alice8thx_fc1", 0],
      :premortal_graphic => "50_alice8thx01_st01",
    },
    627 => { # 傘のアリス
      :dead_word => ["\\n<Umbrella Alice> Please excuse me for this...", "alice8thx_fc1", 1],
      :orgasm_word => ["\\n<Umbrella Alice> I enjoyed it...", "alice8thx_fc1", 1],
      :predation_word => ["\\n<Umbrella Alice> It must be delicious, hehe...", "alice8thx_fc1", 1],
      :incontinence_word => ["\\n<Umbrella Alice> This is embarrassing, hehe...", "alice8thx_fc1", 1],
      :premortal_graphic => "50_alice8thx01_st02",
    },
    628 => { # 赤のアリス
      :dead_word => ["\\n<Red Alice> Please excuse me for this...", "alice8thx_fc1", 2],
      :orgasm_word => ["\\n<Red Alice>I thoroughly enjoyed myself...", "alice8thx_fc1", 2],
      :predation_word => ["\\n<Red Alice>Delicious, isn't it... Fufu...", "alice8thx_fc1", 2],
      :incontinence_word => ["\\n<Red Alice>This is quite embarrassing, fufu...", "alice8thx_fc1", 2],
      :premortal_graphic => "50_alice8thx01_st03",
    },
    629 => { # 冬のアリス
      :dead_word => ["\\n<Winter Alice>With this, I shall take my leave...", "alice8thx_fc1", 3],
      :orgasm_word => ["\\n<Winter Alice>I thoroughly enjoyed myself...", "alice8thx_fc1", 3],
      :predation_word => ["\\n<Winter Alice>Delicious, isn't it... Fufu...", "alice8thx_fc1", 3],
      :incontinence_word => ["\\n<Winter Alice>This is quite embarrassing, fufu...", "alice8thx_fc1", 3],
      :premortal_graphic => "50_alice8thx01_st04",
    },
    630 => { # 剣のアリス
      :dead_word => ["\\n<Sword Alice>With this, I shall take my leave...", "alice8thx_fc1", 4],
      :orgasm_word => ["\\n<Sword Alice>I thoroughly enjoyed myself...", "alice8thx_fc1", 4],
      :predation_word => ["\\n<Sword Alice>Delicious, isn't it... Fufu...", "alice8thx_fc1", 4],
      :incontinence_word => ["\\n<Sword Alice>This is so embarrassing, fufu...", "alice8thx_fc1", 4],
      :premortal_graphic => "50_alice8thx01_st05",
    },
    631 => { # 武のアリス
      :dead_word => ["\\n<Martial Alice>Let's take our leave now...", "alice8thx_fc1", 5],
      :orgasm_word => ["\\n<Martial Alice>I had a lot of fun...", "alice8thx_fc1", 5],
      :predation_word => ["\\n<Martial Alice>Isn't it delicious, fufu...", "alice8thx_fc1", 5],
      :incontinence_word => ["\\n<Martial Alice>This is so embarrassing, fufu...", "alice8thx_fc1", 5],
      :premortal_graphic => "50_alice8thx01_st06",
    },
    632 => { # アジ・ダハーカ
      :dead_word => ["\\n<Aži Dahāka>What, you defeated me...", "azidahaka_fc1", 2],
      :orgasm_word => ["\\n<Aži Dahāka>To succumb... to pleasure...", "azidahaka_fc1", 2],
      :predation_word => ["\\n<Aži Dahāka>To think I would become... prey...", "azidahaka_fc1", 2],
      :incontinence_word => ["\\n<Aži Dahāka>To wet myself... such humiliation...", "azidahaka_fc1", 2],
      :premortal_graphic => "80_azidahaka_st03",
    },
    633 => { # 白のアリス
      :dead_word => ["\\n<White Alice>Let's take our leave now...", "alice8thx_fc1", 7],
      :orgasm_word => ["\\n<White Alice>I had a lot of fun...", "alice8thx_fc1", 7],
      :predation_word => ["\\n<White Alice>Isn't it delicious, fufu...", "alice8thx_fc1", 7],
      :incontinence_word => ["\\n<White Alice>This is so embarrassing, fufu...", "alice8thx_fc1", 7],
      :premortal_graphic => "50_alice8thx01_st08",
    },
    634 => { # 侍のアリス
      :dead_word => ["\\n<Samurai Alice>Let's take our leave now...", "alice8thx_fc2", 0],
      :orgasm_word => ["\\n<Samurai Alice>I had a lot of fun...", "alice8thx_fc2", 0],
      :predation_word => ["\\n<Samurai Alice>Isn't it delicious, fufu...", "alice8thx_fc2", 0],
      :incontinence_word => ["\\n<Samurai Alice>This is so embarrassing, fufu...", "alice8thx_fc2", 0],
      :premortal_graphic => "50_alice8thx01_st09",
    },
    635 => { # 忍のアリス
      :dead_word => ["\\n<Ninja Alice>Let's take our leave now...", "alice8thx_fc2", 1],
      :orgasm_word => ["\\n<Ninja Alice>I had a lot of fun...", "alice8thx_fc2", 1],
      :predation_word => ["\\n<Ninja Alice>Isn't it delicious, fufu...", "alice8thx_fc2", 1],
      :incontinence_word => ["\\n<Ninja Alice>  This is embarrassing, hehe...", "alice8thx_fc2", 1],
      :premortal_graphic => "50_alice8thx01_st10",
    },
    636 => { # ヒミコ
      :dead_word => ["\\n<Himiko>  Is it destined to rot here...", "tukumokomati_fc1", 2],
      :orgasm_word => ["\\n<Himiko>  Will the concubine end in pleasure...?", "tukumokomati_fc1", 2],
      :predation_word => ["\\n<Himiko>  It's good to taste the high-quality meat.", "tukumokomati_fc1", 2],
      :incontinence_word => ["\\n<Himiko>  Oh, I'm sorry... I won't forgive you...", "tukumokomati_fc1", 2],
      :premortal_graphic => "80_tukumokomati_st03",
    },
    637 => { # 猟のアリス
      :dead_word => ["\\n<Hunter Alice>  Please excuse me for this...", "alice8thx_fc1", 6],
      :orgasm_word => ["\\n<Hunter Alice>  I enjoyed it...", "alice8thx_fc1", 6],
      :predation_word => ["\\n<Hunter Alice>  It must be delicious, hehe...", "alice8thx_fc1", 6],
      :incontinence_word => ["\\n<Hunter Alice>  This is embarrassing, hehe...", "alice8thx_fc1", 6],
      :premortal_graphic => "50_alice8thx01_st07",
    },
    638 => { # 舞のアリス
      :dead_word => ["\\n<Dancer Alice>  Please excuse me for this...", "alice8thx_fc2", 2],
      :orgasm_word => ["\\n<Dancer Alice> I enjoyed it...", "alice8thx_fc2", 2],
      :predation_word => ["\\n<Dancer Alice> It must be delicious, hehe...", "alice8thx_fc2", 2],
      :incontinence_word => ["\\n<Dancer Alice> This is embarrassing, hehe...", "alice8thx_fc2", 2],
      :premortal_graphic => "50_alice8thx01_st11",
    },
    639 => { # 呪のアリス
      :dead_word => ["\\n<Curse Alice> Please excuse me for this...", "alice8thx_fc2", 4],
      :orgasm_word => ["\\n<Curse Alice> I enjoyed it...", "alice8thx_fc2", 4],
      :predation_word => ["\\n<Curse Alice> It must be delicious, hehe...", "alice8thx_fc2", 4],
      :incontinence_word => ["\\n<Curse Alice> This is embarrassing, hehe...", "alice8thx_fc2", 4],
      :premortal_graphic => "50_alice8thx01_st13",
    },
    640 => { # 兎のアリス
      :dead_word => ["\\n<Rabbit Alice> Please excuse me for this...", "alice8thx_fc2", 5],
      :orgasm_word => ["\\n<Rabbit Alice> I enjoyed it...", "alice8thx_fc2", 5],
      :predation_word => ["\\n<Rabbit Alice> It must be delicious, hehe...", "alice8thx_fc2", 5],
      :incontinence_word => ["\\n<Rabbit Alice>This is quite embarrassing, hehe...", "alice8thx_fc2", 5],
      :premortal_graphic => "50_alice8thx01_st14",
    },
    641 => { # イザナミ
      :dead_word => ["\\n<Izanami>Let us return to the underworld...", "izanami_fc1", 2],
      :orgasm_word => ["\\n<Izanami>Pleasure is also sweet...", "izanami_fc1", 2],
      :predation_word => ["\\n<Izanami>Will you even devour death...", "izanami_fc1", 2],
      :incontinence_word => ["\\n<Izanami>The river of death, here it is...", "izanami_fc1", 2],
      :premortal_graphic => "80_izanami_st03",
    },
    642 => { # 蝕のアリス
      :dead_word => ["\\n<Devouring Alice>Let us take our leave...", "alice8th_fc3", 0],
      :orgasm_word => ["\\n<Devouring Alice>I have enjoyed myself...", "alice8th_fc3", 0],
      :predation_word => ["\\n<Devouring Alice>Is it delicious, hehe...", "alice8th_fc3", 0],
      :incontinence_word => ["\\n<Devouring Alice>This is quite embarrassing, hehe...", "alice8th_fc3", 0],
      :premortal_graphic => "80_alice8th5_st03",
    },
    643 => { # 海のアリス
      :dead_word => ["\\n<Sea Alice>Let us take our leave...", "alice8thx_fc2", 3],
      :orgasm_word => ["\\n<Sea Alice>I have enjoyed myself……", "alice8thx_fc2", 3],
      :predation_word => ["\\n<Sea Alice>Isn't it delicious, fufu……", "alice8thx_fc2", 3],
      :incontinence_word => ["\\n<Sea Alice>This is quite embarrassing, fufu……", "alice8thx_fc2", 3],
      :premortal_graphic => "50_alice8thx01_st12",
    },
    644 => { # 魔のアリス
      :dead_word => ["\\n<Magical Alice>I shall take my leave now……", "alice8thx_fc2", 6],
      :orgasm_word => ["\\n<Magical Alice>I have enjoyed myself……", "alice8thx_fc2", 6],
      :predation_word => ["\\n<Magical Alice>Isn't it delicious, fufu……", "alice8thx_fc2", 6],
      :incontinence_word => ["\\n<Magical Alice>This is quite embarrassing, fufu……", "alice8thx_fc2", 6],
      :premortal_graphic => "50_alice8thx01_st15",
    },
    645 => { # ハインリヒボディ
      :dead_word => ["\\n<Heinrich's Body>Even if I fall here……", "heinrich_fc1", 2],
      :orgasm_word => ["\\n<Heinrich's Body>The reflection meeting with Lady Ilias……", "heinrich_fc1", 2],
      :predation_word => ["\\n<Heinrich's Body>Even if I become food for monsters……", "heinrich_fc1", 2],
      :incontinence_word => ["\\n<Heinrich's Body>This disgraceful behavior, please forget it...", "heinrich_fc1", 2],
      :premortal_graphic => "80_heinrich_st03",
    },
    646 => { # ハインリヒソウル
      :dead_word => ["\\n<Heinrich's Soul>Even if I fall here...", "heinrich_fc3", 2],
      :orgasm_word => ["\\n<Heinrich's Soul>The reflection meeting with Lady Ilias...", "heinrich_fc3", 2],
      :predation_word => ["\\n<Heinrich's Soul>Even if I become food for monsters...", "heinrich_fc3", 2],
      :incontinence_word => ["\\n<Heinrich's Soul>This disgraceful behavior, please forget it...", "heinrich_fc3", 2],
      :premortal_graphic => "80_heinrich_st22",
    },
    647 => { # マルケルス
      :dead_word => ["\\n<Marcellus>You've become stronger...", "marcellus_fc1", 0],
      :orgasm_word => ["\\n<Marcellus>You've become stronger...", "marcellus_fc1", 0],
      :predation_word => ["\\n<Marcellus>You've become stronger...", "marcellus_fc1", 0],
      :incontinence_word => ["\\n<Marcellus>........................", "marcellus_fc1", 0],
      :premortal_graphic => "80_marcellus_st01",
    },
    648 => { # 黒のアリス
      :dead_word => ["\\n<Black Alice>Ufufu, isn't it enjoyable...?", "alice8th_fc4", 3],
      :orgasm_word => ["\\n<Black Alice>Ufufu, isn't it enjoyable...?", "alice8th_fc4", 3],
      :predation_word => ["\\n<Black Alice>Ufufu, isn't it enjoyable...?", "alice8th_fc4", 3],
      :incontinence_word => ["\\n<Black Alice>Ah... I wet myself...", "alice8th_fc4", 3],
      :premortal_graphic => "80_alice8th6_st03",
    },
    649 => { # アルカンシエル
      :dead_word => ["\\n<Arc-en-Ciel>For me to lose, you have quite the skill...", "arcen_fc1", 2],
      :orgasm_word => ["\\n<Arc-En-Ciel>Ugh, I'm not good with pleasure...", "arcen_fc1", 2],
      :predation_word => ["\\n<Arc-En-Ciel>Hmph, take as much as you want...!", "arcen_fc1", 2],
      :incontinence_word => ["\\n<Arc-En-Ciel>Ugh... I won't forgive you...", "arcen_fc1", 2],
      :premortal_graphic => "80_arcen_st03",
    },
    650 => { # ヨモツシコメ
      :dead_word => ["\\n<Yomotsu-Shikome>Regretful...", "yomotu_fc1", 0],
      :orgasm_word => ["\\n<Yomotsu-Shikome>Ascending...", "yomotu_fc1", 0],
      :predation_word => ["\\n<Yomotsu-Shikome>Regretful...", "yomotu_fc1", 0],
      :incontinence_word => ["\\n<Yomotsu-Shikome>Urination...", "yomotu_fc1", 0],
      :premortal_graphic => "50_yomotu_st01",
    },
    651 => { # フェルメサーラ
      :dead_word => ["\\n<Ferme Sara>Only to decay...", "fermesara_fc1", 0],
      :orgasm_word => ["\\n<Ferme Sara>Only to perish...", "fermesara_fc1", 0],
      :predation_word => ["\\n<Ferme Sara>Use me as sustenance, and go on for a long time...", "fermesara_fc1", 0],
      :incontinence_word => ["\\n<Ferme Sara>The bandages... are wet...", "fermesara_fc1", 0],
      :premortal_graphic => "50_fermesara_st01",
    },
    652 => { # エンジェルグール
      :dead_word => ["\\n<Angel Ghoul>I don't want to die...", "angelghoul_fc1", 0],
      :orgasm_word => ["\\n<Angel Ghoul>It feels good...", "angelghoul_fc1", 0],
      :predation_word => ["\\n<Angel Ghoul>Stop...", "angelghoul_fc1", 0],
      :incontinence_word => ["\\n<Angel Ghoul>Urine... No...", "angelghoul_fc1", 0],
      :premortal_graphic => "80_angelghoul_st01",
    },
    653 => { # ドラゴンゾンビ娘
      :dead_word => ["\\n<Dragon Zombie Girl>Is this the end...?", "dragonzonbe_fc1", 2],
      :orgasm_word => ["\\n<Dragon Zombie Girl>I thought I had forgotten pleasure...", "dragonzonbe_fc1", 2],
      :predation_word => ["\\n<Dragon Zombie Girl>Your stomach will suffer...", "dragonzonbe_fc1", 2],
      :incontinence_word => ["\\n<Dragon Zombie Girl>Ah, zombie fluids are leaking...", "dragonzonbe_fc1", 2],
      :premortal_graphic => "80_dragonzonbe_st23",
    },
    654 => { # シグルドリーヴァ
      :dead_word => ["\\n<Sigrdrifa>Is this... a nightmare...", "sigurd_fc1", 4],
      :orgasm_word => ["\\n<Sigrdrifa>Ugh... this feeling... ahhh...", "sigurd_fc1", 4],
      :predation_word => ["\\n<Sigrdrifa>My material isn't tasty at all...!", "sigurd_fc1", 4],
      :incontinence_word => ["\\n<Sigrdrifa>This sense of liberation and humiliation... Ugh, don't look...", "sigurd_fc1", 4],
      :premortal_graphic => "80_sigurd_st11",
    },
    655 => { # ドッペルエリート
      :dead_word => ["\\n<Doppel Elite>Is this... the end...?", "doppele_fc2", 2],
      :orgasm_word => ["\\n<Doppel Elite>Ah, no, I can't...", "doppele_fc2", 2],
      :predation_word => ["\\n<Doppel Elite>I'm going to be eaten...", "doppele_fc2", 2],
      :incontinence_word => ["\\n<Doppel Elite>I'm also leaking...", "doppele_fc2", 2],
      :premortal_graphic => "50_doppeleb_st03",
    },
    656 => { # サルラック娘
      :dead_word => ["\\n<Sarlacc Girl>Ugh... ahhh...", "sarlacc_fc1", 0],
      :orgasm_word => ["\\n<Sarlacc Girl>Ugh... ahhh...", "sarlacc_fc1", 0],
      :predation_word => ["\\n<Sarlacc Girl>Oh, ah... ah...", "sarlacc_fc1", 0],
      :incontinence_word => ["\\n<Sarlacc Girl>Ah, ahhh...", "sarlacc_fc1", 0],
      :premortal_graphic => "80_sarlacc_st01",
    },
    657 => { # ルカ・ホリィ
      :dead_word => ["\\n<Luka Holly>Is this... the end...?", "doppele_fc1", 0],
      :orgasm_word => ["\\n<Luka Holly>Ah, no...", "doppele_fc1", 0],
      :predation_word => ["\\n<Luka Holly>I'm going to be eaten...", "doppele_fc1", 0],
      :incontinence_word => ["\\n<Luka Holly>I'm going to wet myself...", "doppele_fc1", 0],
      :premortal_graphic => "50_doppele_st01",
    },
    658 => { # ルカ・リノア
      :dead_word => ["\\n<Luka Rinoa>You're quite skilled...", "doppele_fc1", 4],
      :orgasm_word => ["\\n<Luka Rinoa>To think I'd feel this...", "doppele_fc1", 4],
      :predation_word => ["\\n<Luka Rinoa>To become food, such humiliation...", "doppele_fc1", 4],
      :incontinence_word => ["\\n<Luka Rinoa>You're the worst...", "doppele_fc1", 4],
      :premortal_graphic => "50_doppele_st11",
    },
    659 => { # ルカ・ハイネ
      :dead_word => ["\\n<Luka Heine>I lost~!", "doppele_fc1", 1],
      :orgasm_word => ["\\n<Luka Heine>It feels so good~!", "doppele_fc1", 1],
      :predation_word => ["\\n<Luka Heine>Don't eat me~!", "doppele_fc1", 1],
      :incontinence_word => ["\\n<Luka Heine>I wet myself...", "doppele_fc1", 1],
      :premortal_graphic => "50_doppele_st21",
    },
    660 => { # ルカ・キリエ
      :dead_word => ["\\n<Luka Kyrie>  I regret it...", "doppele_fc1", 2],
      :orgasm_word => ["\\n<Luka Kyrie>  Such humiliation...", "doppele_fc1", 2],
      :predation_word => ["\\n<Luka Kyrie>  I wonder if it's delicious...", "doppele_fc1", 2],
      :incontinence_word => ["\\n<Luka Kyrie>  I'm going to leak it...don't look...", "doppele_fc1", 2],
      :premortal_graphic => "50_doppele_st31",
    },
    661 => { # ルシフィナ
      :dead_word => ["\\n<Lucifina>Luka... you're a strong one...", "rucyfina_fc2", 0],
      :orgasm_word => ["\\n<Lucifina>Luka... you're a strong one...", "rucyfina_fc2", 0],
      :predation_word => ["\\n<Lucifina>Luka... you're a strong one...", "rucyfina_fc2", 0],
      :incontinence_word => ["\\n<Lucifina>It's embarrassing, but it feels good...", "rucyfina_fc2", 0],
      :premortal_graphic => "80_rucyfina_st21",
    },
    662 => { # シリエル
      :dead_word => ["\\n<Siriel>You're a rough person...", "siriel_fc1", 0],
      :orgasm_word => ["\\n<Siriel> Hehe, I enjoyed it...", "siriel_fc1", 0],
      :predation_word => ["\\n<Siriel> Things like this also feel good...", "siriel_fc1", 0],
      :incontinence_word => ["\\n<Siriel> Ah, it gives me chills...", "siriel_fc1", 0],
      :premortal_graphic => "50_siriel_st01",
    },
    663 => { # エグエル
      :dead_word => ["\\n<Eggiel> The egg broke...", "eggel_fc1", 2],
      :orgasm_word => ["\\n<Eggiel> Let's depart to the world of pleasure...", "eggel_fc1", 2],
      :predation_word => ["\\n<Eggiel> Oh, don't eat eggs...", "eggel_fc1", 2],
      :incontinence_word => ["\\n<Eggiel> Oh, it's leaking...", "eggel_fc1", 2],
      :premortal_graphic => "50_eggel_st03",
    },
    664 => { # キメラチャリオッツ
      :dead_word => ["\\n<Chimera Chariot> Was it destroyed...?", "c_chariot_fc1", 0],
      :orgasm_word => ["\\n<Chimera Chariot> Have you been made to climax...?", "c_chariot_fc1", 0],
      :predation_word => ["\\n<Chimera Chariot> To be eaten...", "c_chariot_fc1", 0],
      :incontinence_word => ["\\n<Chimera Chariot>Fuel is leaking...", "c_chariot_fc1", 0],
      :premortal_graphic => "50_c_chariot_st01",
    },
    665 => { # ナイトロイド
      :dead_word => ["\\n<Knightroid>Ugh, did I lose...?", "knightloid_fc1", 2],
      :orgasm_word => ["\\n<Knightroid>This is... pleasure...", "knightloid_fc1", 2],
      :predation_word => ["\\n<Knightroid>Is this the fate of the defeated...?", "knightloid_fc1", 2],
      :incontinence_word => ["\\n<Knightroid>D-Don't look...! D-Damn it...!", "knightloid_fc1", 2],
      :premortal_graphic => "80_knightloid_st05",
    },
    666 => { # アサシンロイド
      :dead_word => ["\\n<Assassinroid>To think I would be defeated...", "assassinloid_fc1", 2],
      :orgasm_word => ["\\n<Assassinroid>Ugh, to succumb to pleasure...", "assassinloid_fc1", 2],
      :predation_word => ["\\n<Assassinroid>To become prey... how regretful.", "assassinloid_fc1", 2],
      :incontinence_word => ["\\n<Assassinroid>Such disgrace... ahhh...", "assassinloid_fc1", 2],
      :premortal_graphic => "80_assassinloid_st03",
    },
    667 => { # エデン
      :dead_word => ["\\n<Eden>Lady Ilias... please forgive me...", "eden_fc1", 3],
      :orgasm_word => ["\\n<Eden>For me... to succumb to pleasure...", "eden_fc1", 3],
      :predation_word => ["\\n<Eden>Such barbarity... divine punishment will surely... ah...", "eden_fc1", 3],
      :incontinence_word => ["\\n<Eden>Ah... you must not look... d-don't look...", "eden_fc1", 3],
      :premortal_graphic => "80_eden_st01",
    },
    668 => { # ユリエル
      :dead_word => ["\\n<Yuriel>This is it...", "yuriel_fc1", 0],
      :orgasm_word => ["\\n<Yuriel>Such humiliation...", "yuriel_fc1", 0],
      :predation_word => ["\\n<Yuriel>Doesn't taste like flowers...?", "yuriel_fc1", 0],
      :incontinence_word => ["\\n<Yuriel>D-don't look... you are the worst...", "yuriel_fc1", 0],
      :premortal_graphic => "50_yuriel_st01",
    },
    669 => { # メルシエル
      :dead_word => ["\\n<Melciel>I dislike rough people...", "merusiel_fc1", 2],
      :orgasm_word => ["\\n<Melciel>Ah, it feels so good...", "merusiel_fc1", 2],
      :predation_word => ["\\n<Melciel>To eat me, are you a sweet tooth...?", "merusiel_fc1", 2],
      :incontinence_word => ["\\n<Melciel>Ah, my pee is...", "merusiel_fc1", 2],
      :premortal_graphic => "50_merusiel_st03",
    },
    670 => { # セバスイール
      :dead_word => ["\\n<Sebasiel>For this sword to break...", "sebasiel_fc1", 2],
      :orgasm_word => ["\\n<Sebasiel>To think I'd succumb to pleasure...", "sebasiel_fc1", 2],
      :predation_word => ["\\n<Sebasiel>Even if it pierces your stomach, I don't care...", "sebasiel_fc1", 2],
      :incontinence_word => ["\\n<Sebasiel>Ah, I'm leaking urine...", "sebasiel_fc1", 2],
      :premortal_graphic => "50_sebasiel_st03",
    },
    671 => { # 量産型ラプンツェル
      :dead_word => ["\\n<Mass-Produced Rapunzel>It's over, I can't enjoy it anymore...", "rapun_fc1", 2],
      :orgasm_word => ["\\n<Mass-Produced Rapunzel>I thoroughly enjoyed myself...", "rapun_fc1", 1],
      :predation_word => ["\\n<Mass-Produced Rapunzel>Delicious...? It's delicious, isn't it...?", "rapun_fc1", 1],
      :incontinence_word => ["\\n<Mass-Produced Rapunzel>This sense of liberation... it's irresistible...", "rapun_fc1", 1],
      :premortal_graphic => "80_rapun_st03",
    },
    672 => { # 量産型ハイヌウェレ
      :dead_word => ["\\n<Mass-Produced Hainuwele>I can't take it anymore, I'm stopping...", "hainu_fc1", 2],
      :orgasm_word => ["\\n<Mass-produced Hainuwele> I shouldn't feel this way...", "hainu_fc1", 2],
      :predation_word => ["\\n<Mass-produced Hainuwele> Don't eat it...! That's the worst...!", "hainu_fc1", 2],
      :incontinence_word => ["\\n<Mass-produced Hainuwele> I feel so... miserable...", "hainu_fc1", 2],
      :premortal_graphic => "80_hainu_st03",
    },
    673 => { # 量産型アンフィスバエナ
      :dead_word => ["\\n<Mass-produced Amphisbaena> I can't move my body anymore...", "amphis_fc1", 2],
      :orgasm_word => ["\\n<Mass-produced Amphisbaena> I can't resist this pleasure...", "amphis_fc1", 2],
      :predation_word => ["\\n<Mass-produced Amphisbaena>, stop it...ahhh!", "amphis_fc1", 2],
      :incontinence_word => ["\\n<Mass-produced Amphisbaena> It's humiliating...", "amphis_fc1", 2],
      :premortal_graphic => "80_amphis_st03",
    },
    674 => { # 量産型ツクヨミ
      :dead_word => ["\\n<Mass-produced Tsukuyomi> No more, no more...", "tukuyomi_fc1", 2],
      :orgasm_word => ["\\n<Mass-produced Tsukuyomi> It's not too bad to fall down from pleasure...", "tukuyomi_fc1", 2],
      :predation_word => ["\\n<Mass-produced Tsukuyomi> My body will be devoured...", "tukuyomi_fc1", 2],
      :incontinence_word => ["\\n<Mass-Produced Tsukuyomi>S-so embarrassing... like this...", "tukuyomi_fc1", 2],
      :premortal_graphic => "80_tukuyomi_st03",
    },
    675 => { # 量産型アルカンシエル
      :dead_word => ["\\n<Mass-Produced Arc-en-Ciel>For me to lose, you have quite the skill...", "arcen_fc1", 2],
      :orgasm_word => ["\\n<Mass-Produced Arc-en-Ciel>Ugh, I'm not good with pleasure...", "arcen_fc1", 2],
      :predation_word => ["\\n<Mass-Produced Arc-en-Ciel>Hmph, take as much as you want...!", "arcen_fc1", 2],
      :incontinence_word => ["\\n<Mass-Produced Arc-en-Ciel>Ugh... I won't forgive you...!", "arcen_fc1", 2],
      :premortal_graphic => "80_arcen_st03",
    },
    676 => { # ホルミエル
      :dead_word => ["\\n<Holmiel> To think that I would be defeated...", "holmiel_fc1", 2],
      :orgasm_word => ["\\n<Holmiel> I never thought I would climax...", "holmiel_fc1", 2],
      :predation_word => ["\\n<Holmiel> Eating an angel is a punishment...", "holmiel_fc1", 2],
      :incontinence_word => ["\\n<Holmiel> Ah, urine... it's embarrassing...", "holmiel_fc1", 2],
      :premortal_graphic => "50_holmiel_st03",
    },
    677 => { # アプティエル
      :dead_word => ["\\n<Aptiel>My body... can't move...", "aptiel_fc1", 0],
      :orgasm_word => ["\\n<Aptiel>My body... is melting...", "aptiel_fc1", 0],
      :predation_word => ["\\n<Aptiel>I'm being eaten...", "aptiel_fc1", 0],
      :incontinence_word => ["\\n<Aptiel>Urine is leaking out...", "aptiel_fc1", 0],
      :premortal_graphic => "50_aptiel_st01",
    },
    678 => { # クリオネラ
      :dead_word => ["\\n<Clionera>……………………", "clionera_fc1", 0],
      :orgasm_word => ["\\n<Clionera>……………………", "clionera_fc1", 0],
      :predation_word => ["\\n<Clionera>……………………", "clionera_fc1", 0],
      :incontinence_word => ["\\n<Clionera>……………………", "clionera_fc1", 0],
      :premortal_graphic => "50_clionera_st01",
    },
    679 => { # ロズニエル
      :dead_word => ["\\n<Roseniel>My mission ends here...", "roseniel_fc1", 2],
      :orgasm_word => ["\\n<Roseniel>I've fallen into pleasure...", "roseniel_fc1", 2],
      :predation_word => ["\\n<Roseniel>Ah, I'm becoming sustenance...", "roseniel_fc1", 2],
      :incontinence_word => ["\\n<Roseniel>I can't bear such humiliation...", "roseniel_fc1", 2],
      :premortal_graphic => "50_roseniel_st13",
    },
    680 => { # キュビエル
      :dead_word => ["\\n<Cubeiel>It's terrible...", "cubiel_fc1", 2],
      :orgasm_word => ["\\n<Cubeiel>Hauuu...", "cubiel_fc1", 2],
      :predation_word => ["\\n<Cubeiel>S-stop it... Ahhh...", "cubiel_fc1", 2],
      :incontinence_word => ["\\n<Cubeiel>D-don't look at me...", "cubiel_fc1", 2],
      :premortal_graphic => "50_cubiel_st03",
    },
    681 => { # ワミエル
      :dead_word => ["\\n<Wormiel>My power isn't enough...", "wormiel_fc1", 2],
      :orgasm_word => ["\\n<Wormiel>Ah, I'm ascending...", "wormiel_fc1", 2],
      :predation_word => ["\\n<Wormiel>For me to become sustenance...", "wormiel_fc1", 2],
      :incontinence_word => ["\\n<Wormiel>For me to wet myself...", "wormiel_fc1", 2],
      :premortal_graphic => "80_wormiel_st03",
    },
    682 => { # 量産型ジルフィ
      :dead_word => ["\\n<Mass-Produced Zylphe>Bye-bye...", "zylphe_fc1", 2],
      :orgasm_word => ["\\n<Mass-Produced Zylphe>Feels good...", "zylphe_fc1", 1],
      :predation_word => ["\\n<Mass-Produced Zylphe>No...", "zylphe_fc1", 2],
      :incontinence_word => ["\\n<Mass-Produced Zylphe>I wet myself...", "zylphe_fc1", 1],
      :premortal_graphic => "80_zylphe_st03",
    },
    683 => { # 量産型ノーマレン
      :dead_word => ["\\n<Mass-Produced Gnomaren>................", "gnomaren_fc1", 3],
      :orgasm_word => ["\\n<Mass-Produced Gnomaren>................", "gnomaren_fc1", 2],
      :predation_word => ["\\n<Mass-Produced Gnomaren>................", "gnomaren_fc1", 3],
      :incontinence_word => ["\\n<Mass-Produced Gnomaren>................", "gnomaren_fc1", 2],
      :premortal_graphic => "80_gnomaren_st03",
    },
    684 => { # 量産型グランディーネ
      :dead_word => ["\\n<Mass-Produced Grandine>This is it...", "grandine_fc1", 2],
      :orgasm_word => ["\\n<Mass-Produced Grandine>I'm melting...", "grandine_fc1", 2],
      :predation_word => ["\\n<Mass-Produced Grandine>I'll dissolve you from the inside...", "grandine_fc1", 2],
      :incontinence_word => ["\\n<Mass-Produced Grandine>The contents are leaking out……", "grandine_fc1", 2],
      :premortal_graphic => "80_grandine_st03",
    },
    685 => { # 量産型ギガマンドラ
      :dead_word => ["\\n<Mass-Produced Gigamander>Impossible, to this extent……", "gigamander_fc1", 2],
      :orgasm_word => ["\\n<Mass-Produced Gigamander>The flame of pleasure smolders……", "gigamander_fc1", 2],
      :predation_word => ["\\n<Mass-Produced Gigamander>Guh, you'll get burned……!", "gigamander_fc1", 2],
      :incontinence_word => ["\\n<Mass-Produced Gigamander>Ah, how humiliating……", "gigamander_fc1", 2],
      :premortal_graphic => "80_gigamander_st03",
    },
    686 => { # ミカエラ
      :dead_word => ["\\n<Micaela>To think you are this strong……", "micaela_fc2", 0],
      :orgasm_word => ["\\n<Micaela>To think you are this strong……", "micaela_fc2", 0],
      :predation_word => ["\\n<Micaela>To think you are this strong……", "micaela_fc2", 0],
      :incontinence_word => ["\\n<Micaela>Guh, don't look…… at this……", "micaela_fc2", 0],
      :premortal_graphic => "80_micaela_st31",
    },
    687 => { # イリアス
      :dead_word => ["\\n<Ilias>You dare, against the great me……!", "iriasu_fc6", 5],
      :orgasm_word => ["\\n<Ilias>You dare, against the great me……!", "iriasu_fc6", 5],
      :predation_word => ["\\n<Ilias>You dare, against the great me……!", "iriasu_fc6", 5],
      :incontinence_word => ["\\n<Ilias>You dare, I won't forgive you……", "iriasu_fc6", 5],
      :premortal_graphic => "80_iriasu_st43",
    },
    688 => { # カオスイリアス
      :dead_word => ["\\n<Chaos Ilias>This latent power…… I won't underestimate it……", "iriasu_fc7", 6],
      :orgasm_word => ["\\n<Chaos Ilias>This latent power…… I won't underestimate it……", "iriasu_fc7", 6],
      :predation_word => ["\\n<Chaos Ilias>This latent power…… I won't underestimate it……", "iriasu_fc7", 6],
      :incontinence_word => ["\\n<Chaos Ilias>Ah... I, of all beings, am leaking...", "iriasu_fc7", 7],
      :premortal_graphic => "80_iriasu3_st05",
    },
    689 => { # カオスイリアス
      :dead_word => ["\\n<Chaos Ilias>I, of all beings...! The power of chaos...!", "iriasu_fc7", 6],
      :orgasm_word => ["\\n<Chaos Ilias>I, of all beings...! The power of chaos...!", "iriasu_fc7", 6],
      :predation_word => ["\\n<Chaos Ilias>I, of all beings...! The power of chaos...!", "iriasu_fc7", 6],
      :incontinence_word => ["\\n<Chaos Ilias>Ah... I, of all beings, am leaking...", "iriasu_fc7", 7],
      :premortal_graphic => "80_iriasu3_st05",
    },
    690 => { # ラファエラ
      :dead_word => ["\\n<Raphaela>So, this is the end...", "rafaera_fc3", 2],
      :orgasm_word => ["\\n<Raphaela>So, this is the end...", "rafaera_fc3", 2],
      :predation_word => ["\\n<Raphaela>So, this is the end...", "rafaera_fc3", 2],
      :incontinence_word => ["\\n<Raphaela>Ah, so much pee...", "rafaera_fc3", 2],
      :premortal_graphic => "80_rafaera_st23",
    },
    691 => { # フェンリル
      :dead_word => ["\\n<Fenrir>This was also fated by the moon...", "fenrir_fc1", 2],
      :orgasm_word => ["\\n<Fenrir>Th-that was...so cowardly...", "fenrir_fc1", 2],
      :predation_word => ["\\n<Fenrir>You either eat or get eaten...", "fenrir_fc1", 2],
      :incontinence_word => ["\\n<Fenrir>D-don't look... Don't look at me...", "fenrir_fc1", 2],
      :premortal_graphic => "50_fenrir_st03",
    },
    692 => { # ガルキマセラ
      :dead_word => ["\\n<Garchimacera>To think I'm being made to suffer like this...", "garukimasera_fc1", 2],
      :orgasm_word => ["\\n<Garchimacera>I can't believe I'm coming in public...", "garukimasera_fc1", 2],
      :predation_word => ["\\n<Garchimacera>D-don't eat me... I don't taste good...!", "garukimasera_fc1", 2],
      :incontinence_word => ["\\n<Garchimacera>Aaah... This is so embarrassing...", "garukimasera_fc1", 2],
      :premortal_graphic => "50_garukimasera_st03",
    },
    693 => { # グレートオーク
      :dead_word => ["\\n<Great Orc>Is this it for me...?!", "greatorc_fc1", 2],
      :orgasm_word => ["\\n<Great Orc>I...I'm coming...", "greatorc_fc1", 2],
      :predation_word => ["\\n<Great Orc>It's eat or be eaten...", "greatorc_fc1", 2],
      :incontinence_word => ["\\n<Great Orc>Don't look! Don't look, damnit!", "greatorc_fc1", 2],
      :premortal_graphic => "50_greatorc_st03",
    },
    694 => { # ランキュバス
      :dead_word => ["\\n<Lancubus>So violent...", "ranccubus_fc1", 2],
      :orgasm_word => ["\\n<Lancubus>This could be pretty nice...", "ranccubus_fc1", 1],
      :predation_word => ["\\n<Lancubus>I hate to admit it, but I'm probably delicious...", "ranccubus_fc1", 2],
      :incontinence_word => ["\\n<Lancubus>This is so humiliating...", "ranccubus_fc1", 2],
      :premortal_graphic => "50_ranccubus_st03",
    },
    695 => { # リーキュバス
      :dead_word => ["\\n<Leecubus>I won't forgive you...!", "leeccubus_fc1", 2],
      :orgasm_word => ["\\n<Leecubus>This is so humiliating...!", "leeccubus_fc1", 2],
      :predation_word => ["\\n<Leecubus>I'll give you an upset stomach...!", "leeccubus_fc1", 2],
      :incontinence_word => ["\\n<Leecubus>D-don't look at me...!", "leeccubus_fc1", 2],
      :premortal_graphic => "50_leeccubus_st03",
    },
    696 => { # クィーンエヴァ
      :dead_word => ["\\n<Queen Eva>Why me...?!\nWhy is this always happening to me...?!", "evaq_fc1", 2],
      :orgasm_word => ["\\n<Queen Eva>I can't believe I'm being forced to come...\nI'm a succubus, damn it...", "evaq_fc1", 2],
      :predation_word => ["\\n<Queen Eva>Stop! If you're going to eat someone, eat someone else... Nooooo!", "evaq_fc1", 2],
      :incontinence_word => ["\\n<Queen Eva>Don't look! Don't look...\nUrhg...", "evaq_fc1", 2],
      :premortal_graphic => "80_evaq_st03",
    },
    697 => { # バフォメット
      :dead_word => ["\\n<Baphomet>I shall return to Hades...", "baphomet_fc1", 2],
      :orgasm_word => ["\\n<Baphomet>This pleasure will be unforgettable...", "baphomet_fc1", 2],
      :predation_word => ["\\n<Baphomet>Am I to be food for another...?", "baphomet_fc1", 2],
      :incontinence_word => ["\\n<Baphomet>Are you amused by the sight of me urinating...?", "baphomet_fc1", 2],
      :premortal_graphic => "50_baphomet_st03",
    },
    698 => { # くだん
      :dead_word => ["\\n<Kudan>Kh, have I lost...?", "kudan_fc1", 2],
      :orgasm_word => ["\\n<Kudan>Th-this is... Nooo...", "kudan_fc1", 2],
      :predation_word => ["\\n<Kudan>St-stop... Don't eat me... Hyaaah!", "kudan_fc1", 2],
      :incontinence_word => ["\\n<Kudan>D-don't look... This isn't right!", "kudan_fc1", 2],
      :premortal_graphic => "50_kudan_st03",
    },
    699 => { # ヴェルラウネ
      :dead_word => ["\\n<Velraune>So cruel...", "vellraune_fc1", 2],
      :orgasm_word => ["\\n<Velraune>It feels good...", "vellraune_fc1", 2],
      :predation_word => ["\\n<Velraune>I'm not some medicinal herb... Kyaah!", "vellraune_fc1", 2],
      :incontinence_word => ["\\n<Velraune>My honey is leaking...", "vellraune_fc1", 2],
      :premortal_graphic => "50_vellraune_st03",
    },
    700 => { # ネペンデス
      :dead_word => ["\\n<Nependeath>I loathe violence...", "nependeath_fc1", 2],
      :orgasm_word => ["\\n<Nependeath>To think I'd give into pleasure...", "nependeath_fc1", 2],
      :predation_word => ["\\n<Nependeath>But I'm the one who's supposed to eat others...", "nependeath_fc1", 2],
      :incontinence_word => ["\\n<Nependeath>This is the worst... Uuugh...", "nependeath_fc1", 2],
      :premortal_graphic => "50_nependeath_st03",
    },
    701 => { # 薔薇貴族
      :dead_word => ["\\n<Noble Rose>I despise savages...", "barakizoku_fc1", 2],
      :orgasm_word => ["\\n<Noble Rose>So humiliating... yet it feels wonderful...", "barakizoku_fc1", 1],
      :predation_word => ["\\n<Noble Rose>I'm delicious, aren't I? Just say I'm delicious...", "barakizoku_fc1", 2],
      :incontinence_word => ["\\n<Noble Rose>I-I won't forgive you...for doing this...", "barakizoku_fc1", 2],
      :premortal_graphic => "50_barakizoku_st03",
    },
    702 => { # モルボル娘
      :dead_word => ["\\n<Malboro Girl>Ahh, how frustrating...", "moruboru_fc1", 2],
      :orgasm_word => ["\\n<Malboro Girl>Ahh, it feels good...", "moruboru_fc1", 2],
      :predation_word => ["\\n<Malboro Girl>I thought you'd feel too disgusting to eat me...?", "moruboru_fc1", 2],
      :incontinence_word => ["\\n<Malboro Girl>My breath smells bad, and so does my pee...", "moruboru_fc1", 2],
      :premortal_graphic => "80_moruboru_st03",
    },
    703 => { # 華音の右腕
      :dead_word => ["\\n<Kanon's Right Arm>............", "kanon_fc2", 1],
      :orgasm_word => ["\\n<Kanon's Right Arm>............", "kanon_fc2", 1],
      :predation_word => ["\\n<Kanon's Right Arm>............", "kanon_fc2", 1],
      :incontinence_word => ["\\n<Kanon's Right Arm>............", "kanon_fc2", 1],
      :premortal_graphic => "50_kanon_st12",
    },
    704 => { # 華音の左腕
      :dead_word => ["\\n<Kanon's Left Arm>............", "kanon_fc2", 0],
      :orgasm_word => ["\\n<Kanon's Left Arm>............", "kanon_fc2", 0],
      :predation_word => ["\\n<Kanon's Left Arm>............", "kanon_fc2", 0],
      :incontinence_word => ["\\n<Kanon's Left Arm>............", "kanon_fc2", 0],
      :premortal_graphic => "50_kanon_st11",
    },
    705 => { # 華音
      :dead_word => ["\\n<Kanon>This isn't very fun...", "kanon_fc1", 2],
      :orgasm_word => ["\\n<Kanon>This isn't very fun...", "kanon_fc1", 2],
      :predation_word => ["\\n<Kanon>This isn't very fun...", "kanon_fc1", 2],
      :incontinence_word => ["\\n<Kanon>How embarrassing... Don't look at me.", "kanon_fc1", 2],
      :premortal_graphic => "80_kanon_st03",
    },
    706 => { # ボムスライム
      :dead_word => ["\\n<Bomb Slime>Kh, is this all I can do...?", "bombslime_fc1", 2],
      :orgasm_word => ["\\n<Bomb Slime>Ah, I've been blown away...", "bombslime_fc1", 2],
      :predation_word => ["\\n<Bomb Slime>Won't you explode if you ate me?!", "bombslime_fc1", 2],
      :incontinence_word => ["\\n<Bomb Slime>Crap, don't look... Don't look at me!", "bombslime_fc1", 2],
      :premortal_graphic => "50_bombslime_st03",
    },
    707 => { # リキュルスライム
      :dead_word => ["\\n<Liqueur Slime>Uugh, my body...", "liqurslime_fc1", 2],
      :orgasm_word => ["\\n<Liqueur Slime>This shouldn't be happening...", "liqurslime_fc1", 2],
      :predation_word => ["\\n<Liqueur Slime>All your sicknesses will be cured if you eat me...", "liqurslime_fc1", 2],
      :incontinence_word => ["\\n<Liqueur Slime>Aaah, it's embarrassing...", "liqurslime_fc1", 2],
      :premortal_graphic => "50_liqurslime_st03",
    },
    708 => { # スライムプリンセス
      :dead_word => ["\\n<Slime Princess>Munyuu~! How terrible~!", "slimeprin_fc1", 2],
      :orgasm_word => ["\\n<Slime Princess>I'm going to come~!", "slimeprin_fc1", 2],
      :predation_word => ["\\n<Slime Princess>It's not tasty~!", "slimeprin_fc1", 2],
      :incontinence_word => ["\\n<Slime Princess>This is so indecent~!", "slimeprin_fc1", 2],
      :premortal_graphic => "50_slimeprin_st03",
    },
    709 => { # アスラ
      :dead_word => ["\\n<Ashura>Regretful...", "asura_fc1", 2],
      :orgasm_word => ["\\n<Ashura>What a humiliation...", "asura_fc1", 2],
      :predation_word => ["\\n<Ashura>To eat me, you blasphemous creature...!", "asura_fc1", 2],
      :incontinence_word => ["\\n<Ashura>D-don't look... Ahhh...", "asura_fc1", 2],
      :premortal_graphic => "50_asura_st03",
    },
    710 => { # ギガスライム
      :dead_word => ["\\n<Giga Slime>We are immortal...", "gigaslime_fc1", 2],
      :orgasm_word => ["\\n<Giga Slime>Melting in pleasure...", "gigaslime_fc1", 2],
      :predation_word => ["\\n<Giga Slime>Eating us is futile...", "gigaslime_fc1", 2],
      :incontinence_word => ["\\n<Giga Slime>Urine is also a part of us...", "gigaslime_fc1", 2],
      :premortal_graphic => "80_gigaslime_st01",
    },
    711 => { # 禍撫分裂体
      :dead_word => ["\\n<Kanade Clone>I'm just a split body anyway...", "kanade_fc1", 2],
      :orgasm_word => ["\\n<Kanade Clone>I'm just a split body anyway...", "kanade_fc1", 2],
      :predation_word => ["\\n<Kanade Clone>I must taste quite good...", "kanade_fc1", 2],
      :incontinence_word => ["\\n<Kanade Clone>To think I'd wet myself...", "kanade_fc1", 2],
      :premortal_graphic => "80_kanade_st03",
    },
    712 => { # 禍撫
      :dead_word => ["\\n<Kanade>I won't perish from just this...", "kanade_fc1", 2],
      :orgasm_word => ["\\n<Kanade>  I can't believe it...", "kanade_fc1", 2],
      :predation_word => ["\\n<Kanade>  It must be quite delicious...", "kanade_fc1", 2],
      :incontinence_word => ["\\n<Kanade> I can't believe I leaked ...", "kanade_fc1", 2],
      :premortal_graphic => "80_kanade_st03",
    },
    713 => { # ラミアンナイトメア
      :dead_word => ["\\n<Nightmare Lamia>  Goodbye, see you soon...", "lamia_n_fc1", 0],
      :orgasm_word => ["\\n<Nightmare Lamia>  Ah, it feels good...", "lamia_n_fc1", 0],
      :predation_word => ["\\n<Nightmare Lamia>  Taste it well...", "lamia_n_fc1", 0],
      :incontinence_word => ["\\n<Nightmare Lamia>  Ahaha...hehehehe...", "lamia_n_fc1", 0],
      :premortal_graphic => "80_lamia_n_st01",
    },
    714 => { # ロードメデューサ
      :dead_word => ["\\n<Medusa Lord>  It's not fun at all...", "l_medusa_fc1", 2],
      :orgasm_word => ["\\n<Medusa Lord>  It's not fun to be made to cum...", "l_medusa_fc1", 2],
      :predation_word => ["\\n<Medusa Lord>  Being used as bait is the worst...", "l_medusa_fc1", 2],
      :incontinence_word => ["\\n<Medusa Lord>To wet myself in front of others... Such humiliation...", "l_medusa_fc1", 2],
      :premortal_graphic => "80_l_medusa_st03",
    },
    715 => { # パンドラ
      :dead_word => ["\\n<Pandora>I should have stayed inside the box...", "pandora_fc1", 2],
      :orgasm_word => ["\\n<Pandora>This is miserable... I want to shut myself away...", "pandora_fc1", 2],
      :predation_word => ["\\n<Pandora>D-don't eat me... Ahhh!", "pandora_fc1", 2],
      :incontinence_word => ["\\n<Pandora>Inside the box... I wet myself...", "pandora_fc1", 2],
      :premortal_graphic => "80_pandora_st03",
    },
    716 => { # アリア・ラミア
      :dead_word => ["\\n<Aria Lamia>Ah... Regrettable...", "cirquec_fc4", 2],
      :orgasm_word => ["\\n<Aria Lamia>To succumb to pleasure...", "cirquec_fc4", 2],
      :predation_word => ["\\n<Aria Lamia>Savor it well...", "cirquec_fc4", 2],
      :incontinence_word => ["\\n<Aria Lamia>This indecent appearance... Excuse me...", "cirquec_fc4", 2],
      :premortal_graphic => "80_cirquec_st33",
    },
    717 => { # グリモワール
      :dead_word => ["\\n<Grimoire>The fire is fading...", "grimoire_fc1", 0],
      :orgasm_word => ["\\n<Grimoire>The fire is blazing and then fading away...", "grimoire_fc1", 0],
      :predation_word => ["\\n<Grimoire>I won't be responsible if you get burned...", "grimoire_fc1", 0],
      :incontinence_word => ["\\n<Grimoire>The fire was extinguished by urine... How embarrassing...", "grimoire_fc1", 0],
      :premortal_graphic => "80_grimoire_st01",
    },
    718 => { # ウツボ娘
      :dead_word => ["\\n<Moray Girl>You do terrible things...", "utubom_fc1", 2],
      :orgasm_word => ["\\n<Moray Girl>I came...", "utubom_fc1", 2],
      :predation_word => ["\\n<Moray Girl>Moray eels aren't even tasty...", "utubom_fc1", 2],
      :incontinence_word => ["\\n<Moray Girl>I wet myself... It wouldn't be noticeable underwater.", "utubom_fc1", 2],
      :premortal_graphic => "50_utubom_st03",
    },
    719 => { # アンシェントスキュラ
      :dead_word => ["\\n<Ancient Scylla>Let's call it a day for now...", "ancientscylla_fc1", 2],
      :orgasm_word => ["\\n<Ancient Scylla>Ah, my body is enveloped in pleasure...", "ancientscylla_fc1", 2],
      :predation_word => ["\\n<Ancient Scylla>I won't deny that it's delicious...", "ancientscylla_fc1", 2],
      :incontinence_word => ["\\n<Ancient Scylla>, can you give it to me without looking at it...?", "ancientscylla_fc1", 2],
      :premortal_graphic => "80_ancientscylla_st03",
    },
    720 => { # クィーンスキュラ
      :dead_word => ["\\n<Queen Scylla> Let's leave...", "cirquec_fc6", 2],
      :orgasm_word => ["\\n<Queen Scylla> Ah... it feels so good...", "cirquec_fc6", 2],
      :predation_word => ["\\n<Queen Scylla> Please taste it and eat it...", "cirquec_fc6", 2],
      :incontinence_word => ["\\n<Queen Scylla> I can't show you something like this...", "cirquec_fc6", 2],
      :premortal_graphic => "80_cirquec_st53",
    },
    721 => { # ガタノソア
      :dead_word => ["\\n<Ghatanothoa> It's no good anymore...", "ghatanothoa_fc1", 0],
      :orgasm_word => ["\\n<Ghatanothoa> I feel good...", "ghatanothoa_fc1", 0],
      :predation_word => ["\\n<Ghatanothoa> I'm delicious...?", "ghatanothoa_fc1", 0],
      :incontinence_word => ["\\n<Ghatanothoa> I leaked a lot of ...", "ghatanothoa_fc1", 0],
      :premortal_graphic => "80_ghatanothoa_st01",
    },
    722 => { # アスモデウス
      :dead_word => ["\\n<Asmodeus> Me, in a place like this...", "asmodeus_fc1", 2],
      :orgasm_word => ["\\n<Asmodeus>For me to drown in pleasure...", "asmodeus_fc1", 2],
      :predation_word => ["\\n<Asmodeus>Such an irresistible woman...", "asmodeus_fc1", 2],
      :incontinence_word => ["\\n<Asmodeus>Ah, like this...Hurry, hurry and finish it...", "asmodeus_fc1", 2],
      :premortal_graphic => "80_asmodeus_st03",
    },
    723 => { # ヨルムンガンド
      :dead_word => ["\\n<Jormungandr>For me, in a place like this...", "jormungand_fc1", 2],
      :orgasm_word => ["\\n<Jormungandr>Kuh, to succumb to pleasure...", "jormungand_fc1", 2],
      :predation_word => ["\\n<Jormungandr>You insolent fool... Haaah!", "jormungand_fc1", 2],
      :incontinence_word => ["\\n<Jormungandr>What are you looking at? This is not a spectacle...", "jormungand_fc1", 2],
      :premortal_graphic => "80_jormungand_st03",
    },
    724 => { # 三口あかなめ
      :dead_word => ["\\n<Three-Mouth Akaname>It hurts... I'll stop now!", "s_akaname_fc1", 2],
      :orgasm_word => ["\\n<Three-Mouth Akaname>I'm about to come... Haaah!", "s_akaname_fc1", 2],
      :predation_word => ["\\n<Three-Mouth Akaname>Don't eat me... Nooo!", "s_akaname_fc1", 2],
      :incontinence_word => ["\\n<Three-Mouth Akaname>  Ah... I've teased you...", "s_akaname_fc1", 2],
      :premortal_graphic => "80_s_akaname_st01",
    },
    725 => { # 猫神
      :dead_word => ["\\n<Nekogami>  Meow...", "nekogami_fc1", 1],
      :orgasm_word => ["\\n<Nekogami>  Funyaa...", "nekogami_fc1", 1],
      :predation_word => ["\\n<Nekogami>  Yamelow!　Fnya! !", "nekogami_fc1", 1],
      :incontinence_word => ["\\n<Nekogami>  Meow...", "nekogami_fc1", 1],
      :premortal_graphic => "50_nekogami_st02",
    },
    726 => { # 銀鬼
      :dead_word => ["\\n<Silver Oni>  I'll stop being unreasonable...", "kizin_fc1", 1],
      :orgasm_word => ["\\n<Silver Oni>  It doesn't taste bad...", "kizin_fc1", 1],
      :predation_word => ["\\n<Silver Oni>  Lifespan may be extended...", "kizin_fc1", 1],
      :incontinence_word => ["\\n<Silver Oni>  It's embarrassing... Ugh...", "kizin_fc1", 1],
      :premortal_graphic => "50_kizin_st02",
    },
    727 => { # 陰陽蠍
      :dead_word => ["\\n<Scorpio Taoist>  Today's work is over...", "onmyosasori_fc1", 2],
      :orgasm_word => ["\\n<Scorpio Taoist>This is quite blissful...", "onmyosasori_fc1", 2],
      :predation_word => ["\\n<Scorpio Taoist>Become sustenance...", "onmyosasori_fc1", 2],
      :incontinence_word => ["\\n<Scorpio Taoist>To wet myself, how careless...", "onmyosasori_fc1", 2],
      :premortal_graphic => "50_onmyosasori_st03",
    },
    728 => { # たまも
      :dead_word => ["\\n<Tamamo>Mmm, how careless...", "tamamo_fc1", 3],
      :orgasm_word => ["\\n<Tamamo>Not bad...", "tamamo_fc1", 2],
      :predation_word => ["\\n<Tamamo>Savor it well...", "tamamo_fc1", 3],
      :incontinence_word => ["\\n<Tamamo>I've wet myself...", "tamamo_fc1", 3],
      :premortal_graphic => "80_tamamo_st03",
    },
    729 => { # ケット・シー
      :dead_word => ["\\n<Cait Sith>Gyann!", "caitsith_fc1", 2],
      :orgasm_word => ["\\n<Cait Sith>Funii!", "caitsith_fc1", 2],
      :predation_word => ["\\n<Cait Sith>Stop it! Stop it!", "caitsith_fc1", 2],
      :incontinence_word => ["\\n<Cait Sith>……", "caitsith_fc1", 2],
      :premortal_graphic => "50_caitsith_st03",
    },
    730 => { # ガルフォックス
      :dead_word => ["\\n<Gal Fox>I am broken...", "galfox_fc1", 2],
      :orgasm_word => ["\\n<Gal Fox>I came...", "galfox_fc1", 3],
      :predation_word => ["\\n<Gal Fox>Stop it, I am not food...Ahhh!", "galfox_fc1", 2],
      :incontinence_word => ["\\n<Gal Fox>Look, dont look...at my urination...", "galfox_fc1", 3],
      :premortal_graphic => "80_galfox_st03",
    },
    731 => { # 玉藻
      :dead_word => ["\\n<Tamamo> Oh, that's really interesting...", "tamamo_fc3", 0],
      :orgasm_word => ["\\n<Tamamo> Oh, that's really interesting...", "tamamo_fc3", 0],
      :predation_word => ["\\n<Tamamo> Oh, that's really interesting...", "tamamo_fc3", 0],
      :incontinence_word => ["\\n<Tamamo> Don't look... don't look", "tamamo_fc3", 2],
      :premortal_graphic => "80_tamamo_st63",
    },
    732 => { # ジュラエイビス
      :dead_word => ["\\n<Jura Aevis>It hurts, I'm going to stop...", "juraabis_fc1", 2],
      :orgasm_word => ["\\n<Jura Aevis>That feels so good...", "juraabis_fc1", 2],
      :predation_word => ["\\n<Jura Aevis>I can't believe I'm being eaten like this...!", "juraabis_fc1", 2],
      :incontinence_word => ["\\n<Jura Aevis> Leaking ... it's embarrassing...", "juraabis_fc1", 2],
      :premortal_graphic => "50_juraabis_st03",
    },
    733 => { # マルコシアス娘
      :dead_word => ["\\n<Marchosias Girl> is terrible...", "marchosias_fc1", 2],
      :orgasm_word => ["\\n<Marchosias Girl> I was made to cum...", "marchosias_fc1", 2],
      :predation_word => ["\\n<Marchosias Girl> Stop, don't eat...!", "marchosias_fc1", 2],
      :incontinence_word => ["\\n<Marchosias Girl> I'm sorry...", "marchosias_fc1", 2],
      :premortal_graphic => "50_marchosias_st03",
    },
    734 => { # アルケオプテリクス
      :dead_word => ["\\n<Archeopteryx> I don't like this...", "a_pterix_fc1", 2],
      :orgasm_word => ["\\n<Archeopteryx> Ah... it feels good...", "a_pterix_fc1", 2],
      :predation_word => ["\\n<Archeopteryx> Now we can be together...", "a_pterix_fc1", 1],
      :incontinence_word => ["\\n<Archeopteryx> My friends... are gone...", "a_pterix_fc1", 2],
      :premortal_graphic => "80_a_pterix_st03",
    },
    735 => { # クィーンハーピー
      :dead_word => ["\\n<Queen Harpy> I can't believe I'm going to lose...", "cirquec_fc5", 2],
      :orgasm_word => ["\\n<Queen Harpy>To be made to come like this...", "cirquec_fc5", 2],
      :predation_word => ["\\n<Queen Harpy>To be eaten... how disgraceful...", "cirquec_fc5", 2],
      :incontinence_word => ["\\n<Queen Harpy>Such humiliation... I will never forgive this...", "cirquec_fc5", 2],
      :premortal_graphic => "80_cirquec_st43",
    },
    736 => { # ローキュバス
      :dead_word => ["\\n<Loccubus>Such terrible violence...", "loccubus_fc1", 2],
      :orgasm_word => ["\\n<Loccubus>Such humiliation... d-damn you...", "loccubus_fc1", 2],
      :predation_word => ["\\n<Loccubus>I may be tasty, but spare me from being eaten... gyah!", "loccubus_fc1", 2],
      :incontinence_word => ["\\n<Loccubus>Don't look... don't look at me...", "loccubus_fc1", 2],
      :premortal_graphic => "50_loccubus_st03",
    },
    737 => { # テスタロッサ
      :dead_word => ["\\n<Testarossa>Damn, I was careless...", "testarossa_fc1", 2],
      :orgasm_word => ["\\n<Testarossa>It feels good, but it's humiliating...", "testarossa_fc1", 2],
      :predation_word => ["\\n<Testarossa>Savor the taste of this exquisite flesh...", "testarossa_fc1", 2],
      :incontinence_word => ["\\n<Testarossa>My urine has value...", "testarossa_fc1", 2],
      :premortal_graphic => "50_testarossa_st03",
    },
    738 => { # 上級海賊マーメイド
      :dead_word => ["\\n<Elite Pirate Mermaid>I'm sorry for being useless...", "ek_mermaid_fc1", 2],
      :orgasm_word => ["\\n<Elite Pirate Mermaid>It feels too good...", "ek_mermaid_fc1", 2],
      :predation_word => ["\\n<Elite Pirate Mermaid>I think it must be delicious...", "ek_mermaid_fc1", 2],
      :incontinence_word => ["\\n<Elite Pirate Mermaid>Ah, it's embarrassing... don't look...", "ek_mermaid_fc1", 2],
      :premortal_graphic => "50_ek_mermaid_st03",
    },
    739 => { # グレイトマーマン
      :dead_word => ["\\n<Great Merman>Why is this happening to me...", "greatmarman_fc1", 2],
      :orgasm_word => ["\\n<Great Merman>Such humiliation...", "greatmarman_fc1", 2],
      :predation_word => ["\\n<Great Merman>The horn will pierce you...!", "greatmarman_fc1", 2],
      :incontinence_word => ["\\n<Great Merman>It wouldn't be noticeable underwater...", "greatmarman_fc1", 2],
      :premortal_graphic => "50_greatmarman_st03",
    },
    740 => { # ロザ
      :dead_word => ["\\n<Roza>You're quite entertaining...", "cirquec_fc3", 2],
      :orgasm_word => ["\\n<Roza>You're quite entertaining...", "cirquec_fc3", 2],
      :predation_word => ["\\n<Roza>It must be quite delicious...", "cirquec_fc3", 2],
      :incontinence_word => ["\\n<Roza>I can't show this to my subordinates...", "cirquec_fc3", 2],
      :premortal_graphic => "80_cirquec_st23",
    },
    741 => { # ロザ
      :dead_word => ["\\n<Roza>I'm completely defeated...", "cirquec_fc3", 2],
      :orgasm_word => ["\\n<Roza>You're quite entertaining...", "cirquec_fc3", 2],
      :predation_word => ["\\n<Roza>It must be quite delicious...", "cirquec_fc3", 2],
      :incontinence_word => ["\\n<Roza>I can't show this to my subordinates...", "cirquec_fc3", 2],
      :premortal_graphic => "80_cirquec_st23",
    },
    742 => { # ギガドライアド
      :dead_word => ["\\n<Giga Dryad>It hurts...", "gigadryad_fc1", 0],
      :orgasm_word => ["\\n<Giga Dryad>It feels good...", "gigadryad_fc1", 0],
      :predation_word => ["\\n<Giga Dryad>Vegetarian...", "gigadryad_fc1", 0],
      :incontinence_word => ["\\n<Giga Dryad>How embarrassing...", "gigadryad_fc1", 0],
      :premortal_graphic => "80_gigadryad_st01",
    },
    743 => { # アンブロシア
      :dead_word => ["\\n<Ambrosia>.........................", "ambrosia_fc1", 0],
      :orgasm_word => ["\\n<Ambrosia>.........................", "ambrosia_fc1", 0],
      :predation_word => ["\\n<Ambrosia>.........................", "ambrosia_fc1", 0],
      :incontinence_word => ["\\n<Ambrosia>.........................", "ambrosia_fc1", 0],
      :premortal_graphic => "80_ambrosia_st01",
    },
    744 => { # シヴァ
      :dead_word => ["\\n<Shiva>I can't believe I was careless...", "siva_fc1", 2],
      :orgasm_word => ["\\n<Shiva>I can't believe I'm ascending...", "siva_fc1", 2],
      :predation_word => ["\\n<Shiva> What does it mean to eat me...", "siva_fc1", 2],
      :incontinence_word => ["\\n<Shiva> Don't look at ... If you look, I'll kill you...!", "siva_fc1", 2],
      :premortal_graphic => "80_siva_st03",
    },
    745 => { # アルキュバス
      :dead_word => ["\\n<Arcubus> I'm going to take a break now...", "arucubuss_fc1", 2],
      :orgasm_word => ["\\n<Arcubus> I'm a succubus too...", "arucubuss_fc1", 2],
      :predation_word => ["\\n<Arcubus> It tastes like medicine...! ?", "arucubuss_fc1", 2],
      :incontinence_word => ["\\n<Arcubus> Are you planning to use my urine as medicine...?", "arucubuss_fc1", 2],
      :premortal_graphic => "50_arucubuss_st03",
    },
    746 => { # レスキュバス
      :dead_word => ["\\n<Lescubus> Hey, isn't that terrible...! ?", "lesscubuss_fc1", 2],
      :orgasm_word => ["\\n<Lescubus> Even though I'm a succubus, it's humiliating...", "lesscubuss_fc1", 2],
      :predation_word => ["\\n<Lescubus> I'll do something good for you, so don't eat it...!", "lesscubuss_fc1", 2],
      :incontinence_word => ["\\n<Lescubus> This is the worst... Uuuu...", "lesscubuss_fc1", 2],
      :premortal_graphic => "50_lesscubuss_st03",
    },
    747 => { # グラナバス
      :dead_word => ["\\n<Granabass>I hate violence...", "granabass_fc1", 0],
      :orgasm_word => ["\\n<Granabass>This is also pleasure... Ufufu.", "granabass_fc1", 0],
      :predation_word => ["\\n<Granabass>I have a good figure, don't I? Ufufu...", "granabass_fc1", 0],
      :incontinence_word => ["\\n<Granabass>Look at my miserable appearance even more...", "granabass_fc1", 0],
      :premortal_graphic => "50_granabass_st01",
    },
    748 => { # クロム
      :dead_word => ["\\n<Chrome>I can't take it anymore...", "chrom_fc1", 6],
      :orgasm_word => ["\\n<Chrome>N-no... I'm going to... Hauuuu...", "chrom_fc1", 5],
      :predation_word => ["\\n<Chrome>D-don't eat me... Hyaaaaa!", "chrom_fc1", 6],
      :incontinence_word => ["\\n<Chrome>I-I'm going to wet myself... So embarrassing... Ahhh...", "chrom_fc1", 6],
      :premortal_graphic => "50_chrom_st43",
    },
    749 => { # ユー
      :dead_word => ["\\n<Yu>That's so mean~!", "chromg_fc1", 2],
      :orgasm_word => ["\\n<Yu>It feels good, but...", "chromg_fc1", 2],
      :predation_word => ["\\n<Yu>Don't eat me~!", "chromg_fc1", 2],
      :incontinence_word => ["\\n<Yu>I wet myself...", "chromg_fc1", 2],
      :premortal_graphic => "50_chromg_st03",
    },
    750 => { # レイ
      :dead_word => ["\\n<Rei>I can't take it anymore, I'm going home...", "chromg_fc2", 1],
      :orgasm_word => ["\\n<Rei>I came...", "chromg_fc2", 1],
      :predation_word => ["\\n<Rei>I don't want to be eaten...", "chromg_fc2", 1],
      :incontinence_word => ["\\n<Rei>This is the worst... Just the worst...", "chromg_fc2", 1],
      :premortal_graphic => "50_chromg_st13",
    },
    751 => { # 魅凪
      :dead_word => ["\\n<Minagi>That power... It's a threat to us as well.", "minagi_fc1", 2],
      :orgasm_word => ["\\n<Minagi>That power... It's a threat to us as well.", "minagi_fc1", 2],
      :predation_word => ["\\n<Minagi>That power... It's a threat to us as well.", "minagi_fc1", 2],
      :incontinence_word => ["\\n<Minagi>To be seen like this, it's a disgrace...", "minagi_fc1", 2],
      :premortal_graphic => "80_minagi_st03",
    },
    752 => { # アリスフィーズ10世
      :dead_word => ["\\n<Alipheese the 10th>I need to rest now...", "alice10th_fc1", 2],
      :orgasm_word => ["\\n<Alipheese the 10th>I-I'm coming...", "alice10th_fc1", 3],
      :predation_word => ["\\n<Alipheese the 10th>Don't eat me!", "alice10th_fc1", 4],
      :incontinence_word => ["\\n<Alipheese the 10th>Hauu... it leaked...", "alice10th_fc1", 6],
      :premortal_graphic => "80_alice10th_st03",
    },
    753 => { # ハーゲンベック
      :dead_word => ["\\n<Hargenbeck>This is the end~!", "hargenbeck_fc2", 2],
      :orgasm_word => ["\\n<Hargenbeck>This is the ascension~!", "hargenbeck_fc2", 2],
      :predation_word => ["\\n<Hargenbeck>Don't eat the dolls~!", "hargenbeck_fc2", 2],
      :incontinence_word => ["\\n<Hargenbeck>This is not a performance...", "hargenbeck_fc2", 2],
      :premortal_graphic => "50_hargenbeck_st23",
    },
    754 => { # ベック・ザ・ビースト
      :dead_word => ["\\n<Beck the Beast>........................", "hargenbeck_fc1", 2],
      :orgasm_word => ["\\n<Beck the Beast>........................", "hargenbeck_fc1", 2],
      :predation_word => ["\\n<Beck the Beast>........................", "hargenbeck_fc1", 2],
      :incontinence_word => ["\\n<Beck the Beast>........................", "hargenbeck_fc1", 2],
      :premortal_graphic => "50_hargenbeck_st03",
    },
    755 => { # サンタマリア
      :dead_word => ["\\n<Santa Maria>Let's go to the presence of God...", "santamaria_fc2", 2],
      :orgasm_word => ["\\n<Santa Maria>I have never known such pleasure...", "santamaria_fc2", 2],
      :predation_word => ["\\n<Santa Maria>God, help me... Ahhh!", "santamaria_fc2", 2],
      :incontinence_word => ["\\n<Santa Maria>Ah, how embarrassing...", "santamaria_fc2", 2],
      :premortal_graphic => "50_santamaria_st13",
    },
    756 => { # セントメイデン
      :dead_word => ["\\n<Saint Maiden>....................", "santamaria_fc1", 0],
      :orgasm_word => ["\\n<Saint Maiden>....................", "santamaria_fc1", 0],
      :predation_word => ["\\n<Saint Maiden>....................", "santamaria_fc1", 0],
      :incontinence_word => ["\\n<Saint Maiden>....................", "santamaria_fc1", 0],
      :premortal_graphic => "50_santamaria_st01",
    },
    757 => { # 切り裂きエリス
      :dead_word => ["\\n<Slicing Ellis>Huh, my body...? My body, my body...?", "elis_fc1", 2],
      :orgasm_word => ["\\n<Slicing Ellis>I'm coming, coming... I'm coming...", "elis_fc1", 2],
      :predation_word => ["\\n<Slicing Ellis>I'm not tasty...", "elis_fc1", 2],
      :incontinence_word => ["\\n<Slicing Ellis>Oil, all gooey...", "elis_fc1", 2],
      :premortal_graphic => "50_elis_st03",
    },
    758 => { # アリスフィーズ7世
      :dead_word => ["\\n<Alipheese the 7th>I don't feel like doing any more...", "alice7th_fc1", 2],
      :orgasm_word => ["\\n<Alipheese the 7th>I enjoyed the pleasure...", "alice7th_fc1", 4],
      :predation_word => ["\\n<Alipheese the 7th>Isn't it delicious, ufufu...", "alice7th_fc1", 3],
      :incontinence_word => ["\\n<Alipheese the 7th>Oh, excuse me...", "alice7th_fc1", 2],
      :premortal_graphic => "80_alice7th_st03",
    },
    759 => { # シャウトマータ
      :dead_word => ["\\n<Shout Mata> Unable to act...", "shoutmata_fc1", 2],
      :orgasm_word => ["\\n<Shout Mata> Pleasure voltage, exceeding limits...", "shoutmata_fc1", 2],
      :predation_word => ["\\n<Shout Mata> This item is not for consumption! This item is not for consumption!", "shoutmata_fc1", 2],
      :incontinence_word => ["\\n<Shout Mata> Oil leakage occurring...", "shoutmata_fc1", 2],
      :premortal_graphic => "50_shoutmata_st03",
    },
    760 => { # ジャイアントセーラ
      :dead_word => ["\\n<Giant Serra> No way~!", "giantsarah_fc1", 2],
      :orgasm_word => ["\\n<Giant Serra> It's embarrassing to come~!", "giantsarah_fc1", 2],
      :predation_word => ["\\n<Giant Serra> I don't want to be eaten~!", "giantsarah_fc1", 2],
      :incontinence_word => ["\\n<Giant Serra> I won't wet myself~!", "giantsarah_fc1", 2],
      :premortal_graphic => "80_giantsarah_st03",
    },
    761 => { # アリスフィーズ11+12世
      :dead_word => ["\\n<Alipheese the 11+12th> This is as far as it goes...", "alice11th12th_fc1", 2],
      :orgasm_word => ["\\n<Alipheese the 11+12th> It's so good...", "alice11th12th_fc1", 2],
      :predation_word => ["\\n<Alipheese the 11+12th>Are you going to make me your prey? Ahaha...", "alice11th12th_fc1", 2],
      :incontinence_word => ["\\n<Alipheese the 11+12th>Ahahahaha...", "alice11th12th_fc1", 2],
      :premortal_graphic => "80_alice11th12th_st03",
    },
    762 => { # パイズリ人形Mk.2
      :dead_word => ["\\n<Paizuri Doll Mk.2>........................", "paizuridoll2_fc1", 2],
      :orgasm_word => ["\\n<Paizuri Doll Mk.2>........................", "paizuridoll2_fc1", 2],
      :predation_word => ["\\n<Paizuri Doll Mk.2>........................", "paizuridoll2_fc1", 2],
      :incontinence_word => ["\\n<Paizuri Doll Mk.2>........................", "paizuridoll2_fc1", 2],
      :premortal_graphic => "50_paizuridoll2_st03",
    },
    763 => { # ラブマータ
      :dead_word => ["\\n<Love Marta>Can't you enjoy it anymore...?", "lovemata_fc1", 2],
      :orgasm_word => ["\\n<Love Marta>I can't believe I'm the one who came...", "lovemata_fc1", 2],
      :predation_word => ["\\n<Love Marta>There's something more fun than eating...Aaaaaah...", "lovemata_fc1", 2],
      :incontinence_word => ["\\n<Love Marta>You're seeing my embarrassing parts...", "lovemata_fc1", 2],
      :premortal_graphic => "50_lovemata_st03",
    },
    764 => { # アリスフィーズ9世
      :dead_word => ["\\n<Alipheese the 9th>With this... it's over...", "alice9th_fc1", 2],
      :orgasm_word => ["\\n<Alipheese the 9th>Ah, it feels so good...", "alice9th_fc1", 2],
      :predation_word => ["\\n<Alipheese the 9th>Don't eat me... Ah...", "alice9th_fc1", 2],
      :incontinence_word => ["\\n<Alipheese the 9th>Don't look at me... Ah...", "alice9th_fc1", 2],
      :premortal_graphic => "80_alice9th_st03",
    },
    765 => { # ブラヴァツキー
      :dead_word => ["\\n<Blavatsky>Goodbye...", "blavatsky_fc1", 2],
      :orgasm_word => ["\\n<Blavatsky>I'm going to come...", "blavatsky_fc1", 2],
      :predation_word => ["\\n<Blavatsky>No...", "blavatsky_fc1", 2],
      :incontinence_word => ["\\n<Blavatsky>N-No...", "blavatsky_fc1", 2],
      :premortal_graphic => "50_blavatsky_st03",
    },
    766 => { # アリスフィーズ6世
      :dead_word => ["\\n<Alipheese the 6th>What a violent person...", "alice6th_fc1", 2],
      :orgasm_word => ["\\n<Alipheese the 6th>Will I succumb to pleasure...", "alice6th_fc1", 2],
      :predation_word => ["\\n<Alipheese the 6th>D-Don't eat me...!", "alice6th_fc1", 2],
      :incontinence_word => ["\\n<Alipheese the 6th>Ah, I'm going to wet myself...", "alice6th_fc1", 2],
      :premortal_graphic => "80_alice6th_st03",
    },
    767 => { # 決戦人型兵器アグニ
      :dead_word => ["\\n<Humanoid Decisive Weapon Agni>Unable to continue combat...", "aguni_fc1", 2],
      :orgasm_word => ["\\n<Humanoid Decisive Weapon Agni> climax... unable to act...", "aguni_fc1", 2],
      :predation_word => ["\\n<Humanoid Decisive Weapon Agni> Don't eat it...!  I'm a weapon...! !", "aguni_fc1", 2],
      :incontinence_word => ["\\n<Humanoid Decisive Weapon Agni> Even though I am a weapon...  I can't believe you leaked something like this...", "aguni_fc1", 2],
      :premortal_graphic => "80_aguni_st03",
    },
    768 => { # 快楽人形・雅姫
      :dead_word => ["\\n<Pleasure Doll Miyabihime> I can't get enough of it...", "miyabihime_fc1", 2],
      :orgasm_word => ["\\n<Pleasure Doll Miyabihime> Let me die first...", "miyabihime_fc1", 2],
      :predation_word => ["\\n<Pleasure Doll Miyabihime> It's not even delicious...", "miyabihime_fc1", 2],
      :incontinence_word => ["\\n<Pleasure Doll Miyabihime> This kind of thing about the concubine...  I don't see it...", "miyabihime_fc1", 2],
      :premortal_graphic => "80_miyabihime_st03",
    },
    769 => { # 影紬
      :dead_word => ["\\n<Kagetsumugi> Is this body also at its limit...?", "kagetumugi_fc1", 2],
      :orgasm_word => ["\\n<Kagetsumugi> The pleasure receptor function becomes an enemy...", "kagetumugi_fc1", 2],
      :predation_word => ["\\n<Kagetsumugi> If I could eat it anyway, I would have used delicious ingredients...", "kagetumugi_fc1", 2],
      :incontinence_word => ["\\n<Kagetsumugi>To think my bodily fluids would leak…", "kagetumugi_fc1", 2],
      :premortal_graphic => "50_kagetumugi_st03",
    },
    770 => { # 黄泉蜘蛛
      :dead_word => ["\\n<Yomigumo>……………………", "kagetumugi_fc2", 2],
      :orgasm_word => ["\\n<Yomigumo>……………………", "kagetumugi_fc2", 2],
      :predation_word => ["\\n<Yomigumo>……………………", "kagetumugi_fc2", 2],
      :incontinence_word => ["\\n<Yomigumo>……………………", "kagetumugi_fc2", 2],
      :premortal_graphic => "50_kagetumugi_st13",
    },
    771 => { # 魁狐々
      :dead_word => ["\\n<Kaiko Kitsune>……………………", "kagetumugi_fc3", 2],
      :orgasm_word => ["\\n<Kaiko Kitsune>……………………", "kagetumugi_fc3", 2],
      :predation_word => ["\\n<Kaiko Kitsune>……………………", "kagetumugi_fc3", 2],
      :incontinence_word => ["\\n<Kaiko Kitsune>……………………", "kagetumugi_fc3", 2],
      :premortal_graphic => "50_kagetumugi_st23",
    },
    772 => { # 蘭天狗
      :dead_word => ["\\n<Rantengu>……………………", "kagetumugi_fc4", 2],
      :orgasm_word => ["\\n<Rantengu>……………………", "kagetumugi_fc4", 2],
      :predation_word => ["\\n<Rantengu>……………………", "kagetumugi_fc4", 2],
      :incontinence_word => ["\\n<Rantengu>……………………", "kagetumugi_fc4", 2],
      :premortal_graphic => "50_kagetumugi_st33",
    },
    773 => { # ナンキュバス
      :dead_word => ["\\n<Nancubus>It's no use…", "nanccubus_fc1", 2],
      :orgasm_word => ["\\n<Nancubus>Ah, I'm going to cum…", "nanccubus_fc1", 2],
      :predation_word => ["\\n<Nancubus>S-stop eating me… Kya!", "nanccubus_fc1", 2],
      :incontinence_word => ["\\n<Nancubus>This is too embarrassing…", "nanccubus_fc1", 2],
      :premortal_graphic => "50_nanccubus_st03",
    },
    774 => { # パビルサグ
      :dead_word => ["\\n<Pabilsag>Is this the end of my role…", "pabilsag_fc1", 2],
      :orgasm_word => ["\\n<Pabilsag>Am I to succumb to reproductive desire…", "pabilsag_fc1", 2],
      :predation_word => ["\\n<Pabilsag> I'm going to eat all sorts of crazy things...", "pabilsag_fc1", 2],
      :incontinence_word => ["\\n<Pabilsag> My concubine is like this... Don't look at me, don't look at me...", "pabilsag_fc1", 2],
      :premortal_graphic => "50_pabilsag_st03",
    },
    775 => { # マンイーター
      :dead_word => ["\\n<Maneater> It's over!", "maneater_fc1", 2],
      :orgasm_word => ["\\n<Maneater> I'm going to cum!", "maneater_fc1", 2],
      :predation_word => ["\\n<Maneater> Don't eat it!", "maneater_fc1", 2],
      :incontinence_word => ["\\n<Maneater> Omorashi, year!", "maneater_fc1", 2],
      :premortal_graphic => "50_maneater_st03",
    },
    776 => { # 古代竜
      :dead_word => ["\\n<Ancient Dragon> In a place like this...", "kodairyu_fc1", 2],
      :orgasm_word => ["\\n<Ancient Dragon> Gugh, I can't believe it ends here...", "kodairyu_fc1", 2],
      :predation_word => ["\\n<Ancient Dragon> How strong you are to try to eat me...!", "kodairyu_fc1", 2],
      :incontinence_word => ["\\n<Ancient Dragon> Such humiliation... Uuuu...", "kodairyu_fc1", 2],
      :premortal_graphic => "50_kodairyu_st03",
    },
    777 => { # クィーンエヴァ
      :dead_word => ["\\n<Queen Eva>  Why am I...!  It's just me like this...!", "evaq_fc1", 2],
      :orgasm_word => ["\\n<Queen Eva>  I'm a succubus...  It's embarrassing to be made to cum...", "evaq_fc1", 2],
      :predation_word => ["\\n<Queen Eva>  Stop it, if you're going to eat it, choose someone else...  Noooo...!", "evaq_fc1", 2],
      :incontinence_word => ["\\n<Queen Eva> Don't look at ! Don't look at me...Uuuu......", "evaq_fc1", 2],
      :premortal_graphic => "80_evaq_st03",
    },
    778 => { # ロア
      :dead_word => ["\\n<Loa>Is it okay to break now? Kunya~.", "loa_fc1", 0],
      :orgasm_word => ["\\n<Loa>It feels so good, I'm going to collapse. Kunya~.", "loa_fc1", 0],
      :predation_word => ["\\n<Loa>If you eat mud, you'll ruin your body, you know? You'll ruin it.", "loa_fc1", 0],
      :incontinence_word => ["\\n<Loa>I leaked, I leaked...", "loa_fc1", 0],
      :premortal_graphic => "80_loa_st01",
    },
    779 => { # 蛭蟲分裂体
      :dead_word => ["\\n<Hiruko Clone>Isn't it quite amusing...", "hiruko_fc1", 2],
      :orgasm_word => ["\\n<Hiruko Clone>Pleasure is also a feast...", "hiruko_fc1", 2],
      :predation_word => ["\\n<Hiruko Clone>You would eat me? Foolish...", "hiruko_fc1", 2],
      :incontinence_word => ["\\n<Hiruko Clone>Don't make eye contact, or I'll devour you...", "hiruko_fc1", 2],
      :premortal_graphic => "80_hiruko_st03",
    },
    780 => { # メフィスト
      :dead_word => ["\\n<Mephisto>Was my power not enough...", "mefist_fc3", 2],
      :orgasm_word => ["\\n<Mephisto>To make me climax...", "mefist_fc3", 2],
      :predation_word => ["\\n<Mephisto> I can't believe I'm being preyed upon...", "mefist_fc3", 2],
      :incontinence_word => ["\\n<Mephisto> I can no longer teach at this stage...", "mefist_fc3", 2],
      :premortal_graphic => "80_mefist_st33",
    },
    781 => { # 魔列車
      :dead_word => ["\\n<Monster Train> Emergency stop...", "niprell_fc1", 2],
      :orgasm_word => ["\\n<Monster Train> Unknown pleasure, unknown pleasure...", "niprell_fc1", 2],
      :predation_word => ["\\n<Monster Train> I will go straight into your stomach...", "niprell_fc1", 2],
      :incontinence_word => ["\\n<Monster Train> Urine will be discharged, please be careful...", "niprell_fc1", 2],
      :premortal_graphic => "80_niprell_st03",
    },
    782 => { # ハイバフォメット
      :dead_word => ["\\n<High Baphomet> Be more gentle...", "high_baphomet_fc1", 2],
      :orgasm_word => ["\\n<High Baphomet> is embarrassing...", "high_baphomet_fc1", 2],
      :predation_word => ["\\n<High Baphomet> I'm going to curse you... Hey!", "high_baphomet_fc1", 2],
      :incontinence_word => ["\\n<High Baphomet> Damn, this is humiliating...", "high_baphomet_fc1", 2],
      :premortal_graphic => "50_high_baphomet_st03",
    },
    783 => { # ローグエルフ
      :dead_word => ["\\n<Rogue Elf>Violence, no way!!", "rogueelf_fc1", 2],
      :orgasm_word => ["\\n<Rogue Elf>It feels good, but it's the worst!", "rogueelf_fc1", 2],
      :predation_word => ["\\n<Rogue Elf>N-no... Kyaa!!", "rogueelf_fc1", 2],
      :incontinence_word => ["\\n<Rogue Elf>Don't look at me... sniff.", "rogueelf_fc1", 2],
      :premortal_graphic => "50_rogueelf_st03",
    },
    784 => { # 蛭蟲
      :dead_word => ["\\n<Hiruko>You're more capable than I expected...", "hiruko_fc1", 2],
      :orgasm_word => ["\\n<Hiruko>You're more capable than I expected...", "hiruko_fc1", 2],
      :predation_word => ["\\n<Hiruko>You're more capable than I expected...", "hiruko_fc1", 2],
      :incontinence_word => ["\\n<Hiruko>Don't make eye contact, or you'll be devoured...", "hiruko_fc1", 2],
      :premortal_graphic => "80_hiruko_st03",
    },
    785 => { # 量産型魔王人形III型
      :dead_word => ["\\n<Mass-Produced Alipheese the 3rd>Anyway... I'm doomed...", "alice3th_fc1", 2],
      :orgasm_word => ["\\n<Mass-Produced Alipheese the 3rd>To be exhausted... it's humiliating...", "alice3th_fc1", 4],
      :predation_word => ["\\n<Mass-Produced Alipheese the 3rd>Devour me... as you please...", "alice3th_fc1", 2],
      :incontinence_word => ["\\n<Mass-Produced Alipheese the 3rd>Humiliation...", "alice3th_fc1", 4],
      :premortal_graphic => "80_alice3th_st03",
    },
    786 => { # 量産型魔王人形IV型
      :dead_word => ["\\n<Mass-Produced Alipheese the 4th> I'll take a rest now...", "alice4th_fc1", 2],
      :orgasm_word => ["\\n<Mass-Produced Alipheese the 4th> My body can't move from the pleasure...", "alice4th_fc1", 2],
      :predation_word => ["\\n<Mass-Produced Alipheese the 4th> You're quite peculiar...", "alice4th_fc1", 2],
      :incontinence_word => ["\\n<Mass-Produced Alipheese the 4th> I feel so pathetic...", "alice4th_fc1", 2],
      :premortal_graphic => "80_alice4th_st03",
    },
    787 => { # 量産型魔王人形V型
      :dead_word => ["\\n<Mass-Produced Alipheese the 5th> I don't want this anymore, I'm going home!", "alice5th_fc1", 3],
      :orgasm_word => ["\\n<Mass-Produced Alipheese the 5th> It feels good, but it's embarrassing...", "alice5th_fc1", 2],
      :predation_word => ["\\n<Mass-Produced Alipheese the 5th> Are you going to eat me? I don't like that.", "alice5th_fc1", 3],
      :incontinence_word => ["\\n<Mass-Produced Alipheese the 5th> I just spilled some water.  It's not an accident...", "alice5th_fc1", 4],
      :premortal_graphic => "80_alice5th_st03",
    },
    788 => { # 量産型魔王人形VI型
      :dead_word => ["\\n<Mass-Produced Alipheese the 6th> How rough you are...", "alice6th_fc1", 2],
      :orgasm_word => ["\\n<Mass-Produced Alipheese the 6th> To be ended by pleasure...", "alice6th_fc1", 2],
      :predation_word => ["\\n<Mass-Produced Alipheese the 6th> Ugh, don't eat me...!", "alice6th_fc1", 2],
      :incontinence_word => ["\\n<Mass-Produced Alipheese the 6th> Ah, I'm leaking urine...", "alice6th_fc1", 2],
      :premortal_graphic => "80_alice6th_st03",
    },
    789 => { # 量産型魔王人形VII型
      :dead_word => ["\\n<Mass-Produced Alipheese the 7th> I don't feel like continuing any further...", "alice7th_fc1", 2],
      :orgasm_word => ["\\n<Mass-Produced Alipheese the 7th> I've enjoyed the pleasure...", "alice7th_fc1", 4],
      :predation_word => ["\\n<Mass-Produced Alipheese the 7th> Is it delicious? Ufufu...", "alice7th_fc1", 3],
      :incontinence_word => ["\\n<Mass-Produced Alipheese the 7th> Oh, my apologies...", "alice7th_fc1", 2],
      :premortal_graphic => "80_alice7th_st03",
    },
    790 => { # 量産型魔王人形IX型
      :dead_word => ["\\n<Mass-Produced Alipheese the 9th> With this... it's over...", "alice9th_fc1", 2],
      :orgasm_word => ["\\n<Mass-Produced Alipheese the 9th> Ah, it feels so good...", "alice9th_fc1", 2],
      :predation_word => ["\\n<Mass-Produced Alipheese the 9th> Don't eat me... Ah...", "alice9th_fc1", 2],
      :incontinence_word => ["\\n<Mass-Produced Alipheese the 9th> Don't look at me... Ah...", "alice9th_fc1", 2],
      :premortal_graphic => "80_alice9th_st03",
    },
    791 => { # 量産型魔王人形X型
      :dead_word => ["\\n<Mass-Produced Alipheese the 10th>I need to rest now...", "alice10th_fc1", 2],
      :orgasm_word => ["\\n<Mass-Produced Alipheese the 10th>I-I'm coming...", "alice10th_fc1", 3],
      :predation_word => ["\\n<Mass-Produced Alipheese the 10th>Don't eat me!", "alice10th_fc1", 4],
      :incontinence_word => ["\\n<Mass-Produced Alipheese the 10th>Hauu... it leaked...", "alice10th_fc1", 6],
      :premortal_graphic => "80_alice10th_st03",
    },
    792 => { # 量産型魔王人形XI＋XII型
      :dead_word => ["\\n<Mass-Produced Alipheese the 11+12th>This is as far as it goes...", "alice11th12th_fc1", 2],
      :orgasm_word => ["\\n<Mass-Produced Alipheese the 11+12th>It's so good...", "alice11th12th_fc1", 2],
      :predation_word => ["\\n<Mass-Produced Alipheese the 11+12th>Are you going to make me your prey? Ahaha...", "alice11th12th_fc1", 2],
      :incontinence_word => ["\\n<Mass-Produced Alipheese the 11+12th>Ahahahaha...", "alice11th12th_fc1", 2],
      :premortal_graphic => "80_alice11th12th_st03",
    },
    793 => { # 量産型魔王人形XIII型
      :dead_word => ["\\n<Mass-Produced Alipheese the 13th>Don't mess up the garden...", "alice13th_fc1", 2],
      :orgasm_word => ["\\n<Mass-Produced Alipheese the 13th>I can't resist sweet pleasure...", "alice13th_fc1", 2],
      :predation_word => ["\\n<Mass-Produced Alipheese the 13th> It's rude to eat a garden...", "alice13th_fc1", 2],
      :incontinence_word => ["\\n<Mass-Produced Alipheese the 13th> Ah, my urine is in the garden...", "alice13th_fc1", 2],
      :premortal_graphic => "80_alice13th_st03",
    },
    794 => { # 量産型魔王人形XIV型
      :dead_word => ["\\n<Mass-Produced Alipheese the 14th> I wonder if I can play with it anymore...?", "alice14th_fc1", 2],
      :orgasm_word => ["\\n<Mass-Produced Alipheese the 14th> Feels good...", "alice14th_fc1", 7],
      :predation_word => ["\\n<Mass-Produced Alipheese the 14th> Eating candy...?  Don't eat me...", "alice14th_fc1", 2],
      :incontinence_word => ["\\n<Mass-Produced Alipheese the 14th> Sorry, I messed up...", "alice14th_fc1", 7],
      :premortal_graphic => "80_alice14th_st03",
    },
    795 => { # 影紬
      :dead_word => ["\\n<Kagetsumugi> Is this body also at its limit...?", "kagetumugi_fc8", 2],
      :orgasm_word => ["\\n<Kagetsumugi> The pleasure receptor function becomes an enemy...", "kagetumugi_fc8", 2],
      :predation_word => ["\\n<Kagetsumugi> If I could eat it anyway, I would have used delicious ingredients...", "kagetumugi_fc8", 2],
      :incontinence_word => ["\\n<Kagetsumugi>To think my bodily fluids would leak…", "kagetumugi_fc8", 2],
      :premortal_graphic => "80_kagetumugi2_st03",
    },
    796 => { # マガツカルラ
      :dead_word => ["\\n<Magatsu-Karura>……………………", "kagetumugi_fc9", 2],
      :orgasm_word => ["\\n<Magatsu-Karura>……………………", "kagetumugi_fc9", 2],
      :predation_word => ["\\n<Magatsu-Karura>……………………", "kagetumugi_fc9", 2],
      :incontinence_word => ["\\n<Magatsu-Karura>……………………", "kagetumugi_fc9", 2],
      :premortal_graphic => "80_kagetumugi2_st13",
    },
    797 => { # 黒のアリス
      :dead_word => ["\\n<Black Alice>Ufufu, isn't it enjoyable...?", "alice8th_fc4", 3],
      :orgasm_word => ["\\n<Black Alice>Ufufu, isn't it enjoyable...?", "alice8th_fc4", 3],
      :predation_word => ["\\n<Black Alice>Ufufu, isn't it enjoyable...?", "alice8th_fc4", 3],
      :incontinence_word => ["\\n<Black Alice>Ah... I wet myself...", "alice8th_fc4", 3],
      :premortal_graphic => "80_alice8th6_st03",
    },
    798 => { # 白兎・虚
      :dead_word => ["\\n<White Rabbit: Void>……………………", "sirousagi_fc2", 0],
      :orgasm_word => ["\\n<White Rabbit: Void>……………………", "sirousagi_fc2", 0],
      :predation_word => ["\\n<White Rabbit: Void>……………………", "sirousagi_fc2", 0],
      :incontinence_word => ["\\n<White Rabbit: Void>……………………", "sirousagi_fc2", 0],
      :premortal_graphic => "80_sirousagi_st21",
    },
    799 => { # 白兎・妄
      :dead_word => ["\\n<White Rabbit: Delusion>……………………", "sirousagi_fc2", 1],
      :orgasm_word => ["\\n<White Rabbit: Delusion>……………………", "sirousagi_fc2", 1],
      :predation_word => ["\\n<White Rabbit: Delusion>……………………", "sirousagi_fc2", 1],
      :incontinence_word => ["\\n<White Rabbit: Delusion>……………………", "sirousagi_fc2", 1],
      :premortal_graphic => "80_sirousagi_st22",
    },
    800 => { # 白兎・沌
      :dead_word => ["\\n<White Rabbit: Chaos>……………………", "sirousagi_fc2", 2],
      :orgasm_word => ["\\n<White Rabbit: Chaos>……………………", "sirousagi_fc2", 2],
      :predation_word => ["\\n<White Rabbit: Chaos>……………………", "sirousagi_fc2", 2],
      :incontinence_word => ["\\n<White Rabbit: Chaos>……………………", "sirousagi_fc2", 2],
      :premortal_graphic => "80_sirousagi_st23",
    },
    801 => { # 死神・虚
      :dead_word => ["\\n<Reaper: Void>……………………", "sinigami_fc2", 0],
      :orgasm_word => ["\\n<Reaper: Void>……………………", "sinigami_fc2", 0],
      :predation_word => ["\\n<Reaper: Void>……………………", "sinigami_fc2", 0],
      :incontinence_word => ["\\n<Reaper: Void>……………………", "sinigami_fc2", 0],
      :premortal_graphic => "80_sinigami_st11",
    },
    802 => { # 死神・妄
      :dead_word => ["\\n<Reaper: Delusion>……………………", "sinigami_fc2", 1],
      :orgasm_word => ["\\n<Reaper: Delusion>……………………", "sinigami_fc2", 1],
      :predation_word => ["\\n<Reaper: Delusion>……………………", "sinigami_fc2", 1],
      :incontinence_word => ["\\n<Reaper: Delusion>……………………", "sinigami_fc2", 1],
      :premortal_graphic => "80_sinigami_st12",
    },
    803 => { # 死神・沌
      :dead_word => ["\\n<Reaper: Chaos>……………………", "sinigami_fc2", 2],
      :orgasm_word => ["\\n<Reaper: Chaos>……………………", "sinigami_fc2", 2],
      :predation_word => ["\\n<Reaper: Chaos>……………………", "sinigami_fc2", 2],
      :incontinence_word => ["\\n<Reaper: Chaos>……………………", "sinigami_fc2", 2],
      :premortal_graphic => "80_sinigami_st13",
    },
    804 => { # 死兎
      :dead_word => ["\\n<Death Rabbit>……………………", "siniusagi_fc1", 0],
      :orgasm_word => ["\\n<Death Rabbit>……………………", "siniusagi_fc1", 0],
      :predation_word => ["\\n<Death Rabbit>……………………", "siniusagi_fc1", 0],
      :incontinence_word => ["\\n<Death Rabbit>……………………", "siniusagi_fc1", 0],
      :premortal_graphic => "80_siniusagi_st01",
    },
    805 => { # ソニアヴィジョン
      :dead_word => ["\\n<Sonya Vision>……………………", "sonia_fc3", 4],
      :orgasm_word => ["\\n<Sonya Vision>……………………", "sonia_fc3", 4],
      :predation_word => ["\\n<Sonya Vision>……………………", "sonia_fc3", 4],
      :incontinence_word => ["\\n<Sonya Vision>……………………", "sonia_fc3", 4],
      :premortal_graphic => "80_sonia_m1_st21",
    },
    806 => { # プロトソニア
      :dead_word => ["\\n<Proto Sonya>……………………", "soniaapoto_fc3", 4],
      :orgasm_word => ["\\n<Proto Sonya>……………………", "soniaapoto_fc3", 4],
      :predation_word => ["\\n<Proto Sonya>……………………", "soniaapoto_fc3", 4],
      :incontinence_word => ["\\n<Proto Sonya>……………………", "soniaapoto_fc3", 4],
      :premortal_graphic => "80_soniaapoto_m1_st27",
    },
    807 => { # ガーゴイル娘
      :dead_word => ["\\n<Gargoyle Girl> Gununu...", "gargoyle_fc1", 2],
      :orgasm_word => ["\\n<Gargoyle Girl> Damn, it's humiliating...", "gargoyle_fc1", 2],
      :predation_word => ["\\n<Gargoyle Girl> Don't eat too much...!", "gargoyle_fc1", 2],
      :incontinence_word => ["\\n<Gargoyle Girl> No... this is different...", "gargoyle_fc1", 2],
      :premortal_graphic => "50_gargoyle_st03",
    },
    808 => { # アテナ
      :dead_word => ["\\n<Athena>Ugh, I can't fight anymore...", "athena_fc1", 2],
      :orgasm_word => ["\\n<Athena>A warrior succumbing to pleasure...", "athena_fc1", 2],
      :predation_word => ["\\n<Athena>Ah, to be turned into food... how regretful...", "athena_fc1", 2],
      :incontinence_word => ["\\n<Athena>Ah, to wet myself...", "athena_fc1", 2],
      :premortal_graphic => "50_athena_st03",
    },
    809 => { # リリスオリジン
      :dead_word => ["\\n<Lilith Origin>Without even avenging...", "lilith2_fc2", 2],
      :orgasm_word => ["\\n<Lilith Origin>Without even avenging...", "lilith2_fc2", 2],
      :predation_word => ["\\n<Lilith Origin>Without even avenging...", "lilith2_fc2", 2],
      :incontinence_word => ["\\n<Lilith Origin>This... humiliation...", "lilith2_fc2", 2],
      :premortal_graphic => "80_lilith2_st13",
    },
    810 => { # エルベティエ分裂体
      :dead_word => ["\\n<Erubetie Clone>In the end, I am just a clone...", "erbetie_fc1", 0],
      :orgasm_word => ["\\n<Erubetie Clone>In the end, I am just a clone...", "erbetie_fc1", 0],
      :predation_word => ["\\n<Erubetie Clone>In the end, I am just a clone...", "erbetie_fc1", 0],
      :incontinence_word => ["\\n<Erubetie Clone>My bodily fluids are leaking...", "erbetie_fc1", 0],
      :premortal_graphic => "80_erbetie_st01",
    },
    811 => { # エルベティエ・カナデ
      :dead_word => ["\\n<Erubetie Kanade>Even with this power... how...", "erbetie_fc2", 0],
      :orgasm_word => ["\\n<Erubetie Kanade>To be made to climax...", "erbetie_fc2", 0],
      :predation_word => ["\\n<Erubetie Kanade> How can you capture me...", "erbetie_fc2", 0],
      :incontinence_word => ["\\n<Erubetie Kanade> Body fluids are leaking...", "erbetie_fc2", 0],
      :premortal_graphic => "80_erbetie_st14",
    },
    812 => { # 阿吽
      :dead_word => ["\\n<Aun> Ugyu...", "aun_fc1", 2],
      :orgasm_word => ["\\n<Aun> Huh......", "aun_fc1", 2],
      :predation_word => ["\\n<Aun> Stop it! Stop it!　Hya~!", "aun_fc1", 2],
      :incontinence_word => ["\\n<Aun> I leaked ...I'm sorry...", "aun_fc1", 2],
      :premortal_graphic => "80_aun_st03",
    },
    813 => { # ドラゴンヘッド
      :dead_word => ["\\n<Dragon Head> This is the result of a serious competition, I have no regrets...", "dragonhead_fc1", 2],
      :orgasm_word => ["\\n<Dragon Head> This is the height of humiliation...!", "dragonhead_fc1", 2],
      :predation_word => ["\\n<Dragon Head> Is it the providence of nature that it becomes food for losers...", "dragonhead_fc1", 2],
      :incontinence_word => ["\\n<Dragon Head>, don't look at me...", "dragonhead_fc1", 2],
      :premortal_graphic => "80_dragonhead_st03",
    },
    814 => { # モンストロ
      :dead_word => ["\\n<Monstro>Ugyah!!", "monstruo_fc1", 2],
      :orgasm_word => ["\\n<Monstro>It feels so good!!", "monstruo_fc1", 2],
      :predation_word => ["\\n<Monstro>It's not tasty!!", "monstruo_fc1", 2],
      :incontinence_word => ["\\n<Monstro>It's embarrassing!!", "monstruo_fc1", 2],
      :premortal_graphic => "80_monstruo_st03",
    },
    815 => { # シヴァ
      :dead_word => ["\\n<Shiva>I can't believe I was careless...", "siva_fc1", 2],
      :orgasm_word => ["\\n<Shiva>I can't believe I'm ascending...", "siva_fc1", 2],
      :predation_word => ["\\n<Shiva> What does it mean to eat me...", "siva_fc1", 2],
      :incontinence_word => ["\\n<Shiva> Don't look at ... If you look, I'll kill you...!", "siva_fc1", 2],
      :premortal_graphic => "50_siva_st03",
    },
    816 => { # メフィスト
      :dead_word => ["\\n<Mephisto>Was my power not enough...", "mefist_fc4", 2],
      :orgasm_word => ["\\n<Mephisto>To make me climax...", "mefist_fc4", 2],
      :predation_word => ["\\n<Mephisto> I can't believe I'm being preyed upon...", "mefist_fc4", 2],
      :incontinence_word => ["\\n<Mephisto> I can no longer teach at this stage...", "mefist_fc4", 2],
      :premortal_graphic => "80_mefist_st43",
    },
    817 => { # ネプチューン
      :dead_word => ["\\n<Neptune>I have sunk...", "neptune_fc1", 0],
      :orgasm_word => ["\\n<Neptune>Sinking into pleasure...", "neptune_fc1", 0],
      :predation_word => ["\\n<Neptune>Sinking into food...", "neptune_fc1", 0],
      :incontinence_word => ["\\n<Neptune>Sink into my urine...", "neptune_fc1", 0],
      :premortal_graphic => "80_neptune_st01",
    },
    818 => { # タオ
      :dead_word => ["\\n<Tao>This body finally perishes...", "tao_fc1", 2],
      :orgasm_word => ["\\n<Tao>This pleasure, a souvenir for the afterlife...", "tao_fc1", 2],
      :predation_word => ["\\n<Tao> You seem like a really bad eater...", "tao_fc1", 2],
      :incontinence_word => ["\\n<Tao> Oh... how miserable...", "tao_fc1", 2],
      :premortal_graphic => "80_tao_st03",
    },
    819 => { # モルボル娘
      :dead_word => ["\\n<Malboro Girl>Ah, how frustrating...", "moruboru_fc1", 2],
      :orgasm_word => ["\\n<Malboro Girl>Ah, it feels so good...", "moruboru_fc1", 2],
      :predation_word => ["\\n<Malboro Girl>To eat me, isn't it disgusting...?", "moruboru_fc1", 2],
      :incontinence_word => ["\\n<Malboro Girl>My breath stinks, and so does my pee...", "moruboru_fc1", 2],
      :premortal_graphic => "80_moruboru_st03",
    },
    820 => { # アルケオプテリクス
      :dead_word => ["\\n<Archeopteryx> I don't like this...", "a_pterix_fc1", 2],
      :orgasm_word => ["\\n<Archeopteryx> Ah... it feels good...", "a_pterix_fc1", 2],
      :predation_word => ["\\n<Archeopteryx> Now we can be together...", "a_pterix_fc1", 1],
      :incontinence_word => ["\\n<Archeopteryx> My friends... are gone...", "a_pterix_fc1", 2],
      :premortal_graphic => "80_a_pterix_st03",
    },
    821 => { # アスモデウス
      :dead_word => ["\\n<Asmodeus> Me, in a place like this...", "asmodeus_fc1", 2],
      :orgasm_word => ["\\n<Asmodeus>For me to drown in pleasure...", "asmodeus_fc1", 2],
      :predation_word => ["\\n<Asmodeus>Such an irresistible woman...", "asmodeus_fc1", 2],
      :incontinence_word => ["\\n<Asmodeus>Ah, like this...Hurry, hurry and finish it...", "asmodeus_fc1", 2],
      :premortal_graphic => "80_asmodeus_st03",
    },
    822 => { # ヨルムンガンド
      :dead_word => ["\\n<Jormungandr>For me, in a place like this...", "jormungand_fc1", 2],
      :orgasm_word => ["\\n<Jormungandr>Kuh, to succumb to pleasure...", "jormungand_fc1", 2],
      :predation_word => ["\\n<Jormungandr>You insolent fool... Haaah!", "jormungand_fc1", 2],
      :incontinence_word => ["\\n<Jormungandr>What are you looking at? This is not a spectacle...", "jormungand_fc1", 2],
      :premortal_graphic => "80_jormungand_st03",
    },
    823 => { # アリスフィーズ16世
      :dead_word => ["\\n<Alipheese the 16th> Ugh, I'm like this...", "alice_fc2", 1],
      :orgasm_word => ["\\n<Alipheese the 16th> and others are made to cum...", "alice_fc2", 1],
      :predation_word => ["\\n<Alipheese the 16th>, don't eat...!  Wow! !", "alice_fc2", 1],
      :incontinence_word => ["\\n<Alipheese the 16th> and more leaked...aaah...", "alice_fc2", 1],
      :premortal_graphic => "80_alice_st10",
    },
    824 => { # 沙蛇
      :dead_word => ["\\n<Saja> That power is already in the realm of myth...", "sazya_fc1", 2],
      :orgasm_word => ["\\n<Saja> That power is already in the realm of myth...", "sazya_fc1", 2],
      :predation_word => ["\\n<Saja> Eat with care...", "sazya_fc1", 2],
      :incontinence_word => ["\\n<Saja> What a humiliation...", "sazya_fc1", 2],
      :premortal_graphic => "80_sazya_st03",
    },
    825 => { # アリスフィーズ
      :dead_word => ["\\n<Alipheese> Is this the power of the destroyer...", "alice0_fc1", 0],
      :orgasm_word => ["\\n<Alipheese> Is this the power of the destroyer...", "alice0_fc1", 0],
      :predation_word => ["\\n<Alipheese> To devour me, you must be quite determined...", "alice0_fc1", 0],
      :incontinence_word => ["\\n<Alipheese> Is this what humiliation feels like...", "alice0_fc1", 0],
      :premortal_graphic => "80_alice0_st01",
    },
    826 => { # カオスフィーズ
      :dead_word => ["\\n<Chaos Alipheese> To resist me this much, you are impressive...", "alice0_fc1", 1],
      :orgasm_word => ["\\n<Chaos Alipheese> To resist me this much, you are impressive...", "alice0_fc1", 1],
      :predation_word => ["\\n<Chaos Alipheese> To devour me, you must be quite determined...", "alice0_fc1", 1],
      :incontinence_word => ["\\n<Chaos Alipheese> Is this what humiliation feels like...", "alice0_fc1", 1],
      :premortal_graphic => "80_alice0_st11",
    },
    827 => { # カオスフィーズ
      :dead_word => ["\\n<Chaos Alipheese> Even with the power of chaos...", "alice0_fc1", 1],
      :orgasm_word => ["\\n<Chaos Alipheese> Even with the power of chaos...", "alice0_fc1", 1],
      :predation_word => ["\\n<Chaos Alipheese> Even with the power of chaos...", "alice0_fc1", 1],
      :incontinence_word => ["\\n<Chaos Alipheese> Is this what humiliation feels like...", "alice0_fc1", 1],
      :premortal_graphic => "80_alice0_st11",
    },
    828 => { # 前鬼
      :dead_word => ["\\n<Zenki>You've done well...", "zenki_fc1", 2],
      :orgasm_word => ["\\n<Zenki>This pisses me off, but it feels so good...", "zenki_fc1", 2],
      :predation_word => ["\\n<Zenki>You're going to eat me--Uwaaah!!", "zenki_fc1", 2],
      :incontinence_word => ["\\n<Zenki>D-don't look at me!", "zenki_fc1", 2],
      :premortal_graphic => "50_zenki_st03",
    },
    829 => { # 後鬼
      :dead_word => ["\\n<Kouki>I'm already at my limit...", "kouki_fc1", 2],
      :orgasm_word => ["\\n<Kouki>I enjoyed that...", "kouki_fc1", 2],
      :predation_word => ["\\n<Kouki>To think I'd be preyed upon...", "kouki_fc1", 2],
      :incontinence_word => ["\\n<Kouki>This is so shameful of me...", "kouki_fc1", 2],
      :premortal_graphic => "50_kouki_st03",
    },
    830 => { # 鎧の狂戦士
      :dead_word => ["\\n<Armored Berserker>An... ge... l...!", "heinrich_fc2", 0],
      :orgasm_word => ["\\n<Armored Berserker>An... ge... l...!", "heinrich_fc2", 0],
      :predation_word => ["\\n<Armored Berserker>An... ge... l...!", "heinrich_fc2", 0],
      :incontinence_word => ["\\n<Armored Berserker>An... ge... l...!", "heinrich_fc2", 0],
      :premortal_graphic => "50_heinrich_st51",
    },
    832 => { # 失墜の玉座
      :dead_word => ["\\n<Fallen Throne> The shattered throne...", "s_gyokuza_fc1", 0],
      :orgasm_word => ["\\n<Fallen Throne> At the end of pleasure...", "s_gyokuza_fc1", 0],
      :predation_word => ["\\n<Fallen Throne> Chairs are for sitting, not for eating...", "s_gyokuza_fc1", 0],
      :incontinence_word => ["\\n<Fallen Throne> The leaking drops...", "s_gyokuza_fc1", 0],
      :premortal_graphic => "50_s_gyokuza_st01",
    },
    833 => { # ダブルアンデッド
      :dead_word => ["\\n<Double Undead>My strength is running out...", "doubleundead_fc1", 0],
      :orgasm_word => ["\\n<Double Undead>I'm going to ascend...", "doubleundead_fc1", 0],
      :predation_word => ["\\n<Double Undead>This definitely doesn't taste good...", "doubleundead_fc1", 0],
      :incontinence_word => ["\\n<Double Undead>The juice is leaking out...", "doubleundead_fc1", 0],
      :premortal_graphic => "50_doubleundead_st01",
    },
    834 => { # イズン
      :dead_word => ["\\n<Idun>That's terrible...", "izun_fc1", 2],
      :orgasm_word => ["\\n<Idun>I came...♪", "izun_fc1", 0],
      :predation_word => ["\\n<Idun>Don't eat me...", "izun_fc1", 2],
      :incontinence_word => ["\\n<Idun>I wet myself...♪", "izun_fc1", 0],
      :premortal_graphic => "50_izun_st03",
    },
    835 => { # カースエンジェルズ
      :dead_word => ["\\n<Cursed Angels>Aaaaaah...", "carthangels_fc1", 0],
      :orgasm_word => ["\\n<Cursed Angels>Ahahahaha...", "carthangels_fc1", 0],
      :predation_word => ["\\n<Cursed Angels>Aaaaaah...", "carthangels_fc1", 0],
      :incontinence_word => ["\\n<Curse Angels>  Hehe, hehehe...", "carthangels_fc1", 0],
      :premortal_graphic => "50_carthangels_st01",
    },
    836 => { # カースエンジェルズ
      :dead_word => ["\\n<Cursed Angels>Aaaaaah...", "carthangels_fc1", 1],
      :orgasm_word => ["\\n<Cursed Angels>Ahahahaha...", "carthangels_fc1", 1],
      :predation_word => ["\\n<Cursed Angels>Aaaaaah...", "carthangels_fc1", 1],
      :incontinence_word => ["\\n<Curse Angels>  Hehe, hehehe...", "carthangels_fc1", 1],
      :premortal_graphic => "50_carthangels_st02",
    },
    837 => { # カースエンジェルズ
      :dead_word => ["\\n<Cursed Angels>Aaaaaah...", "carthangels_fc1", 2],
      :orgasm_word => ["\\n<Cursed Angels>Ahahahaha...", "carthangels_fc1", 2],
      :predation_word => ["\\n<Cursed Angels>Aaaaaah...", "carthangels_fc1", 2],
      :incontinence_word => ["\\n<Curse Angels>  Hehe, hehehe...", "carthangels_fc1", 2],
      :premortal_graphic => "50_carthangels_st03",
    },
    838 => { # アルジェミニ
      :dead_word => ["\\n<Algemini>  I can't fight anymore...", "algemini_fc1", 2],
      :orgasm_word => ["\\n<Algemini>  I can't believe I'm giving in to pleasure...", "algemini_fc1", 2],
      :predation_word => ["\\n<Algemini>  It's strange that I'm the bait...", "algemini_fc1", 2],
      :incontinence_word => ["\\n<Algemini> , don't look at it...it's the worst...", "algemini_fc1", 2],
      :premortal_graphic => "50_algemini_st03",
    },
    839 => { # エルジェミニ
      :dead_word => ["\\n<Elgemini>  No more...", "elgemini_fc1", 2],
      :orgasm_word => ["\\n<Elgemini>  Ah, it feels good...", "elgemini_fc1", 2],
      :predation_word => ["\\n<Elgemini>  I can't believe I'll become bait...", "elgemini_fc1", 2],
      :incontinence_word => ["\\n<Elgemini>  Please... please don't look at it...", "elgemini_fc1", 2],
      :premortal_graphic => "50_elgemini_st03",
    },
    840 => { # ネロ
      :dead_word => ["\\n<Nero>  I'm sorry, father...", "nero_fc2", 2],
      :orgasm_word => ["\\n<Nero>  I'm sorry, father...", "nero_fc2", 2],
      :predation_word => ["\\n<Nero> Looks like a really bad meal...", "nero_fc2", 2],
      :incontinence_word => ["\\n<Nero> What a blunder...", "nero_fc2", 2],
      :premortal_graphic => "80_nero_st13",
    },
    841 => { # ネリス
      :dead_word => ["\\n<Neris> I'm sorry, Dad...", "neris_fc2", 2],
      :orgasm_word => ["\\n<Neris> I'm going to cum...", "neris_fc2", 2],
      :predation_word => ["\\n<Neris> It doesn't taste good...maybe.", "neris_fc2", 2],
      :incontinence_word => ["\\n<Neris> Dad... I've messed with you...", "neris_fc2", 2],
      :premortal_graphic => "80_neris_st13",
    },
    842 => { # アピロ・ラゴス
      :dead_word => ["\\n<Apiro Lagos> Now, goodbye!", "apiro_ragos_fc1", 0],
      :orgasm_word => ["\\n<Apiro Lagos> I will ascend to heaven!", "apiro_ragos_fc1", 0],
      :predation_word => ["\\n<Apiro Lagos> Even if you break my stomach, I won't know!", "apiro_ragos_fc1", 0],
      :incontinence_word => ["\\n<Apiro Lagos> I'm embarrassed, I leaked it...", "apiro_ragos_fc1", 0],
      :premortal_graphic => "80_apiro_ragos_st03",
    },
    843 => { # シェムハザ
      :dead_word => ["\\n<Samyaza> Function stopped...", "shemhaza_fc1", 2],
      :orgasm_word => ["\\n<Samyaza> Excess pleasure pulse...", "shemhaza_fc1", 2],
      :predation_word => ["\\n<Samyaza> Devour, devour, devour...", "shemhaza_fc1", 2],
      :incontinence_word => ["\\n<Samyaza> Chaos, leakage...", "shemhaza_fc1", 2],
      :premortal_graphic => "50_shemhaza_st03",
    },
    844 => { # アグレイブ
      :dead_word => ["\\n<Agrave> I wanted to be free...", "agrave_fc1", 2],
      :orgasm_word => ["\\n<Agrave> I can see a world of pleasure...", "agrave_fc1", 2],
      :predation_word => ["\\n<Agrave> Ah, don't eat me...", "agrave_fc1", 2],
      :incontinence_word => ["\\n<Agrave> Ah, my insides are leaking...", "agrave_fc1", 2],
      :premortal_graphic => "80_agrave_st03",
    },
    845 => { # アドラメレク
      :dead_word => ["\\n<Adramelech> Ka...se, se...cond...stage...", "adramelek_fc3", 0],
      :orgasm_word => ["\\n<Adramelech> Ka...se, se...cond...stage...", "adramelek_fc3", 0],
      :predation_word => ["\\n<Adramelech> Ka...se, se...cond...stage...", "adramelek_fc3", 0],
      :incontinence_word => ["\\n<Adramelech> ..................", "adramelek_fc3", 0],
      :premortal_graphic => "80_adramelek_st31",
    },
    846 => { # エクス・ソニア
      :dead_word => ["\\n<EX Sonya> It's more powerful than I expected...", "ex_sonia_fc1", 0],
      :orgasm_word => ["\\n<EX Sonya> It's more powerful than I expected...", "ex_sonia_fc1", 0],
      :predation_word => ["\\n<EX Sonya> Eating me...", "ex_sonia_fc1", 0],
      :incontinence_word => ["\\n<EX Sonya> It's embarrassing to leak ...", "ex_sonia_fc1", 0],
      :premortal_graphic => "80_ex_sonia_st03",
    },
    847 => { # アンゴルモア
      :dead_word => ["\\n<Angolmois> is quite enjoyable...", "angolmois_fc1", 2],
      :orgasm_word => ["\\n<Angolmois> is quite enjoyable...", "angolmois_fc1", 2],
      :predation_word => ["\\n<Angolmois> Is this the law of the world...", "angolmois_fc1", 2],
      :incontinence_word => ["\\n<Angolmois> I'm like this... it's the height of humiliation...", "angolmois_fc1", 2],
      :premortal_graphic => "80_angolmois_st03",
    },
    848 => { # スターマ
      :dead_word => ["\\n<Starma> Will I perish here...", "starma_fc1", 2],
      :orgasm_word => ["\\n<Starma> This is nectar...", "starma_fc1", 2],
      :predation_word => ["\\n<Starma> It might be delicious...", "starma_fc1", 2],
      :incontinence_word => ["\\n<Starma> The juices of shame are overflowing...", "starma_fc1", 2],
      :premortal_graphic => "50_starma_st03",
    },
    849 => { # ラジャーラ
      :dead_word => ["\\n<Rajara>Ugh, damn it...!", "rajara_fc1", 2],
      :orgasm_word => ["\\n<Rajara>I'm going to come...!", "rajara_fc1", 2],
      :predation_word => ["\\n<Rajara>Is it delicious...!?", "rajara_fc1", 2],
      :incontinence_word => ["\\n<Rajara>Don't look at me leaking...!", "rajara_fc1", 2],
      :premortal_graphic => "50_rajara_st03",
    },
    850 => { # アプティルト
      :dead_word => ["\\n<Aptilt>Body■■■■■is■...", "aptiel_fc1", 1],
      :orgasm_word => ["\\n<Aptilt>Body■■■■■but■...", "aptiel_fc1", 1],
      :predation_word => ["\\n<Aptilt>Eat■■■...", "aptiel_fc1", 1],
      :incontinence_word => ["\\n<Aptilt>Urine■■■le■■...", "aptiel_fc1", 1],
      :premortal_graphic => "80_aptiel_st11",
    },
    851 => { # メギドリアード
      :dead_word => ["\\n<Megiddryad>Ah, how regrettable...", "megidryad_fc1", 2],
      :orgasm_word => ["\\n<Megiddryad>This is such humiliation...", "megidryad_fc1", 2],
      :predation_word => ["\\n<Megiddryad> My body is full of poison...", "megidryad_fc1", 2],
      :incontinence_word => ["\\n<Megiddryad> This is... oh, this is...", "megidryad_fc1", 2],
      :premortal_graphic => "50_megidryad_st03",
    },
    852 => { # エグセラ
      :dead_word => ["\\n<Exsera> It won't perish anyway...", "exsera_fc1", 2],
      :orgasm_word => ["\\n<Exsera> This is also part of the fun...", "exsera_fc1", 2],
      :predation_word => ["\\n<Exsera> I think it's delicious...?", "exsera_fc1", 2],
      :incontinence_word => ["\\n<Exsera>My mucus looks like it's going to melt...", "exsera_fc1", 2],
      :premortal_graphic => "50_exsera_st03",
    },
    853 => { # アプサラス
      :dead_word => ["\\n<Apsara> I hate violence...", "apsaras_fc1", 2],
      :orgasm_word => ["\\n<Apsara> Something like this isn't bad...", "apsaras_fc1", 2],
      :predation_word => ["\\n<Apsara> I think it's delicious...", "apsaras_fc1", 2],
      :incontinence_word => ["\\n<Apsara> I have never experienced such humiliation...", "apsaras_fc1", 2],
      :premortal_graphic => "50_apsaras_st03",
    },
    854 => { # アザゼル
      :dead_word => ["\\n<Azazel>Let's meet again……", "azazel_fc1", 1],
      :orgasm_word => ["\\n<Azazel>Ah, it's wonderful……", "azazel_fc1", 0],
      :predation_word => ["\\n<Azazel>Delicious, isn't it……？", "azazel_fc1", 1],
      :incontinence_word => ["\\n<Azazel>Watch me leak……", "azazel_fc1", 1],
      :premortal_graphic => "50_azazel_st02",
    },
    855 => { # グリゴリ
      :dead_word => ["\\n<Grigori>I enjoyed it……", "grigori_fc1", 1],
      :orgasm_word => ["\\n<Grigori>It was very good……", "grigori_fc1", 1],
      :predation_word => ["\\n<Grigori>Savor it properly……", "grigori_fc1", 1],
      :incontinence_word => ["\\n<Grigori>This is the worst……", "grigori_fc1", 1],
      :premortal_graphic => "50_grigori_st02",
    },
    856 => { # 蛭蟲分裂体
      :dead_word => ["\\n<Hiruko Clone>Isn't it quite amusing...", "hiruko_fc1", 2],
      :orgasm_word => ["\\n<Hiruko Clone>Pleasure is also a feast...", "hiruko_fc1", 2],
      :predation_word => ["\\n<Hiruko Clone>You would eat me? Foolish...", "hiruko_fc1", 2],
      :incontinence_word => ["\\n<Hiruko Clone>Don't make eye contact, or I'll devour you...", "hiruko_fc1", 2],
      :premortal_graphic => "80_hiruko_st03",
    },
    857 => { # クレオ・アドラ
      :dead_word => ["\\n<Cleo Adra>You resist this much……", "kureo_adora_fc1", 0],
      :orgasm_word => ["\\n<Cleo Adra>You resist this much……", "kureo_adora_fc1", 0],
      :predation_word => ["\\n<Cleo Adra>Feeding on chaos……", "kureo_adora_fc1", 0],
      :incontinence_word => ["\\n<Cleo Adra>This is humiliation...", "kureo_adora_fc1", 0],
      :premortal_graphic => "80_kureo_adora_st01",
    },
    858 => { # アピロ・ラゴス
      :dead_word => ["\\n<Apiro Lagos> Now, goodbye!", "apiro_ragos_fc1", 0],
      :orgasm_word => ["\\n<Apiro Lagos> I will ascend to heaven!", "apiro_ragos_fc1", 0],
      :predation_word => ["\\n<Apiro Lagos> Even if you break my stomach, I won't know!", "apiro_ragos_fc1", 0],
      :incontinence_word => ["\\n<Apiro Lagos> I'm embarrassed, I leaked it...", "apiro_ragos_fc1", 0],
      :premortal_graphic => "80_apiro_ragos_st03",
    },
    859 => { # アピロ・ラゴス
      :dead_word => ["\\n<Apiro Lagos>Hmm, not bad...", "apiro_ragos_fc1", 0],
      :orgasm_word => ["\\n<Apiro Lagos>Hmm, not bad...", "apiro_ragos_fc1", 0],
      :predation_word => ["\\n<Apiro Lagos> Even if you break my stomach, I won't know!", "apiro_ragos_fc1", 0],
      :incontinence_word => ["\\n<Apiro Lagos> I'm embarrassed, I leaked it...", "apiro_ragos_fc1", 0],
      :premortal_graphic => "80_apiro_ragos_st03",
    },
    860 => { # マガツオオミカミ
      :dead_word => ["\\n<Magatsu-Omikami>O...oo...", "magatuomikami_fc1", 0],
      :orgasm_word => ["\\n<Magatsu-Omikami>Aaaaaa...", "magatuomikami_fc1", 0],
      :predation_word => ["\\n<Magatsu-Omikami>Ah...oo...", "magatuomikami_fc1", 0],
      :incontinence_word => ["\\n<Magatsu-Omikami>Uuuu...", "magatuomikami_fc1", 0],
      :premortal_graphic => "80_magatuomikami_st01",
    },
    861 => { # マガツオオミカミ
      :dead_word => ["\\n<Magatsu-Omikami>O...oo...", "magatuomikami_fc1", 0],
      :orgasm_word => ["\\n<Magatsu-Omikami>Aaaaaa...", "magatuomikami_fc1", 0],
      :predation_word => ["\\n<Magatsu-Omikami>Ah...oo...", "magatuomikami_fc1", 0],
      :incontinence_word => ["\\n<Magatsu-Omikami>Uuuu...", "magatuomikami_fc1", 0],
      :premortal_graphic => "80_magatuomikami_st01",
    },
    862 => { # ゾルオクト
      :dead_word => ["\\n<Zoloct>I will cease functioning for a bit...", "zoloct_fc1", 2],
      :orgasm_word => ["\\n<Zoloct>This feels good... I might get addicted.", "zoloct_fc1", 2],
      :predation_word => ["\\n<Zoloct>Please don't eat the unit...", "zoloct_fc1", 2],
      :incontinence_word => ["\\n<Zoloct>Ah, my skirt is wet...", "zoloct_fc1", 2],
      :premortal_graphic => "80_zoloct_st03",
    },
    863 => { # ティアマト
      :dead_word => ["\\n<Tiamat> My speed...", "tiamat_fc1", 2],
      :orgasm_word => ["\\n<Tiamat> I'm going to heaven...", "tiamat_fc1", 2],
      :predation_word => ["\\n<Tiamat> Don't eat it...I don't like it!", "tiamat_fc1", 2],
      :incontinence_word => ["\\n<Tiamat> fuel discharge...that's what I did.", "tiamat_fc1", 2],
      :premortal_graphic => "80_tiamat_st03",
    },
    864 => { # シンギュラリティ
      :dead_word => ["\\n<Singularity> Huh...? It doesn't move...", "singularity_fc1", 0],
      :orgasm_word => ["\\n<Singularity> It's strange, it feels strange...", "singularity_fc1", 0],
      :predation_word => ["\\n<Singularity> It doesn't have any flavor...", "singularity_fc1", 0],
      :incontinence_word => ["\\n<Singularity> has been leaked, is it the name...", "singularity_fc1", 0],
      :premortal_graphic => "80_singularity_st22",
    },
    865 => { # 奉仕種族
      :dead_word => ["\\n<Serviceborne> If it's for that person...", "houshi_fc1", 2],
      :orgasm_word => ["\\n<Serviceborne> Sinking in pleasure...", "houshi_fc1", 2],
      :predation_word => ["\\n<Serviceborne>Will I become a sacrifice...", "houshi_fc1", 2],
      :incontinence_word => ["\\n<Serviceborne>It's leaking out...", "houshi_fc1", 2],
      :premortal_graphic => "50_houshi_st03",
    },
    866 => { # 落とし子
      :dead_word => ["\\n<Forsaken Spawn>Is this the end...", "spawn_fc1", 2],
      :orgasm_word => ["\\n<Forsaken Spawn>I'm going to finish...", "spawn_fc1", 2],
      :predation_word => ["\\n<Forsaken Spawn>To become a sacrifice...", "spawn_fc1", 2],
      :incontinence_word => ["\\n<Forsaken Spawn>................", "spawn_fc1", 2],
      :premortal_graphic => "50_spawn_st03",
    },
    867 => { # シスエル
      :dead_word => ["\\n<Sisel>So this is the end...", "sisel_fc1", 2],
      :orgasm_word => ["\\n<Sisel>I have no strength in my body...", "sisel_fc1", 2],
      :predation_word => ["\\n<Sisel>Even though it's not tasty...", "sisel_fc1", 2],
      :incontinence_word => ["\\n<Sisel>Ah, it's leaking...", "sisel_fc1", 2],
      :premortal_graphic => "80_sisel_st03",
    },
    868 => { # エクスキュウビ
      :dead_word => ["\\n<EX-Kyubi> has stopped functioning...", "exkyubi_fc1", 0],
      :orgasm_word => ["\\n<EX-Kyubi> Neural circuit stopped due to pleasure signal...", "exkyubi_fc1", 0],
      :predation_word => ["\\n<EX-Kyubi> It's not delicious! Ahhh...", "exkyubi_fc1", 0],
      :incontinence_word => ["\\n<EX-Kyubi> It leaks...Aaaa...", "exkyubi_fc1", 0],
      :premortal_graphic => "80_exkyubi_st01",
    },
    869 => { # フレール
      :dead_word => ["\\n<Frere> I...I won't disappear...", "ozum_fc1", 1],
      :orgasm_word => ["\\n<Frere> I feel like I'm going to melt...", "ozum_fc1", 1],
      :predation_word => ["\\n<Frere> I will devour it from within...", "ozum_fc1", 1],
      :incontinence_word => ["\\n<Frere> I am flowing out...", "ozum_fc1", 1],
      :premortal_graphic => "50_ozum_st02",
    },
    870 => { # ブラッディドラゴン
      :dead_word => ["\\n<Bloody Dragon>, I can't believe it...", "bloddydragon_fc1", 2],
      :orgasm_word => ["\\n<Bloody Dragon> Pleasure is delicious wine...", "bloddydragon_fc1", 0],
      :predation_word => ["\\n<Bloody Dragon> Eat with care...", "bloddydragon_fc1", 0],
      :incontinence_word => ["\\n<Bloody Dragon> Anyone who sees my foolishness will be killed...", "bloddydragon_fc1", 2],
      :premortal_graphic => "80_bloddydragon_st03",
    },
    871 => { # アプティルト
      :dead_word => ["\\n<Aptilt>Body■■■■■is■...", "aptiel_fc1", 1],
      :orgasm_word => ["\\n<Aptilt>Body■■■■■but■...", "aptiel_fc1", 1],
      :predation_word => ["\\n<Aptilt>Eat■■■...", "aptiel_fc1", 1],
      :incontinence_word => ["\\n<Aptilt>Urine■■■le■■...", "aptiel_fc1", 1],
      :premortal_graphic => "50_aptiel_st11",
    },
    872 => { # アムナリオ
      :dead_word => ["\\n<Amunario> Remember ...!", "amnario_fc1", 2],
      :orgasm_word => ["\\n<Amunario> Such pleasure... Ugh...", "amnario_fc1", 2],
      :predation_word => ["\\n<Amunario> There is a limit to bad eating...!", "amnario_fc1", 2],
      :incontinence_word => ["\\n<Amunario> is embarrassing...", "amnario_fc1", 2],
      :premortal_graphic => "80_amnario_st03",
    },
    873 => { # サマエル
      :dead_word => ["\\n<Samael> Why am I like this?", "samael_fc1", 2],
      :orgasm_word => ["\\n<Samael> Ah, I can feel it...", "samael_fc1", 2],
      :predation_word => ["\\n<Samael> Don't eat...Ah, ah...!", "samael_fc1", 2],
      :incontinence_word => ["\\n<Samael> Don't look, don't look...!", "samael_fc1", 2],
      :premortal_graphic => "80_samael_st03",
    },
    874 => { # シャドウアサシン
      :dead_word => ["\\n<Shadow Assassin>Disappear into the darkness...", "shadowassassin_fc1", 0],
      :orgasm_word => ["\\n<Shadow Assassin>Such humiliation...", "shadowassassin_fc1", 0],
      :predation_word => ["\\n<Shadow Assassin>There's no taste in shadows...", "shadowassassin_fc1", 0],
      :incontinence_word => ["\\n<Shadow Assassin>There's no greater humiliation...", "shadowassassin_fc1", 0],
      :premortal_graphic => "50_shadowassassin_st01",
    },
    875 => { # 正体不明
      :dead_word => ["\\n<Unknown>........................", "unknown1_fc1", 0],
      :orgasm_word => ["\\n<Unknown>........................", "unknown1_fc1", 0],
      :predation_word => ["\\n<Unknown>........................", "unknown1_fc1", 0],
      :incontinence_word => ["\\n<Unknown>........................", "unknown1_fc1", 0],
      :premortal_graphic => "50_unknown1_st01",
    },
    876 => { # 正体不明
      :dead_word => ["\\n<Unknown>........................", "unknown2_fc1", 0],
      :orgasm_word => ["\\n<Unknown>........................", "unknown2_fc1", 0],
      :predation_word => ["\\n<Unknown>........................", "unknown2_fc1", 0],
      :incontinence_word => ["\\n<Unknown>........................", "unknown2_fc1", 0],
      :premortal_graphic => "50_unknown2_st01",
    },
    877 => { # 正体不明
      :dead_word => ["\\n<Unknown>........................", "unknown3_fc1", 0],
      :orgasm_word => ["\\n<Unknown>........................", "unknown3_fc1", 0],
      :predation_word => ["\\n<Unknown>........................", "unknown3_fc1", 0],
      :incontinence_word => ["\\n<Unknown>........................", "unknown3_fc1", 0],
      :premortal_graphic => "50_unknown3_st01",
    },
    878 => { # 正体不明
      :dead_word => ["\\n<Unknown>........................", "unknown4_fc1", 0],
      :orgasm_word => ["\\n<Unknown>........................", "unknown4_fc1", 0],
      :predation_word => ["\\n<Unknown>........................", "unknown4_fc1", 0],
      :incontinence_word => ["\\n<Unknown>........................", "unknown4_fc1", 0],
      :premortal_graphic => "50_unknown4_st01",
    },
    879 => { # 正体不明
      :dead_word => ["\\n<Unknown>........................", "unknown5_fc1", 0],
      :orgasm_word => ["\\n<Unknown>........................", "unknown5_fc1", 0],
      :predation_word => ["\\n<Unknown>........................", "unknown5_fc1", 0],
      :incontinence_word => ["\\n<Unknown>........................", "unknown5_fc1", 0],
      :premortal_graphic => "80_unknown5_st01",
    },
    880 => { # 強欲のパピ
      :dead_word => ["\\n<Greedy Papi>Ugh...", "dragonp_fc3", 2],
      :orgasm_word => ["\\n<Greedy Papi>What is this...?My body... Hauuu~~!", "dragonp_fc3", 2],
      :predation_word => ["\\n<Greedy Papi>D-Don't eat me! I'll bite you from inside your stomach...!Hyaaaaaa!!", "dragonp_fc3", 2],
      :incontinence_word => ["\\n<Greedy Papi>My panties... They're wet...", "dragonp_fc3", 2],
      :premortal_graphic => "80_dragonp_st23",
    },
    881 => { # バンシィ
      :dead_word => ["\\n<Banshee>It's so frustrating...", "curseloreley_fc1", 2],
      :orgasm_word => ["\\n<Banshee> Ah, it feels good...", "curseloreley_fc1", 2],
      :predation_word => ["\\n<Banshee> I wonder what it tastes like...", "curseloreley_fc1", 2],
      :incontinence_word => ["\\n<Banshee> I hope you don't look at ...", "curseloreley_fc1", 2],
      :premortal_graphic => "50_curseloreley_st03",
    },
    882 => { # ボアバンシィ
      :dead_word => ["\\n<Vore Banshee> Goodbye...", "voremermaid_fc1", 2],
      :orgasm_word => ["\\n<Vore Banshee> Feels good...", "voremermaid_fc1", 2],
      :predation_word => ["\\n<Vore Banshee> I can't believe I'm being eaten...", "voremermaid_fc1", 2],
      :incontinence_word => ["\\n<Vore Banshee> It's embarrassing to leak ...", "voremermaid_fc1", 2],
      :premortal_graphic => "50_voremermaid_st03",
    },
    883 => { # ワールドドロウン
      :dead_word => ["\\n<World Drown> I have to go back again...", "worlddrown_fc1", 1],
      :orgasm_word => ["\\n<World Drown> I have to go back again...", "worlddrown_fc1", 1],
      :predation_word => ["\\n<World Drown> If you eat , you will be cursed...", "worlddrown_fc1", 1],
      :incontinence_word => ["\\n<World Drown> This is... humiliation...", "worlddrown_fc1", 1],
      :premortal_graphic => "80_worlddrown_st02",
    },
    884 => { # パズズ
      :dead_word => ["\\n<Pazuzu>I'll curse you...", "pazuzu_fc1", 2],
      :orgasm_word => ["\\n<Pazuzu>Uuu...", "pazuzu_fc1", 2],
      :predation_word => ["\\n<Pazuzu>Don't eat... Uuu...", "pazuzu_fc1", 2],
      :incontinence_word => ["\\n<Pazuzu>Leaked... Uuu", "pazuzu_fc1", 2],
      :premortal_graphic => "50_pazuzu_st03",
    },
    885 => { # マステマ
      :dead_word => ["\\n<Mastema>Such... regret...", "masutema_fc1", 2],
      :orgasm_word => ["\\n<Mastema>To end here...", "masutema_fc1", 2],
      :predation_word => ["\\n<Mastema>Kuh... It must be delicious...", "masutema_fc1", 2],
      :incontinence_word => ["\\n<Mastema>So much sap...", "masutema_fc1", 2],
      :premortal_graphic => "50_masutema_st03",
    },
    886 => { # コスモス
      :dead_word => ["\\n<Cosmos>To end under this sky...", "queenmoss_fc1", 2],
      :orgasm_word => ["\\n<Cosmos>To end under this sky...", "queenmoss_fc1", 2],
      :predation_word => ["\\n<Cosmos>To make me your prey……ugh.", "queenmoss_fc1", 2],
      :incontinence_word => ["\\n<Cosmos>This is amniotic fluid……not urine……", "queenmoss_fc1", 2],
      :premortal_graphic => "80_queenmoss_st21",
    },
    887 => { # ノーライフキング
      :dead_word => ["\\n<No Life King>....................", "dragonbone_fc1", 2],
      :orgasm_word => ["\\n<No Life King>....................", "dragonbone_fc1", 2],
      :predation_word => ["\\n<No Life King> If you eat me, you are a lover of things...", "dragonbone_fc1", 2],
      :incontinence_word => ["\\n<No Life King> Such humiliation... Don't look at it...", "dragonbone_fc1", 3],
      :premortal_graphic => "80_dragonbone_st03",
    },
    888 => { # アメノハヅチ
      :dead_word => ["\\n<Ame no Hazuchi> Let's leave this world...", "amenohaduti_fc1", 2],
      :orgasm_word => ["\\n<Ame no Hazuchi> Ah...sweet pleasure...", "amenohaduti_fc1", 2],
      :predation_word => ["\\n<Ame no Hazuchi> I hold a grudge...", "amenohaduti_fc1", 2],
      :incontinence_word => ["\\n<Ame no Hazuchi> I am ashamed of my life...I will not forgive...", "amenohaduti_fc1", 2],
      :premortal_graphic => "80_amenohaduti_st03",
    },
    889 => { # 八尺様
      :dead_word => ["\\n<Hasshaku-sama>  Popopo...", "hasyakusama_fc1", 2],
      :orgasm_word => ["\\n<Hasshaku-sama>  Popopo...", "hasyakusama_fc1", 2],
      :predation_word => ["\\n<Hasshaku-sama>po… popopopopopo…", "hasyakusama_fc1", 2],
      :incontinence_word => ["\\n<Hasshaku-sama>po...", "hasyakusama_fc1", 2],
      :premortal_graphic => "50_hasyakusama_st03",
    },
    890 => { # ニフタ・テロス
      :dead_word => ["\\n<Nychta Telos> Will you show power greater than God...?", "nihuta_telos_fc1", 0],
      :orgasm_word => ["\\n<Nychta Telos> Will you show power greater than God...?", "nihuta_telos_fc1", 0],
      :predation_word => ["\\n<Nychta Telos>You will be consumed by death...", "nihuta_telos_fc1", 0],
      :incontinence_word => ["\\n<Nychta Telos>Such humiliation... Curse you...", "nihuta_telos_fc1", 0],
      :premortal_graphic => "80_nihuta_telos_st01",
    },
    891 => { # ノーライフキング
      :dead_word => ["\\n<No Life King>This is the end...", "dragonbone_fc1", 2],
      :orgasm_word => ["\\n<No Life King>This is the end...", "dragonbone_fc1", 2],
      :predation_word => ["\\n<No Life King> If you eat me, you are a lover of things...", "dragonbone_fc1", 2],
      :incontinence_word => ["\\n<No Life King> Such humiliation... Don't look at it...", "dragonbone_fc1", 3],
      :premortal_graphic => "80_dragonbone_st03",
    },
    892 => { # アンゴルモア
      :dead_word => ["\\n<Angolmois>Heh heh heh, this is getting interesting...!", "angolmois_fc1", 2],
      :orgasm_word => ["\\n<Angolmois>Heh heh heh, this is getting interesting...!", "angolmois_fc1", 2],
      :predation_word => ["\\n<Angolmois> Is this the law of the world...", "angolmois_fc1", 2],
      :incontinence_word => ["\\n<Angolmois> I'm like this... it's the height of humiliation...", "angolmois_fc1", 2],
      :premortal_graphic => "80_angolmois_st03",
    },
    893 => { # マガツオオミカミ
      :dead_word => ["\\n<Magatsu-Omikami>O...oo...", "magatuomikami_fc1", 0],
      :orgasm_word => ["\\n<Magatsu-Omikami>Aaaaaa...", "magatuomikami_fc1", 0],
      :predation_word => ["\\n<Magatsu-Omikami>Ah...oo...", "magatuomikami_fc1", 0],
      :incontinence_word => ["\\n<Magatsu-Omikami>Uuuu...", "magatuomikami_fc1", 0],
      :premortal_graphic => "80_magatuomikami_st01",
    },
    894 => { # アリスフィーズ3世
      :dead_word => ["\\n<Alipheese the 3rd>Such magnificent power...", "alice3th_fc2", 2],
      :orgasm_word => ["\\n<Alipheese the 3rd>Such magnificent power...", "alice3th_fc2", 4],
      :predation_word => ["\\n<Alipheese the 3rd>Hmph, devour as you please...", "alice3th_fc2", 2],
      :incontinence_word => ["\\n<Alipheese the 3rd>Such... humiliation...", "alice3th_fc2", 4],
      :premortal_graphic => "80_alice3th_st13",
    },
    895 => { # アリスフィーズ4世
      :dead_word => ["\\n<Alipheese the 4th>Impressive, I surrender...", "alice4th_fc2", 2],
      :orgasm_word => ["\\n<Alipheese the 4th>Impressive, I surrender...", "alice4th_fc2", 2],
      :predation_word => ["\\n<Alipheese the 4th>How peculiar...", "alice4th_fc2", 2],
      :incontinence_word => ["\\n<Alipheese the 4th>I feel so pathetic...", "alice4th_fc2", 2],
      :premortal_graphic => "80_alice4th_st13",
    },
    896 => { # アリスフィーズ5世
      :dead_word => ["\\n<Alipheese the 5th>I don't want this anymore, I'm going home!", "alice5th_fc2", 2],
      :orgasm_word => ["\\n<Alipheese the 5th>It feels good, but it's embarrassing...", "alice5th_fc2", 2],
      :predation_word => ["\\n<Alipheese the 5th>Are you going to eat me? No way.", "alice5th_fc2", 2],
      :incontinence_word => ["\\n<Alipheese the 5th>I just spilled water. It's not an accident...", "alice5th_fc2", 2],
      :premortal_graphic => "80_alice5th_st13",
    },
    897 => { # アリスフィーズ6世
      :dead_word => ["\\n<Alipheese the 6th>That power, it's wonderful...", "alice6th_fc2", 2],
      :orgasm_word => ["\\n<Alipheese the 6th>That power, it's wonderful...", "alice6th_fc2", 2],
      :predation_word => ["\\n<Alipheese the 6th>D-Don't eat me...!", "alice6th_fc2", 2],
      :incontinence_word => ["\\n<Alipheese the 6th>Ah, I'm going to wet myself...", "alice6th_fc2", 2],
      :premortal_graphic => "80_alice6th_st13",
    },
    898 => { # アリスフィーズ7世
      :dead_word => ["\\n<Alipheese the 7th>I don't feel like doing any more...", "alice7th_fc2", 2],
      :orgasm_word => ["\\n<Alipheese the 7th>I enjoyed the pleasure...", "alice7th_fc2", 2],
      :predation_word => ["\\n<Alipheese the 7th>Isn't it delicious, ufufu...", "alice7th_fc2", 2],
      :incontinence_word => ["\\n<Alipheese the 7th>Oh, excuse me...", "alice7th_fc2", 2],
      :premortal_graphic => "80_alice7th_st13",
    },
    899 => { # アリスフィーズ9世
      :dead_word => ["\\n<Alipheese the 9th>As expected, such power...", "alice9th_fc2", 2],
      :orgasm_word => ["\\n<Alipheese the 9th>As expected, such power...", "alice9th_fc2", 2],
      :predation_word => ["\\n<Alipheese the 9th>Don't eat me... Ah...", "alice9th_fc2", 2],
      :incontinence_word => ["\\n<Alipheese the 9th>Don't look at me... Ah...", "alice9th_fc2", 2],
      :premortal_graphic => "80_alice9th_st13",
    },
    900 => { # アリスフィーズ10世
      :dead_word => ["\\n<Alipheese the 10th>Ugh, I can't win...", "alice10th_fc2", 2],
      :orgasm_word => ["\\n<Alipheese the 10th>Ugh, I can't win...", "alice10th_fc2", 3],
      :predation_word => ["\\n<Alipheese the 10th>Don't eat me!", "alice10th_fc2", 4],
      :incontinence_word => ["\\n<Alipheese the 10th>Hauu... it leaked...", "alice10th_fc2", 6],
      :premortal_graphic => "80_alice10th_st13",
    },
    901 => { # アリスフィーズ11世
      :dead_word => ["\\n<Alipheese the 11th>This is as far as I go...", "alice11th_fc1", 2],
      :orgasm_word => ["\\n<Alipheese the 11th>Not bad...", "alice11th_fc1", 2],
      :predation_word => ["\\n<Alipheese the 11th>Are you going to use me as bait...? Ahhh...!", "alice11th_fc1", 2],
      :incontinence_word => ["\\n<Alipheese the 11th>, this is such a humiliation...", "alice11th_fc1", 2],
      :premortal_graphic => "80_alice11th_st03",
    },
    902 => { # アリスフィーズ12世
      :dead_word => ["\\n<Alipheese the 12th>, I'll do it...!", "alice12th_fc1", 2],
      :orgasm_word => ["\\n<Alipheese the 12th> Ah, aaaaa! !", "alice12th_fc1", 2],
      :predation_word => ["\\n<Alipheese the 12th> Don't eat! Don't eat...meow! !", "alice12th_fc1", 2],
      :incontinence_word => ["\\n<Alipheese the 12th> Meow...", "alice12th_fc1", 2],
      :premortal_graphic => "80_alice12th_st03",
    },
    903 => { # アリスフィーズ13世
      :dead_word => ["\\n<Alipheese the 13th> It's my loss...", "alice13th_fc2", 2],
      :orgasm_word => ["\\n<Alipheese the 13th> I will give in to sweet pleasure...", "alice13th_fc2", 2],
      :predation_word => ["\\n<Alipheese the 13th> You are so violent, like eating me...", "alice13th_fc2", 2],
      :incontinence_word => ["\\n<Alipheese the 13th> Oh, my urine is leaking...", "alice13th_fc2", 2],
      :premortal_graphic => "80_alice13th_st13",
    },
    904 => { # アリスフィーズ14世
      :dead_word => ["\\n<Alipheese the 14th> That girl is so strong...", "alice14th_fc2", 2],
      :orgasm_word => ["\\n<Alipheese the 14th> That girl is so strong...", "alice14th_fc2", 2],
      :predation_word => ["\\n<Alipheese the 14th>Candy, do you want to eat...?But don't eat me...", "alice14th_fc2", 2],
      :incontinence_word => ["\\n<Alipheese the 14th>Sorry, I wet myself...", "alice14th_fc2", 2],
      :premortal_graphic => "80_alice14th_st13",
    },
    905 => { # 禍撫分裂体
      :dead_word => ["\\n<Kanade Clone>I'm just a split body anyway...", "kanade_fc1", 2],
      :orgasm_word => ["\\n<Kanade Clone>I'm just a split body anyway...", "kanade_fc1", 2],
      :predation_word => ["\\n<Kanade Clone>I must taste quite good...", "kanade_fc1", 2],
      :incontinence_word => ["\\n<Kanade Clone>To think I'd wet myself...", "kanade_fc1", 2],
      :premortal_graphic => "80_kanade_st03",
    },
    906 => { # 蛭蟲分裂体
      :dead_word => ["\\n<Hiruko Clone>Isn't it quite amusing...", "hiruko_fc1", 2],
      :orgasm_word => ["\\n<Hiruko Clone>Pleasure is also a feast...", "hiruko_fc1", 2],
      :predation_word => ["\\n<Hiruko Clone>You would eat me? Foolish...", "hiruko_fc1", 2],
      :incontinence_word => ["\\n<Hiruko Clone>Don't make eye contact, or I'll devour you...", "hiruko_fc1", 2],
      :premortal_graphic => "80_hiruko_st03",
    },
    907 => { # ゲシュタルト
      :dead_word => ["\\n<Gestalt>Anyway, everyone will become one...", "gestalt_fc1", 2],
      :orgasm_word => ["\\n<Gestalt>This is such humiliation...", "gestalt_fc1", 2],
      :predation_word => ["\\n<Gestalt>How can you even think of eating me...", "gestalt_fc1", 2],
      :incontinence_word => ["\\n<Gestalt>There's no greater humiliation than this...", "gestalt_fc1", 2],
      :premortal_graphic => "50_gestalt_st03",
    },
    908 => { # ハイブマインド
      :dead_word => ["\\n<Hivemind>Don't you want to become one with me...?", "hivemind_fc1", 2],
      :orgasm_word => ["\\n<Hivemind>Ugh, it feels so good...", "hivemind_fc1", 2],
      :predation_word => ["\\n<Hivemind>I'll become one with you...", "hivemind_fc1", 2],
      :incontinence_word => ["\\n<Hivemind>Ah... I'm going to leak...", "hivemind_fc1", 2],
      :premortal_graphic => "50_hivemind_st03",
    },
    909 => { # バアル・ゼブブ
      :dead_word => ["\\n<Baal Zebub> Not yet...it's not over yet...", "baal_zebub_fc1", 2],
      :orgasm_word => ["\\n<Baal Zebub> Not yet...it's not over yet...", "baal_zebub_fc1", 2],
      :predation_word => ["\\n<Baal Zebub> You're going to use me as bait... Ugh...", "baal_zebub_fc1", 2],
      :incontinence_word => ["\\n<Baal Zebub> will leak... it will leak...!", "baal_zebub_fc1", 2],
      :premortal_graphic => "80_baal_zebub_st03",
    },
    910 => { # 強欲のゴブ
      :dead_word => ["\\n<Greedy Gob> Give me a break...", "gob_fc3", 2],
      :orgasm_word => ["\\n<Greedy Gob> This is... it's going to be bad...!", "gob_fc3", 2],
      :predation_word => ["\\n<Greedy Gob> I-I'm going to eat it...!  Oh no! !", "gob_fc3", 2],
      :incontinence_word => ["\\n<Greedy Gob> It's embarrassing...", "gob_fc3", 2],
      :premortal_graphic => "80_gob_st13",
    },
    911 => { # 強欲のプチ
      :dead_word => ["\\n<Greedy Teeny> Like this... Kyuu...", "pramia_fc3", 2],
      :orgasm_word => ["\\n<Greedy Teeny> I can feel it... Wow...", "pramia_fc3", 2],
      :predation_word => ["\\n<Greedy Teeny> I don't like it!  Hey, are you listening...?　Kyaaaa!", "pramia_fc3", 2],
      :incontinence_word => ["\\n<Greedy Teeny>I'm going to wet myself...Ahhh...", "pramia_fc3", 2],
      :premortal_graphic => "80_pramia_st23",
    },
    912 => { # 強欲のヴァニラ
      :dead_word => ["\\n<Greedy Vanilla>I'll take a peek into the world of darkness...", "vgirl_fc3", 2],
      :orgasm_word => ["\\n<Greedy Vanilla>No, I'm going to cum...Hyahhh...", "vgirl_fc3", 2],
      :predation_word => ["\\n<Greedy Vanilla>D-don't eat me... stop...!Hyahhh!", "vgirl_fc3", 2],
      :incontinence_word => ["\\n<Greedy Vanilla>I wet myself again...", "vgirl_fc3", 2],
      :premortal_graphic => "80_vgirl_st23",
    },
    913 => { # マダムラミア
      :dead_word => ["\\n<Madame Lamia>Oh, what a rough person...", "madamlamia_fc1", 2],
      :orgasm_word => ["\\n<Madame Lamia>I had a good time...", "madamlamia_fc1", 2],
      :predation_word => ["\\n<Madame Lamia>Such a passionate person...", "madamlamia_fc1", 2],
      :incontinence_word => ["\\n<Madame Lamia>At this age, to experience something like this...", "madamlamia_fc1", 2],
      :premortal_graphic => "50_madamlamia_st03",
    },
    914 => { # 嫉妬のリリィ
      :dead_word => ["\\n<Jealous Lily>Crawling on the ground again, in a place like this...?", "lily_fc2", 2],
      :orgasm_word => ["\\n<Jealous Lily> I am so humiliated...!  Ahhh...!", "lily_fc2", 2],
      :predation_word => ["\\n<Jealous Lily> Hmm, do whatever you like...", "lily_fc2", 2],
      :incontinence_word => ["\\n<Jealous Lily> I will never forgive such humiliation...!  Absolutely... absolutely...!", "lily_fc2", 2],
      :premortal_graphic => "80_lily_st23",
    },
    915 => { # 憤怒の牛魔王
      :dead_word => ["\\n<Wrathful Cow Demon Queen> I feel so pathetic...", "nyumaou_fc2", 3],
      :orgasm_word => ["\\n<Wrathful Cow Demon Queen> I don't think it will end in front of me... Hmmmm!", "nyumaou_fc2", 3],
      :predation_word => ["\\n<Wrathful Cow Demon Queen> You are so bold that you want to eat me...", "nyumaou_fc2", 3],
      :incontinence_word => ["\\n<Wrathful Cow Demon Queen> Damn, what a humiliation...!", "nyumaou_fc2", 3],
      :premortal_graphic => "80_nyumaou_st16",
    },
    916 => { # 暴食のカサンドラ
      :dead_word => ["\\n<Gluttonous Cassandra> Remember...", "cassandra_fc4", 2],
      :orgasm_word => ["\\n<Gluttonous Cassandra> Such humiliation...Ah, ah...", "cassandra_fc4", 2],
      :predation_word => ["\\n<Gluttonous Cassandra> I will never forgive you for eating me...!", "cassandra_fc4", 2],
      :incontinence_word => ["\\n<Gluttonous Cassandra>Anyone who sees me like this will surely...", "cassandra_fc4", 2],
      :premortal_graphic => "80_cassandra_st63",
    },
    917 => { # 色欲のリリス＆リリム
      :dead_word => ["\\n<Lustful Lilith & Lilim>I'm going to rest for a bit...", "lilith_fc1", 2],
      :orgasm_word => ["\\n<Lustful Lilith & Lilim>It's humiliating, but... it feels good...", "lilith_fc1", 2],
      :predation_word => ["\\n<Lustful Lilith & Lilim>It tastes sweet...", "lilith_fc1", 2],
      :incontinence_word => ["\\n<Lustful Lilith & Lilim>Ah... we, the queens, wet ourselves...", "lilith_fc1", 2],
      :premortal_graphic => "80_lilith_st03",
    },
    918 => { # 色欲のウィッチ
      :dead_word => ["\\n<Lustful Witch>The plan was in vain...", "witchs_fc2", 1],
      :orgasm_word => ["\\n<Lustful Witch>The plan was in vain...", "witchs_fc2", 1],
      :predation_word => ["\\n<Lustful Witch>If you eat me, you'll regret it...", "witchs_fc2", 1],
      :incontinence_word => ["\\n<Lustful Witch>Forget about me like this... quickly...", "witchs_fc2", 1],
      :premortal_graphic => "80_witchs_st22",
    },
    919 => { # 傲慢のカーミラ
      :dead_word => ["\\n<Prideful Carmilla>I can't take it anymore...", "carmilla_fc1", 2],
      :orgasm_word => ["\\n<Prideful Carmilla>I'm going to come...", "carmilla_fc1", 2],
      :predation_word => ["\\n<Prideful Carmilla> I don't like this...", "carmilla_fc1", 2],
      :incontinence_word => ["\\n<Prideful Carmilla> It's embarrassing to be rude...", "carmilla_fc1", 2],
      :premortal_graphic => "80_carmilla_st03",
    },
    920 => { # 傲慢のエリザベート
      :dead_word => ["\\n<Prideful Elizabeth> This grudge will definitely...", "elisabeth_fc1", 2],
      :orgasm_word => ["\\n<Prideful Elizabeth> Damn, it's humiliating... I'm sorry...", "elisabeth_fc1", 2],
      :predation_word => ["\\n<Prideful Elizabeth> Stop it, you're going to eat me...! !", "elisabeth_fc1", 2],
      :incontinence_word => ["\\n<Prideful Elizabeth> Look, don't look...Uuuuuuu...", "elisabeth_fc1", 2],
      :premortal_graphic => "80_elisabeth_st03",
    },
    921 => { # 傲慢のファティマ
      :dead_word => ["\\n<Prideful Fatima> Will the concubine bow down...", "queenvampire_fc2", 2],
      :orgasm_word => ["\\n<Prideful Fatima> Giving in to pleasure... it's unbelievable...", "queenvampire_fc2", 2],
      :predation_word => ["\\n<Prideful Fatima> I will never forgive such rudeness... Arrogant...", "queenvampire_fc2", 2],
      :incontinence_word => ["\\n<Prideful Fatima> Don't look at ...uh...uh...", "queenvampire_fc2", 2],
      :premortal_graphic => "80_queenvanpire_st33",
    },
    922 => { # サタナキア
      :dead_word => ["\\n<Satanachia>The darkness is my homeland...", "satanachia_fc1", 2],
      :orgasm_word => ["\\n<Satanachia>Pleasure is my joy...", "satanachia_fc1", 1],
      :predation_word => ["\\n<Satanachia>To devour the darkness...", "satanachia_fc1", 2],
      :incontinence_word => ["\\n<Satanachia>I-I won't forgive you...!", "satanachia_fc1", 2],
      :premortal_graphic => "50_satanachia_st03",
    },
    923 => { # ブラッディドラゴン
      :dead_word => ["\\n<Bloody Dragon>, I can't believe it...", "bloddydragon_fc1", 2],
      :orgasm_word => ["\\n<Bloody Dragon> Pleasure is delicious wine...", "bloddydragon_fc1", 0],
      :predation_word => ["\\n<Bloody Dragon> Eat with care...", "bloddydragon_fc1", 0],
      :incontinence_word => ["\\n<Bloody Dragon> Anyone who sees my foolishness will be killed...", "bloddydragon_fc1", 2],
      :premortal_graphic => "80_bloddydragon_st03",
    },
    924 => { # 強欲のエヴァ
      :dead_word => ["\\n<Greedy Eva>Why is it always me...! Why am I the only one who has to go through this...!", "evaq_fc1", 2],
      :orgasm_word => ["\\n<Greedy Eva>Even though I'm a succubus... It's so embarrassing to be made to climax...", "evaq_fc1", 2],
      :predation_word => ["\\n<Greedy Eva>Stop, if you're going to eat someone, eat someone else... Noooo...!", "evaq_fc1", 2],
      :incontinence_word => ["\\n<Greedy Eva>Don't look! Don't look at me... Uuuu...", "evaq_fc1", 2],
      :premortal_graphic => "80_evaq_st03",
    },
    925 => { # 嫉妬のエヴァ
      :dead_word => ["\\n<Jealous Eva>Again, this is happening...! Why does this keep happening...!", "evaq_fc1", 2],
      :orgasm_word => ["\\n<Jealous Eva>Even though I'm a succubus... It's so embarrassing to be made to climax...", "evaq_fc1", 2],
      :predation_word => ["\\n<Jealous Eva> Stop it, if you're going to eat it, choose someone else...  Noooo...!", "evaq_fc1", 2],
      :incontinence_word => ["\\n<Jealous Eva> Don't look at ! Don't look...  Uuuuu...", "evaq_fc1", 2],
      :premortal_graphic => "80_evaq_st03",
    },
    926 => { # 怠惰のエヴァ
      :dead_word => ["\\n<Lazy Eva> It's just me, why...!  Don't you think it's pitiful...?", "evaq_fc1", 2],
      :orgasm_word => ["\\n<Lazy Eva> I'm a succubus... It's embarrassing to be made to cum...", "evaq_fc1", 2],
      :predation_word => ["\\n<Lazy Eva> Stop, if you're going to eat it, choose someone else...  Noooooo...!", "evaq_fc1", 2],
      :incontinence_word => ["\\n<Lazy Eva> Don't look at ! Don't look at it... Uuuu...", "evaq_fc1", 2],
      :premortal_graphic => "80_evaq_st03",
    },
    927 => { # 七つの大罪
      :dead_word => ["\\n<Seven Deadly Sins> The deadly sins will not be destroyed...", "satan_fc1", 0],
      :orgasm_word => ["\\n<Seven Deadly Sins> Is this pleasure...", "satan_fc1", 0],
      :predation_word => ["\\n<Seven Deadly Sins> What does it mean to suffer sin...", "satan_fc1", 0],
      :incontinence_word => ["\\n<Seven Deadly Sins> Urinating…is it a sin…?", "satan_fc1", 0],
      :premortal_graphic => "80_satan_st01",
    },
    928 => { # パイズリ人形終異体
      :dead_word => ["\\n<Final Paizuri Doll>……………………", "paizuridoll3_fc1", 2],
      :orgasm_word => ["\\n<Final Paizuri Doll>……………………", "paizuridoll3_fc1", 2],
      :predation_word => ["\\n<Final Paizuri Doll>……………………", "paizuridoll3_fc1", 2],
      :incontinence_word => ["\\n<Final Paizuri Doll>……………………", "paizuridoll3_fc1", 2],
      :premortal_graphic => "50_paizuridoll3_st03",
    },
    929 => { # アイアンメイデン終異体
      :dead_word => ["\\n<Final Iron Maiden>……………………", "ironmaiden_s_fc1", 2],
      :orgasm_word => ["\\n<Final Iron Maiden>……………………", "ironmaiden_s_fc1", 2],
      :predation_word => ["\\n<Final Iron Maiden>……………………", "ironmaiden_s_fc1", 2],
      :incontinence_word => ["\\n<Final Iron Maiden>……………………", "ironmaiden_s_fc1", 2],
      :premortal_graphic => "50_ironmaiden_s_st03",
    },
    930 => { # 呪いの人形終異体
      :dead_word => ["\\n<Final Cursed Doll>I'll curse you......", "doll_itai_fc1", 2],
      :orgasm_word => ["\\n<Final Cursed Doll>How embarrassing......", "doll_itai_fc1", 2],
      :predation_word => ["\\n<Final Cursed Doll>Do dolls taste good......?", "doll_itai_fc1", 2],
      :incontinence_word => ["\\n<Final Cursed Doll>I leaked......", "doll_itai_fc1", 2],
      :premortal_graphic => "80_doll_itai_st03",
    },
    931 => { # 量産型影紬
      :dead_word => ["\\n<Mass-Produced Kagetsumugi>Why was I created......", "kagetumugi_fc1", 2],
      :orgasm_word => ["\\n<Mass-Produced Kagetsumugi>To think the pleasure reception function would be my downfall......", "kagetumugi_fc1", 2],
      :predation_word => ["\\n<Mass-Produced Kagetsumugi>If I'm going to be eaten anyway, I wish I was made with delicious ingredients......", "kagetumugi_fc1", 2],
      :incontinence_word => ["\\n<Mass-Produced Kagetsumugi>To think body fluid leakage would occur......", "kagetumugi_fc1", 2],
      :premortal_graphic => "50_kagetumugi_st03",
    },
    932 => { # マグダ
      :dead_word => ["\\n<Magda> I can see the light...", "magda_fc1", 1],
      :orgasm_word => ["\\n<Magda> I will be led to a sweet world...", "magda_fc1", 1],
      :predation_word => ["\\n<Magda> This is the food chain...?", "magda_fc1", 1],
      :incontinence_word => ["\\n<Magda> is such a humiliation...", "magda_fc1", 1],
      :premortal_graphic => "50_magda_st02",
    },
    933 => { # シスエル
      :dead_word => ["\\n<Sisel>So this is the end...", "sisel_fc1", 2],
      :orgasm_word => ["\\n<Sisel>I have no strength in my body...", "sisel_fc1", 2],
      :predation_word => ["\\n<Sisel>Even though it's not tasty...", "sisel_fc1", 2],
      :incontinence_word => ["\\n<Sisel>Ah, it's leaking...", "sisel_fc1", 2],
      :premortal_graphic => "80_sisel_st03",
    },
    934 => { # アザゼル
      :dead_word => ["\\n<Azazel>Let's meet again……", "azazel_fc1", 1],
      :orgasm_word => ["\\n<Azazel>Ah, it's wonderful……", "azazel_fc1", 0],
      :predation_word => ["\\n<Azazel>Delicious, isn't it……？", "azazel_fc1", 1],
      :incontinence_word => ["\\n<Azazel>Watch me leak……", "azazel_fc1", 1],
      :premortal_graphic => "50_azazel_st02",
    },
    935 => { # グリゴリ
      :dead_word => ["\\n<Grigori>I enjoyed it……", "grigori_fc1", 1],
      :orgasm_word => ["\\n<Grigori>It was very good……", "grigori_fc1", 1],
      :predation_word => ["\\n<Grigori>Savor it properly……", "grigori_fc1", 1],
      :incontinence_word => ["\\n<Grigori>This is the worst……", "grigori_fc1", 1],
      :premortal_graphic => "50_grigori_st02",
    },
    936 => { # 白天狐
      :dead_word => ["\\n<Hakutenko> Let's take a little break...", "hakutenko_fc1", 2],
      :orgasm_word => ["\\n<Hakutenko> This pleasure isn't so bad...", "hakutenko_fc1", 2],
      :predation_word => ["\\n<Hakutenko> Punishment...", "hakutenko_fc1", 2],
      :incontinence_word => ["\\n<Hakutenko> Those who see my foolishness will curse me...", "hakutenko_fc1", 2],
      :premortal_graphic => "80_hakutenko_st03",
    },
    937 => { # 妙法絡新婦
      :dead_word => ["\\n<Upaya Jorogumo> Excuse me for this...", "myouhouzyorougumo_fc1", 2],
      :orgasm_word => ["\\n<Upaya Jorogumo> That's a bad idea...", "myouhouzyorougumo_fc1", 2],
      :predation_word => ["\\n<Upaya Jorogumo> If you eat me, you will live a long life...", "myouhouzyorougumo_fc1", 2],
      :incontinence_word => ["\\n<Upaya Jorogumo> Miraculous holy water...", "myouhouzyorougumo_fc1", 2],
      :premortal_graphic => "80_myouhouzyorougumo_st03",
    },
    938 => { # 全てを識る者
      :dead_word => ["\\n<The All-Knowing> I knew this too...", "skyuba_fc1", 0],
      :orgasm_word => ["\\n<The All-Knowing> I also knew about this pleasure...", "skyuba_fc1", 0],
      :predation_word => ["\\n<The All-Knowing> Know my taste...", "skyuba_fc1", 0],
      :incontinence_word => ["\\n<The All-Knowing> I didn't want to know about this shame...", "skyuba_fc1", 0],
      :premortal_graphic => "80_skyuba_st01",
    },
    939 => { # モリガン
      :dead_word => ["\\n<Morrigan> Tsk, that's all...", "morrigan_fc1", 2],
      :orgasm_word => ["\\n<Morrigan> I can't believe I'm being made to cum...!  Damn...", "morrigan_fc1", 2],
      :predation_word => ["\\n<Morrigan> Stop! 'Damn, remember...!'", "morrigan_fc1", 2],
      :incontinence_word => ["\\n<Morrigan> Damn it, don't look at it...!  Don't look, don't look...!", "morrigan_fc1", 2],
      :premortal_graphic => "50_morrigan_st03",
    },
    940 => { # アスタロト
      :dead_word => ["\\n<Astaroth> Looks like you let your guard down, like this...", "astaroth_fc1", 2],
      :orgasm_word => ["\\n<Astaroth> I can't accept this kind of humiliation...  I, a big lewd demon, am like this...!", "astaroth_fc1", 2],
      :predation_word => ["\\n<Astaroth> You'll regret it if you eat me...!", "astaroth_fc1", 2],
      :incontinence_word => ["\\n<Astaroth>, such humiliation...! , prepare yourself...!", "astaroth_fc1", 2],
      :premortal_graphic => "50_astaroth_st03",
    },
    941 => { # リリス
      :dead_word => ["\\n<Lilith> I can't win against this power after all...", "lilith2_fc1", 2],
      :orgasm_word => ["\\n<Lilith> To defeat me with pleasure...", "lilith2_fc1", 2],
      :predation_word => ["\\n<Lilith> Eating me is really tough...", "lilith2_fc1", 2],
      :incontinence_word => ["\\n<Lilith> Making me incontinent... it's miserable...", "lilith2_fc1", 2],
      :premortal_graphic => "50_lilith2_st03",
    },
    942 => { # エキドナ
      :dead_word => ["\\n<Echidna> Can't you enjoy it anymore...?", "echidna_fc1", 7],
      :orgasm_word => ["\\n<Echidna> It feels good... wonderful...", "echidna_fc1", 3],
      :predation_word => ["\\n<Echidna>Does it feel good to be melted...?", "echidna_fc1", 2],
      :incontinence_word => ["\\n<Echidna>This kind of thing... feels good...", "echidna_fc1", 3],
      :premortal_graphic => "80_echidna_st03",
    },
    943 => { # エキドナクィーン
      :dead_word => ["\\n<Echidna Queen>It's not over yet...", "echidna_fc1", 7],
      :orgasm_word => ["\\n<Echidna Queen>It feels good... wonderful...", "echidna_fc1", 3],
      :predation_word => ["\\n<Echidna Queen>Does it feel good to be melted...?", "echidna_fc1", 2],
      :incontinence_word => ["\\n<Echidna Queen>This kind of thing... feels good...", "echidna_fc1", 3],
      :premortal_graphic => "80_echidna_st03",
    },
    944 => { # 奉仕種族
      :dead_word => ["\\n<Serviceborne> If it's for that person...", "houshi_fc1", 2],
      :orgasm_word => ["\\n<Serviceborne> Sinking in pleasure...", "houshi_fc1", 2],
      :predation_word => ["\\n<Serviceborne>Will I become a sacrifice...", "houshi_fc1", 2],
      :incontinence_word => ["\\n<Serviceborne>It's leaking out...", "houshi_fc1", 2],
      :premortal_graphic => "50_houshi_st03",
    },
    945 => { # 落とし子
      :dead_word => ["\\n<Forsaken Spawn>Is this the end...", "spawn_fc1", 2],
      :orgasm_word => ["\\n<Forsaken Spawn>I'm going to finish...", "spawn_fc1", 2],
      :predation_word => ["\\n<Forsaken Spawn>To become a sacrifice...", "spawn_fc1", 2],
      :incontinence_word => ["\\n<Forsaken Spawn>................", "spawn_fc1", 2],
      :premortal_graphic => "50_spawn_st03",
    },
    946 => { # クトゥルフ
      :dead_word => ["\\n<Cthulhu>Finally, I awaken from my slumber...", "cthulhu_fc1", 2],
      :orgasm_word => ["\\n<Cthulhu>Finally, I awaken from my slumber...", "cthulhu_fc1", 2],
      :predation_word => ["\\n<Cthulhu>To devour me...", "cthulhu_fc1", 2],
      :incontinence_word => ["\\n<Cthulhu>The height of humiliation...", "cthulhu_fc1", 2],
      :premortal_graphic => "80_cthulhu_st03",
    },
    947 => { # 触手の眷属
      :dead_word => ["\\n<Tentacle Kin>I apologize...", "zigen_kenzoku_fc1", 2],
      :orgasm_word => ["\\n<Tentacle Kin>I apologize...", "zigen_kenzoku_fc1", 2],
      :predation_word => ["\\n<Tentacle Kin>Ah, please don't eat me......", "zigen_kenzoku_fc1", 2],
      :incontinence_word => ["\\n<Tentacle Kin>I...I wet myself......ugh......", "zigen_kenzoku_fc1", 2],
      :premortal_graphic => "50_zigen_kenzoku_st03",
    },
    948 => { # 粘膜の眷属
      :dead_word => ["\\n<Slimy Kin>Ah, it's so painful......", "zigen_kenzoku2_fc1", 2],
      :orgasm_word => ["\\n<Slimy Kin>It feels so good......", "zigen_kenzoku2_fc1", 2],
      :predation_word => ["\\n<Slimy Kin>Please don't eat me......", "zigen_kenzoku2_fc1", 2],
      :incontinence_word => ["\\n<Slimy Kin>I wet myself......it's so slimy......", "zigen_kenzoku2_fc1", 2],
      :premortal_graphic => "50_zigen_kenzoku2_st03",
    },
    949 => { # アウタージェリー
      :dead_word => ["\\n<Outer Jelly>See you again~♪", "outerjelly_fc1", 0],
      :orgasm_word => ["\\n<Outer Jelly>Big sister, I came......♪", "outerjelly_fc1", 0],
      :predation_word => ["\\n<Outer Jelly>Eat me deliciously~♪", "outerjelly_fc1", 0],
      :incontinence_word => ["\\n<Outer Jelly>I wet myself......ufufu♪", "outerjelly_fc1", 0],
      :premortal_graphic => "80_outerjelly_st01",
    },
    950 => { # アウターワーム
      :dead_word => ["\\n<Outer Worm> See you soon...", "outerworm_fc1", 0],
      :orgasm_word => ["\\n<Outer Worm> Feels good...", "outerworm_fc1", 0],
      :predation_word => ["\\n<Outer Worm> Do I taste delicious...?", "outerworm_fc1", 0],
      :incontinence_word => ["\\n<Outer Worm> was leaked...", "outerworm_fc1", 0],
      :premortal_graphic => "80_outerworm_st01",
    },
    951 => { # 次元侵蝕者
      :dead_word => ["\\n<Dimensional Eroder> The owner of such power...", "zigen_boss_fc1", 2],
      :orgasm_word => ["\\n<Dimensional Eroder> So nice, hehehe...", "zigen_boss_fc1", 2],
      :predation_word => ["\\n<Dimensional Eroder> Do you want to be eroded from inside...?", "zigen_boss_fc1", 2],
      :incontinence_word => ["\\n<Dimensional Eroder> My body fluids are dangerous...", "zigen_boss_fc1", 2],
      :premortal_graphic => "80_zigen_boss_st13",
    },
    952 => { # フェニックス娘
      :dead_word => ["\\n<Phoenix Girl> This... even though it's a phoenix...", "phoenixb_fc1", 2],
      :orgasm_word => ["\\n<Phoenix Girl> This is so cowardly... Hah...", "phoenixb_fc1", 2],
      :predation_word => ["\\n<Phoenix Girl> Don't eat me! Don't eat me!", "phoenixb_fc1", 2],
      :incontinence_word => ["\\n<Phoenix Girl> I'm not a child anymore...", "phoenixb_fc1", 2],
      :premortal_graphic => "80_phoenixb_st03",
    },
    953 => { # ダークフェニックス
      :dead_word => ["\\n<Dark Phoenix> Am I... going to perish...?", "darkphenix_fc1", 2],
      :orgasm_word => ["\\n<Dark Phoenix> Am I... going to end...?", "darkphenix_fc1", 2],
      :predation_word => ["\\n<Dark Phoenix> You too, into the whirlpool of reincarnation...", "darkphenix_fc1", 2],
      :incontinence_word => ["\\n<Dark Phoenix> The droplets of reincarnation...", "darkphenix_fc1", 2],
      :premortal_graphic => "80_darkphenix_st03b",
    },
    954 => { # 星喰い
      :dead_word => ["\\n<Star Eater> Why do you resist so much...", "hosikui_fc1", 2],
      :orgasm_word => ["\\n<Star Eater> Why do you resist so much...", "hosikui_fc1", 2],
      :predation_word => ["\\n<Star Eater> To eat the Star Eater...", "hosikui_fc1", 2],
      :incontinence_word => ["\\n<Star Eater> A galactic-scale urination...", "hosikui_fc1", 2],
      :premortal_graphic => "80_hosikui_st11",
    },
    955 => { # 星喰い
      :dead_word => ["\\n<Star Eater> Is this the end... no...", "hosikui_fc1", 1],
      :orgasm_word => ["\\n<Star Eater> Is this the end... no...", "hosikui_fc1", 1],
      :predation_word => ["\\n<Star Eater> To eat the Star Eater...", "hosikui_fc1", 1],
      :incontinence_word => ["\\n<Star Eater> A galactic-scale urination...", "hosikui_fc1", 1],
      :premortal_graphic => "80_hosikui_st02",
    },
    956 => { # ヌルの眷属
      :dead_word => ["\\n<Null Kin> Kyu...", "null_kenzoku_fc1", 0],
      :orgasm_word => ["\\n<Null Kin> Kyu...", "null_kenzoku_fc1", 0],
      :predation_word => ["\\n<Null Kin> Kyukyu...", "null_kenzoku_fc1", 0],
      :incontinence_word => ["\\n<Null Kin> Kyu, Kyu...", "null_kenzoku_fc1", 0],
      :premortal_graphic => "50_null_kenzoku_st01",
    },
    957 => { # ヌルの眷属
      :dead_word => ["\\n<Null Kin> Kyuu...!", "null_kenzoku_fc1", 1],
      :orgasm_word => ["\\n<Null Kin> Kyu~...", "null_kenzoku_fc1", 1],
      :predation_word => ["\\n<Null Kin> Kyu~! Squeaky!", "null_kenzoku_fc1", 1],
      :incontinence_word => ["\\n<Null Kin> Kyuu...", "null_kenzoku_fc1", 1],
      :premortal_graphic => "50_null_kenzoku_st02",
    },
    958 => { # ヌルの眷属
      :dead_word => ["\\n<Null Kin> Kyuukyu~!", "null_kenzoku_fc1", 2],
      :orgasm_word => ["\\n<Null Kin> Squeaky...", "null_kenzoku_fc1", 2],
      :predation_word => ["\\n<Null Kin> Kyukyu, Kyukyu...", "null_kenzoku_fc1", 2],
      :incontinence_word => ["\\n<Null's Kin>........................", "null_kenzoku_fc1", 2],
      :premortal_graphic => "50_null_kenzoku_st03",
    },
    959 => { # TT
      :dead_word => ["\\n<TT>Myu...", "TT_fc1", 2],
      :orgasm_word => ["\\n<TT>Myu...", "TT_fc1", 2],
      :predation_word => ["\\n<TT>Myu, myumyumyu~!", "TT_fc1", 2],
      :incontinence_word => ["\\n<TT>Myu... myu...", "TT_fc1", 2],
      :premortal_graphic => "50_TT_st03",
    },
    960 => { # QQ
      :dead_word => ["\\n<QQ>", "QQ_fc1", 2],
      :orgasm_word => ["\\n<QQ>", "QQ_fc1", 2],
      :predation_word => ["\\n<QQ>", "QQ_fc1", 2],
      :incontinence_word => ["\\n<QQ>", "QQ_fc1", 2],
      :premortal_graphic => "80_QQ_st03",
    },
    961 => { # ヌール・コギト
      :dead_word => ["\\n<Null Cogito>■■■■■■■■■......", "nurukox_fc1", 2],
      :orgasm_word => ["\\n<Null Cogito>■■■■■■......", "nurukox_fc1", 2],
      :predation_word => ["\\n<Null Cogito>■■■■■......", "nurukox_fc1", 2],
      :incontinence_word => ["\\n<Null Cogito>■■■■■■■......", "nurukox_fc1", 2],
      :premortal_graphic => "80_nurukox_st18",
    },
    962 => { # グラン・アラーニェ
      :dead_word => ["\\n<Grand Arachne>Hehe, I even enjoyed the pain...", "gran_arachne_fc1", 2],
      :orgasm_word => ["\\n<Grand Arachne>Thank you for the wonderful pleasure...", "gran_arachne_fc1", 2],
      :predation_word => ["\\n<Grand Arachne>Savor it slowly and eat...", "gran_arachne_fc1", 2],
      :incontinence_word => ["\\n<Grand Arachne>Ah, such a liberating feeling...", "gran_arachne_fc1", 2],
      :premortal_graphic => "50_gran_arachne_st03",
    },
    963 => { # 白兎・蝕
      :dead_word => ["\\n<White Rabbit: Decay>……………………", "sirousagi_fc2", 4],
      :orgasm_word => ["\\n<White Rabbit: Decay>……………………", "sirousagi_fc2", 4],
      :predation_word => ["\\n<White Rabbit: Decay>……………………", "sirousagi_fc2", 4],
      :incontinence_word => ["\\n<White Rabbit: Decay>……………………", "sirousagi_fc2", 4],
      :premortal_graphic => "50_sirousagi_st01",
    },
    964 => { # 死神・蝕
      :dead_word => ["\\n<Reaper: Decay>……………………", "sinigami_fc2", 4],
      :orgasm_word => ["\\n<Reaper: Decay>……………………", "sinigami_fc2", 4],
      :predation_word => ["\\n<Reaper: Decay>……………………", "sinigami_fc2", 4],
      :incontinence_word => ["\\n<Reaper: Decay>……………………", "sinigami_fc2", 4],
      :premortal_graphic => "50_sinigami_st01",
    },
    965 => { # 白兎・流
      :dead_word => ["\\n<White Rabbit: Flow>……………………", "sirousagi_fc2", 3],
      :orgasm_word => ["\\n<White Rabbit: Flow>……………………", "sirousagi_fc2", 3],
      :predation_word => ["\\n<White Rabbit: Flow>……………………", "sirousagi_fc2", 3],
      :incontinence_word => ["\\n<White Rabbit: Flow>……………………", "sirousagi_fc2", 3],
      :premortal_graphic => "80_sirousagi_st24",
    },
    966 => { # 死神・流
      :dead_word => ["\\n<Reaper: Flow>……………………", "sinigami_fc2", 3],
      :orgasm_word => ["\\n<Reaper: Flow>……………………", "sinigami_fc2", 3],
      :predation_word => ["\\n<Reaper: Flow>……………………", "sinigami_fc2", 3],
      :incontinence_word => ["\\n<Reaper: Flow>……………………", "sinigami_fc2", 3],
      :premortal_graphic => "80_sinigami_st14",
    },
    967 => { # エクス・ソニア
      :dead_word => ["\\n<EX Sonya>I...! I am not done yet...!!", "ex_sonia_fc3", 0],
      :orgasm_word => ["\\n<EX Sonya>I...! I am not done yet...!!", "ex_sonia_fc3", 0],
      :predation_word => ["\\n<EX Sonya> Eating me...", "ex_sonia_fc3", 0],
      :incontinence_word => ["\\n<EX Sonya> It's embarrassing to leak ...", "ex_sonia_fc3", 0],
      :premortal_graphic => "80_ex_sonia_st21",
    },
    968 => { # ベリアル
      :dead_word => ["\\n<Belial>Tch, you're quite skilled...", "berial_fc1", 2],
      :orgasm_word => ["\\n<Belial>Such humiliation...", "berial_fc1", 2],
      :predation_word => ["\\n<Belial>Stop, I am Belial!", "berial_fc1", 2],
      :incontinence_word => ["\\n<Belial> This is the first time I've experienced such humiliation...", "berial_fc1", 2],
      :premortal_graphic => "80_berial_st03b",
    },
    969 => { # 虚竜
      :dead_word => ["\\n<Koron> Ha, it's getting interesting...!", "koron_fc1", 2],
      :orgasm_word => ["\\n<Koron> It's quite humiliating...", "koron_fc1", 2],
      :predation_word => ["\\n<Koron> Is this also the law of the fittest...?", "koron_fc1", 2],
      :incontinence_word => ["\\n<Koron>, don't look... Ugh...", "koron_fc1", 2],
      :premortal_graphic => "80_koron_st03",
    },
    970 => { # 虚竜
      :dead_word => ["\\n<Koron> Gah, you're going to do it...", "koron_fc1", 2],
      :orgasm_word => ["\\n<Koron> It's quite humiliating...", "koron_fc1", 2],
      :predation_word => ["\\n<Koron> Is this also the law of the fittest...?", "koron_fc1", 2],
      :incontinence_word => ["\\n<Koron>, don't look... Ugh...", "koron_fc1", 2],
      :premortal_graphic => "80_koron_st03",
    },
    971 => { # アピロ・ラゴス
      :dead_word => ["\\n<Apiro Lagos> I am like this...!", "apiro_ragos_fc1", 2],
      :orgasm_word => ["\\n<Apiro Lagos> I am like this...!", "apiro_ragos_fc1", 2],
      :predation_word => ["\\n<Apiro Lagos> Even if you break my stomach, I won't know!", "apiro_ragos_fc1", 0],
      :incontinence_word => ["\\n<Apiro Lagos> I'm embarrassed, I leaked it...", "apiro_ragos_fc1", 0],
      :premortal_graphic => "80_apiro_ragos_st03",
    },
    972 => { # ゲイザー
      :dead_word => ["\\n<Gazer> Stop it!", "gazer_fc1", 2],
      :orgasm_word => ["\\n<Gazer> Huh... it feels so good...", "gazer_fc1", 2],
      :predation_word => ["\\n<Gazer> Eyeballs aren't delicious!", "gazer_fc1", 2],
      :incontinence_word => ["\\n<Gazer>Nooo! Don't look!", "gazer_fc1", 2],
      :premortal_graphic => "80_gazer_st03",
    },
    973 => { # インドラ
      :dead_word => ["\\n<Indra>Have I been defeated...", "indora_fc1", 2],
      :orgasm_word => ["\\n<Indra>To think I would be brought to climax...", "indora_fc1", 2],
      :predation_word => ["\\n<Indra>To think I would be devoured...", "indora_fc1", 2],
      :incontinence_word => ["\\n<Indra>Ugh, this is too embarrassing...!", "indora_fc1", 2],
      :premortal_graphic => "50_indora_st03",
    },
    974 => { # トンベリ娘
      :dead_word => ["\\n<Tonberry Girl>................", "tonberi_fc1", 2],
      :orgasm_word => ["\\n<Tonberry Girl>................", "tonberi_fc1", 2],
      :predation_word => ["\\n<Tonberry Girl>................", "tonberi_fc1", 2],
      :incontinence_word => ["\\n<Tonberry Girl>................", "tonberi_fc1", 2],
      :premortal_graphic => "80_tonberi_st03",
    },
    975 => { # トンベリーズ娘
      :dead_word => ["\\n<Tonberry Girls>................", "tonberi_fc1", 2],
      :orgasm_word => ["\\n<Tonberry Girls>................", "tonberi_fc1", 2],
      :predation_word => ["\\n<Tonberry Girls>................", "tonberi_fc1", 2],
      :incontinence_word => ["\\n<Tonberry Girls>................", "tonberi_fc1", 2],
      :premortal_graphic => "50_tonberi_st03",
    },
    976 => { # アバドン
      :dead_word => ["\\n<Abaddon>To meet my end in a place like this...", "abaddon_fc1", 2],
      :orgasm_word => ["\\n<Abaddon>Pleasure is consuming my body...", "abaddon_fc1", 2],
      :predation_word => ["\\n<Abaddon>To be eaten... someone like me...", "abaddon_fc1", 2],
      :incontinence_word => ["\\n<Abaddon>I can't stop... wetting myself...", "abaddon_fc1", 2],
      :premortal_graphic => "80_abaddon_st03",
    },
    977 => { # エクスキュウビ
      :dead_word => ["\\n<EX-Kyubi> has stopped functioning...", "exkyubi_fc1", 0],
      :orgasm_word => ["\\n<EX-Kyubi> Neural circuit stopped due to pleasure signal...", "exkyubi_fc1", 0],
      :predation_word => ["\\n<EX-Kyubi> It's not delicious! Ahhh...", "exkyubi_fc1", 0],
      :incontinence_word => ["\\n<EX-Kyubi> leaks...aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa...", "exkyubi_fc1", 0],
      :premortal_graphic => "80_exkyubi_st01",
    },
    978 => { # ドーラドーラ
      :dead_word => ["\\n<Dolla-Dolla>Goodbye...", "dolladolla_fc1", 2],
      :orgasm_word => ["\\n<Dolla-Dolla>This is, pleasure...", "dolladolla_fc1", 2],
      :predation_word => ["\\n<Dolla-Dolla>I'm not food...", "dolladolla_fc1", 2],
      :incontinence_word => ["\\n<Dolla-Dolla>This is, incontinence...", "dolladolla_fc1", 2],
      :premortal_graphic => "50_dolladolla_st03",
    },
    979 => { # ベルゼバブ終異体
      :dead_word => ["\\n<Final Beelzebub>I can't believe I lost...", "beelzebub_s_fc1", 2],
      :orgasm_word => ["\\n<Final Beelzebub>Pleasure, is not my forte...", "beelzebub_s_fc1", 2],
      :predation_word => ["\\n<Final Beelzebub>Such gluttony...", "beelzebub_s_fc1", 2],
      :incontinence_word => ["\\n<Final Beelzebub>Ah, how embarrassing...", "beelzebub_s_fc1", 2],
      :premortal_graphic => "50_beelzebub_s_st03",
    },
    980 => { # メルカヴァ
      :dead_word => ["\\n<Merkabah>Everything is the essence of chaos...", "merkava_fc1", 2],
      :orgasm_word => ["\\n<Merkabah>Pleasure too is a trigger for entropy...", "merkava_fc1", 2],
      :predation_word => ["\\n<Merkabah> Make me your food, that is also reincarnation...", "merkava_fc1", 2],
      :incontinence_word => ["\\n<Merkabah> This shame...it's hard to resist...", "merkava_fc1", 2],
      :premortal_graphic => "80_merkava_st03",
    },
    981 => { # フレール
      :dead_word => ["\\n<Frere> I...I won't disappear...", "ozum_fc1", 1],
      :orgasm_word => ["\\n<Frere> I feel like I'm going to melt...", "ozum_fc1", 1],
      :predation_word => ["\\n<Frere> I will devour it from within...", "ozum_fc1", 1],
      :incontinence_word => ["\\n<Frere> I am flowing out...", "ozum_fc1", 1],
      :premortal_graphic => "50_ozum_st02",
    },
    982 => { # アガリアレプト
      :dead_word => ["\\n<Agaliarept> It will return soon anyway...", "agaliarept_fc1", 2],
      :orgasm_word => ["\\n<Agaliarept> Hehe, not bad...", "agaliarept_fc1", 0],
      :predation_word => ["\\n<Agaliarept> To be reduced to my bait...", "agaliarept_fc1", 2],
      :incontinence_word => ["\\n<Agaliarept> What a humiliation...", "agaliarept_fc1", 2],
      :premortal_graphic => "80_agaliarept_st03b",
    },
    983 => { # ゲイザー
      :dead_word => ["\\n<Gazer> Stop it!", "gazer_fc1", 2],
      :orgasm_word => ["\\n<Gazer> Huh... it feels so good...", "gazer_fc1", 2],
      :predation_word => ["\\n<Gazer> Eyeballs aren't delicious!", "gazer_fc1", 2],
      :incontinence_word => ["\\n<Gazer>Nooo! Don't look!", "gazer_fc1", 2],
      :premortal_graphic => "50_gazer_st03",
    },
    984 => { # ベリアル
      :dead_word => ["\\n<Belial>Tch, you're quite skilled...", "berial_fc1", 2],
      :orgasm_word => ["\\n<Belial>Such humiliation...", "berial_fc1", 2],
      :predation_word => ["\\n<Belial>Stop, I am Belial!", "berial_fc1", 2],
      :incontinence_word => ["\\n<Belial> This is the first time I've experienced such humiliation...", "berial_fc1", 2],
      :premortal_graphic => "80_berial_st03",
    },
    985 => { # 魔神
      :dead_word => ["\\n<Archfiend> It was a fun party...", "mazin_fc1", 0],
      :orgasm_word => ["\\n<Archfiend> I enjoyed it...", "mazin_fc1", 0],
      :predation_word => ["\\n<Archfiend> Chaos soup must be delicious...", "mazin_fc1", 0],
      :incontinence_word => ["\\n<Archfiend>nAh...I leaked it...", "mazin_fc1", 0],
      :premortal_graphic => "80_mazin_st01b",
    },
    986 => { # 女神
      :dead_word => ["\\n<Goddess>The time has come for me to end...", "megami_fc1", 1],
      :orgasm_word => ["\\n<Goddess>The time has come for me to end...", "megami_fc1", 1],
      :predation_word => ["\\n<Goddess>I will not allow you to devour me...", "megami_fc1", 1],
      :incontinence_word => ["\\n<Goddess>You insolent... I will not forgive you...", "megami_fc1", 1],
      :premortal_graphic => "80_megami_st02b",
    },
    987 => { # 鬼神
      :dead_word => ["\\n<Kishin>Truly splendid...", "kizin2_fc1", 0],
      :orgasm_word => ["\\n<Kishin>For a moment, let's indulge in a sweet dream...", "kizin2_fc1", 0],
      :predation_word => ["\\n<Kishin>To devour me, you must have quite the resolve...", "kizin2_fc1", 0],
      :incontinence_word => ["\\n<Kishin>So this is humiliation...", "kizin2_fc1", 0],
      :premortal_graphic => "80_kizin2_st01b",
    },
    988 => { # ワールドブレイカー
      :dead_word => ["\\n<World Breaker>All worlds...", "worldbreaker_fc1", 2],
      :orgasm_word => ["\\n<World Breaker>All worlds...", "worldbreaker_fc1", 2],
      :predation_word => ["\\n<World Breaker>All worlds...", "worldbreaker_fc1", 2],
      :incontinence_word => ["\\n<World Breaker>All worlds...", "worldbreaker_fc1", 2],
      :premortal_graphic => "80_worldbreaker_st03",
    },
    989 => { # ジャッジメント
      :dead_word => ["\\n<Judgment>The time of judgment...", "judgement_fc1", 2],
      :orgasm_word => ["\\n<Judgment>The time of judgment...", "judgement_fc1", 2],
      :predation_word => ["\\n<Judgment>The time of judgment...", "judgement_fc1", 2],
      :incontinence_word => ["\\n<Judgment>The time of judgment...", "judgement_fc1", 2],
      :premortal_graphic => "80_judgement_st01",
    },
    990 => { # デウスエクスマキナ
      :dead_word => ["\\n<Deus Ex Machina>■■■■■■■...", "deusex_fc1", 0],
      :orgasm_word => ["\\n<Deus Ex Machina>■■■■■■...", "deusex_fc1", 0],
      :predation_word => ["\\n<Deus Ex Machina>■■■■■■■...", "deusex_fc1", 0],
      :incontinence_word => ["\\n<Deus Ex Machina>■■■■■■■■■...", "deusex_fc1", 0],
      :premortal_graphic => "80_deusex_st01",
    },
    991 => { # カオス
      :dead_word => ["\\n<Chaos> Your lives are like flames...  It will burn fiercely before it goes out...", "chaos_fc1", 2],
      :orgasm_word => ["\\n<Chaos> Your lives are like flames...  It will burn fiercely before it goes out...", "chaos_fc1", 2],
      :predation_word => ["\\n<Chaos> Your lives are like flames...  It will burn fiercely before it goes out...", "chaos_fc1", 2],
      :incontinence_word => ["\\n<Chaos> chaos leaks...", "chaos_fc1", 2],
      :premortal_graphic => "80_chaos_st03",
    },
    992 => { # カオス
      :dead_word => ["\\n<Chaos> Father... are you also the god of chaos...", "chaos_fc1", 2],
      :orgasm_word => ["\\n<Chaos> Father... are you also the god of chaos...", "chaos_fc1", 2],
      :predation_word => ["\\n<Chaos> Father... are you also the god of chaos...", "chaos_fc1", 2],
      :incontinence_word => ["\\n<Chaos> chaos leaks...", "chaos_fc1", 2],
      :premortal_graphic => "80_chaos_st03",
    },
    993 => { # カオス
      :dead_word => ["\\n<Chaos> Something like this... something like this...", "chaos_fc1", 2],
      :orgasm_word => ["\\n<Chaos> Something like this... something like this...", "chaos_fc1", 2],
      :predation_word => ["\\n<Chaos> Something like this... something like this...", "chaos_fc1", 2],
      :incontinence_word => ["\\n<Chaos> chaos leaks...", "chaos_fc1", 2],
      :premortal_graphic => "80_chaos_st03",
    },
    994 => { # 蛭蟲
      :dead_word => ["\\n<Hiruko>You're more capable than I expected...", "hiruko_fc1", 2],
      :orgasm_word => ["\\n<Hiruko>You're more capable than I expected...", "hiruko_fc1", 2],
      :predation_word => ["\\n<Hiruko>You're more capable than I expected...", "hiruko_fc1", 2],
      :incontinence_word => ["\\n<Hiruko>Don't make eye contact, or you'll be devoured...", "hiruko_fc1", 2],
      :premortal_graphic => "50_hiruko_st03",
    },
    995 => { # 華音
      :dead_word => ["\\n<Kanon>This isn't funny at all...", "kanon_fc1", 2],
      :orgasm_word => ["\\n<Kanon>This isn't funny at all...", "kanon_fc1", 2],
      :predation_word => ["\\n<Kanon>This isn't funny at all...", "kanon_fc1", 2],
      :incontinence_word => ["\\n<Kanon>So embarrassing... Don't look.", "kanon_fc1", 2],
      :premortal_graphic => "50_kanon_st03",
    },
    996 => { # 禍撫
      :dead_word => ["\\n<Kanade>I won't perish from just this...", "kanade_fc1", 2],
      :orgasm_word => ["\\n<Kanade>  I can't believe it...", "kanade_fc1", 2],
      :predation_word => ["\\n<Kanade>  It must be quite delicious...", "kanade_fc1", 2],
      :incontinence_word => ["\\n<Kanade> I can't believe I leaked ...", "kanade_fc1", 2],
      :premortal_graphic => "50_kanade_st03",
    },
    997 => { # イデア・ルカス
      :dead_word => ["\\n<Idea Lukas> Even if it ends here... as many times as possible...", "idea_rukas_fc1", 0],
      :orgasm_word => ["\\n<Idea Lukas> Even if it ends here... as many times as possible...", "idea_rukas_fc1", 0],
      :predation_word => ["\\n<Idea Lukas> Even if it ends here... as many times as possible...", "idea_rukas_fc1", 0],
      :premortal_graphic => "80_idea_rukas_st01",
    },
    998 => { # アガリアレプト
      :dead_word => ["\\n<Agaliarept> It will return soon anyway...", "agaliarept_fc1", 2],
      :orgasm_word => ["\\n<Agaliarept> Hehe, not bad...", "agaliarept_fc1", 0],
      :predation_word => ["\\n<Agaliarept> To be reduced to my bait...", "agaliarept_fc1", 2],
      :incontinence_word => ["\\n<Agaliarept> What a humiliation...", "agaliarept_fc1", 2],
      :premortal_graphic => "80_agaliarept_st03b",
    },
  }
end

 